/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.validators.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoragePropertiesValidator
extends AbstractValidator<OracleStorageProperties> {
    private static Integer n0 = new Integer(0);
    private static Integer n1 = new Integer(1);
    private static Integer n99 = new Integer(99);
    private static Integer n255 = new Integer(255);

    public StoragePropertiesValidator(DBObjectProvider pro) {
        super(pro);
    }

    @Override
    protected boolean canHaveEmptyName() {
        return true;
    }

    @AbstractValidator.PropertyValidator(value={"percentFree"})
    public void validatePercentFree(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer pctFree = updated.getPercentFree();
        if (pctFree != null && (pctFree < 0 || pctFree > 99)) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)273, (Object)"PCTFREE", (Object)n0, (Object)n99));
        }
        this.validateSumOfPctFreeAndPctUsed(updated);
    }

    @AbstractValidator.PropertyValidator(value={"percentUsed"})
    public void validatePercentUsed(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer pctUsed = updated.getPercentUsed();
        if (pctUsed != null && (pctUsed < 0 || pctUsed > 99)) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)273, (Object)"PCTUSED", (Object)n0, (Object)n99));
        }
        this.validateSumOfPctFreeAndPctUsed(updated);
    }

    @AbstractValidator.PropertyValidator(value={"initrans"})
    public void validateInitrans(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer initrans = updated.getInitrans();
        if (initrans != null && (initrans < 1 || initrans > 255)) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)273, (Object)"INITRANS", (Object)n1, (Object)n255));
        }
    }

    @AbstractValidator.PropertyValidator(value={"maxtrans"})
    public void validateMaxtrans(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer maxtrans = updated.getMaxtrans();
        if (maxtrans != null && (maxtrans < 1 || maxtrans > 255)) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)273, (Object)"MAXTRANS", (Object)n1, (Object)n255));
        }
    }

    @AbstractValidator.PropertyValidator(value={"initialExtent"})
    public void validateInitialExtent(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer initialExtent = updated.getInitialExtent();
        if (initialExtent != null && initialExtent < 1) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)274, (Object)"INITIAL", (Object)n1));
        }
    }

    @AbstractValidator.PropertyValidator(value={"nextExtent"})
    public void validateNextExtent(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer nextExtent = updated.getNextExtent();
        if (nextExtent != null && nextExtent < 1) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)274, (Object)"NEXT", (Object)n1));
        }
    }

    @AbstractValidator.PropertyValidator(value={"minExtent"})
    public void validateMinExtent(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer minExtent = updated.getMinExtent();
        if (minExtent != null && minExtent < 1) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)274, (Object)"MINEXTENT", (Object)n1));
        }
    }

    @AbstractValidator.PropertyValidator(value={"maxExtent"})
    public void validateMaxExtent(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer maxExtent = updated.getMaxExtent();
        if (maxExtent != null && maxExtent < 1) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)274, (Object)"MAXEXTENT", (Object)n1));
        }
    }

    @AbstractValidator.PropertyValidator(value={"percentIncrease"})
    public void validatePercentIncrease(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer pctIncrease = updated.getPercentIncrease();
        if (pctIncrease != null && pctIncrease < 0) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)274, (Object)"PCTINCREASE", (Object)n0));
        }
    }

    @AbstractValidator.PropertyValidator(value={"freelistGroups"})
    public void validateFreelistGroups(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer freelistGroups = updated.getFreelistGroups();
        if (freelistGroups != null && freelistGroups < 1) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)274, (Object)"FREELIST_GROUPS", (Object)n1));
        }
    }

    @AbstractValidator.PropertyValidator(value={"freelists"})
    public void validateFreelists(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer freelists = updated.getFreelists();
        if (freelists != null && freelists < 1) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)274, (Object)"FREELISTS", (Object)n1));
        }
    }

    @AbstractValidator.PropertyValidator(value={"bufferMode"})
    public void validateBufferMode(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
    }

    private void validateSumOfPctFreeAndPctUsed(OracleStorageProperties props) throws ValidationException {
        Integer pctFree = props.getPercentFree();
        Integer pctUsed = props.getPercentUsed();
        if (pctFree != null && pctUsed != null && pctFree + pctUsed > 100) {
            throw new ValidationException((DBObject)props, DBArb.getString((int)275));
        }
    }

    @AbstractValidator.PropertyValidator(value={"tablespaceID"})
    public void validateTablespaceID(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
    }
}

