/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.AutoExtendProperties;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.validators.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTablespacePropertiesValidator
extends AbstractValidator<OracleTablespaceProperties> {
    private static Integer n1 = new Integer(1);

    public OracleTablespacePropertiesValidator(DBObjectProvider prov) {
        super(prov);
    }

    @Override
    protected boolean canHaveEmptyName() {
        return true;
    }

    @AbstractValidator.PropertyValidator(value={"minExtent"})
    public void validateMinExtent(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Integer minExtent = updated.getMinExtent();
        if (minExtent != null && minExtent < 1) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)274, (Object)"MINEXTENT", (Object)n1));
        }
        OracleTablespaceProperties.ExtentManagementType extentMgmnt = updated.getExtentManagementType();
        if (minExtent != null && extentMgmnt != null && !extentMgmnt.equals((Object)OracleTablespaceProperties.ExtentManagementType.DICTIONARY)) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)84));
        }
    }

    @AbstractValidator.PropertyValidator(value={"blockSize"})
    public void validateBlockSize(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        Integer blockSize = updated.getBlockSize();
        if (blockSize != null && blockSize < 1) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)274, (Object)"MINEXTENT", (Object)n1));
        }
        if (updated.getParent() instanceof Tablespace && blockSize != null && (tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")).equals((Object)Tablespace.TablespaceType.TEMPORARY)) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)85));
        }
    }

    @AbstractValidator.PropertyValidator(value={"forceLogging"})
    public void validateForceLogging(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        boolean forceLogging = updated.isForceLogging();
        if (updated.getParent() instanceof Tablespace && forceLogging && !(tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")).equals((Object)Tablespace.TablespaceType.PERMANENT)) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)86));
        }
    }

    @AbstractValidator.PropertyValidator(value={"defaultTableCompression"})
    public void validateDefaultTableCompression(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        OracleTablespaceProperties.DefaultTableCompression tabCompress = updated.getDefaultTableCompression();
        if (updated.getParent() instanceof Tablespace && tabCompress != null && (tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")).equals((Object)Tablespace.TablespaceType.TEMPORARY)) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)87));
        }
        OracleTablespaceProperties.ExtentManagementType extentMgmnt = updated.getExtentManagementType();
        if (tabCompress != null && tabCompress != OracleTablespaceProperties.DefaultTableCompression.COMPRESS && extentMgmnt != null && extentMgmnt.equals((Object)OracleTablespaceProperties.ExtentManagementType.DICTIONARY)) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)88));
        }
    }

    @AbstractValidator.PropertyValidator(value={"autoAllocate"})
    public void validateAutoAllocate(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        boolean autoAllocate = updated.isAutoAllocate();
        Integer minExtent = updated.getMinExtent();
        if (autoAllocate && minExtent != null) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)90));
        }
        if (updated.getParent() instanceof Tablespace && autoAllocate && (tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")).equals((Object)Tablespace.TablespaceType.TEMPORARY)) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)91));
        }
    }

    @AbstractValidator.PropertyValidator(value={"uniformSize"})
    public void validateUniformSize(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        Integer uniformSize = updated.getUniformSize();
        if (uniformSize != null && uniformSize < 1) {
            throw new ValidationException((DBObject)updated, DBArb.format((int)274, (Object)"UNIFORM SIZE", (Object)n1));
        }
        if (updated.getParent() instanceof Tablespace && uniformSize != null && (tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")).equals((Object)Tablespace.TablespaceType.UNDO)) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)92));
        }
    }

    @AbstractValidator.PropertyValidator(value={"extentManagementType"})
    public void validateExtentManagement(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        OracleTablespaceProperties.ExtentManagementType extentMgmnt = updated.getExtentManagementType();
        if (updated.getParent() instanceof Tablespace && extentMgmnt != null && extentMgmnt.equals((Object)OracleTablespaceProperties.ExtentManagementType.DICTIONARY)) {
            Tablespace tbsp = (Tablespace)updated.getParent();
            Tablespace.TablespaceType tbspType = (Tablespace.TablespaceType)tbsp.getProperty("TablespaceType");
            if (tbspType.equals((Object)Tablespace.TablespaceType.TEMPORARY)) {
                throw new ValidationException((DBObject)updated, DBArb.getString((int)93));
            }
            if (tbspType.equals((Object)Tablespace.TablespaceType.UNDO)) {
                throw new ValidationException((DBObject)updated, DBArb.getString((int)94));
            }
            if (tbsp.getFileType().equals((Object)Tablespace.FileType.BIGFILE)) {
                throw new ValidationException((DBObject)updated, DBArb.getString((int)95));
            }
        }
    }

    @AbstractValidator.PropertyValidator(value={"segmentManagement"})
    public void validateSegmentManagement(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        OracleTablespaceProperties.SegmentManagement segMgmnt = updated.getSegmentManagement();
        OracleTablespaceProperties.ExtentManagementType extentMgmnt = updated.getExtentManagementType();
        if (updated.getParent() instanceof Tablespace && extentMgmnt != null && segMgmnt != null && segMgmnt.equals((Object)OracleTablespaceProperties.SegmentManagement.MANUAL) && (!(tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")).equals((Object)Tablespace.TablespaceType.PERMANENT) && !extentMgmnt.equals((Object)OracleTablespaceProperties.ExtentManagementType.LOCAL) || tbsp.getFileType().equals((Object)Tablespace.FileType.BIGFILE))) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)96));
        }
    }

    @AbstractValidator.PropertyValidator(value={"tablespaceGroup"})
    public void validateTablespaceGroup(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        String tablespaceGroup = updated.getTablespaceGroup();
        if (updated.getParent() instanceof Tablespace && tablespaceGroup != null && !(tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")).equals((Object)Tablespace.TablespaceType.TEMPORARY)) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)97));
        }
    }

    @AbstractValidator.PropertyValidator(value={"retention"})
    public void validateRetention(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        Tablespace.TablespaceType tbspType;
        OracleTablespaceProperties.RetentionType retention = updated.getRetention();
        if (updated.getParent() instanceof Tablespace && retention != null && !(tbspType = (Tablespace.TablespaceType)(tbsp = (Tablespace)updated.getParent()).getProperty("TablespaceType")).equals((Object)Tablespace.TablespaceType.UNDO)) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)98));
        }
    }

    @AbstractValidator.PropertyValidator(value={"properties", "OracleStorageProperties"}, path=true)
    public void validateOracleStorageProps(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        OracleStorageProperties osp = (OracleStorageProperties)updated.getProperty("OracleStorageProperties");
        if (updated.getParent() instanceof Tablespace && osp != null) {
            Tablespace tbsp = (Tablespace)updated.getParent();
            Tablespace.TablespaceType tbspType = (Tablespace.TablespaceType)tbsp.getProperty("TablespaceType");
            if (tbspType.equals((Object)Tablespace.TablespaceType.TEMPORARY)) {
                throw new ValidationException((DBObject)updated, DBArb.getString((int)99));
            }
            OracleTablespaceProperties.ExtentManagementType extentMgmnt = updated.getExtentManagementType();
            if (extentMgmnt != null && extentMgmnt.equals((Object)OracleTablespaceProperties.ExtentManagementType.LOCAL)) {
                throw new ValidationException((DBObject)updated, DBArb.getString((int)100));
            }
        }
        if (osp != null) {
            this.getProvider().validateObject((DBObject)osp);
        }
    }

    @AbstractValidator.PropertyValidator(value={"autoExtendProperties"})
    public void validateAutoExtend(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
        Tablespace tbsp;
        AutoExtendProperties autoExtendProps = updated.getAutoExtendProperties();
        if (updated.getParent() instanceof Tablespace && autoExtendProps != null && !(tbsp = (Tablespace)updated.getParent()).getFileType().equals((Object)Tablespace.FileType.BIGFILE)) {
            throw new ValidationException((DBObject)updated, DBArb.getString((int)101));
        }
    }

    @AbstractValidator.PropertyValidator(value={"logging"})
    public void validateLogging(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
    }

    @AbstractValidator.PropertyValidator(value={"onlineStatus"})
    public void validateOnlineStatus(OracleTablespaceProperties original, OracleTablespaceProperties updated) throws ValidationException {
    }
}

