/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Arrays;
import java.util.HashSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.ObjectTypeUsage;
import oracle.javatools.db.ora.validators.OracleIndexAndConstraintValidator;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.validators.ConstraintValidator;

public class OracleConstraintValidator
extends ConstraintValidator {
    private static final HashSet INVALID_CONSTRAINT_DATATYPES = new HashSet<String>(Arrays.asList("BFILE", "BLOB", "CLOB", "LONG", "LONG RAW", "NCLOB", "LOB", "VARRAY", "NESTED TABLE", "OBJECT", "REF"));

    public OracleConstraintValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected boolean enforceChildNameUniqueInSchema(DBObject obj) {
        return !this.isChildOfPendingObject(obj);
    }

    protected void validateNameInUse(DBObject object) throws NameInUseException {
        super.validateNameInUse(object);
        if (object instanceof UniqueConstraint && this.enforceChildNameUniqueInSchema(object)) {
            Relation parent = (Relation)object.getParent();
            try {
                this.getProvider().validateUniqueName("INDEX", (DBObject)parent.getSchema(), object.getName());
            }
            catch (NameInUseException e) {
                if (e.getUserName().equals(parent.getName()) && e.getUserType().equals(parent.getType())) {
                    OracleIndexAndConstraintValidator.validateConstraint((Constraint)((UniqueConstraint)object));
                }
                throw e;
            }
        }
    }

    protected boolean isValidConstraintDatatype(String dataTypeName, DataTypeUsage dataTypeUsage) {
        String timeZoneValue;
        boolean isValidType;
        boolean bl = isValidType = !INVALID_CONSTRAINT_DATATYPES.contains(dataTypeName) && !(dataTypeUsage instanceof ObjectTypeUsage);
        if (dataTypeUsage != null && dataTypeName.equals("TIMESTAMP") && (timeZoneValue = (String)dataTypeUsage.getAttributeValue("time_zone")) != null && timeZoneValue.equals("TIME ZONE")) {
            isValidType = false;
        }
        return isValidType;
    }

    protected void checkIsUniqueDefinition(Constraint con) throws ValidationException {
        super.checkIsUniqueDefinition(con);
        if (!(con.getRelation() instanceof Table) || !(con instanceof UniqueConstraint)) {
            return;
        }
        Table owningTable = (Table)con.getRelation();
        Column[] conColumns = ((UniqueConstraint)con).getColumns();
        Index[] indicies = owningTable.getIndexes();
        for (int i = 0; i < indicies.length; ++i) {
            IndexObject[] idxColExpressions = indicies[i].getColumnExpressions();
            if (idxColExpressions.length != conColumns.length || indicies[i].getIndexType() == Index.IndexType.UNIQUE && !con.isEnabled() || !OracleIndexAndConstraintValidator.contraintAndIndexColumnsMatch(this.getProvider(), owningTable, conColumns, idxColExpressions)) continue;
            throw new ValidationException((DBObject)con, DBArb.format((int)241, (Object[])new Object[]{this.getConstraintTypeDisplayName(con), con.getName(), indicies[i].getName()}));
        }
    }
}

