/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.validators.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexPartitionsValidator
extends AbstractValidator<OracleIndexPartitions> {
    public IndexPartitionsValidator(DBObjectProvider pro) {
        super(pro);
    }

    @Override
    protected boolean canHaveEmptyName() {
        return true;
    }

    @Override
    public void validateObject(OracleIndexPartitions original, OracleIndexPartitions oip) throws ValidationException {
        Index index = (Index)oip.getParent();
        if (index == null) {
            throw new ValidationException((DBObject)oip, "OracleIndexPartitions must have a parent Index");
        }
        Table table = index.getTable();
        if (table == null) {
            throw new ValidationException((DBObject)oip, "OracleIndexPartitions must have a parent Table");
        }
        super.validateObject(original, oip);
        this.validateGlobalHashPartitions(oip);
        this.validateGlobalRangePartitions(oip);
        this.validateLocalPartitions(oip);
    }

    private void validateGlobalPartitionColumns(OracleIndexPartitions oip) throws ValidationException {
        OracleIndexPartitions.PartitionType partitionType = oip.getPartitionType();
        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH || partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            DBObjectID[] partitionColumns = oip.getGlobalPartitionColumns();
            if (partitionColumns.length == 0) {
                throw new ValidationException((DBObject)oip, DBArb.getString((int)147));
            }
            Index index = (Index)oip.getParent();
            Table table = index.getTable();
            Column[] validColumns = OracleIndexPartitions.getValidGlobalPartitionColumns((Index)index);
            for (int i = 0; i < partitionColumns.length; ++i) {
                Column column = (Column)table.findOwnedObject(partitionColumns[i]);
                if (column == null) {
                    try {
                        column = (Column)partitionColumns[i].resolveID();
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                }
                if (column == null || i < validColumns.length && validColumns.length >= 1 && column.getName().equals(validColumns[i].getName())) continue;
                throw new ValidationException((DBObject)oip, DBArb.format((int)148, (Object)column.getName()));
            }
        }
    }

    private void validateGlobalHashPartitions(OracleIndexPartitions oip) throws ValidationException {
        Index index = (Index)oip.getParent();
        if (index.getIndexType() == Index.IndexType.BITMAP) {
            throw new ValidationException((DBObject)index, DBArb.getString((int)140));
        }
        OracleIndexPartitions.PartitionType m_partitionType = oip.getPartitionType();
        if (m_partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH) {
            this.validateGlobalPartitionColumns(oip);
            Integer globalHashQuantity = oip.getGlobalHashQuantity();
            int hashQuantity = globalHashQuantity == null ? 0 : globalHashQuantity;
            IndexPartition[] partitions = oip.getPartitions();
            if (hashQuantity == 0 && partitions.length == 0) {
                throw new ValidationException((DBObject)oip, DBArb.getString((int)149));
            }
            for (IndexPartition partition : partitions) {
                this.getProvider().validateObject((DBObject)partition);
            }
        }
    }

    private void validateGlobalRangePartitions(OracleIndexPartitions oip) throws ValidationException {
        OracleIndexPartitions.PartitionType partitionType = oip.getPartitionType();
        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            this.validateGlobalPartitionColumns(oip);
            IndexPartition[] partitions = oip.getPartitions();
            if (partitions.length == 0) {
                throw new ValidationException((DBObject)oip, DBArb.getString((int)150));
            }
            IndexPartition lastPartition = null;
            for (IndexPartition indexPartition : partitions) {
                this.getProvider().validateObject((DBObject)indexPartition);
                lastPartition = indexPartition;
            }
            for (Object object : lastPartition.getValuesLessThan()) {
                if (object != null && object == TablePartition.RangeValue.MAXVALUE) continue;
                throw new ValidationException((DBObject)oip, DBArb.getString((int)152));
            }
        }
    }

    private void validateLocalPartitions(OracleIndexPartitions oip) throws ValidationException {
        Index index = (Index)oip.getParent();
        OracleIndexPartitions.PartitionType partitionType = oip.getPartitionType();
        if (index != null && (partitionType == OracleIndexPartitions.PartitionType.DOMAIN || partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP || partitionType == OracleIndexPartitions.PartitionType.LOCAL_HASH || partitionType == OracleIndexPartitions.PartitionType.LOCAL_OTHER)) {
            OracleTablePartitions otp;
            Table table = index.getTable();
            OracleTablePartitions oracleTablePartitions = otp = table == null ? null : (OracleTablePartitions)table.getProperty("OracleTablePartitions");
            if (partitionType == OracleIndexPartitions.PartitionType.DOMAIN && otp != null && (otp.getPartitionType() == OracleTablePartitions.PartitionType.HASH || otp.getPartitionType() == OracleTablePartitions.PartitionType.LIST || otp.getSubpartitionModel() != null)) {
                String partitionTypeString = otp.getPartitionType().toString();
                if (otp.getSubpartitionModel() != null) {
                    partitionTypeString = partitionTypeString + "-" + otp.getSubpartitionModel().getPartitionType().toString();
                }
                throw new ValidationException((DBObject)oip, DBArb.format((int)156, (Object)partitionTypeString));
            }
            IndexPartition[] partitions = oip.getPartitions();
            if (partitions.length > 0) {
                if (otp == null) {
                    throw new ValidationException((DBObject)oip, DBArb.getString((int)154));
                }
                int tablePartitionCount = otp.getPartitions().length;
                if (tablePartitionCount == 0 && otp.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                    int n = tablePartitionCount = otp.getHashQuantity() == null ? 1 : otp.getHashQuantity();
                }
                if (tablePartitionCount != partitions.length) {
                    throw new ValidationException((DBObject)oip, DBArb.getString((int)155));
                }
            }
        }
    }
}

