/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.db.property.Property;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TriggerSXMLGenerator
extends SXMLFragmentGenerator {
    TriggerSXMLGenerator() {
    }

    protected void populateNode(Node parent, Document doc, Object obj) {
        String[] events;
        String root;
        Trigger trig = (Trigger)obj;
        Trigger.BaseType baseType = trig.getBaseType();
        if (baseType == null) {
            baseType = Trigger.BaseType.TABLE;
        }
        switch (baseType) {
            case SCHEMA: {
                root = "DDL_EVENT";
                break;
            }
            case DATABASE: {
                events = trig.getEvents();
                if (events.length > 0 && Trigger.isDatabaseOnlyEvent((String)events[0])) {
                    root = "DATABASE_EVENT";
                    break;
                }
                root = "DDL_EVENT";
                break;
            }
            default: {
                root = "DML_EVENT";
            }
        }
        this.findOrCreateNodeAfter(doc, parent, root, "TRIGGER_TYPE");
        switch (baseType) {
            case SCHEMA: {
                this.processPropertyMapping(parent, doc, trig, root + "/EVENT_LIST//EVENT_LIST_ITEM/EVENT", "events");
                this.processPropertyMapping(parent, doc, trig, root + "/SCHEMA", "baseSchemaName");
                break;
            }
            case DATABASE: {
                events = trig.getEvents();
                if (events.length <= 0) break;
                this.processPropertyMapping(parent, doc, trig, root + "/EVENT_LIST//EVENT_LIST_ITEM/EVENT", "events");
                if (Trigger.isDatabaseOnlyEvent((String)events[0])) break;
                this.findOrCreateNode(doc, parent, root + "/DATABASE");
                break;
            }
            default: {
                Node listNode = this.findOrCreateNode(doc, parent, root + "/EVENT_LIST");
                String[] events2 = trig.getEvents();
                for (int i = 0; i < events2.length; ++i) {
                    Node eventItemNode = this.createNode(doc, listNode, "EVENT_LIST_ITEM");
                    Node eventNode = this.createNode(doc, eventItemNode, "EVENT");
                    eventNode.appendChild(doc.createTextNode(events2[i]));
                    if (!events2[i].equals("UPDATE")) continue;
                    this.processPropertyMapping(eventItemNode, doc, trig, "COL_LIST//COL_LIST_ITEM/NAME", "columnIDs");
                }
                this.processPropertyMapping(parent, doc, trig, root + "/SCHEMA", Property.createPath((String[])new String[]{"tableID", "schema", "name"}));
                this.processPropertyMapping(parent, doc, trig, root + "/NAME", "tableID");
                if (ModelUtil.hasLength((String)trig.getReferencingOldAs())) {
                    Node oldNode = this.findOrCreateNode(doc, parent, root + "/REFERENCING/OLD_AS");
                    oldNode.appendChild(doc.createTextNode(trig.getReferencingOldAs()));
                }
                if (ModelUtil.hasLength((String)trig.getReferencingNewAs())) {
                    Node oldNode = this.findOrCreateNode(doc, parent, root + "/REFERENCING/NEW_AS");
                    oldNode.appendChild(doc.createTextNode(trig.getReferencingNewAs()));
                }
                this.processPropertyMapping(parent, doc, trig, root + "/REFERENCING/FOR_EACH_ROW", "statementLevel", new SXMLMappings.InverseBooleanConverter());
            }
        }
    }

    protected void readNode(Node parent, Object obj) {
        Trigger trigger = (Trigger)obj;
        Node eventListNode = null;
        Schema schema = null;
        if (this.nodeExists(parent, "DATABASE_EVENT")) {
            trigger.setBaseType(Trigger.BaseType.DATABASE);
            eventListNode = this.findNode(parent, "DATABASE_EVENT/EVENT_LIST");
        } else if (this.nodeExists(parent, "DDL_EVENT/DATABASE")) {
            trigger.setBaseType(Trigger.BaseType.DATABASE);
            eventListNode = this.findNode(parent, "DDL_EVENT/EVENT_LIST");
        } else if (this.nodeExists(parent, "DDL_EVENT")) {
            trigger.setBaseSchemaName(this.nodeText(parent, "DDL_EVENT/SCHEMA"));
            trigger.setBaseType(Trigger.BaseType.SCHEMA);
            eventListNode = this.findNode(parent, "DDL_EVENT/EVENT_LIST");
        } else {
            schema = new Schema(this.nodeText(parent, "DML_EVENT/SCHEMA"));
            NameBasedID id = new NameBasedID();
            id.setSchema(schema);
            id.setName(this.nodeText(parent, "DML_EVENT/NAME"));
            trigger.setTableID((DBObjectID)id);
            if ("INSTEAD_OF".equals(this.nodeText(parent, "TRIGGER_TYPE"))) {
                trigger.setBaseType(Trigger.BaseType.VIEW);
                id.setType("VIEW");
            } else {
                trigger.setBaseType(Trigger.BaseType.TABLE);
                id.setType("TABLE");
            }
            eventListNode = this.findNode(parent, "DML_EVENT/EVENT_LIST");
            trigger.setReferencingOldAs(this.nodeText(parent, "DML_EVENT/REFERENCING/OLD_AS"));
            trigger.setReferencingNewAs(this.nodeText(parent, "DML_EVENT/REFERENCING/NEW_AS"));
            if (this.nodeExists(parent, "DML_EVENT/REFERENCING/FOR_EACH_ROW")) {
                trigger.setStatementLevel(false);
            }
        }
        ArrayList<String> eventList = new ArrayList<String>();
        if (eventListNode != null) {
            SXMLFragmentGenerator.childXMLElementIterator it = new SXMLFragmentGenerator.childXMLElementIterator(eventListNode);
            while (it.hasNext()) {
                String event;
                Node node = (Node)it.next();
                if (!"EVENT_LIST_ITEM".equals(node.getLocalName()) || (event = this.nodeText(node, "EVENT")) == null) continue;
                eventList.add(event);
                if (!this.nodeExists(node, "COL_LIST")) continue;
                ArrayList<NameBasedID> columnList = new ArrayList<NameBasedID>();
                Node colListNode = this.findNode(node, "COL_LIST");
                NodeList colNodes = colListNode.getChildNodes();
                for (int j = 0; j < colNodes.getLength(); ++j) {
                    Node colNode = colNodes.item(j);
                    if (!"COL_LIST_ITEM".equals(colNode.getLocalName())) continue;
                    NameBasedID id = new NameBasedID();
                    id.setSchema(schema);
                    id.setName(this.nodeText(colNode, "NAME"));
                    id.setType("COLUMN");
                    id.setParent(trigger.getTableID());
                    columnList.add(id);
                }
                trigger.setColumnIDs(columnList.toArray(new DBObjectID[columnList.size()]));
            }
            trigger.setEvents(eventList.toArray(new String[eventList.size()]));
        }
    }
}

