/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Index;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.db.ora.sxml.ColumnSXMLGenerator;
import oracle.javatools.db.ora.sxml.ConstraintSXMLGenerator;
import oracle.javatools.db.ora.sxml.DataTypeSXMLGenerator;
import oracle.javatools.db.ora.sxml.IndexPartitionSXMLGenerator;
import oracle.javatools.db.ora.sxml.MatViewLogSXMLGenerator;
import oracle.javatools.db.ora.sxml.MatViewSXMLGenerator;
import oracle.javatools.db.ora.sxml.PartitionSXMLGenerator;
import oracle.javatools.db.ora.sxml.PhysicalPropsSXMLGenerator;
import oracle.javatools.db.ora.sxml.PlSqlMethodGenerator;
import oracle.javatools.db.ora.sxml.SQLFragmentSXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLValueConverter;
import oracle.javatools.db.ora.sxml.TriggerSXMLGenerator;
import oracle.javatools.db.ora.sxml.UnsupportedTypeForSXMLException;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SXMLMappings {
    private Map<String, List<Mapping>> m_mappings;
    private Map<String, String> m_nameMap;
    private Map<String, List<Class<? extends SXMLFragmentGenerator>>> m_genMap;
    private Map<String, String> m_xsdMap = new HashMap<String, String>();

    SXMLMappings() {
        this.m_mappings = new HashMap<String, List<Mapping>>();
        this.m_nameMap = new HashMap<String, String>();
        this.m_nameMap.put("TYPE", "TYPE_SPEC");
        this.m_genMap = new HashMap<String, List<Class<? extends SXMLFragmentGenerator>>>();
        YNBooleanConverter ynCon = new YNBooleanConverter();
        InverseBooleanConverter invBooCon = new InverseBooleanConverter();
        PositiveIntegerConverter posIntCon = new PositiveIntegerConverter();
        CommaSeperatingStringArrayConverter commaCon = new CommaSeperatingStringArrayConverter();
        this.registerXSD("TABLE", "kustable.xsd");
        this.registerXSD("MATERIALIZED VIEW", "kusmv.xsd");
        this.registerXSD("MATERIALIZED VIEW LOG", "kusmvl.xsd");
        this.registerXSD("SEQUENCE", "kusseq.xsd");
        this.registerXSD("SYNONYM", "kussyn.xsd");
        this.registerXSD("TRIGGER", "kustrig.xsd");
        this.registerXSD("INDEX", "kusindex.xsd");
        this.registerXSD("VIEW", "kusview.xsd");
        this.registerXSD("TYPE", "kustype.xsd");
        this.registerXSD("COMPOSITE", "kuscomp.xsd");
        String tableTypeKey = "properties/TableType";
        this.cache("TABLE", "GLOBAL_TEMPORARY", "properties/TableType", new ValueCheckingConverter(Table.TableType.TRANSACTION_TEMP, Table.TableType.SESSION_TEMP));
        this.cache("TABLE", "SCHEMA", "schema/name");
        this.cache("TABLE", "NAME", "name");
        this.cache("TABLE", "RELATIONAL_TABLE/COL_LIST//COL_LIST_ITEM", "columns");
        this.cache("TABLE", "RELATIONAL_TABLE/ON_COMMIT", "properties/TableType", new TempTableTypeConverter());
        this.registerGen("TABLE", PhysicalPropsSXMLGenerator.class);
        this.registerGen("TABLE", ColumnSXMLGenerator.class);
        this.cache("TABLE", "RELATIONAL_TABLE/TABLE_PROPERTIES/PARALLEL", "properties/parallel", new ParallelConverter());
        this.cache("COLUMN", "NAME", "name");
        this.cache("COLUMN", "DEFAULT", "default");
        this.cache("COLUMN", "NOT_NULL", "notNull", new ColumnNotNullConverter());
        this.registerGen("COLUMN", DataTypeSXMLGenerator.class);
        this.registerGen("TABLE", ConstraintSXMLGenerator.class);
        this.cache("CONSTRAINT", "NAME", "name");
        this.cache("CONSTRAINT", "COL_LIST//COL_LIST_ITEM/NAME", "columnIDs");
        this.cache("CONSTRAINT", "DISABLE", "enabled", invBooCon);
        this.registerGen("TABLE", PartitionSXMLGenerator.class);
        this.registerGen("MATERIALIZED VIEW", PartitionSXMLGenerator.class);
        this.registerGen("PARTITION MODEL", PartitionSXMLGenerator.class);
        this.registerGen("PARTITION", PartitionSXMLGenerator.class);
        this.registerGen("PARTITION", ColumnSXMLGenerator.class);
        this.cache("PARTITION MODEL", "COL_LIST//COL_LIST_ITEM/NAME", "partitionColumns");
        this.cache("PARTITION MODEL", "PARTITION_LIST//PARTITION_LIST_ITEM", "partitions");
        this.cache("PARTITION", "NAME", "name");
        this.cache("PARTITION", "VALUES", "values", commaCon);
        this.cache("PARTITION", "PHYSICAL_PROPERTIES/HEAP_TABLE/SEGMENT_ATTRIBUTES", "segmentAttributes");
        this.cache("PARTITION", "PHYSICAL_PROPERTIES/HEAP_TABLE/COMPRESS", "compression", new TabPartitionCompressionConverter());
        this.cache("OracleStorageProperties", "PCTFREE", "percentFree");
        this.cache("OracleStorageProperties", "PCTUSED", "percentUsed");
        this.cache("OracleStorageProperties", "INITRANS", "initrans");
        this.cache("OracleStorageProperties", "STORAGE/INITIAL", "initialExtent");
        this.cache("OracleStorageProperties", "STORAGE/NEXT", "nextExtent");
        this.cache("OracleStorageProperties", "STORAGE/MINEXTENTS", "minExtent");
        this.cache("OracleStorageProperties", "STORAGE/MAXEXTENTS", "maxExtent");
        this.cache("OracleStorageProperties", "STORAGE/PCTINCREASE", "percentIncrease");
        this.cache("OracleStorageProperties", "STORAGE/FREELISTS", "freelists");
        this.cache("OracleStorageProperties", "STORAGE/FREELIST_GROUPS", "freelistGroups");
        this.cache("OracleStorageProperties", "STORAGE/BUFFER_POOL", "bufferMode");
        this.cache("OracleStorageProperties", "TABLESPACE", "tablespaceID");
        this.cache("OracleStorageProperties", "LOGGING", "logging", ynCon);
        this.cache("OracleColumnProperties", "LOB_PROPERTIES/STORAGE_TABLE", "LOBProperties");
        this.cache("OracleColumnProperties", "VARRAY_PROPERTIES/STORE_AS", "VAProperties", new VAAsLOBConverter());
        this.cache("OracleColumnProperties", "VARRAY_PROPERTIES/LOB_PROPERTIES/STORAGE_TABLE", "VAProperties");
        this.cache("OracleColumnProperties", "NESTED_TABLE_PROPERTIES", "nestedTableProperties");
        this.cache("OracleColumnProperties", "XMLTYPE_PROPERTIES", "XMLTypeColumnProperties");
        this.cache("OracleNestedTableProperties", "STORAGE_TABLE/SCHEMA", "!schema");
        this.cache("OracleNestedTableProperties", "STORAGE_TABLE/NAME", "tableName");
        this.cache("OracleNestedTableProperties", "RETURN_AS", "returnAs");
        this.cache("LOB DESCRIPTOR", "SCHEMA", "!schema");
        this.cache("LOB DESCRIPTOR", "NAME", "LOBSegName");
        this.cache("LOB DESCRIPTOR", "TABLESPACE", "storage/tablespaceID");
        this.cache("LOB DESCRIPTOR", "STORAGE_IN_ROW", "storageEnabledInRow");
        this.cache("LOB DESCRIPTOR", "STORAGE/INITIAL", "storage/initialExtent");
        this.cache("LOB DESCRIPTOR", "STORAGE/NEXT", "storage/nextExtent");
        this.cache("LOB DESCRIPTOR", "STORAGE/MINEXTENTS", "storage/minExtent");
        this.cache("LOB DESCRIPTOR", "STORAGE/MAXEXTENTS", "storage/maxExtent");
        this.cache("LOB DESCRIPTOR", "STORAGE/PCTINCREASE", "storage/percentIncrease");
        this.cache("LOB DESCRIPTOR", "STORAGE/LOBRETENTION", "retention", new LOBRetentionConverter());
        this.cache("LOB DESCRIPTOR", "STORAGE/FREELISTS", "storage/freelists");
        this.cache("LOB DESCRIPTOR", "STORAGE/FREELIST_GROUPS", "storage/freelistGroups");
        this.cache("LOB DESCRIPTOR", "STORAGE/BUFFER_POOL", "storage/bufferMode");
        this.cache("LOB DESCRIPTOR", "CHUNK", "chunk");
        this.cache("LOB DESCRIPTOR", "PCTVERSION", "pctVersion");
        this.cache("LOB DESCRIPTOR", "CACHE", "cache", new LOBCacheConverter());
        this.cache("LOB DESCRIPTOR", "LOGGING", "storage/logging", ynCon);
        this.cache("XMLTypeColumnProperties", "XMLTYPE_STORAGE/STORE_AS", "storeAs", new XMLTypeColumnStoreAsConverter());
        this.cache("XMLTypeColumnProperties", "XMLSCHEMA", "elementID/parent/name");
        this.cache("XMLTypeColumnProperties", "ELEMENT", "elementID");
        this.cache("XMLTypeColumnProperties", "ALLOW_ANYSCHEMA", "allowAnySchema");
        this.cache("XMLTypeColumnProperties", "DISALLOW_NONSCHEMA", "allowNonSchema", invBooCon);
        this.cache("COLUMN", "CUSTOMER_AREA/ODB_PROPERTY_LIST/XMLTYPE_COLUMN_XMLSCHEMA_OWNER", "properties/OracleColumnProperties/XMLTypeColumnProperties/elementID/parent/schemaName");
        this.cache("IOT PROPERTIES", "MAPPING_TABLE", "mapped");
        this.cache("IOT PROPERTIES", "PCTTHRESHOLD", "pctThreshold");
        this.cache("IOT PROPERTIES", "KEYCOMPRESS", "keyCompression", new KeyCompressionConverter());
        this.cache("IOT PROPERTIES", "OVERFLOW/INCLUDING", "includeColumn/name");
        this.cache("IOT PROPERTIES", "OVERFLOW/SEGMENT_ATTRIBUTES", "overflowProperties");
        this.cache("EXTERNAL TABLE PROPERTIES", "ACCESS_DRIVER_TYPE", "accessDriverType");
        this.cache("EXTERNAL TABLE PROPERTIES", "DEFAULT_DIRECTORY", "defaultDirectory/name");
        this.cache("EXTERNAL TABLE PROPERTIES", "ACCESS_PARAMETERS", "accessParameters");
        this.cache("EXTERNAL TABLE PROPERTIES", "LOCATION//LOCATION_ITEM", "locationSpecifiers");
        this.cache("EXTERNAL TABLE PROPERTIES", "REJECT_LIMIT", "rejectLimit");
        String locSpec = "LOCATION_SPECIFIER";
        this.cache("LOCATION_SPECIFIER", "DIRECTORY", "directory/name");
        this.cache("LOCATION_SPECIFIER", "NAME", "specifier");
        this.cache("INDEX", "UNIQUE", "indexType", new ValueCheckingConverter(Index.IndexType.UNIQUE));
        this.cache("INDEX", "BITMAP", "indexType", new ValueCheckingConverter(Index.IndexType.BITMAP));
        this.cache("INDEX", "SCHEMA", "schema/name");
        this.cache("INDEX", "NAME", "name");
        this.cache("INDEX", "TABLE_INDEX/ON_TABLE/SCHEMA", "table/schema/name");
        this.cache("INDEX", "TABLE_INDEX/ON_TABLE/NAME", "table/name");
        this.cache("INDEX", "TABLE_INDEX/INDEX_ATTRIBUTES", "properties/OracleStorageProperties", new TempTableIndexCheckerConverter());
        this.cache("INDEX", "TABLE_INDEX/INDEX_ATTRIBUTES/KEYCOMPRESS", "keyCompression", new KeyCompressionConverter());
        this.cache("INDEX", "TABLE_INDEX/INDEX_ATTRIBUTES/PARALLEL", "parallelDegree", new ParallelConverter(ParallelConverter.OwnerType.INDEX));
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/INDEXTYPE/SCHEMA", "domainIndextype/schemaName");
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/INDEXTYPE/SCHEMA", "domainIndextype/schema/name");
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/INDEXTYPE/NAME", "domainIndextype/name");
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/PARALLEL", "parallelDegree", new ParallelConverter(ParallelConverter.OwnerType.DOMAIN_INDEX));
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/PARAMETERS", "domainIndextypeParameters");
        this.registerGen("INDEX", IndexPartitionSXMLGenerator.class);
        this.registerGen("INDEX PARTITION", IndexPartitionSXMLGenerator.class);
        this.cache("INDEX PARTITION MODEL", "PARTITION_LIST//PARTITION_LIST_ITEM", "partitions");
        this.cache("INDEX PARTITION", "NAME", "name");
        this.cache("INDEX PARTITION", "VALUES", "valuesLessThan", commaCon);
        this.cache("INDEX PARTITION", "SEGMENT_ATTRIBUTES", "segmentAttributes");
        this.cache("INDEX PARTITION", "KEYCOMPRESS", "keyCompression", new YNBooleanConverter());
        this.cache("INDEX PARTITION", "PARAMETERS", "domainParameters");
        this.cache("VIEW", "SCHEMA", "schema/name");
        this.cache("VIEW", "NAME", "name");
        this.cache("VIEW", "READ_ONLY", "queryRestriction", new ValueCheckingConverter("WITH READ ONLY"));
        this.cache("VIEW", "COL_LIST//COL_LIST_ITEM", "columns");
        this.cache("VIEW", "CUSTOMER_AREA/ODB_PROPERTY_LIST/FORCE_ON_CREATE", "forceOnCreate");
        this.cache("VIEW", "CUSTOMER_AREA/ODB_PROPERTY_LIST/CHECK_OPTION", "queryRestriction", new ValueCheckingConverter("WITH CHECK OPTION"));
        this.cache("SEQUENCE", "SCHEMA", "schema/name");
        this.cache("SEQUENCE", "NAME", "name");
        this.cache("SEQUENCE", "START_WITH", "startWith");
        this.cache("SEQUENCE", "INCREMENT", "incrementBy");
        this.cache("SEQUENCE", "MINVALUE", "minValue");
        this.cache("SEQUENCE", "MAXVALUE", "maxValue");
        this.cache("SEQUENCE", "CYCLE", "cycleFlag");
        this.cache("SEQUENCE", "CACHE", "cacheFlag", new CacheFlagConverter());
        this.cache("SEQUENCE", "CACHE", "cacheSize");
        this.cache("SEQUENCE", "ORDER", "orderFlag");
        this.cache("TRIGGER", "SCHEMA", "schema/name");
        this.cache("TRIGGER", "NAME", "name");
        this.cache("TRIGGER", "TRIGGER_TYPE", "timing");
        this.cache("TRIGGER", "WHEN_CONDITION", "whenClause");
        this.cache("TRIGGER", "PLSQL_BLOCK", "code");
        this.cache("TRIGGER", "DISABLE", "enabled", invBooCon);
        this.registerGen("TRIGGER", TriggerSXMLGenerator.class);
        this.cache("MATERIALIZED VIEW", "SCHEMA", "schema/name");
        this.cache("MATERIALIZED VIEW", "NAME", "name");
        this.cache("MATERIALIZED VIEW", "PHYSICAL_PROPERTIES/HEAP_TABLE", null);
        this.cache("MATERIALIZED VIEW", "PHYSICAL_PROPERTIES/HEAP_TABLE/SEGMENT_ATTRIBUTES", "properties/OracleStorageProperties");
        this.cache("MATERIALIZED VIEW", "PHYSICAL_PROPERTIES/HEAP_TABLE/COMPRESS", "compression", new MVCompressionConverter());
        this.cache("MATERIALIZED VIEW", "CACHE", "cache");
        this.cache("MATERIALIZED VIEW", "PARALLEL", "parallel", new ParallelConverter());
        this.cache("MATERIALIZED VIEW", "BUILD", "buildType");
        this.cache("MATERIALIZED VIEW", "ON_PREBUILT_TABLE", "onPrebuilt", new ValueCheckingConverter(MaterializedView.PrebuiltType.UNSPECIFIED_PRECISION));
        this.cache("MATERIALIZED VIEW", "ON_PREBUILT_TABLE/REDUCED_PRECISION", "onPrebuilt", new YNBooleanConverter(MaterializedView.PrebuiltType.WITH_REDUCED_PRECISION, MaterializedView.PrebuiltType.WITHOUT_REDUCED_PRECISION));
        this.cache("MATERIALIZED VIEW", "USING_NO_INDEX", "useNoIndex");
        this.cache("MATERIALIZED VIEW", "INDEX_ATTRIBUTES", "properties/MatViewIndexStorageProperties");
        this.cache("MATERIALIZED VIEW", "NEVER_REFRESH", "refreshMode", new ValueCheckingConverter(MaterializedView.RefreshMode.NEVER));
        this.cache("MATERIALIZED VIEW", "REFRESH", "refreshMode", new InverseValueCheckingConverter(MaterializedView.RefreshMode.NEVER));
        this.cache("MATERIALIZED VIEW", "REFRESH/FAST", "refreshMethod", new MVRefreshValueCheckingConverter(MaterializedView.RefreshMethod.FAST));
        this.cache("MATERIALIZED VIEW", "REFRESH/ON_COMMIT", "refreshMode", new ValueCheckingConverter(MaterializedView.RefreshMode.COMMIT));
        this.cache("MATERIALIZED VIEW", "REFRESH/COMPLETE", "refreshMethod", new MVRefreshValueCheckingConverter(MaterializedView.RefreshMethod.COMPLETE));
        this.cache("MATERIALIZED VIEW", "REFRESH/START_WITH", "nextRefreshDate", new MVRefreshStartWithConverter());
        this.cache("MATERIALIZED VIEW", "REFRESH/NEXT", "interval", new MVRefreshConverter());
        this.cache("MATERIALIZED VIEW", "REFRESH/WITH_PRIMARY_KEY", "keyType", new MVRefreshValueCheckingConverter(MaterializedView.RefreshWith.PRIMARY_KEY));
        this.cache("MATERIALIZED VIEW", "REFRESH/WITH_ROWID", "keyType", new MVRefreshValueCheckingConverter(MaterializedView.RefreshWith.ROWID));
        this.cache("MATERIALIZED VIEW", "REFRESH/CONSTRAINTS", "usingConstraints", new MVRefreshConverter());
        this.cache("MATERIALIZED VIEW", "QUERY_REWRITE", "rewrite");
        this.registerGen("MATERIALIZED VIEW", MatViewSXMLGenerator.class);
        this.cache("MATERIALIZED VIEW LOG", "ON_TABLE/SCHEMA", "schema/name");
        this.cache("MATERIALIZED VIEW LOG", "ON_TABLE/NAME", "masterTableID");
        this.cache("MATERIALIZED VIEW LOG", "SEGMENT_ATTRIBUTES", "properties/OracleStorageProperties");
        this.cache("MATERIALIZED VIEW LOG", "CACHE", "cache");
        this.cache("MATERIALIZED VIEW LOG", "PARALLEL", "parallel", new ParallelConverter());
        this.cache("MATERIALIZED VIEW LOG", "RECORDS/OBJECT_ID", "objectIdLogged");
        this.cache("MATERIALIZED VIEW LOG", "RECORDS/PRIMARY_KEY", "primaryKeyLogged");
        this.cache("MATERIALIZED VIEW LOG", "RECORDS/ROWID", "rowidLogged");
        this.cache("MATERIALIZED VIEW LOG", "RECORDS/SEQUENCE", "sequenceLogged");
        this.cache("MATERIALIZED VIEW LOG", "INCLUDING_NEW_VALUES", "newValues");
        this.registerGen("MATERIALIZED VIEW LOG", MatViewLogSXMLGenerator.class);
        this.cache("SYNONYM", "SCHEMA", "schema/name");
        this.cache("SYNONYM", "NAME", "name");
        this.cache("SYNONYM", "OBJECT_SCHEMA", "reference/schema/name");
        this.cache("SYNONYM", "OBJECT_SCHEMA", "reference/schemaName");
        this.cache("SYNONYM", "OBJECT_NAME", "reference/name");
        this.cache("SYNONYM", "DB_LINK", "reference/databaseLink");
        this.registerGen("TYPE", DataTypeSXMLGenerator.class);
        this.cache("TYPE", "SCHEMA", "schema/name");
        this.cache("TYPE", "NAME", "name");
        this.cache("TYPE", "OID", "OID");
        this.cache("TYPE", "OBJECT", "typeCode", new ValueCheckingConverter("OBJECT"));
        this.cache("TYPE", "OBJECT/AUTHID_CURRENT_USER", "authidCurrentUser", new ComplexTypeObjectConverter(true));
        this.cache("TYPE", "OBJECT/SQLJ_OBJECT_TYPE/NAME", "sqljExternalName");
        this.cache("TYPE", "OBJECT/SQLJ_OBJECT_TYPE/SQLDATA", "sqljUsing", new ValueCheckingConverter(ComplexType.SQLJUsingType.SQLData));
        this.cache("TYPE", "OBJECT/SQLJ_OBJECT_TYPE/CUSTOMDATUM", "sqljUsing", new ValueCheckingConverter(ComplexType.SQLJUsingType.CustomDatum));
        this.cache("TYPE", "OBJECT/SQLJ_OBJECT_TYPE/ORADATA", "sqljUsing", new ValueCheckingConverter(ComplexType.SQLJUsingType.OraData));
        this.cache("TYPE", "OBJECT/UNDER/SCHEMA", "underTypeID/schema/name");
        this.cache("TYPE", "OBJECT/UNDER/NAME", "underTypeID/name");
        this.cache("TYPE", "OBJECT/ATTRIBUTE_LIST//ATTRIBUTE_LIST_ITEM", "attributes");
        this.cache("TYPE", "OBJECT/ELEMENT_LIST//ELEMENT_LIST_ITEM", "methods");
        this.cache("TYPE", "OBJECT/NOT_FINAL", "final", new ComplexTypeObjectConverter(false));
        this.cache("TYPE", "OBJECT/NOT_INSTANTIABLE", "instantiable", new ComplexTypeObjectConverter(false));
        this.cache("TYPE", "VARRAY", "collectionType", new ValueCheckingConverter("VARYING ARRAY"));
        this.cache("TYPE", "NESTED_TABLE", "collectionType", new ValueCheckingConverter("TABLE"));
        this.cache("TYPE", "CUSTOMER_AREA/ODB_PROPERTY_LIST/PLSQL_BLOCK", "source");
        this.registerGen("TypeAttribute", DataTypeSXMLGenerator.class);
        this.cache("TypeAttribute", "NAME", "name");
        this.cache("TypeAttribute", "EXTERNAL_NAME", "sqljExternalName");
        this.registerGen("TypeMethod", PlSqlMethodGenerator.class);
        this.cache("TypeMethod", "OVERRIDING", "overriding");
        this.cache("TypeMethod", "FINAL", "final");
        this.cache("TypeMethod", "NOT_INSTANTIABLE", "instantiable", new InverseBooleanConverter());
        this.registerGen("PlSqlParameter", DataTypeSXMLGenerator.class);
        this.cache("PlSqlParameter", "NAME", "name");
        this.cache("PlSqlParameter", "OUT", "mode", new ValueCheckingConverter(PlSqlParameter.Mode.OUT));
        this.cache("PlSqlParameter", "IN_OUT", "mode", new ValueCheckingConverter(PlSqlParameter.Mode.INOUT));
        this.cache("PlSqlParameter", "NO_COPY", "noCopy");
        this.registerGen("VIEW", SQLFragmentSXMLGenerator.class);
        this.registerGen("MATERIALIZED VIEW", SQLFragmentSXMLGenerator.class);
        this.registerGen("INDEX", SQLFragmentSXMLGenerator.class);
        this.registerGen("CONSTRAINT", SQLFragmentSXMLGenerator.class);
    }

    String getNodeName(String objType) {
        if (this.m_nameMap.containsKey(objType)) {
            return this.m_nameMap.get(objType);
        }
        return objType.replaceAll(" ", "_");
    }

    boolean hasMappings(String type) {
        return this.m_mappings.containsKey(type);
    }

    Iterator<Mapping> getMappings(String type) {
        if (!this.m_mappings.containsKey(type)) {
            if (this.m_genMap.containsKey(type)) {
                return new ArrayList().iterator();
            }
            throw new UnsupportedTypeForSXMLException(type);
        }
        return this.m_mappings.get(type).iterator();
    }

    Iterator<Class<? extends SXMLFragmentGenerator>> getGenerators(String type) {
        if (this.m_genMap.containsKey(type)) {
            return this.m_genMap.get(type).iterator();
        }
        return null;
    }

    Iterator<String> getGeneratorTypes() {
        return this.m_genMap.keySet().iterator();
    }

    private void registerXSD(String type, String xsd) {
        this.m_xsdMap.put(type, xsd);
    }

    XMLSchema getXSD(String type) {
        String xsd = this.m_xsdMap.get(type);
        if (xsd != null) {
            String res = this.getClass().getPackage().getName().replaceAll("\\.", "/") + "/xsd/" + xsd;
            URL url = this.getClass().getClassLoader().getResource(res);
            try {
                XSDBuilder builder = new XSDBuilder();
                return builder.build(url);
            }
            catch (Exception e) {
                DBLog.logStackTrace((Throwable)e);
            }
        }
        return null;
    }

    void registerGen(String type, Class<? extends SXMLFragmentGenerator> gen) {
        List<Class<? extends SXMLFragmentGenerator>> cache = this.m_genMap.get(type);
        if (cache == null) {
            cache = new ArrayList<Class<? extends SXMLFragmentGenerator>>();
            this.m_genMap.put(type, cache);
        }
        cache.add(gen);
    }

    protected void cache(String type, String elementPath, String propertyPath) {
        this.cache(type, elementPath, propertyPath, null);
    }

    protected void cache(String type, String elementPath, String propertyPath, SXMLValueConverter con) {
        List<Mapping> cache = this.m_mappings.get(type);
        if (cache == null) {
            cache = new ArrayList<Mapping>();
            this.m_mappings.put(type, cache);
        }
        cache.add(new Mapping(elementPath, propertyPath, con));
    }

    protected void uncache(String type, String elementPath, String propertyPath) {
        List<Mapping> cache = this.m_mappings.get(type);
        if (cache == null) {
            return;
        }
        for (int i = 0; i < cache.size(); ++i) {
            Mapping mapping = cache.get(i);
            if (!mapping.getElementPath().equals(elementPath) || (mapping.getPropertyPath() != null || propertyPath != null) && !mapping.getPropertyPath().equals(propertyPath)) continue;
            cache.remove(mapping);
            break;
        }
    }

    static class TempTableIndexCheckerConverter
    implements SXMLValueConverter {
        TempTableIndexCheckerConverter() {
        }

        public Object getXMLValue(Object owner, Object propValue) {
            Table.TableType tt;
            if (owner instanceof Index && ((Index)owner).getTable() != null && ((tt = (Table.TableType)((Index)owner).getTable().getProperty("TableType")) == Table.TableType.SESSION_TEMP || tt == Table.TableType.TRANSACTION_TEMP)) {
                return null;
            }
            return propValue;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            return propValue;
        }
    }

    static class XMLTypeColumnStoreAsConverter
    implements SXMLValueConverter {
        XMLTypeColumnStoreAsConverter() {
        }

        public Object getXMLValue(Object owner, Object propValue) {
            if (XMLTypeColumnProperties.StoreAs.CLOB.equals(propValue)) {
                return "LOB";
            }
            if (XMLTypeColumnProperties.StoreAs.BINARY_XML.equals(propValue)) {
                return "BINARY_XML";
            }
            return "OBJECT_RELATIONAL";
        }

        public Object getBeanValue(Object owner, Object propValue) {
            if ("LOB".equals(propValue)) {
                return XMLTypeColumnProperties.StoreAs.CLOB;
            }
            if ("BINARY_XML".equals(propValue)) {
                return XMLTypeColumnProperties.StoreAs.BINARY_XML;
            }
            return XMLTypeColumnProperties.StoreAs.OBJECT_RELATIONAL;
        }
    }

    static class ComplexTypeObjectConverter
    implements SXMLValueConverter {
        private Boolean m_val;

        public ComplexTypeObjectConverter(Boolean val) {
            this.m_val = val;
        }

        public Object getXMLValue(Object owner, Object propValue) {
            if (owner instanceof ComplexType && propValue instanceof Boolean && this.m_val.equals(propValue) && "OBJECT".equals(((ComplexType)owner).getTypeCode())) {
                return true;
            }
            return null;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            if (owner instanceof ComplexType && "OBJECT".equals(((ComplexType)owner).getTypeCode())) {
                return this.m_val;
            }
            return this.m_val == false;
        }
    }

    static class KeyCompressionConverter
    implements SXMLValueConverter {
        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue != null && propValue instanceof Integer) {
                if (propValue == Integer.valueOf(0)) {
                    return Character.valueOf('Y');
                }
                return propValue;
            }
            return null;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue != null && propValue instanceof String) {
                if ("Y".equals(propValue)) {
                    return 0;
                }
                if ("N".equals(propValue)) {
                    return null;
                }
                return propValue;
            }
            return null;
        }
    }

    static class MVCompressionConverter
    implements SXMLValueConverter {
        MVCompressionConverter() {
        }

        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue instanceof Boolean && ((Boolean)propValue).booleanValue()) {
                return "ALL";
            }
            return null;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue != null) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    static class TabPartitionCompressionConverter
    implements SXMLValueConverter {
        TabPartitionCompressionConverter() {
        }

        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue != null && !"NOCOMPRESS".equals(propValue)) {
                return "ALL";
            }
            return null;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue == null) {
                return "NOCOMPRESS";
            }
            return "COMPRESS";
        }
    }

    static class MVRefreshStartWithConverter
    implements SXMLValueConverter {
        private static final String PREFIX = "GREATEST(SYSDATE,TO_DATE('";
        private static final String SUFFIX = "','YYYY.MM.DD.HH24.MI.SS'))";
        private static final String FORMAT_MASK = "yyyy.MM.dd.HH.mm.ss";
        private static final String OLD_FORMAT_MASK = "EEE MMM dd HH:mm:ss zzz yyyy";

        MVRefreshStartWithConverter() {
        }

        public Object getXMLValue(Object owner, Object propValue) {
            StringBuilder sb = new StringBuilder();
            if (propValue instanceof Date) {
                Date d = (Date)propValue;
                SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_MASK);
                sb.append(PREFIX);
                sb.append(sdf.format(d));
                sb.append(SUFFIX);
            }
            return sb.toString();
        }

        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue instanceof String) {
                SimpleDateFormat sdf;
                String str = (String)propValue;
                if (str.startsWith(PREFIX) && str.endsWith(SUFFIX)) {
                    str = str.substring(PREFIX.length(), str.length() - SUFFIX.length());
                    sdf = new SimpleDateFormat(FORMAT_MASK);
                } else {
                    sdf = new SimpleDateFormat(OLD_FORMAT_MASK);
                }
                try {
                    return sdf.parse(str);
                }
                catch (ParseException pe) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    static class MVRefreshConverter
    implements SXMLValueConverter {
        public Object getXMLValue(Object owner, Object propValue) {
            if (owner instanceof MaterializedView && ((MaterializedView)owner).getRefreshMode() == MaterializedView.RefreshMode.NEVER) {
                return false;
            }
            return propValue;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            return propValue;
        }
    }

    class MVRefreshValueCheckingConverter
    extends ValueCheckingConverter {
        MVRefreshValueCheckingConverter(Object ... values) {
            super(values);
        }

        public Object getXMLValue(Object owner, Object propValue) {
            if (owner instanceof MaterializedView && ((MaterializedView)owner).getRefreshMode() == MaterializedView.RefreshMode.NEVER) {
                return false;
            }
            return super.getXMLValue(owner, propValue);
        }
    }

    static class ColumnNotNullConverter
    implements SXMLValueConverter {
        ColumnNotNullConverter() {
        }

        public Object getXMLValue(Object owner, Object propValue) {
            if (owner != null && owner instanceof Column && ((Column)owner).getRelation() instanceof View) {
                return false;
            }
            return propValue;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            return true;
        }
    }

    static class TempTableTypeConverter
    implements SXMLValueConverter {
        TempTableTypeConverter() {
        }

        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue == Table.TableType.TRANSACTION_TEMP) {
                return "DELETE";
            }
            if (propValue == Table.TableType.SESSION_TEMP) {
                return "PRESERVE";
            }
            return null;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            throw new UnsupportedOperationException("Done be PhysicalPropsSXMLGenerator.readNode()");
        }
    }

    static class CacheFlagConverter
    implements SXMLValueConverter {
        CacheFlagConverter() {
        }

        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue != null && !((Boolean)propValue).booleanValue()) {
                return 0;
            }
            return null;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue != null && propValue.equals("0")) {
                return false;
            }
            return propValue != null;
        }
    }

    static class ParallelConverter
    implements SXMLValueConverter {
        private OwnerType m_ownerTypeContext;

        ParallelConverter() {
            this.m_ownerTypeContext = OwnerType.TABLE;
        }

        ParallelConverter(OwnerType ownerType) {
            this.m_ownerTypeContext = ownerType;
        }

        public Object getXMLValue(Object owner, Object propValue) {
            int degree;
            if (propValue == null) {
                return null;
            }
            if (this.m_ownerTypeContext == OwnerType.INDEX || this.m_ownerTypeContext == OwnerType.DOMAIN_INDEX) {
                Index idx;
                Index index = idx = owner instanceof Index ? (Index)owner : null;
                if (idx == null || this.m_ownerTypeContext == OwnerType.DOMAIN_INDEX && idx.getDomainIndextype() == null || this.m_ownerTypeContext == OwnerType.INDEX && idx.getDomainIndextype() != null) {
                    return null;
                }
            }
            return (degree = ((Integer)propValue).intValue()) == 0 ? "AUTOMATIC" : (degree == 1 ? null : propValue);
        }

        public Object getBeanValue(Object owner, Object propValue) {
            if ("AUTOMATIC".equals(propValue)) {
                return 0;
            }
            return propValue;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum OwnerType {
            TABLE,
            INDEX,
            DOMAIN_INDEX;

        }
    }

    static class CommaSeperatingStringArrayConverter
    implements SXMLValueConverter {
        CommaSeperatingStringArrayConverter() {
        }

        public Object getXMLValue(Object owner, Object propValue) {
            StringBuffer buff = new StringBuffer();
            if (propValue != null) {
                Object[] s = (Object[])propValue;
                for (int i = 0; i < s.length; ++i) {
                    if (buff.length() > 0) {
                        buff.append(", ");
                    }
                    buff.append(s[i]);
                }
            }
            return buff.length() > 0 ? buff.toString() : null;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue instanceof String) {
                PlSqlToken startTk;
                PlSqlToken endTk = startTk = PlSqlTokenizer.tokenize((String)((String)propValue), (String[])new String[0]);
                ArrayList<String> chunks = new ArrayList<String>();
                int parens = 0;
                while (true) {
                    boolean reachedEnd;
                    boolean bl = reachedEnd = endTk.getType() == PlSqlToken.Type.END_MARKER;
                    if (endTk.matches("(")) {
                        ++parens;
                    } else if (endTk.matches(")")) {
                        --parens;
                    } else if (reachedEnd || endTk.matches(",") && parens == 0) {
                        chunks.add(startTk.getSource(false, endTk.getPrevToken()));
                        startTk = endTk.getNextToken();
                    }
                    if (reachedEnd) break;
                    endTk = endTk.getNextToken();
                }
                String[] retval = new String[chunks.size()];
                for (int i = 0; i < chunks.size(); ++i) {
                    retval[i] = ((String)chunks.get(i)).trim();
                }
                return retval;
            }
            return null;
        }
    }

    class InverseValueCheckingConverter
    implements SXMLValueConverter {
        private Object m_value;

        InverseValueCheckingConverter(Object value) {
            this.m_value = value;
        }

        public Object getXMLValue(Object owner, Object propValue) {
            return !ModelUtil.areEqual((Object)propValue, (Object)this.m_value);
        }

        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue instanceof Boolean) {
                return (Boolean)propValue != false ? null : this.m_value;
            }
            return propValue == null ? this.m_value : null;
        }
    }

    class ValueCheckingConverter
    implements SXMLValueConverter {
        private Object[] m_values;

        ValueCheckingConverter(Object ... values) {
            this.m_values = values;
        }

        public Object getXMLValue(Object owner, Object propValue) {
            for (Object o : this.m_values) {
                if (!ModelUtil.areEqual((Object)propValue, (Object)o)) continue;
                return true;
            }
            return false;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue instanceof Boolean) {
                return (Boolean)propValue != false ? this.m_values[0] : null;
            }
            return this.m_values[0];
        }
    }

    static class PositiveIntegerConverter
    implements SXMLValueConverter {
        PositiveIntegerConverter() {
        }

        public Object getXMLValue(Object owner, Object propValue) {
            return propValue != null && (Integer)propValue > 0 ? propValue : null;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            return propValue;
        }
    }

    static class VAAsLOBConverter
    implements SXMLValueConverter {
        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue != null) {
                return "LOB";
            }
            return null;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            return propValue != null;
        }
    }

    static class LOBRetentionConverter
    implements SXMLValueConverter {
        public Object getXMLValue(Object owner, Object propValue) {
            if (((Boolean)propValue).booleanValue()) {
                return "AUTO";
            }
            return null;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            return propValue != null;
        }
    }

    static class LOBCacheConverter
    implements SXMLValueConverter {
        public Object getXMLValue(Object owner, Object propValue) {
            if (ModelUtil.areEqual((Object)"CACHE", (Object)propValue)) {
                return "Y";
            }
            if (ModelUtil.areEqual((Object)"NOCACHE", (Object)propValue)) {
                return "N";
            }
            if (ModelUtil.areEqual((Object)"CACHE READS", (Object)propValue)) {
                return "READS";
            }
            return null;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            if (ModelUtil.areEqual((Object)"Y", (Object)propValue)) {
                return "CACHE";
            }
            if (ModelUtil.areEqual((Object)"N", (Object)propValue)) {
                return "NOCACHE";
            }
            if (ModelUtil.areEqual((Object)"READS", (Object)propValue)) {
                return "CACHE READS";
            }
            return null;
        }
    }

    static class YNBooleanConverter
    implements SXMLValueConverter {
        private Object m_yes;
        private Object m_no;

        public YNBooleanConverter() {
        }

        public YNBooleanConverter(Object yes, Object no) {
            this.m_yes = yes;
            this.m_no = no;
        }

        public Object getXMLValue(Object owner, Object propValue) {
            if (this.m_yes != null) {
                if (ModelUtil.areEqual((Object)this.m_yes, (Object)propValue)) {
                    return "Y";
                }
                if (ModelUtil.areEqual((Object)this.m_no, (Object)propValue)) {
                    return "N";
                }
                return null;
            }
            return propValue == null ? null : ((Boolean)propValue != false ? "Y" : "N");
        }

        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue == null) {
                return null;
            }
            if (this.m_yes != null) {
                if (ModelUtil.areEqual((Object)"Y", (Object)propValue)) {
                    return this.m_yes;
                }
                if (ModelUtil.areEqual((Object)"N", (Object)propValue)) {
                    return this.m_no;
                }
                return null;
            }
            if (propValue instanceof Boolean) {
                return propValue;
            }
            if (ModelUtil.areEqual((Object)"Y", (Object)propValue)) {
                return true;
            }
            if (ModelUtil.areEqual((Object)"N", (Object)propValue)) {
                return false;
            }
            return null;
        }
    }

    static class InverseBooleanConverter
    implements SXMLValueConverter {
        InverseBooleanConverter() {
        }

        public Object getXMLValue(Object owner, Object propValue) {
            return (Boolean)propValue == false;
        }

        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue instanceof Boolean) {
                return (Boolean)propValue == false;
            }
            return propValue == null;
        }
    }

    static class Mapping {
        private String m_elemPath;
        private String m_propPath;
        private SXMLValueConverter m_con;

        Mapping(String elemPath, String propPath, SXMLValueConverter con) {
            this.m_elemPath = elemPath;
            this.m_propPath = propPath;
            this.m_con = con;
        }

        String getElementPath() {
            return this.m_elemPath;
        }

        String getPropertyPath() {
            return this.m_propPath;
        }

        SXMLValueConverter getConverter() {
            return this.m_con;
        }
    }
}

