/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatViewLogSXMLGenerator
extends SXMLFragmentGenerator {
    @Override
    protected void populateNode(Node parent, Document doc, Object obj) {
        if (obj instanceof MaterializedViewLog) {
            MaterializedViewLog mvl = (MaterializedViewLog)obj;
            ArrayList<DBObjectID> colIDs = new ArrayList<DBObjectID>();
            if (mvl.getPrimaryKeyLogged() == Boolean.TRUE) {
                this.addOrRemovePKCOls(mvl, colIDs, true);
            }
            for (DBObjectID colID : mvl.getColumnIDs()) {
                colIDs.add(colID);
            }
            Node refNode = this.findOrCreateNodeAfter(doc, parent, "RECORDS", "PARALLEL");
            Node colListNode = this.findOrCreateNode(doc, refNode, "COL_LIST");
            for (DBObjectID colID : colIDs) {
                String colName = DBUtil.getDBObjectName((DBObjectID)colID);
                Node colNameNode = this.createNode(doc, colListNode, "COL_LIST_ITEM/NAME");
                colNameNode.appendChild(doc.createTextNode(colName));
            }
        }
    }

    @Override
    protected void readNode(Node parent, Object obj) {
        if (obj instanceof MaterializedViewLog) {
            MaterializedViewLog mvl = (MaterializedViewLog)obj;
            ArrayList<DBObjectID> colIDs = new ArrayList<DBObjectID>();
            Node colListNode = this.findNode(parent, "RECORDS/COL_LIST");
            if (colListNode != null) {
                SXMLFragmentGenerator.childXMLElementIterator it = new SXMLFragmentGenerator.childXMLElementIterator(colListNode);
                while (it.hasNext()) {
                    Node n = it.next();
                    String name = this.nodeText(n, "NAME");
                    NameBasedID id = new NameBasedID("COLUMN", name, mvl.getMasterTableID());
                    colIDs.add((DBObjectID)id);
                }
            }
            if (mvl.getPrimaryKeyLogged() == Boolean.TRUE) {
                this.addOrRemovePKCOls(mvl, colIDs, false);
            }
            mvl.setColumnIDs(colIDs.toArray(new DBObjectID[colIDs.size()]));
        }
    }

    private void addOrRemovePKCOls(MaterializedViewLog mvl, List<DBObjectID> colIDs, boolean add) {
        Table table = this.getMasterTable(mvl);
        if (table != null) {
            for (Constraint c : table.getConstraints()) {
                if (!(c instanceof PKConstraint)) continue;
                for (DBObjectID pkColID : ((PKConstraint)c).getColumnIDs()) {
                    if (add) {
                        colIDs.add(pkColID);
                        continue;
                    }
                    DBObjectID delID = null;
                    String pkColName = DBUtil.getDBObjectName((DBObjectID)pkColID);
                    for (DBObjectID colID : colIDs) {
                        String colName = DBUtil.getDBObjectName((DBObjectID)colID);
                        if (!colName.equals(pkColName)) continue;
                        delID = colID;
                        break;
                    }
                    if (delID == null) continue;
                    colIDs.remove(delID);
                }
                break;
            }
        }
    }

    private Table getMasterTable(MaterializedViewLog mvl) {
        DBObjectID id = mvl.getMasterTableID();
        Table retval = null;
        if (id != null) {
            try {
                retval = (Table)id.resolveID();
            }
            catch (DBException e) {
                retval = null;
            }
            if (retval == null) {
                if ((id = (DBObjectID)id.copyTo(null)) instanceof BaseObjectID) {
                    ((BaseObjectID)id).setProvider(this.getProvider(mvl));
                    ((BaseObjectID)id).setSchemaName(this.getSchemaName(mvl));
                }
                try {
                    retval = (Table)id.resolveID();
                }
                catch (DBException e) {
                    DBLog.getLogger((Object)this).warning(e.getMessage());
                }
            }
        }
        return retval;
    }

    private DBObjectProvider getProvider(MaterializedViewLog mvl) {
        DBObjectProvider retval = null;
        if (mvl.getID() instanceof BaseObjectID && ((BaseObjectID)mvl.getID()).getProvider() != null) {
            retval = ((BaseObjectID)mvl.getID()).getProvider();
        } else if (this.getParentGenerator() instanceof SXMLReader) {
            SXMLReader reader = (SXMLReader)this.getParentGenerator();
            retval = reader.getProvider();
        }
        return retval;
    }

    private String getSchemaName(MaterializedViewLog mvl) {
        return mvl.getSchema().getName();
    }
}

