/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstraintSXMLGenerator
extends SXMLFragmentGenerator {
    private static final String CKS = "CHECK_CONSTRAINT_LIST";
    private static final String PKS = "PRIMARY_KEY_CONSTRAINT_LIST";
    private static final String UKS = "UNIQUE_KEY_CONSTRAINT_LIST";
    private static final String FKS = "FOREIGN_KEY_CONSTRAINT_LIST";

    ConstraintSXMLGenerator() {
    }

    @Override
    protected void populateNode(Node parent, Document doc, Object obj) {
        Node relTabNode = this.findOrCreateNode(doc, parent, "RELATIONAL_TABLE");
        Node cks = this.findOrCreateNodeAfter(doc, relTabNode, CKS, "COL_LIST");
        Node pks = this.findOrCreateNodeAfter(doc, relTabNode, PKS, CKS);
        Node uks = this.findOrCreateNodeAfter(doc, relTabNode, UKS, PKS);
        Node fks = this.findOrCreateNodeAfter(doc, relTabNode, FKS, UKS);
        Table tab = (Table)obj;
        Constraint[] cons = tab.getConstraints();
        for (int i = 0; i < cons.length; ++i) {
            if (cons[i] instanceof PKConstraint) {
                this.processConstraint(doc, parent, cons[i], PKS, pks);
                continue;
            }
            if (cons[i] instanceof FKConstraint) {
                Node conNode = this.processConstraint(doc, parent, cons[i], FKS, fks);
                FKConstraint fk = (FKConstraint)cons[i];
                DBObjectID refID = fk.getReferenceID();
                String refSchemaName = null;
                String refTableName = null;
                String[] refColumnNames = new String[]{};
                if (refID instanceof ReferenceID) {
                    ReferenceID ukID = (ReferenceID)refID;
                    DBObjectID parID = ukID.getParent();
                    if (parID instanceof BaseObjectID) {
                        refSchemaName = ((BaseObjectID)parID).getSchemaName();
                        refTableName = ((BaseObjectID)parID).getName();
                        refColumnNames = ukID.getChildObjectNames();
                    }
                } else {
                    DBObject refObj = null;
                    try {
                        refObj = refID.resolveID();
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                    if (refObj instanceof UniqueConstraint) {
                        UniqueConstraint uk = (UniqueConstraint)refObj;
                        SchemaObject par = (SchemaObject)uk.getParent();
                        refSchemaName = par.getSchema().getName();
                        refTableName = par.getName();
                        refColumnNames = new String[uk.getColumnIDs().length];
                        int j = 0;
                        for (DBObjectID dBObjectID : uk.getColumnIDs()) {
                            if (dBObjectID instanceof BaseObjectID) {
                                refColumnNames[j++] = ((BaseObjectID)dBObjectID).getName();
                                continue;
                            }
                            try {
                                Column c = (Column)dBObjectID.resolveID();
                                refColumnNames[j++] = c.getName();
                            }
                            catch (DBException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                Node refNode = this.findOrCreateNodeAfter(doc, conNode, "REFERENCES", "COL_LIST");
                Node schemaNode = this.findOrCreateNode(doc, refNode, "SCHEMA");
                schemaNode.appendChild(doc.createTextNode(refSchemaName));
                Node tableNode = this.findOrCreateNode(doc, refNode, "NAME");
                tableNode.appendChild(doc.createTextNode(refTableName));
                Node colListNode = this.findOrCreateNode(doc, refNode, "COL_LIST");
                for (String string : refColumnNames) {
                    Node colNameNode = this.createNode(doc, colListNode, "COL_LIST_ITEM/NAME");
                    colNameNode.appendChild(doc.createTextNode(string));
                }
                int n = fk.getDeleteMode();
                if (n <= 0) continue;
                Node delNode = this.findOrCreateNode(doc, refNode, "ON_DELETE");
                String txt = n == 1 ? "CASCADE" : (n == 2 ? "SET_NULL" : null);
                if (txt == null) continue;
                delNode.appendChild(doc.createTextNode(txt));
                continue;
            }
            if (cons[i] instanceof CheckConstraint) {
                this.processConstraint(doc, parent, cons[i], CKS, cks);
                continue;
            }
            if (!(cons[i] instanceof UniqueConstraint)) continue;
            this.processConstraint(doc, parent, cons[i], UKS, uks);
        }
        if (pks.getChildNodes().getLength() == 0) {
            relTabNode.removeChild(pks);
        }
        if (uks.getChildNodes().getLength() == 0) {
            relTabNode.removeChild(uks);
        }
        if (cks.getChildNodes().getLength() == 0) {
            relTabNode.removeChild(cks);
        }
        if (fks.getChildNodes().getLength() == 0) {
            relTabNode.removeChild(fks);
        }
    }

    private Node processConstraint(Document doc, Node parentNode, Constraint con, String listName, Node listNode) {
        Node conNode = this.createNode(doc, listNode, listName + "_ITEM");
        this.getParentGenerator().populateNode(conNode, doc, con);
        return conNode;
    }

    @Override
    protected void readNode(Node parent, Object obj) {
        SXMLReader reader = (SXMLReader)this.getParentGenerator();
        Table tab = (Table)obj;
        Object constraintsNode = null;
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        this.addConstraints(reader, this.findNode(parent, "RELATIONAL_TABLE/CHECK_CONSTRAINT_LIST"), constraints, CheckConstraint.class);
        this.addConstraints(reader, this.findNode(parent, "RELATIONAL_TABLE/PRIMARY_KEY_CONSTRAINT_LIST"), constraints, PKConstraint.class);
        this.addConstraints(reader, this.findNode(parent, "RELATIONAL_TABLE/UNIQUE_KEY_CONSTRAINT_LIST"), constraints, UniqueConstraint.class);
        this.addConstraints(reader, this.findNode(parent, "RELATIONAL_TABLE/FOREIGN_KEY_CONSTRAINT_LIST"), constraints, FKConstraint.class);
        tab.setConstraints(constraints.toArray(new Constraint[constraints.size()]));
    }

    private void addConstraints(SXMLReader reader, Node constraintsNode, ArrayList<Constraint> constraints, Class<? extends Constraint> clz) {
        if (constraintsNode != null) {
            SXMLFragmentGenerator.childXMLElementIterator nodeIter = new SXMLFragmentGenerator.childXMLElementIterator(constraintsNode);
            while (nodeIter.hasNext()) {
                Node n = (Node)nodeIter.next();
                Constraint c = null;
                try {
                    c = clz.newInstance();
                    reader.fillInObject(c, n, null);
                    constraints.add(c);
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                if (!(c instanceof FKConstraint)) continue;
                String schemaName = this.nodeText(n, "REFERENCES/SCHEMA");
                Schema schema = new Schema(schemaName);
                String tableName = this.nodeText(n, "REFERENCES/NAME");
                ArrayList<String> colNames = new ArrayList<String>();
                Node colListNode = this.findNode(n, "REFERENCES/COL_LIST");
                if (colListNode != null) {
                    SXMLFragmentGenerator.childXMLElementIterator colListIter = new SXMLFragmentGenerator.childXMLElementIterator(colListNode);
                    while (colListIter.hasNext()) {
                        Node colNode = (Node)colListIter.next();
                        colNames.add(this.nodeText(colNode, "NAME"));
                    }
                }
                ReferenceID tabID = new ReferenceID("TABLE", schema, tableName);
                ReferenceID refID = new ReferenceID("CONSTRAINT", (DBObjectID)tabID, null, "FKConstraint", colNames.toArray(new String[colNames.size()]));
                ReferenceID oldRefID = (ReferenceID)((FKConstraint)c).getReferenceID();
                if (oldRefID != null) {
                    refID.setName(oldRefID.getName());
                }
                ((FKConstraint)c).setReferenceID((DBObjectID)refID);
                if ("SET_NULL".equals(this.nodeText(n, "REFERENCES/ON_DELETE"))) {
                    ((FKConstraint)c).setDeleteMode(2);
                    continue;
                }
                if ("CASCADE".equals(this.nodeText(n, "REFERENCES/ON_DELETE"))) {
                    ((FKConstraint)c).setDeleteMode(1);
                    continue;
                }
                ((FKConstraint)c).setDeleteMode(0);
            }
        }
    }
}

