/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import oracle.javatools.db.Index;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.owb.OMBPropertyResolver;
import oracle.javatools.db.ora.owb.OMBStoragePropsBuilder;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;

class OMBIndexPropsBuilder
extends OMBStoragePropsBuilder {
    Index m_index = null;

    public OMBIndexPropsBuilder(Object forIndex) {
        this.setContextObject(forIndex);
        this.m_index = (Index)forIndex;
        this.setMapPath("properties/OracleStorageProperties/");
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    public void registerPropertyMappings() {
        super.registerPropertyMappings();
        if (!(this.m_index.getParent() instanceof MaterializedView)) {
            this.registerPropertyMapping("parallelDegree", new String[]{"PARALLEL_ACCESS_MODE", "PARALLEL_DEGREE"});
            HashMap<String, String> parallelMap = new HashMap<String, String>();
            parallelMap.put("$DEFAULT$", "PARALLEL");
            this.registerSubstitutionValues("PARALLEL_ACCESS_MODE", (HashMap)parallelMap);
        }
        this.registerPropertyMapping("keyCompression", new String[]{"KEYCOMPRESS", "KEYCOMPRESSPREFIXLENGTH"});
        HashMap<String, String> compressMap = new HashMap<String, String>();
        compressMap.put("$DEFAULT$", "COMPRESS");
        this.registerSubstitutionValues("KEYCOMPRESS", (HashMap)compressMap);
        if (this.m_index.getIndexType() != Index.IndexType.BITMAP && this.m_index.getIndexType() != Index.IndexType.UNIQUE) {
            this.registerPropertyMapping("columnExpressions", new OMBColExpressionPropResolver((Index)this.getContextObject()));
        }
        this.registerPropertyMapping("indexType", 1, "INDEX_TYPE");
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("NORMAL", "FUNCTION-BASED");
        this.registerSubstitutionValues("INDEX_TYPE", (HashMap)typeMap);
        this.registerPropertyMapping("properties/OracleIndexPartitions", new OMBIsLocalIndxPropResolver((Index)this.getContextObject()));
    }

    public final class OMBIsLocalIndxPropResolver
    extends OMBPropertyResolver {
        Index m_indx = null;

        public OMBIsLocalIndxPropResolver(Index index) {
            this.m_indx = index;
        }

        public String resolvePropertyValue() {
            OracleIndexPartitions oip;
            PropertyHelper ph = new PropertyHelper();
            Object propVal = ph.getPropertyValue((Object)this.m_indx, "properties/OracleIndexPartitions");
            if (propVal != null && propVal instanceof OracleIndexPartitions && ((oip = (OracleIndexPartitions)propVal).getPartitionType().equals((Object)OracleIndexPartitions.PartitionType.LOCAL_HASH) || oip.getPartitionType().equals((Object)OracleIndexPartitions.PartitionType.LOCAL_COMP) || oip.getPartitionType().equals((Object)OracleIndexPartitions.PartitionType.LOCAL_OTHER))) {
                return "true";
            }
            return "false";
        }

        public String resolvePropertyName() {
            return "LOCAL_INDEX";
        }
    }

    public final class OMBColExpressionPropResolver
    extends OMBPropertyResolver {
        Index m_indx = null;
        final String COMMA = ",";

        public OMBColExpressionPropResolver(Index index) {
            this.m_indx = index;
        }

        public String resolvePropertyValue() {
            StringBuffer colBuff = new StringBuffer();
            boolean firstTimeAround = true;
            for (IndexObject io : this.m_indx.getColumnExpressions()) {
                SQLFragment frag;
                if (!firstTimeAround) {
                    colBuff.append(",");
                }
                if ((frag = io.getExpression()) instanceof ColumnUsage) {
                    colBuff.append(((ColumnUsage)frag).getColumnName());
                    if (io.getOrder() != null && io.getOrder().equals("DESC")) {
                        colBuff.append(" DESC");
                    }
                } else {
                    colBuff.append(frag.toString());
                }
                firstTimeAround = false;
            }
            return colBuff.toString();
        }

        public String resolvePropertyName() {
            return "COLUMN_EXPRESSION";
        }
    }
}

