/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ora.owb.OMBPropertyResolver;
import oracle.javatools.db.ora.owb.OMBPropsStatementBuilder;

class OMBConstraintPropsBuilder
extends OMBPropsStatementBuilder {
    public OMBConstraintPropsBuilder(Object forConstraint) {
        this.setContextObject(forConstraint);
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    public void registerPropertyMappings() {
        this.registerPropertyMapping("enabled", "ENABLECONSTRAINT");
        HashMap<String, String> enabledMap = new HashMap<String, String>();
        enabledMap.put("true", "ENABLE");
        enabledMap.put("false", "DISABLE");
        this.registerSubstitutionValues("ENABLECONSTRAINT", enabledMap);
        this.registerPropertyMapping("deleteMode", "ONDELETE");
        HashMap<String, String> deleteMap = new HashMap<String, String>();
        deleteMap.put("0", "$IGNORE$");
        deleteMap.put("1", "CASCADE");
        deleteMap.put("2", "SET NULL");
        this.registerSubstitutionValues("ONDELETE", deleteMap);
        this.registerPropertyMapping("checkCondition", new OMBCheckConditionQueryPropResolver((Constraint)this.getContextObject()));
    }

    public final class OMBCheckConditionQueryPropResolver
    extends OMBPropertyResolver {
        Constraint m_cons = null;

        public OMBCheckConditionQueryPropResolver(Constraint cons) {
            this.m_cons = cons;
        }

        public String resolvePropertyValue() {
            if (this.m_cons instanceof CheckConstraint) {
                String consText = ((CheckConstraint)this.m_cons).getCheckConditionFragment().getSQLText();
                return consText.trim().replaceAll("'", "''");
            }
            return null;
        }

        public String resolvePropertyName() {
            return "CHECK_CONDITION";
        }
    }
}

