/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddl;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBCore;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.Index;
import oracle.javatools.db.Package;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenDDLGenerator;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.javatools.db.ora.Oracle10gR2XE;
import oracle.javatools.db.ora.Oracle11g;
import oracle.javatools.db.ora.Oracle11gR2;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.XMLSchema;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDDLSupport {
    private static final String BASE = "/oracle/javatools/db/ora/ddl/";
    private static final String ORACLE_DDL = "/oracle/javatools/db/ora/ddl/OracleDDL.properties";
    private static final String ORACLE_DDL_BASE = "/oracle/javatools/db/ora/ddl/OracleBaseDDL.properties";
    private static final String ORACLE_LITE_DDL = "/oracle/javatools/db/ora/ddl/OracleLiteDDL.properties";
    private static final String ORACLE_10g_DDL = "/oracle/javatools/db/ora/ddl/Oracle10gDDL.properties";
    private static final String ORACLE_10gR2_DDL = "/oracle/javatools/db/ora/ddl/Oracle10gR2DDL.properties";
    private static final String ORACLE_10gR2XE_DDL = "/oracle/javatools/db/ora/ddl/Oracle10gR2XEDDL.properties";
    private static final String ORACLE_9iR2_DDL = "/oracle/javatools/db/ora/ddl/Oracle9iDDL.properties";
    private static final String ORACLE_11g_DDL = "/oracle/javatools/db/ora/ddl/Oracle11gDDL.properties";
    private static final String ORACLE_11gR2_DDL = "/oracle/javatools/db/ora/ddl/Oracle11gR2DDL.properties";
    private String m_simpleDrop;
    private final Map<String, TokenGenerator> m_globals = new TreeMap<String, TokenGenerator>();

    private OracleDDLSupport() {
        this.m_globals.put("islobcol", new IsLOBColumnGenerator());
        this.m_globals.put("varraydef", new VarrayDefinitionGenerator());
        this.m_globals.put("lobdef", new LOBDefinitionGenerator());
        this.m_globals.put("lobcoldef", new PartitionLOBGenerator());
        this.m_globals.put("partitionsnotempty", new PartitionsNotEmptyGenerator());
        this.m_globals.put("hastablespaces", new HasTablespacesGenerator());
        this.m_globals.put("hasPartitions", new HasPartitionsGenerator());
        this.m_globals.put("needOSPAlter", new NeedOSPAlterTokenGenerator());
        this.m_globals.put("needOSPMove", new NeedOSPMoveTokenGenerator());
        this.m_globals.put("needIPMod", new NeedIndexPartitionModTokenGenerator());
        this.m_globals.put("formatLastDate", new MatViewLastDateGenerator());
        this.m_globals.put("changedValues", new PartitionValuesChangedTokenGenerator());
        this.m_globals.put("handleWiths", new MatViewLogWithsGenerator());
        this.m_globals.put("handleAddWiths", new MatViewLogAddWithsGenerator());
        this.m_globals.put("handleTrgEvents", new TriggerEventsListGenerator());
        this.m_globals.put("getSyntaxFromSource", new SyntaxFromSourceGenerator());
        this.m_globals.put("codeExists", new CodeExistsTokenGenerator());
        this.m_globals.put("refOldAsExists", new TrgOldAsExistsTokenGenerator());
        this.m_globals.put("refNewAsExists", new TrgNewAsExistsTokenGenerator());
        this.m_globals.put("getBodySource", new BodySourceTokenGenerator());
        this.m_globals.put("hostExists", new DBLinkHostExistsTokenGenerator());
        this.m_globals.put("schemaText", new XMLSchemaTextTokenGenerator());
        this.m_globals.put("triggerKeyWord", new TriggerKeyWordGenerator());
        this.m_globals.put("needsRebuildIndexes", new NeedsRebuildIndexesModTokenGenerator());
        this.m_globals.put("needDropAndRecreateConstraint", new DropAndRecreateConTokenGenerator());
        this.m_globals.put("quotedComment", new QuotedCommentGenerator());
        this.m_globals.put("filePath", new FileSpecPathGenerator());
        this.m_globals.put("originalFilePath", new OldFileSpecPathGenerator());
        this.m_globals.put("pathDiffers", new FileDiffersTokenGenerator());
    }

    String[] getBundles(Class<? extends OracleDatabase> clz) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add(ORACLE_DDL_BASE);
        if (OracleLite.class.isAssignableFrom(clz)) {
            retval.remove(ORACLE_DDL_BASE);
            retval.add(ORACLE_LITE_DDL);
        }
        if (Oracle9iR2.class.isAssignableFrom(clz)) {
            retval.add(ORACLE_9iR2_DDL);
        }
        if (Oracle10g.class.isAssignableFrom(clz)) {
            retval.add(ORACLE_10g_DDL);
        }
        if (Oracle10gR2.class.isAssignableFrom(clz)) {
            retval.add(ORACLE_10gR2_DDL);
        }
        if (Oracle10gR2XE.class.isAssignableFrom(clz)) {
            retval.add(ORACLE_10gR2XE_DDL);
        }
        if (Oracle11g.class.isAssignableFrom(clz)) {
            retval.add(ORACLE_11g_DDL);
        }
        if (Oracle11gR2.class.isAssignableFrom(clz)) {
            retval.add(ORACLE_11gR2_DDL);
        }
        return retval.toArray(new String[retval.size()]);
    }

    public void includeOracleSyntax(TokenDDLGenerator gen, String type, boolean includeAlter) {
        DatabaseDescriptor dd = DatabaseFactory.getDatabaseDescriptor(Oracle11g.class);
        gen.includeSyntax(dd, type, includeAlter);
    }

    public String getSimpleDropDDL() {
        if (this.m_simpleDrop == null) {
            try {
                Properties props = new Properties();
                props.load(this.getClass().getResourceAsStream(ORACLE_DDL_BASE));
                this.m_simpleDrop = props.getProperty("SIMPLE_DROP");
            }
            catch (IOException ioe) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Couldn't open ddl properties: " + ioe.getMessage());
            }
        }
        return this.m_simpleDrop;
    }

    public Map<String, TokenGenerator> getGlobalTokenGenerators() {
        return Collections.unmodifiableMap(this.m_globals);
    }

    public static OracleDDLSupport getInstance() {
        DBCore core = DBCore.getInstance();
        OracleDDLSupport retval = (OracleDDLSupport)core.get(OracleDDLSupport.class);
        if (retval == null) {
            retval = new OracleDDLSupport();
            core.put((Object)retval);
        }
        return retval;
    }

    public static class PropertyFilter
    implements DifferenceFilter {
        HashSet<String> m_propsToFilter = new HashSet();

        public void addFilterProp(String prop) {
            this.m_propsToFilter.add(prop);
        }

        public boolean isFilteredProperty(Difference diff, String prop) {
            if (prop.indexOf("/") != -1) {
                prop = prop.substring(prop.indexOf("/") + 1);
            }
            return this.m_propsToFilter.contains(prop);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FileDiffersTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "pathDiffers";

        private FileDiffersTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof FileSpecification) {
                return this.propHasChanged(context, "name") || this.propHasChanged(context, "directory");
            }
            return false;
        }

        public Collection<String> getPropertiesAltered(String type, DBObjectProvider pro) {
            return Arrays.asList("name", "directory");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OldFileSpecPathGenerator
    extends TokenGenerator {
        public static final String TOKEN = "originalFilePath";

        private OldFileSpecPathGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof FileSpecification) {
                Difference diff = context.getDifference();
                FileSpecification file = (FileSpecification)diff.getOriginalObject();
                String separator = "/";
                if (file.getDirectory() != null && file.getDirectory().indexOf("\\") != -1) {
                    separator = "\\";
                }
                if (file.getDirectory() != null) {
                    context.append((Object)(file.getDirectory() + separator));
                }
                context.append((Object)file.getName());
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("name", "directory");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileSpecPathGenerator
    extends TokenGenerator {
        public static final String TOKEN = "filePath";

        private FileSpecPathGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof FileSpecification) {
                FileSpecification file = (FileSpecification)context.getObject();
                String separator = "/";
                if (file.getDirectory() != null && file.getDirectory().indexOf("\\") != -1) {
                    separator = "\\";
                }
                if (file.getDirectory() != null) {
                    context.append((Object)(file.getDirectory() + separator));
                }
                context.append((Object)file.getName());
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("name", "directory");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QuotedCommentGenerator
    extends TokenGenerator {
        private static final String TOKEN = "quotedComment";

        private QuotedCommentGenerator() {
        }

        public void generateToken(TokenContext context) {
            String c = this.getComment(context);
            if (ModelUtil.hasLength((String)c)) {
                context.append((Object)"'");
                context.append((Object)c.replaceAll("'", "''"));
                context.append((Object)"'");
            } else {
                context.append((Object)"''");
            }
        }

        private String getComment(TokenContext context) {
            String retval = null;
            Object c = context.getObject();
            if (c instanceof DBObject) {
                retval = (String)((DBObject)c).getProperty("Comment");
            }
            return retval;
        }

        public Object evaluateToken(TokenContext context) {
            String comment = this.getComment(context);
            return ModelUtil.hasLength((String)comment);
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList(Property.createPath((String[])new String[]{"properties", "Comment"}));
        }
    }

    private static final class TriggerKeyWordGenerator
    extends TokenGenerator {
        public static final String TOKEN = "triggerKeyWord";
        public static final String TRIGGER = "TRIGGER";

        private TriggerKeyWordGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof Trigger) {
                Trigger trigger = (Trigger)context.getObject();
                PlSqlInterrogator pi = trigger.getSourceInterrogator();
                PlSqlFragment pf = pi.getRoot();
                if (pf != null) {
                    PlSqlToken keywordToken = pf.getFirstToken();
                    context.append((Object)keywordToken.getSource());
                } else {
                    context.append((Object)TRIGGER);
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XMLSchemaTextTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "schemaText";

        private XMLSchemaTextTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
            XMLSchema xs;
            if (context.getObject() instanceof XMLSchema && (xs = (XMLSchema)context.getObject()).getSchemaText() != null && xs.getSchemaText().length() > 0) {
                context.append((Object)xs.getSchemaText().replaceAll("'", "''"));
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList(TOKEN.toString());
        }
    }

    private static final class DBLinkHostExistsTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "hostExists";

        private DBLinkHostExistsTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof DatabaseLink) {
                DatabaseLink dblink = (DatabaseLink)context.getObject();
                String host = dblink.getHost();
                return host != null && !host.equals("");
            }
            return false;
        }
    }

    private static final class BodySourceTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "getBodySource";

        private BodySourceTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof PlSql) {
                PlSqlInterrogator pi = null;
                String source = this.getBodySource(context);
                if (source != null || !source.equals("")) {
                    if (context.getObject() instanceof Package) {
                        Package pkg = (Package)context.getObject();
                        pi = pkg.getBodySourceInterrogator();
                    } else if (context.getObject() instanceof ComplexType) {
                        ComplexType typ = (ComplexType)context.getObject();
                        pi = typ.getBodySourceInterrogator();
                    }
                    PlSqlFragment pf = pi.getRoot();
                    context.append((Object)pf.getSource());
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Package || context.getObject() instanceof ComplexType) {
                String source = this.getBodySource(context);
                return source != null && !source.equals("");
            }
            return false;
        }

        private String getBodySource(TokenContext context) {
            String source = null;
            if (context.getObject() instanceof Package) {
                Package pkg = (Package)context.getObject();
                source = pkg.getBodySource();
            } else if (context.getObject() instanceof ComplexType) {
                ComplexType typ = (ComplexType)context.getObject();
                source = typ.getBodySource();
            }
            return source;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TrgNewAsExistsTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "refNewAsExists";

        private TrgNewAsExistsTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Trigger) {
                Trigger trg = (Trigger)context.getObject();
                String newAs = trg.getReferencingNewAs();
                return newAs != null && !newAs.equals("");
            }
            return false;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("referencingNewAs".toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TrgOldAsExistsTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "refOldAsExists";

        private TrgOldAsExistsTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Trigger) {
                Trigger trg = (Trigger)context.getObject();
                String oldAs = trg.getReferencingOldAs();
                return oldAs != null && !oldAs.equals("");
            }
            return false;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("referencingOldAs".toString());
        }
    }

    private static final class DropAndRecreateConTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needDropAndRecreateConstraint";

        private DropAndRecreateConTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Constraint) {
                Difference rs = context.getDifference();
                PropertyFilter df = new PropertyFilter();
                df.addFilterProp("enabled");
                df.addFilterProp("name");
                Difference filtered = rs.getFilteredDifference(new DifferenceFilter[]{df});
                return !filtered.isSame();
            }
            return false;
        }
    }

    private static final class CodeExistsTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "codeExists";

        private CodeExistsTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Trigger) {
                Trigger trg = (Trigger)context.getObject();
                String code = trg.getCode();
                return code != null && !code.equals("");
            }
            return false;
        }
    }

    private static final class SyntaxFromSourceGenerator
    extends TokenGenerator {
        public static final String TOKEN = "getSyntaxFromSource";
        public static final String ALTER = "ALTER";

        private SyntaxFromSourceGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof PlSql) {
                PlSqlInterrogator pi = null;
                String source = this.getSource(context);
                if (source != null || !source.equals("")) {
                    PlSql pls = (PlSql)context.getObject();
                    pi = pls.getSourceInterrogator();
                    if (pi.isEvolvedType()) {
                        context.append((Object)this.buildEvolvedTypeSource(context, pi));
                    } else {
                        context.append((Object)this.buildSource(pi));
                    }
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof PlSql) {
                String source = this.getSource(context);
                return source != null && !source.equals("");
            }
            return false;
        }

        private String getSource(TokenContext context) {
            String source = null;
            PlSql pls = (PlSql)context.getObject();
            source = pls.getSource();
            return source;
        }

        private String buildEvolvedTypeSource(TokenContext context, PlSqlInterrogator pi) {
            StringBuffer srcBuff;
            block8: {
                srcBuff = new StringBuffer();
                try {
                    Schema defaultSchema = context.getProvider().getDefaultSchema();
                    PropertyHelper ph = new PropertyHelper();
                    Schema ctxtSchema = (Schema)ph.getPropertyValue(context.getObject(), "schema");
                    if (!defaultSchema.getName().equals(ctxtSchema.getName())) {
                        PlSqlFragment pf = pi.getRoot();
                        for (PlSqlFragment frag : pf.getChildren()) {
                            if (!frag.getFramentType().equals((Object)PlSqlFragment.Type.TYPE_SPEC) && !frag.getFramentType().equals((Object)PlSqlFragment.Type.TYPE_ALTER_STATEMENT)) continue;
                            PlSqlToken currToken = frag.getFirstToken();
                            int counter = 1;
                            if (frag.getFramentType().equals((Object)PlSqlFragment.Type.TYPE_ALTER_STATEMENT)) {
                                srcBuff.append("\n");
                                srcBuff.append(currToken.getSource());
                                while (currToken.getNextCodeToken() != null && !(currToken = currToken.getNextCodeToken()).getSource().equalsIgnoreCase(ALTER)) {
                                    srcBuff.append(" ");
                                    if (counter == 2) {
                                        srcBuff.append(ctxtSchema + "." + currToken.getSource());
                                    } else {
                                        srcBuff.append(currToken.getSource());
                                    }
                                    ++counter;
                                }
                                continue;
                            }
                            PlSqlToken codeStart = currToken.getNextCodeToken(2);
                            int codeStartIndx = codeStart.getStart();
                            srcBuff.append(frag.getSource().substring(codeStartIndx, frag.getSource().length()));
                        }
                        break block8;
                    }
                    srcBuff.append(this.buildSource(pi));
                }
                catch (DBException e) {
                    DBLog.log((String)"", (Object[])new Object[0]);
                }
            }
            return srcBuff.toString();
        }

        private String buildSource(PlSqlInterrogator pi) {
            int startAt = 2;
            int tokenCount = 0;
            String src = null;
            PlSqlFragment pf = pi.getRoot();
            PlSqlToken currToken = pf.getFirstToken();
            while (currToken.getNextCodeToken() != null) {
                currToken = currToken.getNextCodeToken();
                if (++tokenCount >= startAt) {
                    int startIndx = currToken.getStart() - pf.getFirstToken().getStart();
                    src = pf.getSource().substring(startIndx, pf.getSource().length());
                    break;
                }
                if (tokenCount != 1 || !currToken.getNextCodeToken().matches(".")) continue;
                startAt += 2;
            }
            return src;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TriggerEventsListGenerator
    extends TokenGenerator {
        public static final String TOKEN = "handleTrgEvents";

        private TriggerEventsListGenerator() {
        }

        public void generateToken(TokenContext context) {
            Trigger trg;
            boolean isFirst = true;
            if (context.getObject() instanceof Trigger && (trg = (Trigger)context.getObject()).getEvents() != null && trg.getEvents().length > 0) {
                for (String event : trg.getEvents()) {
                    if (!isFirst) {
                        context.append((Object)" OR ");
                    }
                    context.append((Object)event);
                    DBObjectID[] colIDs = trg.getColumnIDs();
                    if ("UPDATE".equals(event) && colIDs != null) {
                        for (int i = 0; i < colIDs.length; ++i) {
                            context.append((Object)(i == 0 ? " OF " : ","));
                            context.append((Object)DBUtil.getDBObjectName((DBObjectID)colIDs[i]));
                        }
                    }
                    isFirst = false;
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("events".toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MatViewLogAddWithsGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "handleAddWiths";
        private Collection<String> m_props = new TreeSet<String>();

        private MatViewLogAddWithsGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof MaterializedViewLog) {
                MaterializedViewLog mvl = (MaterializedViewLog)context.getObject();
                HashSet<String> withVals = new HashSet<String>();
                StringBuffer colBuff = new StringBuffer();
                String newValues = null;
                if (this.propHasChangedToValue(context, "objectIdLogged".toString(), true)) {
                    withVals.add("OBJECT ID");
                }
                if (this.propHasChangedToValue(context, "primaryKeyLogged".toString(), true)) {
                    withVals.add("PRIMARY KEY");
                }
                if (this.propHasChangedToValue(context, "rowidLogged".toString(), true)) {
                    withVals.add("ROWID");
                }
                if (this.propHasChangedToValue(context, "sequenceLogged".toString(), true)) {
                    withVals.add("SEQUENCE");
                }
                if (this.propHasChangedToValue(context, "newValues".toString(), true)) {
                    newValues = " INCLUDING NEW VALUES";
                } else if (this.propHasChangedToValue(context, "newValues".toString(), false)) {
                    newValues = " EXCLUDING NEW VALUES";
                }
                if (!withVals.isEmpty() || colBuff.length() > 0 || newValues != null) {
                    boolean notFirst = false;
                    context.append((Object)"\nADD ");
                    for (String withStatement : withVals) {
                        if (notFirst) {
                            context.append((Object)", ");
                        }
                        context.append((Object)withStatement);
                        notFirst = true;
                    }
                    context.append((Object)colBuff);
                    if (newValues != null) {
                        context.append((Object)newValues);
                    }
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            if (this.m_props == null) {
                this.m_props = new TreeSet<String>();
                this.m_props.add("objectIdLogged".toString());
                this.m_props.add("primaryKeyLogged".toString());
                this.m_props.add("rowidLogged".toString());
                this.m_props.add("sequenceLogged".toString());
                this.m_props.add("columnIDs".toString());
                this.m_props.add("newValues".toString());
            }
            return this.m_props;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MatViewLogWithsGenerator
    extends TokenGenerator {
        public static final String TOKEN = "handleWiths";
        private Collection<String> m_props = null;

        private MatViewLogWithsGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof MaterializedViewLog) {
                boolean notFirst;
                MaterializedViewLog mvl = (MaterializedViewLog)context.getObject();
                HashSet<String> withVals = new HashSet<String>();
                StringBuffer colBuff = new StringBuffer();
                if (mvl.getObjectIdLogged() != null && mvl.getObjectIdLogged().booleanValue()) {
                    withVals.add("OBJECT ID");
                }
                if (mvl.getPrimaryKeyLogged() != null && mvl.getPrimaryKeyLogged().booleanValue()) {
                    withVals.add("PRIMARY KEY");
                }
                if (mvl.getRowidLogged() != null && mvl.getRowidLogged().booleanValue()) {
                    withVals.add("ROWID");
                }
                if (mvl.getSequenceLogged() != null && mvl.getSequenceLogged().booleanValue()) {
                    withVals.add("SEQUENCE");
                }
                if (mvl.getColumnIDs() != null && mvl.getColumnIDs().length > 0) {
                    colBuff.append("(");
                    notFirst = false;
                    for (int i = 0; i < mvl.getColumnIDs().length; ++i) {
                        DBObjectID id = mvl.getColumnIDs()[i];
                        try {
                            DBObject obj = id.resolveID();
                            if (notFirst) {
                                colBuff.append(", ");
                            }
                            if (obj.getName().indexOf(" ") == -1) {
                                colBuff.append(obj.getName());
                            } else {
                                colBuff.append("\"").append(obj.getName()).append("\"");
                            }
                            notFirst = true;
                            continue;
                        }
                        catch (DBException e) {
                            // empty catch block
                        }
                    }
                    colBuff.append(")");
                }
                if (!withVals.isEmpty() || colBuff.length() > 0) {
                    notFirst = false;
                    context.append((Object)"\nWITH ");
                    for (String withStatement : withVals) {
                        if (notFirst) {
                            context.append((Object)", ");
                        }
                        context.append((Object)withStatement);
                        notFirst = true;
                    }
                    context.append((Object)colBuff);
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            if (this.m_props == null) {
                this.m_props = new TreeSet<String>();
                this.m_props.add("objectIdLogged".toString());
                this.m_props.add("primaryKeyLogged".toString());
                this.m_props.add("rowidLogged".toString());
                this.m_props.add("sequenceLogged".toString());
                this.m_props.add("columnIDs".toString());
                this.m_props.add("newValues".toString());
            }
            return this.m_props;
        }
    }

    private static final class PartitionValuesChangedTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "changedValues";

        private PartitionValuesChangedTokenGenerator() {
        }

        private boolean valuesHaveChanged(TokenContext context) {
            PropertyHelper ph = new PropertyHelper();
            Difference rs = context.getDifference();
            Object newVal = ph.getPropertyValue(context.getObject(), "values");
            Object oldVal = ph.getPropertyValue(rs.getOriginalObject(), "values");
            if (newVal != null && oldVal != null) {
                return !newVal.equals(oldVal);
            }
            return oldVal == null && newVal != null || oldVal != null && newVal == null;
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            return this.valuesHaveChanged(context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MatViewLastDateGenerator
    extends TokenGenerator {
        public static final String TOKEN = "formatLastDate";

        private MatViewLastDateGenerator() {
        }

        public void generateToken(TokenContext context) {
            MaterializedView mv;
            if (context.getObject() instanceof MaterializedView && (mv = (MaterializedView)context.getObject()).getLastRefreshDate() != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
                context.append((Object)sdf.format(mv.getLastRefreshDate()));
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("lastRefreshDate".toString());
        }
    }

    private static final class NeedsRebuildIndexesModTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needsRebuildIndexes";

        private NeedsRebuildIndexesModTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            return this.propHasChanged(context, Property.createPath((String[])new String[]{"segmentAttributes", "logging"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"segmentAttributes", "initrans"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"segmentAttributes", "bufferMode"})) || this.propHasChanged(context, "percentFree") || this.propHasChanged(context, "percentUsed") || this.propHasChanged(context, "compression");
        }
    }

    private static final class NeedIndexPartitionModTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needIPMod";

        private NeedIndexPartitionModTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            return this.propHasChanged(context, "segmentAttributes/logging") || this.propHasChanged(context, "segmentAttributes/initrans") || this.propHasChanged(context, "segmentAttributes/initialExtent") || this.propHasChanged(context, "segmentAttributes/nextExtent") || this.propHasChanged(context, "segmentAttributes/minExtent") || this.propHasChanged(context, "segmentAttributes/maxExtent") || this.propHasChanged(context, "segmentAttributes/percentIncrease") || this.propHasChanged(context, "segmentAttributes/freelists") || this.propHasChanged(context, "keyCompression") || this.propHasChanged(context, "segmentAttributes/freelistGroups");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NeedOSPMoveTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needOSPMove";
        private TreeSet<String> m_props;

        private NeedOSPMoveTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            boolean needsMove;
            boolean bl = needsMove = this.propHasChanged(context, Property.createPath((String[])new String[]{"properties", "OracleStorageProperties", "initialExtent"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"properties", "OracleStorageProperties", "nextExtent"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"properties", "OracleStorageProperties", "maxExtent"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"properties", "OracleStorageProperties", "percentIncrease"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"properties", "OracleStorageProperties", "freelists"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"properties", "OracleStorageProperties", "freelistGroups"}));
            if (context.getObject() instanceof Table) {
                PropertyHelper ph = new PropertyHelper();
                Object tableType = ph.getPropertyValue(context.getObject(), Property.createPath((String[])new String[]{"properties", "TableType"}));
                return needsMove || this.propHasChanged(context, Property.createPath((String[])new String[]{"properties", "OracleStorageProperties", "percentFree"})) && tableType.toString().equals(Table.TableType.INDEX_ORGANIZED);
            }
            return needsMove;
        }

        public Collection<String> getPropertiesAltered(String type, DBObjectProvider pro) {
            if (this.m_props == null) {
                this.m_props = new TreeSet();
                this.m_props.add(Property.createPath((String[])new String[]{"properties", "OracleStorageProperties", "initialExtent"}));
                this.m_props.add(Property.createPath((String[])new String[]{"properties", "OracleStorageProperties", "nextExtent"}));
                this.m_props.add(Property.createPath((String[])new String[]{"properties", "OracleStorageProperties", "maxExtent"}));
                this.m_props.add(Property.createPath((String[])new String[]{"properties", "OracleStorageProperties", "percentIncrease"}));
                this.m_props.add(Property.createPath((String[])new String[]{"properties", "OracleStorageProperties", "freelists"}));
                this.m_props.add(Property.createPath((String[])new String[]{"properties", "OracleStorageProperties", "freelistGroups"}));
            }
            return this.m_props;
        }
    }

    private static final class NeedOSPAlterTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needOSPAlter";

        private NeedOSPAlterTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Table) {
                PropertyHelper ph = new PropertyHelper();
                Object tableType = ph.getPropertyValue(context.getObject(), "properties/TableType");
                return this.propHasChanged(context, "properties/OracleStorageProperties/logging") || this.propHasChanged(context, "properties/OracleStorageProperties/percentUsed") || this.propHasChanged(context, "properties/OracleStorageProperties/initrans") || this.propHasChanged(context, "properties/OracleStorageProperties/maxtrans") || this.propHasChanged(context, "properties/OracleStorageProperties/bufferMode") || this.propHasChanged(context, "properties/OracleStorageProperties/percentFree") && !tableType.toString().equals("INDEX_ORGANIZED");
            }
            if (context.getObject() instanceof Index && ((Index)context.getObject()).getIndexType() != Index.IndexType.DOMAIN) {
                return this.propHasChanged(context, "properties/OracleStorageProperties/logging") || this.propHasChanged(context, "properties/OracleStorageProperties/percentUsed") || this.propHasChanged(context, "properties/OracleStorageProperties/initrans") || this.propHasChanged(context, "properties/OracleStorageProperties/maxtrans") || this.propHasChanged(context, "properties/OracleStorageProperties/bufferMode") || this.propHasChanged(context, "properties/OracleStorageProperties/percentFree");
            }
            return false;
        }
    }

    private static final class HasPartitionsGenerator
    extends TokenGenerator {
        public static final String TOKEN = "hasPartitions";

        private HasPartitionsGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Table) {
                OracleTablePartitions otp = (OracleTablePartitions)((Table)context.getObject()).getProperty("OracleTablePartitions");
                return otp != null && otp.getPartitions().length > 0;
            }
            return false;
        }
    }

    private static final class HasTablespacesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "hastablespaces";

        private HasTablespacesGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof OracleTablePartitions) {
                OracleTablePartitions otp = (OracleTablePartitions)context.getObject();
                return otp != null && otp.getHashQuantityTablespaces().length > 0;
            }
            return false;
        }
    }

    private static final class PartitionsNotEmptyGenerator
    extends TokenGenerator {
        public static final String TOKEN = "partitionsnotempty";

        private PartitionsNotEmptyGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof OracleTablePartitions) {
                OracleTablePartitions otp = (OracleTablePartitions)context.getObject();
                return otp != null && otp.getPartitions().length > 0;
            }
            return false;
        }
    }

    private static final class IsLOBColumnGenerator
    extends TokenGenerator {
        public static final String TOKEN = "islobcol";

        private IsLOBColumnGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof LOBDescriptor) {
                DBObjectID[] cols;
                for (DBObjectID colID : cols = ((LOBDescriptor)context.getObject()).getColumns()) {
                    if (!LOBDescriptor.isLOBColumn((DBObjectID)colID)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class PartitionLOBGenerator
    extends LOBTokenGenerator {
        public static final String TOKEN = "lobcoldef";

        private PartitionLOBGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof LOBDescriptor) {
                DBObjectID[] cols;
                LOBDescriptor lob = (LOBDescriptor)context.getObject();
                for (DBObjectID colID : cols = lob.getColumns()) {
                    try {
                        this.addLOBDefinition(context, colID.resolveID().getName(), lob.getLOBSegName(), LOBDescriptor.isVARRAYColumn((DBObjectID)colID), true);
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            LOBDescriptor lob = (LOBDescriptor)context.getObject();
            DBObjectID[] cols = lob.getColumns();
            return cols != null && cols.length > 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LOBDefinitionGenerator
    extends LOBTokenGenerator {
        public static final String TOKEN = "lobdef";

        private LOBDefinitionGenerator() {
        }

        public void generateToken(TokenContext context) {
            OracleColumnProperties ocp;
            LOBDescriptor lob;
            DBObjectID[] cols;
            if (context.getObject() instanceof OracleColumnProperties && ((cols = (lob = (ocp = (OracleColumnProperties)context.getObject()).getLOBProperties()).getColumns()) == null || cols.length == 0)) {
                this.addLOBDefinition(context, ocp.getParent().getName(), lob.getLOBSegName(), false, false);
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("LOBProperties".toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class VarrayDefinitionGenerator
    extends LOBTokenGenerator {
        public static final String TOKEN = "varraydef";

        private VarrayDefinitionGenerator() {
        }

        public void generateToken(TokenContext context) {
            OracleColumnProperties ocp;
            LOBDescriptor lob;
            DBObjectID[] cols;
            if (context.getObject() instanceof OracleColumnProperties && ((cols = (lob = (ocp = (OracleColumnProperties)context.getObject()).getVAProperties()).getColumns()) == null || cols.length == 0)) {
                this.addLOBDefinition(context, ocp.getParent().getName(), lob.getLOBSegName(), true, false);
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("VAProperties".toString());
        }
    }

    private static abstract class AlterTokenGenerator
    extends TokenGenerator {
        private AlterTokenGenerator() {
        }

        protected boolean propHasChanged(TokenContext context, String propPath) {
            Difference propDiff = null;
            try {
                PropertyHelper ph = new PropertyHelper();
                Difference rs = context.getDifference();
                if (rs == null) {
                    return false;
                }
                propDiff = ph.getChildDifference(rs, propPath);
            }
            catch (MissingPropertyException e) {
                DBLog.getLogger((Object)((Object)this)).log(Level.FINER, e.getMessage());
            }
            return propDiff == null ? false : !propDiff.isSame();
        }

        protected boolean propHasChangedToValue(TokenContext context, String propPath, Object value) {
            PropertyHelper ph = new PropertyHelper();
            Difference rs = context.getDifference();
            Object newVal = ph.getPropertyValue(rs.getUpdatedObject(), propPath);
            return this.propHasChanged(context, propPath) && newVal.equals(value);
        }

        private boolean hasPropChanged(Object oldVal, Object newVal) {
            if (newVal != null && oldVal != null) {
                if (newVal instanceof Object[]) {
                    return !Arrays.equals((Object[])oldVal, (Object[])newVal);
                }
                return !newVal.equals(oldVal);
            }
            return oldVal == null && newVal != null || oldVal != null && newVal == null;
        }
    }

    private static abstract class LOBTokenGenerator
    extends TokenGenerator {
        private LOBTokenGenerator() {
        }

        void addLOBDefinition(TokenContext context, String LOBColumn, String LOBSegment, boolean isVarray, boolean addIncr) {
            if (isVarray) {
                context.append((Object)"\n");
                if (addIncr) {
                    context.append((Object)"  ");
                }
                context.append((Object)"VARRAY ");
            } else {
                context.append((Object)"\n");
                if (addIncr) {
                    context.append((Object)"  ");
                }
                context.append((Object)"LOB (");
            }
            context.append((Object)LOBColumn);
            if (!isVarray) {
                context.append((Object)")");
            }
            context.append((Object)" STORE AS ");
            if (isVarray) {
                context.append((Object)"LOB ");
            }
            if (LOBSegment != null) {
                context.append((Object)LOBSegment);
            }
        }
    }
}

