/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddl;

import java.text.MessageFormat;
import java.util.Map;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.ddl.OracleDDLSupport;
import oracle.javatools.db.ora.ddl.OracleDDLType;
import oracle.javatools.db.ora.ddl.OracleStatementType;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDDLGenerator
extends BundleDDLGenerator<OracleDDLType> {
    private Class<? extends OracleDatabase> m_oraClz;

    public OracleDDLGenerator(Class<? extends OracleDatabase> oraClz, DBObjectProvider pro) {
        super(pro, OracleDDLSupport.getInstance().getBundles(oraClz));
        this.m_oraClz = oraClz;
        this.registerTokens();
    }

    protected Class<? extends DBObjectProvider> getProviderClass() {
        return this.m_oraClz;
    }

    protected OracleDDLType getDDLType(String key) {
        return OracleDDLType.getDDLType((String)key);
    }

    protected void registerTokens() {
        this.registerSimpleDropDDL("FUNCTION");
        this.registerSimpleDropDDL("SEQUENCE");
        this.registerSimpleDropDDL("MATERIALIZED VIEW");
        this.registerSimpleDropDDL("PACKAGE");
        this.registerSimpleDropDDL("PROCEDURE");
        this.registerSimpleDropDDL("TRIGGER");
        for (Map.Entry<String, TokenGenerator> entry : OracleDDLSupport.getInstance().getGlobalTokenGenerators().entrySet()) {
            this.registerTokenGenerator(entry.getKey(), entry.getValue());
        }
        this.registerTopLevelChild("TABLE", "indexes", "INDEX");
        this.registerTopLevelChild("MATERIALIZED VIEW", "indexes", "INDEX");
    }

    protected final void registerSimpleDropDDL(String type) {
        this.registerDropDDL(type, OracleDDLSupport.getInstance().getSimpleDropDDL(), (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.DROP));
    }

    protected DDL<OracleDDLType> finish(DDLOptions options, DDL<OracleDDLType> ddl) {
        DDL retval = super.finish(options, ddl);
        String spoolFile = options.getSpoolFile();
        if (ModelUtil.hasLength((String)spoolFile) && ddl.get((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLON)).isEmpty()) {
            ddl.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLON), MessageFormat.format("SPOOL {0}\n", spoolFile));
            ddl.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLOFF), "SPOOL OFF");
        }
        return retval;
    }
}

