/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSearchException;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.parser.plsql.syntax.XMLTableClauseProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleXMLTableClauseProcessor
implements XMLTableClauseProcessor {
    private boolean m_processed = false;
    private int m_errorPos;
    private String m_params;
    private List<String> m_columnNames = new ArrayList<String>();

    public void process(String source, int offset) {
        boolean validXMLTable = false;
        int tokenCount = 0;
        PlSqlSearch searchToColumns = null;
        PlSqlSearch searchColumn = null;
        try {
            searchToColumns = new PlSqlSearch("XMLTABLE ( [ XMLNAMESPACES ( [ ? AS ? ] [ , ? AS ? ]...[ DEFAULT ? ] ), ] ? [ PASSING [BY VALUE] ?. [ AS ? ] [ , ? [AS ? ] ]... ] <columnsOrBracket {COLUMNS | ) }>");
        }
        catch (PlSqlSearchException e) {
            // empty catch block
        }
        try {
            searchColumn = new PlSqlSearch("<colName ?> { FOR ORDINALITY | ?% [ PATH ? ] [ DEFAULT ?. ] } <commaOrBracket {, | ) }> ");
        }
        catch (PlSqlSearchException e) {
            // empty catch block
        }
        PlSqlToken startToken = PlSqlTokenizer.tokenize((String)source, (String[])new String[0]);
        while (startToken.getType() != PlSqlToken.Type.END_MARKER && startToken.getStart() < offset - 1) {
            startToken = startToken.getNextCodeToken();
        }
        PlSqlToken endToken = startToken;
        validXMLTable = false;
        if (searchToColumns.matches(startToken)) {
            validXMLTable = true;
            endToken = searchToColumns.getEndToken();
        } else {
            this.m_errorPos = searchToColumns.getTokenCount();
        }
        if (validXMLTable && searchToColumns.getNamedMatch("columnsOrBracket").equals("COLUMNS")) {
            tokenCount = searchToColumns.getTokenCount();
            endToken = searchToColumns.getEndToken();
            while (validXMLTable) {
                PlSqlToken tk = endToken.getNextCodeToken();
                validXMLTable = searchColumn.matches(tk);
                if (validXMLTable) {
                    this.m_columnNames.add(searchColumn.getNamedMatch("colName"));
                    tokenCount += searchColumn.getTokenCount();
                    endToken = searchColumn.getEndToken();
                    if (!searchColumn.getNamedMatch("commaOrBracket").equals(")")) continue;
                    break;
                }
                this.m_errorPos = tokenCount + searchColumn.getTokenCount();
                break;
            }
        }
        if (validXMLTable) {
            startToken = startToken.getNextCodeToken(2);
            endToken = endToken.getPrevCodeToken();
            this.m_params = startToken.getSource(true, endToken);
        }
        this.m_processed = true;
    }

    public int getErrorTokenPosition() {
        this.checkState();
        return this.m_errorPos;
    }

    public String getXMLTableParams() {
        this.checkState();
        return this.m_params;
    }

    public List<String> getColumnNames() {
        this.checkState();
        return this.m_columnNames;
    }

    private void checkState() {
        if (!this.m_processed) {
            throw new IllegalStateException("Cannot get state before calling process");
        }
    }
}

