/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AutoExtendProperties;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablespaceProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTablespaceBuilder
extends OracleDBObjectBuilder<Tablespace> {
    private static final String ENABLED = "ENABLED";
    private static final String DIRECT_LOAD_OPERATIONS = "DIRECT LOAD ONLY";
    private static final String ALL_OPERATIONS = "FOR ALL OPERATIONS";
    private static final String OLTP = "OLTP";
    private static final String BASIC = "BASIC";
    private static final String QUERY_LOW = "QUERY LOW";
    private static final String QUERY_HIGH = "QUERY HIGH";
    private static final String ARCHIVE_LOW = "ARCHIVE LOW";
    private static final String ARCHIVE_HIGH = "ARCHIVE HIGH";
    private static final String AUTO = "AUTO";
    private static final String LOGGING = "LOGGING";
    private static final String NO = "NO";
    private static final String YES = "YES";
    private static final String ONLINE = "ONLINE";
    private static final String OFFLINE = "OFFLINE";
    private static final String NOGUARANTEE = "NOGUARANTEE";
    private static final String GUARANTEE = "GUARANTEE";
    private static final String UNIFORM = "UNIFORM";
    private static final String TEMPORARY = "TEMPORARY";
    private static final String UNDO = "UNDO";
    private static final String PERMANENT = "PERMANENT";
    private static final String DICTIONARY = "DICTIONARY";
    private static final String LOCAL = "LOCAL";
    private String m_tbspType = "PERMANENT";

    public OracleTablespaceBuilder(BaseOracleDatabase db) {
        super(db, "TABLESPACE");
    }

    protected void fillInObject(final Tablespace tbsp) throws DBException {
        final QueryWrapper wrap = this.newQueryWrapper(this.getTablespaceQuery(), tbsp);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        OracleTablespaceProperties otp = OracleTablespaceBuilder.this.fillInTablespaceProps(rs, tbsp);
                        if (otp.getExtentManagementType().equals((Object)OracleTablespaceProperties.ExtentManagementType.DICTIONARY)) {
                            OracleTablespaceBuilder.this.fillInStorageProps(rs, otp);
                        }
                        try {
                            OracleTablespaceBuilder.this.fillInDataFiles(tbsp);
                        }
                        catch (DBException dBException) {}
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)tbsp, sqe);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private OracleTablespaceProperties fillInTablespaceProps(ResultSet rs, Tablespace tbsp) throws SQLException {
        String tbspGroup;
        String extentMgmt = rs.getString(13);
        if (rs.getString(1).equals(NO)) {
            tbsp.setFileType(Tablespace.FileType.SMALLFILE);
        } else {
            tbsp.setFileType(Tablespace.FileType.BIGFILE);
        }
        this.m_tbspType = rs.getString(2);
        if (this.m_tbspType.equals(TEMPORARY)) {
            tbsp.setProperty("TablespaceType", (Object)Tablespace.TablespaceType.TEMPORARY);
        } else if (this.m_tbspType.equals(UNDO)) {
            tbsp.setProperty("TablespaceType", (Object)Tablespace.TablespaceType.UNDO);
        } else {
            tbsp.setProperty("TablespaceType", (Object)Tablespace.TablespaceType.PERMANENT);
        }
        OracleTablespaceProperties otp = new OracleTablespaceProperties();
        if (this.m_tbspType.equals(PERMANENT)) {
            String defTabComp;
            otp.setBlockSize(new Integer(rs.getString(3)));
            if (extentMgmt.equals(DICTIONARY)) {
                otp.setMinExtent(new Integer(rs.getString(4)));
            }
            if ((defTabComp = rs.getString(5)).equals(ENABLED)) {
                String compressFor = rs.getString(6);
                if (compressFor == null || compressFor.equals(BASIC)) {
                    otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS);
                } else if (compressFor.equals(DIRECT_LOAD_OPERATIONS)) {
                    otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_DIRECT_LOAD_OPERATIONS);
                } else if (compressFor.equals(ALL_OPERATIONS)) {
                    otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_ALL_OPERATIONS);
                } else if (compressFor.equals(OLTP)) {
                    otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_OLTP);
                } else if (compressFor.equals(QUERY_LOW)) {
                    otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_QUERY_LOW);
                } else if (compressFor.equals(QUERY_HIGH)) {
                    otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_QUERY_HIGH);
                } else if (compressFor.equals(ARCHIVE_LOW)) {
                    otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_ARCHIVE_LOW);
                } else {
                    otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.COMPRESS_FOR_ARCHIVE_HIGH);
                }
            } else {
                otp.setDefaultTableCompression(OracleTablespaceProperties.DefaultTableCompression.NOCOMPRESS);
            }
            otp.setSegmentManagement(rs.getString(7).equals(AUTO) ? OracleTablespaceProperties.SegmentManagement.AUTO : OracleTablespaceProperties.SegmentManagement.MANUAL);
            otp.setLogging(rs.getString(8).equals(LOGGING) ? OracleTablespaceProperties.LoggingType.LOGGING : OracleTablespaceProperties.LoggingType.NOLOGGING);
            otp.setForceLogging(!rs.getString(9).equals(NO));
            String onlineStatus = rs.getString(10);
            if (onlineStatus.equals(ONLINE)) {
                otp.setOnlineStatus(OracleTablespaceProperties.OnlineStatus.ONLINE);
            } else if (onlineStatus.equals(OFFLINE)) {
                otp.setOnlineStatus(OracleTablespaceProperties.OnlineStatus.OFFLINE);
            }
        }
        if (this.m_tbspType.equals(UNDO)) {
            String retention = rs.getString(11);
            if (retention.equals(NOGUARANTEE)) {
                otp.setRetention(OracleTablespaceProperties.RetentionType.NOGUARANTEE);
            } else if (retention.equals(GUARANTEE)) {
                otp.setRetention(OracleTablespaceProperties.RetentionType.GUARANTEE);
            }
        }
        if (this.m_tbspType.equals(TEMPORARY) && (tbspGroup = rs.getString(12)) != null) {
            otp.setTablespaceGroup(tbspGroup);
        }
        if (extentMgmt.equals(LOCAL)) {
            otp.setExtentManagementType(OracleTablespaceProperties.ExtentManagementType.LOCAL);
        } else {
            otp.setExtentManagementType(OracleTablespaceProperties.ExtentManagementType.DICTIONARY);
        }
        otp.setAutoAllocate(!rs.getString(14).equals(UNIFORM));
        if (!otp.isAutoAllocate()) {
            otp.setUniformSize(rs.getString(16) == null ? null : new Integer(rs.getString(16)));
        }
        tbsp.setProperty("OracleTablespaceProperties", (Object)otp);
        return otp;
    }

    private void fillInStorageProps(ResultSet rs, OracleTablespaceProperties otp) throws SQLException {
        if (this.m_tbspType.equals(PERMANENT)) {
            OracleStorageProperties osp = new OracleStorageProperties();
            osp.setInitialExtent(rs.getString(15) == null ? null : new Integer(rs.getString(15)));
            osp.setNextExtent(rs.getString(16) == null ? null : new Integer(rs.getString(16)));
            osp.setMinExtent(rs.getString(17) == null ? null : new Integer(rs.getString(17)));
            osp.setMaxExtent(rs.getString(18) == null ? null : new Integer(rs.getString(18)));
            osp.setPercentIncrease(rs.getString(19) == null ? null : new Integer(rs.getString(19)));
            otp.setProperty("OracleStorageProperties", (Object)osp);
        }
    }

    private void fillInDataFiles(final Tablespace tbsp) throws DBException {
        final QueryWrapper wrap = this.newQueryWrapper("SELECT \nFILE_NAME, BYTES\n,      MAXBYTES\n,      AUTOEXTENSIBLE\n,      INCREMENT_BY\n,      'DATA'\nFROM   DBA_DATA_FILES\nWHERE  TABLESPACE_NAME = ?\nUNION\nSELECT FILE_NAME, BYTES\n,      MAXBYTES\n,      AUTOEXTENSIBLE\n,      INCREMENT_BY\n,      'TEMP' FILE_TYPE\nFROM   DBA_TEMP_FILES\nWHERE  TABLESPACE_NAME = ?", tbsp.getName(), tbsp.getName());
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        FileSpecification fileSpec = new FileSpecification();
                        String fullPath = rs.getString(1);
                        if (fullPath.indexOf("\\") != -1) {
                            fileSpec.setDirectory(fullPath.substring(0, fullPath.lastIndexOf("\\")));
                            fileSpec.setName(fullPath.substring(fullPath.lastIndexOf("\\") + 1, fullPath.length()));
                        } else if (fullPath.indexOf("/") != -1) {
                            fileSpec.setDirectory(fullPath.substring(0, fullPath.lastIndexOf("/")));
                            fileSpec.setName(fullPath.substring(fullPath.lastIndexOf("/") + 1, fullPath.length()));
                        } else {
                            fileSpec.setName(fullPath);
                        }
                        fileSpec.setFileSize(rs.getString(2) == null ? null : new BigInteger(rs.getString(2)));
                        String autoExtend = rs.getString(4);
                        if (autoExtend != null && autoExtend.equals(OracleTablespaceBuilder.YES)) {
                            AutoExtendProperties aep = new AutoExtendProperties();
                            aep.setMaxSize(rs.getString(3) == null ? null : new BigInteger(rs.getString(3)));
                            aep.setNextSize(rs.getString(5) == null ? null : new BigInteger(rs.getString(5)));
                            fileSpec.setAutoExtendProperties(aep);
                        }
                        tbsp.addFileSpecification(fileSpec);
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)tbsp, sqe);
                }
            }
        };
        wrap.executeQuery(r);
    }

    public Tablespace createObject(String name, Schema schema, DBObjectID id) {
        Tablespace tbsp = new Tablespace(name);
        tbsp.setID(id);
        return tbsp;
    }

    protected String getTablespaceQuery() {
        String query = null;
        switch (this.getDatabase().getDatabaseVersion()) {
            case 0: 
            case 1: 
            case 81: 
            case 82: 
            case 91: 
            case 100: 
            case 101: 
            case 102: {
                if (this.isDBA()) {
                    query = "SELECT UT.BIGFILE\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      NULL\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      UT.RETENTION\n,      DTG.GROUP_NAME\n/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  USER_TABLESPACES UT, DBA_TABLESPACE_GROUPS DTG\nWHERE DTG.TABLESPACE_NAME(+) = UT.TABLESPACE_NAME\nAND   UT.TABLESPACE_NAME = ?";
                    break;
                }
                query = "SELECT UT.BIGFILE\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      NULL\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      UT.RETENTION\n,      NULL\n/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  USER_TABLESPACES UT\nWHERE UT.TABLESPACE_NAME = ?";
                break;
            }
            case 92: {
                query = "SELECT NULL\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      NULL\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      NULL\n,      NULL/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  USER_TABLESPACES UT \nWHERE   UT.TABLESPACE_NAME = ?";
                break;
            }
            default: {
                query = this.isDBA() ? "SELECT UT.BIGFILE\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      UT.COMPRESS_FOR\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      UT.RETENTION\n,      DTG.GROUP_NAME\n/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  USER_TABLESPACES UT, DBA_TABLESPACE_GROUPS DTG\nWHERE DTG.TABLESPACE_NAME(+) = UT.TABLESPACE_NAME\nAND   UT.TABLESPACE_NAME = ?" : "SELECT UT.BIGFILE\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      UT.COMPRESS_FOR\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      UT.RETENTION\n,      NULL/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  USER_TABLESPACES UT \nWHERE   UT.TABLESPACE_NAME = ?";
            }
        }
        return query;
    }

    private boolean isDBA() {
        return ((OracleDatabaseImpl)this.getDatabase()).hasRole("DBA");
    }
}

