/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleSchemaBuilder
extends OracleDBObjectBuilder<Schema> {
    public OracleSchemaBuilder(BaseOracleDatabase db) {
        super(db, "SCHEMA");
    }

    public Schema createObject(String name, Schema schema, DBObjectID id) {
        Schema s = new Schema(name);
        s.setID(id);
        return s;
    }

    private boolean shouldBuild(Schema schema) {
        return this.getDatabase() instanceof OracleDatabaseImpl && ModelUtil.areEqual((Object)schema.getName(), (Object)this.getDatabase().getUserName());
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleSchemaProperties"})
    public void fillInSchemaProperties(Schema schema) throws DBException {
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"USER_PRIVS"})
    public void fillInPrivs(Schema schema) throws DBException {
        if (this.shouldBuild(schema)) {
            final HashSet privs = new HashSet();
            schema.setProperty("USER_PRIVS", privs);
            final QueryWrapper privsWrap = this.newQueryWrapper("SELECT /*OracleDatabaseImpl.ALL_PRIVS_QUERY*/\n       PRIVILEGE FROM SESSION_PRIVS", new Object[0]);
            QueryWrapper.QueryRunnable privsRun = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        while (rs.next()) {
                            privs.add(rs.getString(1));
                        }
                    }
                    catch (SQLException ex) {
                        privsWrap.throwDBException(ex);
                    }
                }
            };
            try {
                privsWrap.executeQuery(privsRun);
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, DBArb.format((int)380, (Object)this.getDatabase().getConnectionName(), (Object)dbe.getMessage()));
            }
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"USER_ROLES"})
    public void fillInRoles(Schema schema) throws DBException {
        if (this.shouldBuild(schema)) {
            final HashSet roles = new HashSet();
            schema.setProperty("USER_ROLES", roles);
            final QueryWrapper rolesWrap = new QueryWrapper((Database)this.getDatabase(), "SELECT /*OracleDatabaseImpl.ALL_ROLES_QUERY*/\n       ROLE FROM SESSION_ROLES");
            QueryWrapper.QueryRunnable rolesRun = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        while (rs.next()) {
                            roles.add(rs.getString(1));
                        }
                    }
                    catch (SQLException ex) {
                        rolesWrap.throwDBException(ex);
                    }
                }
            };
            try {
                rolesWrap.executeQuery(rolesRun);
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "Could not load roles for database " + this.getDatabase().getConnectionName(), dbe.getCause() == null ? dbe : dbe.getCause());
            }
        }
    }

    protected boolean canBuildComponents() {
        return true;
    }
}

