/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.ora.OracleFunctions;
import oracle.javatools.db.ora.OracleSQLQuery;
import oracle.javatools.db.ora.OracleXMLTableClauseProcessor;
import oracle.javatools.db.ora.sxml.SQLFragmentSXMLGenerator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.ArithmeticOperation;
import oracle.javatools.db.sql.CaseStatement;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.DataMiningFunction;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.GroupByExpression;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.HierarchicalQueryObject;
import oracle.javatools.db.sql.InvalidAliasException;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.OnJoinCondition;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.PlSqlUsage;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SetOperation;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.UsingJoinCondition;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.db.sql.WindowFunction;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.SqlExpression;
import oracle.javatools.parser.plsql.data.SqlOperators;
import oracle.javatools.parser.plsql.symtab.SqlAjndef;
import oracle.javatools.parser.plsql.symtab.SqlColdef;
import oracle.javatools.parser.plsql.symtab.SqlFrodef;
import oracle.javatools.parser.plsql.symtab.SqlGbydef;
import oracle.javatools.parser.plsql.symtab.SqlHqcdef;
import oracle.javatools.parser.plsql.symtab.SqlOdmCost;
import oracle.javatools.parser.plsql.symtab.SqlOdmModel;
import oracle.javatools.parser.plsql.symtab.SqlOdmdef;
import oracle.javatools.parser.plsql.symtab.SqlOpndef;
import oracle.javatools.parser.plsql.symtab.SqlOptdef;
import oracle.javatools.parser.plsql.symtab.SqlOrddef;
import oracle.javatools.parser.plsql.symtab.SqlQbcdef;
import oracle.javatools.parser.plsql.symtab.SqlSeldef;
import oracle.javatools.parser.plsql.symtab.SqlStrdef;
import oracle.javatools.parser.plsql.symtab.SqlTypdef;
import oracle.javatools.parser.plsql.symtab.SqlXmtdef;
import oracle.javatools.parser.plsql.syntax.SqlDriver;
import oracle.javatools.parser.plsql.syntax.XMLTableClauseProcessor;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleSQLQueryBuilder
extends AbstractSQLQueryBuilder
implements SQLQueryBuilder {
    private static OracleFunctions s_funcs;
    private OracleSQLQueryBuilder m_parentBuilder;
    private static String m_originalSQL;

    public OracleSQLQueryBuilder(DBObjectProvider pro, Schema defaultSchema) {
        super(pro, defaultSchema);
    }

    public void buildQuery(SQLQuery query) throws SQLQueryException {
        DBObject parent = query.getParent();
        Schema schema = DBUtil.getSchema((DBObject)parent);
        if (schema != null) {
            this.m_defaultSchema = schema;
        }
        if (query != null && query.isDeclarative()) {
            this.m_query = (AbstractSQLQuery)query;
            this.validateQuery();
            this.loadQuery();
        } else {
            String queryText;
            String string = queryText = query == null ? "" : query.getSQLText();
            if (queryText.equals("SELECT \n    \nFROM \n    ")) {
                queryText = "";
            }
            this.buildQuery(queryText, parent instanceof SQLQueryOwner ? (SQLQueryOwner)parent : null);
        }
    }

    protected void buildQueryImpl(String sql, SQLQueryOwner parent) throws SQLQueryException {
        this.m_query = new OracleSQLQuery();
        if (ModelUtil.hasLength((String)sql)) {
            SqlQbcdef query = OracleSQLQueryBuilder.getQueryRoot(sql);
            try {
                this.buildQuery(query, (DBObject)parent);
                this.m_query.setQueryString(sql);
            }
            catch (SQLQueryException sqe) {
                AbstractSQLQuery oldQuery = this.m_query;
                this.m_query = new NonDeclarativeSQLQuery();
                this.m_query.setFromObjects(oldQuery.getFromObjects());
                this.m_query.setSelectObjects(oldQuery.getSelectObjects());
                this.m_query.setQueryString(sql);
                throw sqe;
            }
        }
    }

    private OracleSQLQueryBuilder(DBObjectProvider pro, Schema defaultSchema, SqlQbcdef query, OracleSQLQueryBuilder parent) throws SQLQueryException {
        super(pro, defaultSchema);
        this.m_parentBuilder = parent;
        this.buildQuery(query, (DBObject)this.m_parentBuilder.getSQLQuery());
    }

    private void buildQuery(SqlQbcdef query, DBObject parent) throws SQLQueryException {
        this.m_query = new OracleSQLQuery();
        if (parent != null && !(parent instanceof SQLQueryOwner) && !(parent instanceof SQLQuery)) {
            throw new IllegalArgumentException("parent of a SQLQuery must be a SQLQuery or SQLQueryOwner");
        }
        this.m_query.setParent((DBObject)(parent == null ? this.m_defaultSchema : parent));
        SQLQueryException oops = null;
        SqlQbcdef query2 = query;
        if (query2 != null) {
            SqlOrddef[] orderby;
            SqlGbydef groupby;
            SqlHqcdef hierarchicalQueryClause;
            this.m_query.setDistinct(query2.isDistinct());
            this.m_query.setDistinctSource(query2.getDistinctQualifierSource());
            SqlFrodef[] from = query2.qbcfro;
            if (from == null) {
                SqlOpndef[] ops = (SqlOpndef[])query2.getOperands();
                short type = query2.getOperatorType();
                oops = new SQLQueryException(DBArb.getString((int)29));
                while (query2.optopv != null) {
                    query2 = (SqlQbcdef)query2.optopv[0];
                }
                from = query2.qbcfro;
                if (from == null) {
                    throw oops;
                }
            }
            for (int i = 0; i < from.length; ++i) {
                try {
                    FromObject newFrom = this.createFrom(from[i]);
                    this.addFromObject(newFrom);
                    continue;
                }
                catch (SQLQueryException sqe) {
                    if (oops == null) {
                        oops = sqe;
                        continue;
                    }
                    oops.setNextException((DBException)((Object)sqe));
                }
            }
            SqlSeldef[] select = query2.qbcsel;
            for (int i = 0; i < select.length; ++i) {
                SQLFragment exp;
                try {
                    SelectObject obj = new SelectObject();
                    String alias = select[i].getSelnam();
                    obj.setAlias(alias);
                    obj.setUseAs(select[i].hasAs());
                    SqlOpndef thing = select[i].getSelopn();
                    if (thing == null) {
                        throw new SQLQueryClauseException((SQLFragment)obj, DBArb.format((int)59, (Object)alias));
                    }
                    exp = this.createFragment(thing, (SQLFragment)obj, null);
                    obj.setExpression(exp);
                    if (ModelUtil.hasLength((String)alias) && !this.isValidName("COLUMN", alias)) {
                        this.throwException((SQLQueryException)new InvalidAliasException((AliasFragment)obj));
                    }
                    this.addSelectObject(obj);
                    continue;
                }
                catch (SQLQueryException sqe) {
                    if (parent instanceof Relation) {
                        SelectObject obj = new SelectObject();
                        String name = select[i].getSelnam();
                        if (!ModelUtil.hasLength((String)name)) {
                            SqlOpndef thing = select[i].getSelopn();
                            name = thing.getColumnBaseName();
                        }
                        if (!ModelUtil.hasLength((String)name)) {
                            int j = i + 1;
                            name = "\"<column " + j + ">\"";
                        }
                        if (!name.startsWith("\"")) {
                            name = name.toUpperCase();
                        }
                        obj.setAlias(name);
                        exp = new SimpleSQLFragment("null");
                        obj.setExpression(exp);
                        this.addSelectObject(obj);
                    }
                    if (oops == null) {
                        oops = sqe;
                        continue;
                    }
                    oops.setNextException((DBException)((Object)sqe));
                }
            }
            if (oops != null) {
                OracleSQLQueryBuilder.removeTemporaryObjectIDs((SQLFragment)this.m_query);
                throw oops;
            }
            SqlOptdef where = query2.qbcwhr;
            if (where != null) {
                WhereObject whereObj = this.createWhere(where);
                this.setWhereObject(whereObj);
            }
            if ((hierarchicalQueryClause = query2.qbchqc) != null) {
                HierarchicalQueryObject connectBy = this.createHierarchicalQuery(query2.qbchqc);
                this.setHierarchicalQueryObject(connectBy);
            }
            if ((groupby = query2.qbcgbh) != null) {
                GroupByObject gbc = this.createGroupBy(groupby, (SqlOpndef)query2.qbchav);
                this.setGroupByObject(gbc);
            }
            if ((orderby = query2.qbcord) != null) {
                for (int i = 0; i < orderby.length; ++i) {
                    this.addOrderByObject(this.createOrderByObject(orderby[i]));
                }
            }
            this.validateAggregatesAndGroupBy();
        }
    }

    private void checkLength(String expression) throws SQLQueryException {
        if (!ModelUtil.hasLength((String)expression)) {
            this.throwException(new SQLQueryException(DBArb.getString((int)26)));
        }
    }

    private OrderByObject createOrderByObject(SqlOrddef orderby) throws SQLQueryException {
        String asc = orderby.getOrderByAscSource();
        String nullsLast = orderby.getOrderByNullsLastSource();
        SqlOpndef term = orderby.getOrderByTerm();
        OrderByObject obo = new OrderByObject();
        SQLFragment frag = this.createFragment(term, (SQLFragment)obo, null);
        obo.setExpression(frag);
        obo.setOrder(asc);
        obo.setNullOrdering(nullsLast);
        return obo;
    }

    private FromObject createFrom(SqlFrodef sql) throws SQLQueryException {
        FromObject retval = null;
        SqlOpndef subquery = sql.getSubQuery();
        if (subquery == null) {
            retval = new FromObject();
            SqlAjndef join = sql.getAnsiJoin();
            if (join == null) {
                String alias = sql.getTableAlias();
                retval.setAlias(alias);
                if (ModelUtil.hasLength((String)alias) && !this.isValidName("COLUMN", alias)) {
                    this.throwException((SQLQueryException)new InvalidAliasException((AliasFragment)retval));
                }
                String schema = sql.getSchemaName();
                String table = sql.getTableName();
                if (ModelUtil.hasLength((String)table) && table.equalsIgnoreCase("DUAL")) {
                    retval.setExpression((SQLFragment)new SimpleSQLFragment(table));
                } else {
                    DBObjectUsage exp;
                    if (ModelUtil.hasLength((String)sql.networkAccess)) {
                        this.throwException(new SQLQueryException(DBArb.format((int)36, (Object)table, (Object)sql.networkAccess)));
                    }
                    if ((exp = this.createRelationUsage(schema, table)) == null) {
                        this.throwException(new SQLQueryException(DBArb.format((int)37, (Object)table)));
                    }
                    retval.setExpression((SQLFragment)exp);
                }
            } else {
                JoinObject exp = new JoinObject();
                retval.setExpression((SQLFragment)exp);
                int type = join.getJoinType();
                String joinType = null;
                switch (type) {
                    case 4: {
                        joinType = "FULL";
                        break;
                    }
                    case 2: {
                        joinType = "LEFT";
                        break;
                    }
                    case 3: {
                        joinType = "RIGHT";
                        break;
                    }
                    case 5: {
                        joinType = "CROSS";
                        break;
                    }
                    case 1: {
                        joinType = "INNER";
                    }
                }
                exp.setJoinType(joinType);
                boolean natural = join.getNaturalJoin();
                exp.setNatural(natural);
                SqlFrodef left = join.getJoinLeftTable();
                FromObject leftFrom = this.createFrom(left);
                ExpressionList leftPartitionBy = this.createQueryPartitionClause(left, (SQLFragment)leftFrom);
                exp.setLeftExpression(leftFrom);
                exp.setLeftPartitionBy(leftPartitionBy);
                SqlFrodef right = join.getJoinRightTable();
                FromObject rightFrom = this.createFrom(right);
                ExpressionList rightPartitionBy = this.createQueryPartitionClause(right, (SQLFragment)rightFrom);
                exp.setRightExpression(rightFrom);
                exp.setRightPartitionBy(rightPartitionBy);
                if (m_originalSQL != null) {
                    int startOffset;
                    if (joinType.equals("INNER")) {
                        startOffset = join.getStartOffset();
                        exp.setIncludeJoinKeyword(this.hasToken(startOffset, joinType, "JOIN"));
                    } else if (exp.isOuterJoin()) {
                        startOffset = join.getStartOffset();
                        exp.setIncludeJoinKeyword(this.hasToken(startOffset, "OUTER", "JOIN"));
                    }
                }
                if (!joinType.equals("CROSS") && !natural) {
                    SqlOpndef onClause = join.getJoinOnClause();
                    if (onClause != null && onClause instanceof SqlOptdef) {
                        WhereObject w = this.createWhere((SqlOptdef)onClause, (SQLFragment)retval);
                        if (w != null) {
                            OnJoinCondition on = (OnJoinCondition)w.copyTo((Object)new OnJoinCondition());
                            exp.setCondition((JoinCondition)on);
                        }
                    } else {
                        SqlColdef[] joinCols = join.getJoinColumns();
                        if (joinCols != null) {
                            UsingJoinCondition using = new UsingJoinCondition();
                            exp.setCondition((JoinCondition)using);
                            for (int i = 0; i < joinCols.length; ++i) {
                                String col = joinCols[i].getColumnBaseName();
                                FromObjectUsage cu = this.findColumnInFromObjects(col, new FromObject[]{leftFrom, rightFrom}, true, true, (SQLFragment)retval);
                                if (cu == null) continue;
                                using.addColumn(cu);
                            }
                        }
                    }
                }
            }
            this.ensureID((DBObject)retval);
        } else if (subquery instanceof SqlQbcdef) {
            OracleSQLQueryBuilder builder = new OracleSQLQueryBuilder(this.m_provider, this.m_defaultSchema, (SqlQbcdef)subquery, this);
            AbstractSQLQuery sub = builder.getSQLQuery();
            if (sub == null) {
                this.throwException(new SQLQueryException(DBArb.getString((int)38)));
            } else {
                String alias = sql.getTableAlias();
                retval = new FromObject((SQLFragment)sub, alias);
                if (ModelUtil.hasLength((String)alias) && !this.isValidName("COLUMN", alias)) {
                    this.throwException((SQLQueryException)new InvalidAliasException((AliasFragment)retval));
                }
            }
        } else if (subquery instanceof SqlOptdef || subquery instanceof SqlColdef) {
            SQLFragment[] arg = new SQLFragment[]{this.createFragment(subquery, (SQLFragment)retval, null)};
            Function tc = this.getOracleFunctions().createFunction("TABLE", arg, "TABLE");
            String alias = sql.getTableAlias();
            retval = new FromObject((SQLFragment)tc, alias);
            if (ModelUtil.hasLength((String)alias) && !this.isValidName("COLUMN", alias)) {
                this.throwException((SQLQueryException)new InvalidAliasException((AliasFragment)retval));
            }
        } else if (subquery instanceof SqlXmtdef) {
            SQLFragment[] arg = new SQLFragment[]{new SimpleSQLFragment(((SqlXmtdef)subquery).getXmltableParams())};
            Function tc = this.getOracleFunctions().createFunction("XMLTABLE", arg, "XMLTABLE");
            String alias = sql.getTableAlias();
            retval = new FromObject((SQLFragment)tc, alias);
            if (ModelUtil.hasLength((String)alias) && !this.isValidName("COLUMN", alias)) {
                this.throwException((SQLQueryException)new InvalidAliasException((AliasFragment)retval));
            }
        } else {
            this.throwException(new SQLQueryException(DBArb.getString((int)38)));
        }
        return retval;
    }

    private ExpressionList createQueryPartitionClause(SqlFrodef sql, SQLFragment creating) throws SQLQueryException {
        SqlOpndef[] exprs;
        ExpressionList retval = null;
        SqlGbydef fge = sql.getFromGroupingExprs();
        if (fge != null && (exprs = fge.getGroupBySetTerms()) != null && exprs.length > 0) {
            retval = new ExpressionList();
            SQLFragment[] args = new SQLFragment[exprs.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.createFragment(exprs[i], creating, null);
            }
            retval.setArguments(args);
        }
        return retval;
    }

    protected FromObjectUsage findColumnInFromExpression(String colName, SQLFragment exp, boolean allowDuplicates, FromObject from, SQLFragment creating) throws SQLQueryException {
        FromObjectUsage found = super.findColumnInFromExpression(colName, exp, allowDuplicates, from, creating);
        if (found == null && exp instanceof Function) {
            if ("TABLE".equals(((Function)exp).getFunction())) {
                SQLFragment[] args = ((Function)exp).getArguments();
                if (args != null && args.length > 0) {
                    found = this.findColumnInFromExpression(colName, args[0], allowDuplicates, from, creating);
                }
            } else if ("XMLTABLE".equals(((Function)exp).getFunction())) {
                OracleXMLTableClauseProcessor p = new OracleXMLTableClauseProcessor();
                p.process(exp.getSQLText(), 0);
                if (p.getColumnNames().contains(colName)) {
                    found = new ColumnKeywordUsage(colName, from);
                }
            }
        }
        return found;
    }

    private boolean hasToken(int offset, String token, String before) {
        if (offset > 0 && m_originalSQL != null) {
            before = before.toUpperCase();
            token = token.toUpperCase();
            String test = m_originalSQL.substring(offset).toUpperCase();
            if (ModelUtil.hasLength((String)before) && test.contains(before)) {
                test = test.substring(0, test.indexOf(before));
                return test.contains(token);
            }
            return test.trim().startsWith(token);
        }
        return false;
    }

    private WhereObject createWhere(SqlOptdef sql) throws SQLQueryException {
        return this.createWhere(sql, null);
    }

    private WhereObject createWhere(SqlOptdef sql, SQLFragment creating) throws SQLQueryException {
        WhereObject retval = null;
        short type = sql.getOperatorType();
        if (WhereObject.isWhereOperator((int)type)) {
            SqlExpression[] operands = sql.getOperands();
            SQLFragment[] frags = new SQLFragment[operands.length];
            for (int i = 0; i < operands.length; ++i) {
                frags[i] = this.createFragment((SqlOpndef)operands[i], creating, null);
            }
            retval = new WhereObject(frags, (int)type);
        } else {
            retval = new WhereObject(this.createFragment((SqlOpndef)sql, creating, null));
        }
        return retval;
    }

    private HierarchicalQueryObject createHierarchicalQuery(SqlHqcdef hqc) throws SQLQueryException {
        HierarchicalQueryObject retval = new HierarchicalQueryObject(null, null, hqc.startWithFirst, hqc.noCycle);
        SQLFragment connectBy = this.createFragment((SqlOpndef)hqc.connectByClause, (SQLFragment)retval, null);
        retval.setConnectBy(connectBy);
        if (hqc.startWithClause != null) {
            SQLFragment startWith = this.createFragment((SqlOpndef)hqc.startWithClause, (SQLFragment)retval, null);
            retval.setStartWith(startWith);
        }
        return retval;
    }

    private GroupByObject createGroupBy(SqlGbydef sql, SqlOpndef having) throws SQLQueryException {
        GroupByObject retval = null;
        int type = sql.getGroupByListType();
        if (type == 0) {
            retval = new GroupByObject();
            SqlOpndef[] gbs = sql.getGroupBySetTerms();
            SQLFragment[] frags = new SQLFragment[gbs.length];
            for (int i = 0; i < gbs.length; ++i) {
                SQLFragment f = this.createFragment(gbs[i], (SQLFragment)retval, null);
                if (f != null) {
                    frags[i] = f;
                    continue;
                }
                this.throwException(new SQLQueryException(DBArb.getString((int)41)));
            }
            retval.setExpressions(frags);
            if (having != null && having instanceof SqlOptdef) {
                WhereObject hv = this.createWhere((SqlOptdef)having);
                retval.setHaving(hv);
            }
        }
        return retval;
    }

    private FromObjectUsage createColumnUsage(SqlColdef columnDef) throws SQLQueryException {
        return this.createColumnUsage(columnDef, null);
    }

    private FromObjectUsage createColumnUsage(SqlColdef columnDef, SQLFragment creating) throws SQLQueryException {
        String colName;
        String col;
        String table;
        ColumnKeywordUsage retval = null;
        ArrayList<String> bits = new ArrayList<String>();
        String user = columnDef.getColumnUserName();
        if (ModelUtil.hasLength((String)user)) {
            bits.add(user);
        }
        if (ModelUtil.hasLength((String)(table = columnDef.getColumnTableName()))) {
            bits.add(table);
        }
        if ((col = columnDef.getColumnBaseName()) == null) {
            String[] ca = columnDef.getColumnAndAttributes();
            if (ca != null) {
                bits.addAll(Arrays.asList(ca));
            }
        } else if (ModelUtil.hasLength((String)col)) {
            bits.add(col);
        }
        ArrayList bitsCopy = new ArrayList(bits);
        int colindex = 0;
        FromObject extraFrom = creating instanceof FromObject ? (FromObject)creating : null;
        FromObject from = null;
        String parentName = null;
        if (bits.size() > 1) {
            ++colindex;
            parentName = (String)bits.remove(0);
            from = this.findFromObject(parentName, extraFrom);
            if (from == null && bits.size() > 0 && (from = this.findFromObject(parentName = parentName + "." + (String)bits.get(0), extraFrom)) != null) {
                ++colindex;
                bits.remove(0);
            }
            if (from == null) {
                this.throwException(new SQLQueryException(DBArb.format((int)44, (Object)parentName)));
            }
        }
        if ((colName = (String)bits.remove(0)).charAt(0) != '\"') {
            colName = colName.toUpperCase();
        }
        if (colName.equals("*")) {
            retval = new ColumnKeywordUsage(colName, from);
        } else if (from == null) {
            retval = this.findColumnInFromObjects(colName, creating, new FromObject[]{extraFrom});
            if (retval == null) {
                if (creating instanceof OrderByObject) {
                    for (SelectObject select : this.m_query.getSelectObjects()) {
                        if (!colName.equals(select.getName())) continue;
                        this.ensureID((DBObject)select);
                        retval = new SelectObjectUsage(select, null);
                        break;
                    }
                }
                if (retval == null) {
                    this.throwException(new SQLQueryException(DBArb.format((int)45, (Object)colName)));
                }
            }
        } else {
            this.ensureID((DBObject)from);
            SQLFragment exp = from.getExpression();
            if (exp instanceof RelationUsage) {
                retval = this.findColumnInRelation(colName, (RelationUsage)exp);
                if (retval == null) {
                    this.throwException(new SQLQueryException(DBArb.format((int)46, (Object)colName, (Object)parentName)));
                }
            } else if (exp instanceof SQLQuery) {
                retval = this.findColumnInSubQuery(colName, (SQLQuery)exp);
                if (retval == null) {
                    this.throwException(new SQLQueryException(DBArb.format((int)48, (Object)colName)));
                }
            } else if (exp instanceof SynonymUsage) {
                SchemaObject obj = ((SynonymUsage)exp).getReferencedObject();
                if (obj instanceof Relation) {
                    retval = this.findColumnInRelation(colName, (Relation)obj);
                }
                if (retval == null) {
                    this.throwException(new SQLQueryException(DBArb.format((int)47, (Object)colName, (Object)parentName)));
                } else {
                    retval.setFromObjectID(from.getID());
                }
            } else {
                retval = this.findColumnInFromExpression(colName, exp, false, from, creating);
                if (retval == null) {
                    this.throwException(new SQLQueryException(DBArb.format((int)33, (Object)colName, (Object)parentName)));
                }
            }
        }
        retval.setQualified(colindex > 0);
        if (retval instanceof ColumnUsage) {
            if (bits.size() > 0) {
                ((ColumnUsage)retval).setAttributes(bits.toArray(new String[bits.size()]));
            }
            if (columnDef.colOuterJoin) {
                ((ColumnUsage)retval).setOuterJoin(true);
            }
        }
        return retval;
    }

    private FromObject findFromObject(String alias, FromObject creating) {
        FromObject from = this.getFromObject(alias, creating);
        if (from == null) {
            OracleSQLQueryBuilder parent = this.m_parentBuilder;
            while (parent != null && from == null) {
                from = parent.getFromObject(alias);
                parent = parent.m_parentBuilder;
            }
        }
        return from;
    }

    private SQLFragment[] createFragments(SqlExpression[] sql, SQLFragment creating, Object context) throws SQLQueryException {
        ArrayList<SQLFragment> retval = new ArrayList<SQLFragment>();
        for (int i = 0; i < sql.length; ++i) {
            if (sql[i] == null) continue;
            retval.add(this.createFragment((SqlOpndef)sql[i], creating, context));
        }
        return retval.toArray(new SQLFragment[retval.size()]);
    }

    private FunctionUsage createFunctionUsageFromSqlColdef(SqlColdef columnDef) {
        StringBuffer sb = new StringBuffer();
        if (ModelUtil.hasLength((String)columnDef.getColumnUserName())) {
            sb.append(".").append(columnDef.getColumnUserName());
        }
        if (ModelUtil.hasLength((String)columnDef.getColumnTableName())) {
            sb.append(".").append(columnDef.getColumnTableName());
        }
        if (columnDef.getColumnBaseName() == null) {
            String[] cola = columnDef.getColumnAndAttributes();
            if (cola != null) {
                for (String s : cola) {
                    sb.append(".").append(s);
                }
            }
        } else if (ModelUtil.hasLength((String)columnDef.getColumnBaseName())) {
            sb.append(".").append(columnDef.getColumnBaseName());
        }
        DBObjectID id = this.findIdForFunctionString(sb.substring(1));
        FunctionUsage retval = null;
        if (id != null && !(id instanceof ReferenceID)) {
            retval = new FunctionUsage();
            retval.setObjectID(id);
        }
        return retval;
    }

    private SQLFragment createFragment(SqlOpndef sql, SQLFragment creating, Object context) throws SQLQueryException {
        SQLQuery retval = null;
        byte operandType = sql.getOperandType();
        switch (operandType) {
            case 10: {
                retval = this.createGroupByExpression((SqlGbydef)sql, creating, context);
                break;
            }
            case 13: {
                retval = this.createDataMiningFunction((SqlOdmdef)sql, creating, context);
                break;
            }
            case 12: {
                retval = this.createFragment(((SqlSeldef)sql).getSelopn(), creating, context);
                break;
            }
            case 1: {
                if (context != null && context instanceof String && "MAKE_REF".equalsIgnoreCase((String)context)) {
                    try {
                        retval = this.createColumnUsage((SqlColdef)sql, creating);
                    }
                    catch (SQLQueryException e) {
                        String tab = ((SqlColdef)sql).getColumnBaseName();
                        String schema = ((SqlColdef)sql).getColumnTableName();
                        retval = this.createRelationUsage(schema, tab);
                        if (retval != null) break;
                        String simple = tab;
                        if (ModelUtil.hasLength((String)schema)) {
                            simple = schema + "." + simple;
                        }
                        retval = new SimpleSQLFragment(simple);
                    }
                    break;
                }
                try {
                    retval = this.createColumnUsage((SqlColdef)sql, creating);
                    break;
                }
                catch (SQLQueryException e) {
                    FunctionUsage fu = this.createFunctionUsageFromSqlColdef((SqlColdef)sql);
                    if (fu != null) {
                        retval = fu;
                        break;
                    }
                    throw e;
                }
            }
            case 2: {
                SQLFragment[] argsL;
                SqlOptdef operatorDef = (SqlOptdef)sql;
                short type = operatorDef.getOperatorType();
                if (WhereObject.isWhereOperator((int)type)) {
                    retval = this.createWhere((SqlOptdef)sql, creating);
                    break;
                }
                if (ArithmeticOperation.isArithmeticOperation((int)type)) {
                    retval = new ArithmeticOperation((int)type, this.createFragments(operatorDef.getOperands(), creating, context));
                    break;
                }
                if (Comparison.isComparator((int)type)) {
                    SQLFragment[] args = this.createFragments(operatorDef.getOperands(), creating, context);
                    retval = new Comparison(args[0], (int)type, args.length > 1 ? args[1] : null);
                    break;
                }
                if (SetOperation.isSetOperator((int)type)) {
                    SQLFragment[] args = this.createFragments(operatorDef.getOperands(), creating, context);
                    retval = new SetOperation((int)type, args);
                    break;
                }
                if (type == 371 || type == 385) {
                    SQLFragment[] args = this.createFragments(operatorDef.getOperands(), creating, context);
                    int i = 0;
                    SQLFragment exp = null;
                    if (type == 385) {
                        exp = args[i++];
                    }
                    SQLFragment elseExp = null;
                    if ((args.length - i) % 2 != 0) {
                        elseExp = args[args.length - 1];
                    }
                    int end = args.length - (elseExp == null ? 0 : 1);
                    CaseStatement.WhenThen[] whenThens = new CaseStatement.WhenThen[(end - i) / 2];
                    for (int j = 0; j < whenThens.length; ++j) {
                        whenThens[j] = new CaseStatement.WhenThen(args[i++], args[i++]);
                    }
                    retval = new CaseStatement(exp, whenThens, elseExp);
                    break;
                }
                if (type == 74) {
                    SqlExpression[] opds = sql.getOperands();
                    if (opds.length != 1 || !(opds[0] instanceof SqlQbcdef)) break;
                    SqlQbcdef qbcdef = (SqlQbcdef)opds[0];
                    SQLQuery subquery = this.buildSubquery(qbcdef);
                    if (qbcdef.qbcnop == 4) {
                        retval = new Comparison((SQLFragment)subquery, 10004);
                        break;
                    }
                    if (qbcdef.qbcnop == 5) {
                        retval = new Comparison((SQLFragment)subquery, 10005);
                        break;
                    }
                    retval = subquery;
                    break;
                }
                if (type == 708) {
                    SqlExpression[] opnds;
                    for (SqlExpression sqle : opnds = sql.getOperands()) {
                        short type2;
                        if (!(sqle instanceof SqlOptdef) || (type2 = ((SqlOptdef)sqle).getOperatorType()) != 708) continue;
                        opnds = sqle.getOperands();
                        break;
                    }
                    SQLFragment[] args = this.createFragments(opnds, creating, context);
                    retval = new ExpressionList(args);
                    break;
                }
                if (type == 333) {
                    if (context instanceof WindowFunction) {
                        SqlExpression[] os = operatorDef.getOperands();
                        if (os.length <= 0) break;
                        OrderByObject[] args = new OrderByObject[os.length];
                        for (int i = 0; i < os.length; ++i) {
                            args[i] = this.createOrderByObject((SqlOrddef)os[i]);
                        }
                        ((WindowFunction)context).setOrderBy(args);
                        break;
                    }
                    this.throwException(new SQLQueryException(DBArb.getString((int)56)));
                    break;
                }
                if (type == 334) {
                    if (context instanceof WindowFunction) {
                        SqlExpression[] os = operatorDef.getOperands();
                        SQLFragment[] argsL2 = this.getArgList(creating, context, os, 0);
                        ((WindowFunction)context).setPartitionBy(argsL2);
                        break;
                    }
                    this.throwException(new SQLQueryException(DBArb.getString((int)57)));
                    break;
                }
                if (type == 728 || type == 727) {
                    if (context instanceof WindowFunction) {
                        if (type == 727) {
                            ((WindowFunction)context).setClauseType(WindowFunction.ClauseType.ROWS);
                            break;
                        }
                        ((WindowFunction)context).setClauseType(WindowFunction.ClauseType.RANGE);
                        break;
                    }
                    this.throwException(new SQLQueryException(DBArb.getString((int)58)));
                    break;
                }
                if (type == 722 || type == 723 || type == 724 || type == 725 || type == 726) {
                    WindowFunction.WindowFunctionBound bound = new WindowFunction.WindowFunctionBound();
                    SqlExpression[] os = operatorDef.getOperands();
                    SQLFragment[] argsL3 = this.getArgList(creating, context, os, 0);
                    bound.setBoundExpr(argsL3);
                    if (type == 722 || type == 724) {
                        bound.setBoundType(WindowFunction.BoundType.PRECEDING);
                    } else if (type == 723 || type == 725) {
                        bound.setBoundType(WindowFunction.BoundType.FOLLOWING);
                    } else {
                        bound.setBoundType(WindowFunction.BoundType.CURRENT_ROW);
                    }
                    SQLFragment[] bounds = ((WindowFunction)context).getBounds();
                    if (bounds == null || bounds.length == 0) {
                        SQLFragment[] newBounds = new SQLFragment[]{bound};
                        ((WindowFunction)context).setBounds(newBounds);
                        break;
                    }
                    SQLFragment[] newBounds = new SQLFragment[]{bounds[0], bound};
                    ((WindowFunction)context).setBounds(newBounds);
                    break;
                }
                String func = SqlOperators.OPT_words[type - 1];
                if (func == null) {
                    this.throwException(new SQLQueryException(DBArb.format((int)50, (Object)func)));
                }
                SqlExpression[] os = operatorDef.getOperands();
                int start = 0;
                if (func.equals("plsfun") && os.length > 0) {
                    String schema;
                    ArrayList<String> bits = new ArrayList<String>();
                    func = os[0].getColumnBaseName();
                    String tab = os[0].getColumnTableName();
                    if (ModelUtil.hasLength((String)tab)) {
                        func = tab + "." + func;
                        bits.add(tab);
                    }
                    if (ModelUtil.hasLength((String)(schema = os[0].getColumnUserName()))) {
                        func = schema + "." + func;
                        bits.add(schema);
                    }
                    start = 1;
                }
                func = func.toUpperCase();
                if (operatorDef.isWindowFuntion()) {
                    retval = new WindowFunction(func);
                    argsL = this.getArgList(creating, retval, os, start);
                    if (argsL.length <= 0 || argsL[0] == null) break;
                    ((Function)retval).setArguments(new SQLFragment[]{argsL[0]});
                    break;
                }
                argsL = this.getArgList(creating, func, os, start);
                if (start > 1 && os[0] instanceof SqlColdef) {
                    try {
                        retval = this.createColumnUsage((SqlColdef)os[0], creating);
                        if (retval instanceof PlSqlUsage) {
                            ((PlSqlUsage)retval).setArguments(argsL);
                        }
                    }
                    catch (SQLQueryException sqe) {
                        // empty catch block
                    }
                }
                if (retval != null) break;
                if (SQLFragmentSXMLGenerator.isInCompoundExpressionGroup(func)) {
                    retval = this.getOracleFunctions().createFunction(func, argsL, operatorDef.getSource());
                    if (retval == null) {
                        this.throwException(new SQLQueryException(DBArb.format((int)50, (Object)func)));
                    }
                    ((Function)retval).setDistinct(operatorDef.isDistinct());
                    ((Function)retval).setDistinctSource(operatorDef.getDistinctQualifierSource());
                    break;
                }
                retval = new FunctionUsage();
                ((FunctionUsage)retval).setObjectID(this.findIdForFunctionString(func));
                ((FunctionUsage)retval).setArguments(argsL);
                break;
            }
            case 3: {
                SqlStrdef stringDef = (SqlStrdef)sql;
                byte type = stringDef.getStringType();
                String text = stringDef.getStringText();
                retval = new SimpleSQLFragment(text);
                break;
            }
            case 11: {
                SqlTypdef typeDef = (SqlTypdef)sql;
                String typName = typeDef.getTypName();
                retval = new SimpleSQLFragment(typName);
                break;
            }
            case 5: {
                retval = this.buildSubquery((SqlQbcdef)sql);
            }
        }
        return retval;
    }

    private DBObjectID findIdForFunctionString(String str) {
        PlSqlToken startTk;
        DBObjectID retval = null;
        PlSqlToken tk = startTk = PlSqlTokenizer.tokenize((String)str, (String[])new String[0]);
        PlSqlToken endTk = null;
        while (tk.getType() != PlSqlToken.Type.END_MARKER) {
            tk = tk.getNextToken();
        }
        endTk = tk.getPrevCodeToken();
        retval = this.findObjectID((DBObject)this.m_defaultSchema, startTk);
        if (retval == null) {
            try {
                Schema schema = this.m_provider.getSchema(this.m_provider.getInternalName(startTk.getSource(true)));
                if (schema != null && startTk.getNextCodeToken().matches(".")) {
                    retval = this.findObjectID((DBObject)schema, startTk.getNextCodeToken(2));
                }
            }
            catch (DBException e) {
                // empty catch block
            }
        }
        if (retval == null) {
            String[] bits = str.split("\\.");
            if (bits.length == 1) {
                retval = new ReferenceID("FUNCTION", this.m_defaultSchema, str);
            } else if (bits.length == 2) {
                Schema s = null;
                try {
                    s = this.m_provider.getSchema(bits[0]);
                }
                catch (DBException e) {
                    // empty catch block
                }
                if (s != null) {
                    retval = new ReferenceID("FUNCTION", s, bits[1]);
                } else {
                    retval = new ReferenceID("FUNCTION", (String)null, bits[1]);
                    ((ReferenceID)retval).setParent((DBObjectID)new ReferenceID("PACKAGE", this.m_defaultSchema, bits[0]));
                }
            }
        }
        return retval;
    }

    private DBObjectID findObjectID(DBObject parent, PlSqlToken tk) {
        String[] types = new String[]{"FUNCTION", "PACKAGE", "TYPE"};
        String tokVal = this.m_provider.getInternalName(tk.getSource(true));
        if (parent instanceof Schema) {
            for (String objType : types) {
                SchemaObject so = null;
                try {
                    so = this.m_provider.getObject(objType, (Schema)parent, tokVal);
                }
                catch (DBException e) {
                    so = null;
                }
                if (so == null) continue;
                if (tk.getNextCodeToken().getType() == PlSqlToken.Type.END_MARKER) {
                    return so.getID();
                }
                if (tk.getNextCodeToken().matches(".")) {
                    return this.findObjectID((DBObject)so, tk.getNextCodeToken(2));
                }
                return null;
            }
        } else {
            for (DBObject kid : parent.getOwnedObjects()) {
                if (kid.getName() == null || !kid.getName().equals(tokVal)) continue;
                if (tk.getNextCodeToken().getType() == PlSqlToken.Type.END_MARKER) {
                    return kid.getID();
                }
                if (tk.getNextCodeToken().matches(".")) {
                    return this.findObjectID(kid, tk.getNextCodeToken(2));
                }
                return null;
            }
        }
        return null;
    }

    private SQLQuery buildSubquery(SqlQbcdef sql) throws SQLQueryException {
        OracleSQLQueryBuilder builder = new OracleSQLQueryBuilder(this.m_provider, this.m_defaultSchema, sql, this);
        AbstractSQLQuery sub = builder.getSQLQuery();
        if (sub == null) {
            this.throwException(new SQLQueryException(DBArb.getString((int)38)));
            return null;
        }
        return sub;
    }

    private SQLFragment[] getArgList(SQLFragment creating, Object func, SqlExpression[] os, int start) throws SQLQueryException {
        ArrayList<SQLFragment> args = new ArrayList<SQLFragment>();
        for (int i = start; i < os.length; ++i) {
            if (os[i] == null) continue;
            SQLFragment arg = this.createFragment((SqlOpndef)os[i], creating, func);
            args.add(arg);
        }
        SQLFragment[] argsL = args.toArray(new SQLFragment[args.size()]);
        return argsL;
    }

    private static void removeTemporaryObjectIDs(SQLFragment frag) {
        if (frag != null) {
            DBObject[] children;
            if (frag.getID() instanceof TemporaryObjectID) {
                frag.setID(null);
            }
            if ((children = frag.getOwnedObjects()) != null) {
                for (DBObject child : children) {
                    if (!(child instanceof SQLFragment)) continue;
                    OracleSQLQueryBuilder.removeTemporaryObjectIDs((SQLFragment)child);
                }
            }
        }
    }

    public DBObjectProvider getProvider() {
        return this.m_provider;
    }

    public void setProvider(DBObjectProvider provider) {
        this.m_provider = provider;
    }

    protected SQLFragment parseFromExpression(String expression, FromObject creating) throws SQLQueryException {
        this.checkLength(expression);
        int dot = expression.indexOf(".");
        String schema = null;
        String relation = null;
        if (dot > 0) {
            schema = expression.substring(0, dot);
            relation = expression.substring(dot + 1);
        } else {
            DBObject queryParent = this.m_query.getParent();
            if (queryParent instanceof SchemaObject) {
                schema = ((SchemaObject)queryParent).getSchema().getName();
            }
            relation = expression;
        }
        DBObjectUsage ru = this.createRelationUsage(schema, relation);
        if (ru == null) {
            this.throwException(new SQLQueryException(DBArb.format((int)37, (Object)expression)));
        }
        return ru;
    }

    protected SQLFragment parseSelectExpression(String expression, SelectObject creating) throws SQLQueryException {
        this.checkLength(expression);
        PlsqlRoot root = OracleSQLQueryBuilder.parseQueryString(expression, 3);
        OracleSQLQueryBuilder.checkErrors(root, expression);
        PlsqlNode[] units = root.getUnits();
        if (units != null && units.length > 0) {
            return this.createFragment((SqlOpndef)units[0], (SQLFragment)creating, null);
        }
        throw new SQLQueryException(DBArb.getString((int)51));
    }

    public SQLFragment parseWhereExpression(String expression, WhereObject creating) throws SQLQueryException {
        this.checkLength(expression);
        PlsqlRoot root = OracleSQLQueryBuilder.parseQueryString(expression, 1);
        OracleSQLQueryBuilder.checkErrors(root, expression);
        PlsqlNode[] units = root.getUnits();
        if (units != null && units.length > 0) {
            return this.createFragment((SqlOpndef)units[0], (SQLFragment)creating, null);
        }
        throw new SQLQueryException(DBArb.getString((int)51));
    }

    public OnJoinCondition parseOnExpression(String expression, JoinObject join) throws SQLQueryException {
        this.checkLength(expression);
        PlsqlRoot root = OracleSQLQueryBuilder.parseQueryString(expression, 1);
        OracleSQLQueryBuilder.checkErrors(root, expression);
        PlsqlNode[] units = root.getUnits();
        if (units != null && units.length > 0) {
            SQLFragment frag = this.createFragment((SqlOpndef)units[0], (SQLFragment)join, null);
            if (frag instanceof WhereObject) {
                return (OnJoinCondition)frag.copyTo((Object)new OnJoinCondition());
            }
            return new OnJoinCondition(frag);
        }
        throw new SQLQueryException(DBArb.getString((int)51));
    }

    private SQLFragment createGroupByExpression(SqlGbydef gby, SQLFragment creating, Object context) throws SQLQueryException {
        ExpressionList retval;
        int type = gby.getGroupByListType();
        if (type == 0) {
            retval = new ExpressionList();
        } else {
            GroupByExpression groupByE = new GroupByExpression();
            retval = groupByE;
            switch (type) {
                case 1: {
                    groupByE.setGroupByType(GroupByExpression.GroupingType.ROLLUP);
                    break;
                }
                case 2: {
                    groupByE.setGroupByType(GroupByExpression.GroupingType.CUBE);
                    break;
                }
                case 3: {
                    groupByE.setGroupByType(GroupByExpression.GroupingType.GROUPING_SETS);
                    break;
                }
                case 4: {
                    groupByE.setGroupByType(null);
                }
            }
        }
        SqlOpndef[] ops = gby.getGroupBySetTerms();
        SQLFragment[] args = new SQLFragment[ops == null ? 0 : ops.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.createFragment(ops[i], (SQLFragment)retval, context);
        }
        if (retval instanceof GroupByExpression) {
            ((GroupByExpression)retval).setArguments(args);
        } else {
            retval.setArguments(args);
        }
        return retval;
    }

    private SQLFragment createDataMiningFunction(SqlOdmdef odm, SQLFragment creating, Object context) throws SQLQueryException {
        DataMiningFunction retval = null;
        short type = odm.getOperatorType();
        String fname = SqlOperators.OPT_words[type - 1];
        if (fname == null) {
            this.throwException(new SQLQueryException(DBArb.format((int)50, (Object)fname)));
        }
        fname = fname.toUpperCase();
        SqlExpression[] os = odm.getOperands();
        SqlOdmdef internalOp = (SqlOdmdef)os[0];
        SqlOdmModel model = internalOp.getModel();
        String msn = model.getSchemaName();
        String modelName = (ModelUtil.hasLength((String)msn) ? msn + "." : "") + model.getModelName();
        SqlOdmCost cost = odm.getCost();
        SQLFragment[] dmSpecificArgs = this.getArgList(creating, fname, os, 1);
        SQLFragment[] usingArgs = this.getArgList(creating, fname, internalOp.getOperands(), 0);
        retval = new DataMiningFunction(fname, (SQLFragment)new SimpleSQLFragment(modelName), cost != null, dmSpecificArgs, usingArgs);
        return retval;
    }

    private DBObjectUsage createRelationUsage(String schema, String relation) {
        if (!ModelUtil.hasLength((String)relation)) {
            return null;
        }
        RelationUsage retval = null;
        schema = schema == null ? null : this.getInternalName(schema);
        relation = this.getInternalName(relation);
        try {
            Schema sch = null;
            sch = ModelUtil.hasLength((String)schema) && this.m_provider != null ? this.m_provider.getSchema(schema) : this.m_defaultSchema;
            if (sch != null || this.m_provider == null) {
                SchemaObject obj = this.getObject("TABLE", sch, relation);
                if (obj == null) {
                    obj = this.getObject("VIEW", sch, relation);
                }
                if (obj == null) {
                    obj = this.getObject("MATERIALIZED VIEW", sch, relation);
                }
                if (obj == null) {
                    DBObjectID id;
                    obj = this.getObject("SYNONYM", sch, relation);
                    if (obj != null && (id = obj.getID()) != null) {
                        retval = new SynonymUsage(id);
                        retval.setProvider(this.m_provider);
                    }
                } else {
                    DBObjectID id = obj.getID();
                    if (id != null) {
                        retval = new RelationUsage(id);
                        retval.setProvider(this.m_provider);
                    }
                }
            }
        }
        catch (DBException e) {
            DBLog.logStackTrace((Throwable)e);
        }
        return retval;
    }

    public boolean supportsConnectBy() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsOrderBy() {
        return true;
    }

    public FunctionDefinition[] getBuiltInFunctions() {
        Collection funcs = this.getOracleFunctions().getAllFunctions();
        return funcs.toArray(new FunctionDefinition[funcs.size()]);
    }

    private OracleFunctions getOracleFunctions() {
        if (s_funcs == null) {
            s_funcs = new OracleFunctions();
        }
        return s_funcs;
    }

    protected final void setViewColDataType(ViewColumn col) {
        super.setViewColDataType(col);
        if (col.getDataTypeUsage() == null) {
            DataType dt;
            DBObjectID id = col.getSelectObjectID();
            SelectObject so = null;
            try {
                so = (SelectObject)id.resolveID();
            }
            catch (DBException e) {
                // empty catch block
            }
            if (so != null && so.getExpression() instanceof Function && (dt = this.getOracleFunctions().getDataType(((Function)so.getExpression()).getFunction(), this.m_provider)) != null) {
                col.setDataTypeUsage(dt.createDefaultUsage());
            }
        }
    }

    protected FromObjectUsage findColumnInRelation(String colName, Relation rel) throws SQLQueryException {
        if (colName.equalsIgnoreCase(this.getOracleFunctions().ROWID)) {
            ColumnKeywordUsage c = new ColumnKeywordUsage();
            c.setColumnName(colName);
            return c;
        }
        return super.findColumnInRelation(colName, rel);
    }

    private void validateAggregatesAndGroupBy() throws SQLQueryException {
        ArrayList<GroupByValidationObject> gbvo = this.getGroupByValidationObjects((SQLFragment[])this.m_query.getSelectObjects());
        boolean aggregatesInSelect = false;
        boolean nonAggregatesInSelect = false;
        SQLFragment firstNonAggregate = null;
        for (GroupByValidationObject val : gbvo) {
            if (val.m_frag instanceof Function && ((Function)val.m_frag).isGrouping()) {
                aggregatesInSelect = true;
                continue;
            }
            nonAggregatesInSelect = true;
            if (firstNonAggregate != null) continue;
            firstNonAggregate = val.m_frag;
        }
        if (aggregatesInSelect && nonAggregatesInSelect && this.m_query.getGroupByObject() == null) {
            SQLQueryClauseException ex = new SQLQueryClauseException((SQLFragment)firstNonAggregate.getParent(), DBArb.format((int)42, (Object)firstNonAggregate.getSQLText()));
            ex.addType("GROUP BY");
            this.throwException((SQLQueryException)ex);
        } else if (this.m_query.getGroupByObject() != null && nonAggregatesInSelect) {
            GroupByObject gbo = this.m_query.getGroupByObject();
            for (GroupByValidationObject val : gbvo) {
                if (!val.m_ok) {
                    for (SQLFragment gbFrag : this.getChildrenDeep((SQLFragment)gbo, null)) {
                        if (!gbFrag.equals(val.m_frag)) continue;
                        val.m_ok = true;
                        break;
                    }
                    if (!val.m_ok && val.m_frag instanceof ColumnUsage) {
                        for (SQLFragment gbFrag : this.getChildrenDeep((SQLFragment)gbo, null)) {
                            if (!(gbFrag instanceof ColumnUsage)) continue;
                            ColumnUsage cu = new ColumnUsage();
                            ((ColumnUsage)gbFrag).copyTo((Object)cu);
                            cu.setQualified(((ColumnUsage)val.m_frag).isQualified());
                            if (!cu.equals((Object)val.m_frag)) continue;
                            val.m_ok = true;
                            break;
                        }
                    }
                }
                if (val.m_ok) continue;
                SQLQueryClauseException ex = new SQLQueryClauseException((SQLFragment)val.m_frag.getParent(), DBArb.format((int)43, (Object)val.m_frag.getSQLText()));
                ex.addType("GROUP BY");
                this.throwException((SQLQueryException)ex);
            }
        }
    }

    private Collection<SQLFragment> getChildrenDeep(SQLFragment parent, Collection<SQLFragment> kids) {
        if (kids == null) {
            kids = new ArrayList<SQLFragment>();
        }
        for (DBObject obj : parent.getOwnedObjects()) {
            if (!(obj instanceof SQLFragment)) continue;
            kids.add((SQLFragment)obj);
            this.getChildrenDeep((SQLFragment)obj, kids);
        }
        return kids;
    }

    private ArrayList<GroupByValidationObject> getGroupByValidationObjects(SQLFragment[] fragList) {
        ArrayList<GroupByValidationObject> retval = new ArrayList<GroupByValidationObject>();
        for (SQLFragment sqlFrag : fragList) {
            GroupByObject gbo;
            boolean groupByExpression = false;
            SQLFragment sqlFrag2 = sqlFrag;
            if (sqlFrag2 instanceof SelectObject) {
                sqlFrag2 = ((SelectObject)sqlFrag).getExpression();
            }
            if ((gbo = this.m_query.getGroupByObject()) != null) {
                for (SQLFragment gbFrag : this.getChildrenDeep((SQLFragment)gbo, null)) {
                    if (!gbFrag.equals(sqlFrag2)) continue;
                    retval.add(new GroupByValidationObject(sqlFrag2, true));
                    groupByExpression = true;
                    break;
                }
            }
            if (groupByExpression) continue;
            if (sqlFrag2 instanceof ArithmeticOperation) {
                retval.addAll(this.getGroupByValidationObjects(((ArithmeticOperation)sqlFrag2).getArguments()));
                continue;
            }
            if (sqlFrag2 instanceof Function) {
                if (((Function)sqlFrag2).isGrouping()) {
                    retval.add(new GroupByValidationObject(sqlFrag2, true));
                    continue;
                }
                retval.addAll(this.getGroupByValidationObjects(((Function)sqlFrag2).getArguments()));
                continue;
            }
            if (!(sqlFrag2 instanceof ColumnUsage)) continue;
            retval.add(new GroupByValidationObject(sqlFrag2, false));
        }
        return retval;
    }

    private static PlsqlRoot parseQueryString(String expression, int type) throws SQLQueryException {
        m_originalSQL = expression;
        try {
            ReadTextBuffer textBuffer = TextBufferFactory.createReadTextBuffer((String)expression);
            PlsqlParser.ParsingOptions options = new PlsqlParser.ParsingOptions();
            options.inputType = 16;
            SqlDriver sql = new SqlDriver();
            sql.setXmlTableClauseProcessor((XMLTableClauseProcessor)new OracleXMLTableClauseProcessor());
            sql.setTextBuffer(textBuffer);
            return sql.qcpidrv(type);
        }
        catch (Exception e) {
            DBLog.logStackTrace((Throwable)e);
            throw new SQLQueryException(DBArb.format((int)28, (Object)e.getMessage()));
        }
    }

    private static void checkErrors(PlsqlRoot root, String sql) throws SQLQueryException {
        PlsqlError[] errors = root.getErrors();
        if (errors != null && errors.length > 0) {
            throw new SQLParseException(errors, sql);
        }
    }

    public static void checkSQLForErrors(String sql) throws SQLQueryException {
        PlsqlRoot root = OracleSQLQueryBuilder.parseQueryString(sql, 0);
        OracleSQLQueryBuilder.checkErrors(root, sql);
    }

    private static SqlQbcdef getQueryRoot(String sql) throws SQLQueryException {
        PlsqlRoot root = OracleSQLQueryBuilder.parseQueryString(sql, 0);
        OracleSQLQueryBuilder.checkErrors(root, sql);
        PlsqlNode[] units = root.getUnits();
        SqlQbcdef query = null;
        for (int i = 0; i < units.length; ++i) {
            byte type = ((SqlExpression)units[i]).getOperandType();
            if (type != 5) continue;
            query = (SqlQbcdef)units[i];
        }
        return query;
    }

    public static void ensureQueryNonDeclarative(DBObjectProvider pro, SQLQueryOwner owner) {
        OracleSQLQueryBuilder.ensureQueryNonDeclarative(pro, owner, false);
    }

    public static void ensureQueryNonDeclarative(DBObjectProvider pro, SQLQueryOwner owner, boolean supportZeroCols) {
        SQLQuery query = owner.getSQLQuery();
        if (query != null) {
            String origtext;
            String newtext = origtext = query.getSQLText();
            try {
                if (owner instanceof Relation) {
                    int i;
                    StringBuilder newtextBuilder = new StringBuilder(origtext);
                    int moved = 0;
                    Column[] cols = ((Relation)owner).getColumns();
                    SqlQbcdef queryRoot = OracleSQLQueryBuilder.getQueryRoot(origtext);
                    SqlSeldef[] seldefs = queryRoot.qbcsel;
                    if (cols.length == 0 && supportZeroCols) {
                        cols = new Column[seldefs.length];
                        for (i = 0; i < seldefs.length; ++i) {
                            cols[i] = new Column("COL" + (i + 1));
                        }
                    }
                    if (seldefs != null && seldefs.length == cols.length) {
                        for (i = 0; i < seldefs.length; ++i) {
                            String alias;
                            SqlOpndef selopn = seldefs[i].getSelopn();
                            if (cols[i] == null || selopn == null || selopn.getOperandType() == 1 || ModelUtil.hasLength((String)(alias = seldefs[i].getSelnam()))) continue;
                            int startOfNext = -1;
                            if (i < seldefs.length - 1) {
                                startOfNext = seldefs[i + 1].getStartOffset();
                                startOfNext = origtext.lastIndexOf(",", startOfNext);
                            } else {
                                SqlFrodef[] froms = queryRoot.qbcfro;
                                if (froms != null && froms.length > 0) {
                                    startOfNext = froms[0].subQuery != null ? froms[0].subQuery.getStartOffset() : (froms[0].ansiJoin != null ? froms[0].ansiJoin.getStartOffset() : froms[0].getStartOffset());
                                    int index = origtext.toUpperCase().indexOf("FROM", startOfNext);
                                    startOfNext = origtext.toUpperCase().lastIndexOf("FROM", startOfNext);
                                }
                            }
                            String exp = origtext.substring(seldefs[i].getStartOffset(), startOfNext);
                            if (startOfNext <= 0 || exp.contains("*") || pro.isValidName("COLUMN", exp.trim())) continue;
                            String toInsert = " " + cols[i].getName() + " ";
                            newtextBuilder.insert(moved + startOfNext, toInsert);
                            Logger logger = DBLog.getLogger(OracleSQLQueryBuilder.class);
                            logger.log(Level.INFO, DBArb.format((int)358, (Object[])new String[]{toInsert, exp.trim(), owner.getType(), owner.getName()}));
                            moved += toInsert.length();
                        }
                    }
                    newtext = newtextBuilder.toString();
                }
            }
            catch (Exception e) {
                DBLog.getLogger(OracleSQLQueryBuilder.class).log(Level.WARNING, "Error processing view", e);
            }
            owner.setSQLQuery((SQLQuery)new NonDeclarativeSQLQuery(newtext));
        }
    }

    private static class GroupByValidationObject {
        private SQLFragment m_frag;
        private boolean m_ok;

        GroupByValidationObject(SQLFragment frag, boolean ok) {
            this.m_frag = frag;
            this.m_ok = ok;
        }
    }
}

