/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleTablespaceUtil;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleIndexBuilder
extends OracleDBObjectBuilder<Index> {
    private static String BITMAP = "BITMAP";
    private static String NORMAL = "NORMAL";
    private static String DOMAIN = "DOMAIN";
    private static String UNIQUE = "UNIQUE";
    private String m_matViewUsingIndexIndexName = null;

    public OracleIndexBuilder(BaseOracleDatabase db) {
        super(db, "INDEX");
    }

    public Index createObject(String name, Schema schema, DBObjectID id) {
        Index idx = new Index(name, schema);
        idx.setID(id);
        return idx;
    }

    protected boolean canBuildMultipleObjects() {
        return true;
    }

    protected void fillInObject(Index indx) throws DBException {
        SchemaObject parent = this.getParent(indx);
        if (parent == null) {
            this.fillInLonelyIndex(indx);
        } else if (parent instanceof Table) {
            OracleTableBuilder tb = (OracleTableBuilder)this.getDatabase().getBuilderForType("TABLE");
            tb.buildObjectComponent((AbstractBuildableObject)((Table)parent), "indexes");
        }
    }

    private SchemaObject getParent(final Index index) throws DBException {
        final QueryWrapper wrap = this.newQueryWrapper(this.getIndexTabQuery(), index.getSchema(), index);
        final String[] details = new String[3];
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        details[0] = rs.getString(1);
                        details[1] = rs.getString(2);
                        details[2] = rs.getString(3);
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)index, sqe);
                }
            }
        };
        wrap.executeQuery(r);
        String tabName = details[0];
        String tabOwner = details[1];
        String tabType = details[2];
        if (ModelUtil.hasLength((String)tabOwner) && ModelUtil.hasLength((String)tabName) && ModelUtil.hasLength((String)tabType)) {
            BaseOracleDatabase db = this.getDatabase();
            Schema s = this.getSchema(tabOwner);
            if (s != null) {
                SchemaObject obj = db.getObject(tabType, s, tabName);
                if (obj == null && "TABLE".equals(tabType)) {
                    obj = db.getObject("MATERIALIZED VIEW", s, tabName);
                }
                return obj;
            }
        }
        return null;
    }

    private void fillInLonelyIndex(Index i) {
    }

    protected void fillInIndexes(SchemaObject parent) throws DBException {
        HashMap<String, Index> nameMap = new HashMap<String, Index>();
        this.fillInBaseDefinitionsForTable(parent, nameMap);
        if (nameMap.size() > 0) {
            this.fillInExpressionsForTable(parent, nameMap);
            if (parent instanceof Table) {
                Table table = (Table)parent;
                Collection<Index> indexes = nameMap.values();
                this.removeSystemIndexes((Relation)table, indexes);
                Index[] idxArray = indexes.toArray(new Index[indexes.size()]);
                Arrays.sort(idxArray, DBUtil.getNameComparator());
                table.setIndexes(idxArray);
                if (this.getDatabase().getDatabaseVersion() != 1) {
                    this.fillInPartitions(table);
                }
                for (Index index : idxArray) {
                    this.registerObject((AbstractBuildableObject)index);
                }
            }
        }
        this.updateTimestamp((DBObject)parent, true);
    }

    private void fillInBaseDefinitionsForTable(final SchemaObject parent, final Map<String, Index> indexes) throws DBException {
        Schema tableOwner = parent.getSchema();
        boolean isDefaultUser = tableOwner == null || tableOwner.getName().equals(this.getDatabase().getUserName());
        String query = this.getTableIndexesQuery(isDefaultUser);
        String parentType = parent.getType();
        if (parent instanceof MaterializedView) {
            parentType = "TABLE";
        }
        final QueryWrapper wrap = this.newQueryWrapper(query, parent.getSchema(), parentType, parent);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        Table.TableType tt;
                        String idxName = rs.getString(1);
                        String owner = rs.getString(2);
                        Schema s = OracleIndexBuilder.this.getSchema(owner);
                        Index index = (Index)OracleIndexBuilder.this.getDatabase().findObject("INDEX", s, idxName);
                        if (index == null) {
                            int idInt = rs.getInt(3);
                            DBObjectID id = OracleIndexBuilder.this.getDatabase().createID(s, idxName, "INDEX", rs.wasNull() ? null : Integer.valueOf(idInt));
                            index = OracleIndexBuilder.this.createObject(idxName, s, id);
                            OracleIndexBuilder.this.getDatabase().cacheObject((SystemObject)index, true);
                        }
                        if (index == null) continue;
                        OracleIndexBuilder.this.markAsBuilt((AbstractBuildableObject)index);
                        String uniqueness = rs.getString(4);
                        String indexType = rs.getString(5);
                        String itypOwner = rs.getString(6);
                        String itypName = rs.getString(7);
                        String itypParameters = rs.getString(8);
                        String domIdxOpStatus = rs.getString(9);
                        String degree = rs.getString(10);
                        String prefix_length = rs.getString(11);
                        OracleIndexBuilder.this.setIndexType(index, uniqueness, indexType, itypOwner, itypName, itypParameters, domIdxOpStatus);
                        int parallelDegree = ModelUtil.hasLength((String)degree) ? ("DEFAULT".equals(degree) ? 0 : Integer.decode(degree)) : 1;
                        index.setParallelDegree(parallelDegree);
                        if (ModelUtil.hasLength((String)prefix_length)) {
                            index.setKeyCompression(Integer.valueOf(prefix_length));
                        } else {
                            index.setKeyCompression(null);
                        }
                        boolean tempTable = parent instanceof Table ? (tt = (Table.TableType)parent.getProperty("TableType")) == Table.TableType.SESSION_TEMP || tt == Table.TableType.TRANSACTION_TEMP : false;
                        if (!tempTable) {
                            OracleStorageProperties osp = OracleTableBuilder.getSegmentAttributeProperties(rs, OracleIndexBuilder.this.getDatabase());
                            index.setProperty("OracleStorageProperties", (Object)osp);
                        }
                        index.setColumnExpressions(null);
                        if (parent instanceof Table) {
                            index.setTable((Table)parent);
                        }
                        indexes.put(idxName, index);
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)parent, sqe);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private void fillInPartitions(final Table table) throws DBException {
        for (final Index index : table.getIndexes()) {
            String indexName = index.getName();
            final QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_INDEX_PARTITION_TYPE_QUERY*/\n       partitioning_type, subpartitioning_type, locality, partition_count\nfrom   all_part_indexes api\nwhere  api.owner = ?\nand    api.index_name = ?\n", index.getSchema(), indexName);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        while (rs.next()) {
                            String partitioningType = rs.getString("PARTITIONING_TYPE");
                            String subpartitioningType = rs.getString("SUBPARTITIONING_TYPE");
                            String locality = rs.getString("LOCALITY");
                            String partitionCount = rs.getString("PARTITION_COUNT");
                            if ("SYSTEM".equals(partitioningType)) continue;
                            OracleIndexPartitions oip = new OracleIndexPartitions();
                            index.setProperty("OracleIndexPartitions", (Object)oip);
                            NameBasedID id = new NameBasedID((DBObject)oip, index.getID());
                            oip.setID((DBObjectID)id);
                            OracleIndexPartitions.PartitionType partitionType = index.getIndexType() == Index.IndexType.DOMAIN ? OracleIndexPartitions.PartitionType.DOMAIN : ("GLOBAL".equals(locality) ? OracleIndexPartitions.PartitionType.valueOf((String)(locality + '_' + partitioningType)) : ("HASH".equals(partitioningType) ? OracleIndexPartitions.PartitionType.LOCAL_HASH : ("NONE".equals(subpartitioningType) ? OracleIndexPartitions.PartitionType.LOCAL_OTHER : OracleIndexPartitions.PartitionType.LOCAL_COMP)));
                            oip.setPartitionType(partitionType);
                            if ("GLOBAL".equals(locality)) {
                                oip.setGlobalPartitionColumns(OracleIndexBuilder.this.getGlobalPartitionColumns(index));
                                Integer guantity = partitionCount != null || partitionCount != "" ? Integer.decode(partitionCount) : 0;
                                if ("HASH".equals(partitioningType) && guantity > 0 && index.getName().startsWith("SYS_P")) {
                                    oip.setGlobalHashQuantity(guantity);
                                }
                            }
                            OracleIndexBuilder.this.fillInIndexPartitions(index);
                        }
                    }
                    catch (SQLException ex) {
                        wrap.throwDBException((DBObject)table, ex);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            };
            wrap.executeQuery(r);
        }
    }

    private DBObjectID[] getGlobalPartitionColumns(Index index) throws DBException {
        final ArrayList columnIDs = new ArrayList();
        final Table table = index.getTable();
        final QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_INDEX_PARTITION_COLUMNS_QUERY*/\n       column_name\nfrom   all_part_key_columns apk1\nwhere  apk1.owner = ?\nand    apk1.name = ?\nand    apk1.object_type = 'INDEX'\norder by apk1.column_position", index.getSchema(), index);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String columnName = rs.getString(1);
                        columnIDs.add(new NameBasedID("COLUMN", columnName, table.getID()));
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)table, ex);
                }
            }
        };
        wrap.executeQuery(r);
        return columnIDs.toArray(new DBObjectID[columnIDs.size()]);
    }

    private void fillInIndexPartitions(final Index index) throws DBException {
        final OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        final OracleIndexPartitions.PartitionType partitionType = oip.getPartitionType();
        final Map<String, OracleIndexPartitions> subpartitionsMap = partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP ? this.getSubpartitions(index) : null;
        final QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_INDEX_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, null PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENT min_extents, MAX_EXTENT max_extents,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       COMPRESSION, PARTITION_NAME, HIGH_VALUE, PARAMETERS\nfrom   all_ind_partitions aip\nwhere  aip.index_owner = ?\nand    aip.index_name  = ?\norder by aip.partition_position", index.getSchema(), index);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String name = rs.getString("PARTITION_NAME");
                        IndexPartition ip = new IndexPartition(name, oip);
                        oip.addPartition(ip);
                        NameBasedID id = new NameBasedID((DBObject)ip, oip.getID());
                        ip.setID((DBObjectID)id);
                        if (partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP || partitionType == OracleIndexPartitions.PartitionType.LOCAL_OTHER) {
                            String compression = rs.getString("COMPRESSION");
                            Boolean keyCompression = rs.wasNull() || !ModelUtil.hasLength((String)compression) ? null : Boolean.valueOf("ENABLED".equals(compression));
                            ip.setKeyCompression(keyCompression);
                        }
                        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
                            String highValue = rs.getString("HIGH_VALUE");
                            ip.setValuesLessThan(highValue);
                        }
                        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH || partitionType == OracleIndexPartitions.PartitionType.LOCAL_HASH) {
                            String tablespaceName = rs.getString("TABLESPACE_NAME");
                            if (ModelUtil.hasLength((String)tablespaceName)) {
                                OracleStorageProperties osp = new OracleStorageProperties();
                                ip.setSegmentAttributes(osp);
                                osp.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)OracleIndexBuilder.this.getDatabase(), tablespaceName));
                            }
                        } else if (partitionType == OracleIndexPartitions.PartitionType.DOMAIN) {
                            ip.setDomainParameters(rs.getString("PARAMETERS"));
                        } else {
                            ip.setSegmentAttributes(OracleTableBuilder.getSegmentAttributeProperties(rs, OracleIndexBuilder.this.getDatabase()));
                        }
                        if (subpartitionsMap == null || !subpartitionsMap.containsKey(name)) continue;
                        ip.setSubpartitions((OracleIndexPartitions)subpartitionsMap.get(name));
                        OracleIndexBuilder.this.setSubpartitionIDs(ip);
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)index, ex);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private Map<String, OracleIndexPartitions> getSubpartitions(final Index index) throws DBException {
        final HashMap<String, OracleIndexPartitions> map = new HashMap<String, OracleIndexPartitions>();
        final QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_INDEX_SUBPARTITIONS_QUERY*/\n       PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE\nfrom   ALL_IND_SUBPARTITIONS\nwhere  INDEX_OWNER = ?\nand    INDEX_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION", index.getSchema(), index);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                String currentPartitionName = null;
                OracleIndexPartitions subpartitions = null;
                try {
                    while (rs.next()) {
                        String name = rs.getString("PARTITION_NAME");
                        if (!name.equals(currentPartitionName)) {
                            subpartitions = new OracleIndexPartitions(OracleIndexPartitions.PartitionType.SUBPARTITION);
                            map.put(name, subpartitions);
                            currentPartitionName = name;
                        }
                        IndexPartition sp = new IndexPartition(rs.getString("SUBPARTITION_NAME"), subpartitions);
                        subpartitions.addPartition(sp);
                        name = rs.getString("TABLESPACE_NAME");
                        if (!ModelUtil.hasLength((String)name)) continue;
                        OracleStorageProperties osp = new OracleStorageProperties();
                        sp.setSegmentAttributes(osp);
                        osp.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)OracleIndexBuilder.this.getDatabase(), name));
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)index, ex);
                }
            }
        };
        wrap.executeQuery(r);
        return map;
    }

    private void setSubpartitionIDs(IndexPartition ip) {
        OracleIndexPartitions subpartitions = ip.getSubpartitions();
        if (subpartitions != null) {
            NameBasedID parid = new NameBasedID((DBObject)subpartitions, ip.getID());
            subpartitions.setID((DBObjectID)parid);
            for (IndexPartition sp : subpartitions.getPartitions()) {
                sp.setID((DBObjectID)new NameBasedID((DBObject)sp, (DBObjectID)parid));
            }
        }
    }

    private void fillInExpressionsForTable(final SchemaObject parent, Map<String, Index> indexes) throws DBException {
        final ArrayList indexCols = new ArrayList();
        final QueryWrapper wrap = this.newQueryWrapper(this.getIndexColumnQuery(), parent.getSchema(), parent);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        indexCols.add(new IndexColumnQueryResult(rs));
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)parent, ex);
                }
            }
        };
        wrap.executeQuery(r);
        Map<String, Map<Long, String>> idxExpressions = null;
        for (IndexColumnQueryResult stuff : indexCols) {
            Constraint c;
            String idxName = stuff.idxName;
            String colName = stuff.colName;
            Long colPosn = stuff.colPosn;
            String colDesc = stuff.colDesc;
            Index index = indexes.get(idxName);
            if (index == null) continue;
            if (parent instanceof Relation && (c = ((Relation)parent).getConstraint(index.getName())) instanceof ColumnConstraint) {
                Column[] cols = ((ColumnConstraint)c).getColumns();
                IndexObject[] exps = new IndexObject[cols.length];
                for (int i = 0; i < cols.length; ++i) {
                    exps[i] = new IndexObject();
                    ColumnUsage cu = new ColumnUsage(cols[i].getID());
                    exps[i].setExpression((SQLFragment)cu);
                }
                index.setColumnExpressions(exps);
                index = null;
            }
            if (index == null || !(parent instanceof Relation)) continue;
            SQLFragment expression = null;
            if (stuff.isAllIndExp == 1) {
                if (idxExpressions == null) {
                    idxExpressions = this.getIndexExpressionsForTable(parent);
                }
                Map columnMap = (Map)idxExpressions.get(idxName);
                assert (columnMap != null && columnMap.containsKey(colPosn)) : "Missing column expression";
                expression = OracleIndexBuilder.createExpression((String)columnMap.get(colPosn), (Relation)parent, (DBObjectProvider)this.getDatabase());
            } else {
                expression = OracleIndexBuilder.createExpression(this.getDatabase().getExternalName(colName), (Relation)parent, (DBObjectProvider)this.getDatabase());
            }
            if (index.getIndexType() == Index.IndexType.DOMAIN) {
                colDesc = null;
            }
            IndexObject io = new IndexObject(expression, colDesc);
            index.addColumnExpression(io);
        }
    }

    private Map<String, Map<Long, String>> getIndexExpressionsForTable(final SchemaObject parent) throws DBException {
        final HashMap<String, Map<Long, String>> idxExpressions = new HashMap<String, Map<Long, String>>();
        final QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_INDEX_EXPRESSION_PER_TAB_QUERY*/\n       index_name, column_position, column_expression  FROM sys.all_ind_expressions WHERE table_owner = ? AND table_name = ? ", parent.getSchema(), parent);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String idxName = rs.getString(1);
                        Long colPosn = new Long(rs.getInt(2));
                        String colExpr = rs.getString(3);
                        HashMap<Long, String> columnMap = (HashMap<Long, String>)idxExpressions.get(idxName);
                        if (columnMap == null) {
                            columnMap = new HashMap<Long, String>();
                            idxExpressions.put(idxName, columnMap);
                        }
                        columnMap.put(colPosn, colExpr);
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)parent, ex);
                }
            }
        };
        wrap.executeQuery(r);
        return idxExpressions;
    }

    public static SQLFragment createExpression(String exp, Relation parent, DBObjectProvider pro) {
        return SQLFragmentExpressionBuilder.getExpression((DBObjectProvider)pro, (Relation)parent, (SQLFragmentExpressionBuilder.ExpressionType)SQLFragmentExpressionBuilder.ExpressionType.ITEM, (String)exp);
    }

    private String getIndexTabQuery() {
        int databaseType = this.getDatabase().getDatabaseVersion();
        return databaseType == 1 ? "SELECT /*OracleDictionaryQueries.ALL_INDEX_TAB_QUERY*/\n       TABLE_NAME, TABLE_OWNER, TABLE_TYPE FROM ALL_INDEXES WHERE OWNER = ? AND INDEX_NAME = ?" : "SELECT /*OracleDictionaryQueries.ALL_INDEX_TAB_QUERY*/\n       TABLE_NAME, TABLE_OWNER, TABLE_TYPE FROM ALL_INDEXES WHERE OWNER = ? AND INDEX_NAME = ? AND GENERATED = 'N'";
    }

    private String getIndexColumnQuery() {
        int databaseType = this.getDatabase().getDatabaseVersion();
        return databaseType == 1 ? "SELECT /*OracleDictionaryQueries.ALL_INDEX_OLITE_COLUMN_PER_TAB_QUERY*/\n       INDEX_NAME, COLUMN_NAME, COLUMN_POSITION, NULL, 0 FROM SYS.ALL_IND_COLUMNS WHERE TABLE_OWNER = ? AND TABLE_NAME = ? ORDER BY INDEX_NAME, COLUMN_POSITION" : "SELECT /*OracleDictionaryQueries.ALL_INDEX_COLUMN_PER_TAB_QUERY*/\n       c.index_name, c.column_name, c.column_position, c.descend,   ( SELECT 1     FROM   sys.all_ind_expressions e     WHERE  e.index_name  = c.index_name     AND    e.index_owner = c.index_owner     AND    e.column_position = c.column_position ) col_expr_exists FROM sys.all_ind_columns c  WHERE c.table_owner = ? AND c.table_name  = ? ORDER BY c.index_name, c.column_position ";
    }

    private String getTableIndexesQuery(boolean isDefaultUser) {
        int databaseType = this.getDatabase().getDatabaseVersion();
        return databaseType == 1 ? " SELECT /*OracleDictionaryQueries.ALL_INDEX_OLITE_PER_TAB_QUERY*/\n       i.INDEX_NAME, i.OWNER, null OBJECT_ID,       i.UNIQUENESS, 'NORMAL', null, null, null, null, null, null,        null TABLESPACE_NAME, null PCT_FREE, null PCT_USED, null INI_TRANS, null MAX_TRANS,\n       null INITIAL_EXTENT, null NEXT_EXTENT, null MIN_EXTENTS, null MAX_EXTENTS, null PCT_INCREASE,\n       null FREELISTS, null FREELIST_GROUPS, null LOGGING, null BUFFER_POOL\n FROM ALL_INDEXES i  WHERE TABLE_OWNER = ? AND TABLE_TYPE = ? AND TABLE_NAME = ?" : (isDefaultUser ? "SELECT /*OracleDictionaryQueries.ALL_INDEX_PER_TAB_QUERY*/\n       i.INDEX_NAME, i.OWNER,       (select object_id from all_objects where object_name = i.index_name and owner = i.owner and object_type = 'INDEX') OBJECT_ID,       i.UNIQUENESS, i.INDEX_TYPE, i.ITYP_OWNER, i.ITYP_NAME, i.PARAMETERS, i.DOMIDX_OPSTATUS, i.DEGREE, i.PREFIX_LENGTH,        i.TABLESPACE_NAME, i.PCT_FREE, null PCT_USED, i.INI_TRANS, i.MAX_TRANS,\n       i.INITIAL_EXTENT, i.NEXT_EXTENT, i.MIN_EXTENTS, i.MAX_EXTENTS, i.PCT_INCREASE,\n       i.FREELISTS, i.FREELIST_GROUPS, i.LOGGING, i.BUFFER_POOL\nFROM ALL_INDEXES i WHERE TABLE_OWNER = ? AND TABLE_TYPE = ? AND TABLE_NAME = ? AND GENERATED = 'N'" : " SELECT /*OracleDictionaryQueries.ALL_INDEX_PER_TAB_OTHER_USER_QUERY*/\n       i.INDEX_NAME, i.OWNER, null OBJECT_ID,       i.UNIQUENESS, i.INDEX_TYPE, i.ITYP_OWNER, i.ITYP_NAME, i.PARAMETERS, i.DOMIDX_OPSTATUS, i.DEGREE, i.PREFIX_LENGTH,        i.TABLESPACE_NAME, i.PCT_FREE, null PCT_USED, i.INI_TRANS, i.MAX_TRANS,\n       i.INITIAL_EXTENT, i.NEXT_EXTENT, i.MIN_EXTENTS, i.MAX_EXTENTS, i.PCT_INCREASE,\n       i.FREELISTS, i.FREELIST_GROUPS, i.LOGGING, i.BUFFER_POOL\n FROM ALL_INDEXES i  WHERE TABLE_OWNER = ? AND TABLE_TYPE = ? AND TABLE_NAME = ? AND GENERATED = 'N' ");
    }

    private void setIndexType(Index index, String uniqueness, String indexType, String itypOwner, String itypName, String itypParameters, String domIdxopStatus) {
        if (UNIQUE.equals(uniqueness)) {
            index.setIndexType(Index.IndexType.UNIQUE);
        } else if (indexType != null && indexType.contains(BITMAP)) {
            index.setIndexType(Index.IndexType.BITMAP);
        } else if (indexType != null && indexType.contains(NORMAL)) {
            index.setIndexType(Index.IndexType.NORMAL);
        } else if (DOMAIN.equals(indexType)) {
            index.setIndexType(Index.IndexType.DOMAIN);
            index.setDomainIndextype((DBObjectID)new ReferenceID("INDEXTYPE", itypOwner, itypName));
            index.setDomainIndextypeParameters(itypParameters);
            index.setDomainIndextypeOpStatus(domIdxopStatus);
        }
    }

    private void removeSystemIndexes(Relation parent, Collection<Index> indexes) throws DBException {
        Iterator<Index> idx = indexes.iterator();
        while (idx.hasNext()) {
            Index index = idx.next();
            Constraint c = parent.getConstraint(index.getName());
            if (c != null) {
                if (!c.isEnabled()) continue;
                idx.remove();
                continue;
            }
            if (parent instanceof MaterializedView && this.m_matViewUsingIndexIndexName != null && index.getName().equals(this.m_matViewUsingIndexIndexName)) {
                idx.remove();
                continue;
            }
            IndexObject[] expressions = index.getColumnExpressions();
            boolean sysColumnBasedIndex = false;
            block3: for (int i = 0; i < expressions.length && !sysColumnBasedIndex; ++i) {
                String expression;
                String string = expression = expressions[i].getExpression() != null ? expressions[i].getExpression().getSQLText() : null;
                if (expression == null) continue;
                try {
                    for (String[] nameComponents : ParserUtils.getColumnNames((String)expression, (ParserUtils.ExpressionType)ParserUtils.ExpressionType.ARITHMETIC)) {
                        if (!nameComponents[0].startsWith("SYS_NC")) continue;
                        idx.remove();
                        sysColumnBasedIndex = true;
                        continue block3;
                    }
                    continue;
                }
                catch (SQLQueryException e) {
                    throw new DBException((DBObject)index, DBArb.format((int)131, (Object[])new Object[]{index.getName(), expression}));
                }
            }
        }
    }

    public void setMatViewUsingIndexIndexName(String matViewUsingIndexIndexName) {
        this.m_matViewUsingIndexIndexName = matViewUsingIndexIndexName;
    }

    private class IndexColumnQueryResult {
        String idxName;
        String colName;
        Long colPosn;
        String colDesc;
        int isAllIndExp;

        private IndexColumnQueryResult(ResultSet rs) throws SQLException {
            this.idxName = rs.getString(1);
            this.colName = rs.getString(2);
            this.colPosn = new Long(rs.getInt(3));
            this.colDesc = rs.getString(4);
            this.isAllIndExp = rs.getInt(5);
        }

        public String toString() {
            return "\n" + this.idxName + " " + this.colName + " " + this.colPosn + " " + this.colDesc + " " + this.isAllIndExp + "\n";
        }
    }
}

