/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.ora.resource.OracleFunctionsBundle;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

public class OracleFunctions {
    public final String LEVEL = "LEVEL";
    public final String ROWID = "ROWID";
    public final String ROWNUM = "ROWNUM";
    public final String NULL = "NULL";
    public final String ABS = "ABS";
    public final String ACOS = "ACOS";
    public final String ASIN = "ASIN";
    public final String ATAN = "ATAN";
    public final String ATAN2 = "ATAN2";
    public final String BITAND = "BITAND";
    public final String CEIL = "CEIL";
    public final String COS = "COS";
    public final String COSH = "COSH";
    public final String EXP = "EXP";
    public final String FLOOR = "FLOOR";
    public final String LN = "LN";
    public final String LOG = "LOG";
    public final String MOD = "MOD";
    public final String NVL = "NVL";
    public final String POWER = "POWER";
    public final String ROUND = "ROUND";
    public final String SIN = "SIN";
    public final String SINH = "SINH";
    public final String SQRT = "SQRT";
    public final String TAN = "TAN";
    public final String TANH = "TANH";
    public final String TRUNC = "TRUNC";
    public final String WIDTH_BUCKET = "WIDTH_BUCKET";
    public final String VSIZE = "VSIZE";
    public final String NANVL = "NANVL";
    public final String REMAINDER = "REMAINDER";
    public final String SIGN = "SIGN";
    public final String CHR = "CHR";
    public final String CONCAT = "CONCAT";
    public final String INITCAP = "INITCAP";
    public final String LOWER = "LOWER";
    public final String LPAD = "LPAD";
    public final String LTRIM = "LTRIM";
    public final String NCHR = "NCHR";
    public final String NLS_INITCAP = "NLS_INITCAP";
    public final String NLS_LOWER = "NLS_LOWER";
    public final String NLSSORT = "NLSSORT";
    public final String NLS_UPPER = "NLS_UPPER";
    public final String REGEXP_REPLACE = "REGEXP_REPLACE";
    public final String REGEXP_SUBSTR = "REGEXP_SUBSTR";
    public final String REPLACE = "REPLACE";
    public final String RPAD = "RPAD";
    public final String RTRIM = "RTRIM";
    public final String SOUNDEX = "SOUNDEX";
    public final String SUBSTR = "SUBSTR";
    public final String SUBSTRB = "SUBSTRB";
    public final String SUBSTRC = "SUBSTRC";
    public final String SUBSTR2 = "SUBSTR2";
    public final String SUBSTR4 = "SUBSTR4";
    public final String TRANSLATE = "TRANSLATE";
    public final String TREAT = "TREAT";
    public final String TRIM = "TRIM";
    public final String UPPER = "UPPER";
    public final String ASCII = "ASCII";
    public final String INSTR = "INSTR";
    public final String INSTRB = "INSTRB";
    public final String INSTRC = "INSTRC";
    public final String INSTR2 = "INSTR2";
    public final String INSTR4 = "INSTR4";
    public final String LENGTH = "LENGTH";
    public final String LENGTHB = "LENGTHB";
    public final String LENGTHC = "LENGTHC";
    public final String LENGTH2 = "LENGTH2";
    public final String LENGTH4 = "LENGTH4";
    public final String REGEXP_INSTR = "REGEXP_INSTR";
    public final String REGEXP_COUNT = "REGEXP_COUNT";
    public final String ADD_MONTHS = "ADD_MONTHS";
    public final String CURRENT_DATE = "CURRENT_DATE";
    public final String CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    public final String DBTIMEZONE = "DBTIMEZONE";
    public final String FROM_TZ = "FROM_TZ";
    public final String LAST_DAY = "LAST_DAY";
    public final String LOCALTIMESTAMP = "LOCALTIMESTAMP";
    public final String MONTHS_BETWEEN = "MONTHS_BETWEEN";
    public final String NEW_TIME = "NEW_TIME";
    public final String NEXT_DAY = "NEXT_DAY";
    public final String NUMTODSINTERVAL = "NUMTODSINTERVAL";
    public final String NUMTOYMINTERVAL = "NUMTOYMINTERVAL";
    public final String SESSIONTIMEZONE = "SESSIONTIMEZONE";
    public final String SYSDATE = "SYSDATE";
    public final String SYSTIMESTAMP = "SYSTIMESTAMP";
    public final String TZ_OFFSET = "TZ_OFFSET";
    public final String CARDINALITY = "CARDINALITY";
    public final String COLLECT = "COLLECT";
    public final String POWERMULTISET = "POWERMULTISET";
    public final String POWERMULTISET_BY_CARDINALITY = "POWERMULTISET_BY_CARDINALITY";
    public final String SET = "SET";
    public final String CLUSTER_ID = "CLUSTER_ID";
    public final String CLUSTER_PROBABILITY = "CLUSTER_PROBABILITY";
    public final String CLUSTER_SET = "CLUSTER_SET";
    public final String FEATURE_ID = "FEATURE_ID";
    public final String FEATURE_SET = "FEATURE_SET";
    public final String FEATURE_VALUE = "FEATURE_VALUE";
    public final String PREDICTION = "PREDICTION";
    public final String PREDICTION_COST = "PREDICTION_COST";
    public final String PREDICTION_DETAILS = "PREDICTION_DETAILS";
    public final String PREDICTION_PROBABILITY = "PREDICTION_PROBABILITY";
    public final String PREDICTION_SET = "PREDICTION_SET";
    public final String PREDICTION_BOUNDS = "PREDICTION_BOUNDS";
    public final String AVG = "AVG";
    public final String CORR = "CORR";
    public final String CORR_S = "CORR_S";
    public final String CORR_K = "CORR_K";
    public final String COUNT = "COUNT";
    public final String COVAR_POP = "COVAR_POP";
    public final String COVAR_SAMP = "COVAR_SAMP";
    public final String CUME_DIST = "CUME_DIST";
    public final String DENSE_RANK = "DENSE_RANK";
    public final String FIRST = "FIRST";
    public final String GROUP_ID = "GROUP_ID";
    public final String GROUPING = "GROUPING";
    public final String GROUPING_ID = "GROUPING_ID";
    public final String LAST = "LAST";
    public final String MAX = "MAX";
    public final String MEDIAN = "MEDIAN";
    public final String MIN = "MIN";
    public final String PERCENTILE_CONT = "PERCENTILE_CONT";
    public final String PERCENTILE_DISC = "PERCENTILE_DISC";
    public final String PERCENT_RANK = "PERCENT_RANK";
    public final String RANK = "RANK";
    public final String REGR_SLOPE = "REGR_SLOPE";
    public final String REGR_INTERCEPT = "REGR_INTERCEPT";
    public final String REGR_COUNT = "REGR_COUNT";
    public final String REGR_R2 = "REGR_R2";
    public final String REGR_AVGX = "REGR_AVGX";
    public final String REGR_AVGY = "REGR_AVGY";
    public final String REGR_SXX = "REGR_SXX";
    public final String REGR_SYY = "REGR_SYY";
    public final String REGR_SXY = "REGR_SXY";
    public final String STATS_BINOMIAL_TEST = "STATS_BINOMIAL_TEST";
    public final String STATS_CROSSTAB = "STATS_CROSSTAB";
    public final String STATS_F_TEST = "STATS_F_TEST";
    public final String STATS_KS_TEST = "STATS_KS_TEST";
    public final String STATS_MODE = "STATS_MODE";
    public final String STATS_MW_TEST = "STATS_MW_TEST";
    public final String STATS_ONE_WAY_ANOVA = "STATS_ONE_WAY_ANOVA";
    public final String STATS_T_TEST_ONE = "STATS_T_TEST_ONE";
    public final String STATS_T_TEST_PAIRED = "STATS_T_TEST_PAIRED";
    public final String STATS_T_TEST_INDEP = "STATS_T_TEST_INDEP";
    public final String STATS_T_TEST_INDEPU = "STATS_T_TEST_INDEPU";
    public final String STATS_WSR_TEST = "STATS_WSR_TEST";
    public final String STDDEV = "STDDEV";
    public final String STDDEV_POP = "STDDEV_POP";
    public final String STDDEV_SAMP = "STDDEV_SAMP";
    public final String SUM = "SUM";
    public final String VAR_POP = "VAR_POP";
    public final String VAR_SAMP = "VAR_SAMP";
    public final String VARIANCE = "VARIANCE";
    public final String ASCIISTR = "ASCIISTR";
    public final String BIN_TO_NUM = "BIN_TO_NUM";
    public final String CAST = "CAST";
    public final String CHARTOROWID = "CHARTOROWID";
    public final String COMPOSE = "COMPOSE";
    public final String CONVERT = "CONVERT";
    public final String DECOMPOSE = "DECOMPOSE";
    public final String HEXTORAW = "HEXTORAW";
    public final String RAWTOHEX = "RAWTOHEX";
    public final String RAWTONHEX = "RAWTONHEX";
    public final String ROWIDTOCHAR = "ROWIDTOCHAR";
    public final String ROWIDTONCHAR = "ROWIDTONCHAR";
    public final String SCN_TO_TIMESTAMP = "SCN_TO_TIMESTAMP";
    public final String TIMESTAMP_TO_SCN = "TIMESTAMP_TO_SCN";
    public final String TO_BINARY_DOUBLE = "TO_BINARY_DOUBLE";
    public final String TO_BINARY_FLOAT = "TO_BINARY_FLOAT";
    public final String TO_CHAR = "TO_CHAR";
    public final String TO_CLOB = "TO_CLOB";
    public final String TO_DATE = "TO_DATE";
    public final String TO_LOB = "TO_LOB";
    public final String TO_MULTI_BYTE = "TO_MULTI_BYTE";
    public final String TO_NCHAR = "TO_NCHAR";
    public final String TO_NCLOB = "TO_NCLOB";
    public final String TO_NUMBER = "TO_NUMBER";
    public final String TO_DSINTERVAL = "TO_DSINTERVAL";
    public final String TO_SINGLE_BYTE = "TO_SINGLE_BYTE";
    public final String TO_TIMESTAMP = "TO_TIMESTAMP";
    public final String TO_TIMESTAMP_TZ = "TO_TIMESTAMP_TZ";
    public final String TO_YMINTERVAL = "TO_YMINTERVAL";
    public final String UNISTR = "UNISTR";
    public final String BFILENAME = "BFILENAME";
    public final String COALESCE = "COALESCE";
    public final String CUBE_TABLE = "CUBE_TABLE";
    public final String CV = "CV";
    public final String DECODE = "DECODE";
    public final String DUMP = "DUMP";
    public final String EMPTY_BLOB = "EMPTY_BLOB";
    public final String EMPTY_CLOB = "EMPTY_CLOB";
    public final String EXTRACT = "EXTRACT";
    public final String GREATEST = "GREATEST";
    public final String ITERATION_NUMBER = "ITERATION_NUMBER";
    public final String LEAST = "LEAST";
    public final String LNNVL = "LNNVL";
    public final String NLS_CHARSET_DECL_LEN = "NLS_CHARSET_DECL_LEN";
    public final String NLS_CHARSET_ID = "NLS_CHARSET_ID";
    public final String NLS_CHARSET_NAME = "NLS_CHARSET_NAME";
    public final String NULLIF = "NULLIF";
    public final String NVL2 = "NVL2";
    public final String ORA_HASH = "ORA_HASH";
    public final String PRESENTNNV = "PRESENTNNV";
    public final String PRESENTV = "PRESENTV";
    public final String PREVIOUS = "PREVIOUS";
    public final String SYS_CONNECT_BY_PATH = "SYS_CONNECT_BY_PATH";
    public final String SYS_CONTEXT = "SYS_CONTEXT";
    public final String SYS_EXTRACT_UTC = "SYS_EXTRACT_UTC";
    public final String SYS_GUID = "SYS_GUID";
    public final String SYS_TYPEID = "SYS_TYPEID";
    public final String UID = "UID";
    public final String USER = "USER";
    public final String USERENV = "USERENV";
    public final String DEREF = "DEREF";
    public final String MAKE_REF = "MAKE_REF";
    public final String REF = "REF";
    public final String REFTOHEX = "REFTOHEX";
    public final String VALUE = "VALUE";
    public final String FIRST_VALUE = "FIRST_VALUE";
    public final String LAG = "LAG";
    public final String LAST_VALUE = "LAST_VALUE";
    public final String LEAD = "LEAD";
    public final String NTILE = "NTILE";
    public final String RATIO_TO_REPORT = "RATIO_TO_REPORT";
    public final String ROW_NUMBER = "ROW_NUMBER";
    public final String APPENDCHILDXML = "APPENDCHILDXML";
    public final String DELETEXML = "DELETEXML";
    public final String DEPTH = "DEPTH";
    public final String EXISTSNODE = "EXISTSNODE";
    public final String EXTRACTVALUE = "EXTRACTVALUE";
    public final String INSERTCHILDXML = "INSERTCHILDXML";
    public final String INSERTXMLBEFORE = "INSERTXMLBEFORE";
    public final String PATH = "PATH";
    public final String SYS_DBURIGEN = "SYS_DBURIGEN";
    public final String SYS_XMLAGG = "SYS_XMLAGG";
    public final String SYS_XMLGEN = "SYS_XMLGEN";
    public final String UPDATEXML = "UPDATEXML";
    public final String XMLAGG = "XMLAGG";
    public final String XMLCDATA = "XMLCDATA";
    public final String XMLCOLATTVAL = "XMLCOLATTVAL";
    public final String XMLCOMMENT = "XMLCOMMENT";
    public final String XMLCONCAT = "XMLCONCAT";
    public final String XMLELEMENT = "XMLELEMENT";
    public final String XMLFOREST = "XMLFOREST";
    public final String XMLPARSE = "XMLPARSE";
    public final String XMLPI = "XMLPI";
    public final String XMLQUERY = "XMLQUERY";
    public final String XMLROOT = "XMLROOT";
    public final String XMLSEQUENCE = "XMLSEQUENCE";
    public final String XMLSERIALIZE = "XMLSERIALIZE";
    public final String XMLTABLE = "XMLTABLE";
    public final String XMLTRANSFORM = "XMLTRANSFORM";
    public final String XMLCAST = "XMLCAST";
    public final String XMLDIFF = "XMLDIFF";
    public final String XMLEXISTS = "XMLEXISTS";
    public final String XMLPATCH = "XMLPATCH";
    private final Map m_singleFuncs = new TreeMap();
    private final Map m_groupFuncs = new TreeMap();
    private final String NUMBER = "NUMBER";
    private final String VARCHAR2 = "VARCHAR2";
    private final String DATE = "DATE";
    private final String CLOB = "CLOB";
    private final String BLOB = "BLOB";
    private final String RAW = "RAW";

    OracleFunctions() {
        this.loadFunctions();
        this.loadGroupingFunctions();
    }

    public Function createFunction(String func, SQLFragment[] args) throws SQLQueryException {
        return this.createFunction(func, args, null);
    }

    public Function createFunction(String func, SQLFragment[] args, String source) throws SQLQueryException {
        if (ModelUtil.hasLength((String)func)) {
            if (func.equals("CAST")) {
                if (args.length != 2) {
                    throw new SQLQueryException("usage: CAST( expr, type )");
                }
                if (args[0] instanceof SQLQuery) {
                    args[0] = new Function("MULTISET", new SQLFragment[]{args[0]});
                }
                return new Function(func, args, " AS ");
            }
            if (func.equals("CONCAT")) {
                if (source != null && source.equals("||")) {
                    Function f = new Function(source, args);
                    return f;
                }
            } else {
                if (func.equals("TRANSLATE") && args.length == 2) {
                    return new Function(func, args, " USING ");
                }
                if (func.equals("LTRIM") && "LEADING".equals(source) || func.equals("RTRIM") && "TRAILING".equals(source) || func.equals("TRIM") && "BOTH".equals(source)) {
                    String leader = source;
                    if (args.length == 2) {
                        this.swapFirstTwoArgs(args);
                    } else {
                        leader = source + " FROM";
                    }
                    Function f = new Function("TRIM", args, " FROM ");
                    f.setTrimLeader(leader);
                    return f;
                }
                if (func.equals("TRIM") && args.length == 2) {
                    this.swapFirstTwoArgs(args);
                    return new Function(func, args, " FROM ");
                }
            }
            return new Function(func, args, this.isGroupingFunction(func));
        }
        return null;
    }

    private void swapFirstTwoArgs(SQLFragment[] args) {
        SQLFragment one = args[1];
        args[1] = args[0];
        args[0] = one;
    }

    private void loadFunctions() {
        this.m_singleFuncs.put("LEVEL", new FunctionDefinition("LEVEL", 0, OracleFunctionsBundle.get("LEVEL"), "NUMBER"));
        this.m_singleFuncs.put("ROWID", new FunctionDefinition("ROWID", 0, OracleFunctionsBundle.get("ROWID"), "VARCHAR2"));
        this.m_singleFuncs.put("ROWNUM", new FunctionDefinition("ROWNUM", 0, OracleFunctionsBundle.get("ROWNUM"), "NUMBER"));
        this.m_singleFuncs.put("NULL", new FunctionDefinition("NULL", 0, OracleFunctionsBundle.get("NULL"), null));
        this.m_singleFuncs.put("ABS", new FunctionDefinition("ABS", 1, OracleFunctionsBundle.get("ABS"), "NUMBER"));
        this.m_singleFuncs.put("ACOS", new FunctionDefinition("ACOS", 1, OracleFunctionsBundle.get("ACOS"), "NUMBER"));
        this.m_singleFuncs.put("ASIN", new FunctionDefinition("ASIN", 1, OracleFunctionsBundle.get("ASIN"), "NUMBER"));
        this.m_singleFuncs.put("ATAN", new FunctionDefinition("ATAN", 1, OracleFunctionsBundle.get("ATAN"), "NUMBER"));
        this.m_singleFuncs.put("ATAN2", new FunctionDefinition("ATAN2", 2, OracleFunctionsBundle.get("ATAN2"), "NUMBER"));
        this.m_singleFuncs.put("BITAND", new FunctionDefinition("BITAND", 2, OracleFunctionsBundle.get("BITAND"), "NUMBER"));
        this.m_singleFuncs.put("CEIL", new FunctionDefinition("CEIL", 1, OracleFunctionsBundle.get("CEIL"), "NUMBER"));
        this.m_singleFuncs.put("COS", new FunctionDefinition("COS", 1, OracleFunctionsBundle.get("COS"), "NUMBER"));
        this.m_singleFuncs.put("COSH", new FunctionDefinition("COSH", 1, OracleFunctionsBundle.get("COSH"), "NUMBER"));
        this.m_singleFuncs.put("EXP", new FunctionDefinition("EXP", 1, OracleFunctionsBundle.get("EXP"), "NUMBER"));
        this.m_singleFuncs.put("FLOOR", new FunctionDefinition("FLOOR", 1, OracleFunctionsBundle.get("FLOOR"), "NUMBER"));
        this.m_singleFuncs.put("LN", new FunctionDefinition("LN", 1, OracleFunctionsBundle.get("LN"), "NUMBER"));
        this.m_singleFuncs.put("LOG", new FunctionDefinition("LOG", 2, OracleFunctionsBundle.get("LOG"), "NUMBER"));
        this.m_singleFuncs.put("MOD", new FunctionDefinition("MOD", 2, OracleFunctionsBundle.get("MOD"), "NUMBER"));
        this.m_singleFuncs.put("NANVL", new FunctionDefinition("NANVL", 2, OracleFunctionsBundle.get("NANVL"), "NUMBER"));
        this.m_singleFuncs.put("POWER", new FunctionDefinition("POWER", 2, OracleFunctionsBundle.get("POWER"), "NUMBER"));
        this.m_singleFuncs.put("REMAINDER", new FunctionDefinition("REMAINDER", 2, OracleFunctionsBundle.get("REMAINDER"), "NUMBER"));
        this.m_singleFuncs.put("ROUND", new FunctionDefinition("ROUND", 1, 2, OracleFunctionsBundle.get("ROUND"), "NUMBER"));
        this.m_singleFuncs.put("SIGN", new FunctionDefinition("SIGN", 1, OracleFunctionsBundle.get("SIGN"), "NUMBER"));
        this.m_singleFuncs.put("SIN", new FunctionDefinition("SIN", 1, OracleFunctionsBundle.get("SIN"), "NUMBER"));
        this.m_singleFuncs.put("SINH", new FunctionDefinition("SINH", 1, OracleFunctionsBundle.get("SINH"), "NUMBER"));
        this.m_singleFuncs.put("SQRT", new FunctionDefinition("SQRT", 1, OracleFunctionsBundle.get("SQRT"), "NUMBER"));
        this.m_singleFuncs.put("TAN", new FunctionDefinition("TAN", 1, OracleFunctionsBundle.get("TAN"), "NUMBER"));
        this.m_singleFuncs.put("TANH", new FunctionDefinition("TANH", 1, OracleFunctionsBundle.get("TANH"), "NUMBER"));
        this.m_singleFuncs.put("TRUNC", new FunctionDefinition("TRUNC", 1, 2, OracleFunctionsBundle.get("TRUNC"), "NUMBER"));
        this.m_singleFuncs.put("WIDTH_BUCKET", new FunctionDefinition("WIDTH_BUCKET", 4, OracleFunctionsBundle.get("WIDTH_BUCKET"), "NUMBER"));
        this.m_singleFuncs.put("CHR", new FunctionDefinition("CHR", 1, OracleFunctionsBundle.get("CHR"), "VARCHAR2"));
        this.m_singleFuncs.put("CONCAT", new FunctionDefinition("CONCAT", 2, OracleFunctionsBundle.get("CONCAT"), "VARCHAR2"));
        this.m_singleFuncs.put("INITCAP", new FunctionDefinition("INITCAP", 1, OracleFunctionsBundle.get("INITCAP"), "VARCHAR2"));
        this.m_singleFuncs.put("LOWER", new FunctionDefinition("LOWER", 1, OracleFunctionsBundle.get("LOWER"), "VARCHAR2"));
        this.m_singleFuncs.put("LPAD", new FunctionDefinition("LPAD", 2, 3, OracleFunctionsBundle.get("LPAD"), "VARCHAR2"));
        this.m_singleFuncs.put("LTRIM", new FunctionDefinition("LTRIM", 1, 2, OracleFunctionsBundle.get("LTRIM"), "VARCHAR2"));
        this.m_singleFuncs.put("NCHR", new FunctionDefinition("NCHR", 1, OracleFunctionsBundle.get("NCHR"), "VARCHAR2"));
        this.m_singleFuncs.put("NLS_INITCAP", new FunctionDefinition("NLS_INITCAP", 1, 2, OracleFunctionsBundle.get("NLS_INITCAP"), "VARCHAR2"));
        this.m_singleFuncs.put("NLS_LOWER", new FunctionDefinition("NLS_LOWER", 1, 2, OracleFunctionsBundle.get("NLS_LOWER"), "VARCHAR2"));
        this.m_singleFuncs.put("NLSSORT", new FunctionDefinition("NLSSORT", 1, 2, OracleFunctionsBundle.get("NLSSORT"), "VARCHAR2"));
        this.m_singleFuncs.put("NLS_UPPER", new FunctionDefinition("NLS_UPPER", 1, 2, OracleFunctionsBundle.get("NLS_UPPER"), "VARCHAR2"));
        this.m_singleFuncs.put("REGEXP_REPLACE", new FunctionDefinition("REGEXP_REPLACE", 2, 6, OracleFunctionsBundle.get("REGEXP_REPLACE"), "VARCHAR2"));
        this.m_singleFuncs.put("REGEXP_SUBSTR", new FunctionDefinition("REGEXP_SUBSTR", 2, 6, OracleFunctionsBundle.get("REGEXP_SUBSTR"), "VARCHAR2"));
        this.m_singleFuncs.put("REPLACE", new FunctionDefinition("REPLACE", 2, 3, OracleFunctionsBundle.get("REPLACE"), "VARCHAR2"));
        this.m_singleFuncs.put("RPAD", new FunctionDefinition("RPAD", 2, 3, OracleFunctionsBundle.get("RPAD"), "VARCHAR2"));
        this.m_singleFuncs.put("RTRIM", new FunctionDefinition("RTRIM", 1, 2, OracleFunctionsBundle.get("RTRIM"), "VARCHAR2"));
        this.m_singleFuncs.put("SOUNDEX", new FunctionDefinition("SOUNDEX", 1, OracleFunctionsBundle.get("SOUNDEX"), "VARCHAR2"));
        this.m_singleFuncs.put("SUBSTR", new FunctionDefinition("SUBSTR", 2, 3, OracleFunctionsBundle.get("SUBSTR"), "VARCHAR2"));
        this.m_singleFuncs.put("SUBSTRB", new FunctionDefinition("SUBSTRB", 2, 3, OracleFunctionsBundle.get("SUBSTRB"), "VARCHAR2"));
        this.m_singleFuncs.put("SUBSTRC", new FunctionDefinition("SUBSTRC", 2, 3, OracleFunctionsBundle.get("SUBSTRC"), "VARCHAR2"));
        this.m_singleFuncs.put("SUBSTR2", new FunctionDefinition("SUBSTR2", 2, 3, OracleFunctionsBundle.get("SUBSTR2"), "VARCHAR2"));
        this.m_singleFuncs.put("SUBSTR4", new FunctionDefinition("SUBSTR4", 2, 3, OracleFunctionsBundle.get("SUBSTR4"), "VARCHAR2"));
        this.m_singleFuncs.put("TRANSLATE", new FunctionDefinition("TRANSLATE", 1, 3, OracleFunctionsBundle.get("TRANSLATE"), "VARCHAR2"));
        this.m_singleFuncs.put("TREAT", new FunctionDefinition("TREAT", 2, 3, OracleFunctionsBundle.get("TREAT"), "VARCHAR2"));
        this.m_singleFuncs.put("TRIM", new FunctionDefinition("TRIM", 1, 2, OracleFunctionsBundle.get("TRIM"), "VARCHAR2"));
        this.m_singleFuncs.put("UPPER", new FunctionDefinition("UPPER", 1, OracleFunctionsBundle.get("UPPER"), "VARCHAR2"));
        this.m_singleFuncs.put("ASCII", new FunctionDefinition("ASCII", 1, OracleFunctionsBundle.get("ASCII"), "NUMBER"));
        this.m_singleFuncs.put("INSTR", new FunctionDefinition("INSTR", 2, 4, OracleFunctionsBundle.get("INSTR"), "NUMBER"));
        this.m_singleFuncs.put("INSTRB", new FunctionDefinition("INSTRB", 2, 4, OracleFunctionsBundle.get("INSTRB"), "NUMBER"));
        this.m_singleFuncs.put("INSTRC", new FunctionDefinition("INSTRC", 2, 4, OracleFunctionsBundle.get("INSTRC"), "NUMBER"));
        this.m_singleFuncs.put("INSTR2", new FunctionDefinition("INSTR2", 2, 4, OracleFunctionsBundle.get("INSTR2"), "NUMBER"));
        this.m_singleFuncs.put("INSTR4", new FunctionDefinition("INSTR4", 2, 4, OracleFunctionsBundle.get("INSTR4"), "NUMBER"));
        this.m_singleFuncs.put("LENGTH", new FunctionDefinition("LENGTH", 1, OracleFunctionsBundle.get("LENGTH"), "NUMBER"));
        this.m_singleFuncs.put("LENGTHB", new FunctionDefinition("LENGTHB", 1, OracleFunctionsBundle.get("LENGTHB"), "NUMBER"));
        this.m_singleFuncs.put("LENGTHC", new FunctionDefinition("LENGTHC", 1, OracleFunctionsBundle.get("LENGTHC"), "NUMBER"));
        this.m_singleFuncs.put("LENGTH2", new FunctionDefinition("LENGTH2", 1, OracleFunctionsBundle.get("LENGTH2"), "NUMBER"));
        this.m_singleFuncs.put("LENGTH4", new FunctionDefinition("LENGTH4", 1, OracleFunctionsBundle.get("LENGTH4"), "NUMBER"));
        this.m_singleFuncs.put("REGEXP_INSTR", new FunctionDefinition("REGEXP_INSTR", 2, 7, OracleFunctionsBundle.get("REGEXP_INSTR"), "NUMBER"));
        this.m_singleFuncs.put("REGEXP_COUNT", new FunctionDefinition("REGEXP_COUNT", 2, 4, OracleFunctionsBundle.get("REGEXP_COUNT"), "NUMBER"));
        this.m_singleFuncs.put("ADD_MONTHS", new FunctionDefinition("ADD_MONTHS", 2, OracleFunctionsBundle.get("ADD_MONTHS"), "DATE"));
        this.m_singleFuncs.put("CURRENT_DATE", new FunctionDefinition("CURRENT_DATE", 0, OracleFunctionsBundle.get("CURRENT_DATE"), "DATE"));
        this.m_singleFuncs.put("CURRENT_TIMESTAMP", new FunctionDefinition("CURRENT_TIMESTAMP", 0, 1, OracleFunctionsBundle.get("CURRENT_TIMESTAMP"), "DATE"));
        this.m_singleFuncs.put("DBTIMEZONE", new FunctionDefinition("DBTIMEZONE", 0, OracleFunctionsBundle.get("DBTIMEZONE"), "DATE"));
        this.m_singleFuncs.put("FROM_TZ", new FunctionDefinition("FROM_TZ", 2, OracleFunctionsBundle.get("FROM_TZ"), "DATE"));
        this.m_singleFuncs.put("LAST_DAY", new FunctionDefinition("LAST_DAY", 1, OracleFunctionsBundle.get("LAST_DAY"), "DATE"));
        this.m_singleFuncs.put("LOCALTIMESTAMP", new FunctionDefinition("LOCALTIMESTAMP", 0, 1, OracleFunctionsBundle.get("LOCALTIMESTAMP"), "DATE"));
        this.m_singleFuncs.put("MONTHS_BETWEEN", new FunctionDefinition("MONTHS_BETWEEN", 2, OracleFunctionsBundle.get("MONTHS_BETWEEN"), "DATE"));
        this.m_singleFuncs.put("NEW_TIME", new FunctionDefinition("NEW_TIME", 3, OracleFunctionsBundle.get("NEW_TIME"), "DATE"));
        this.m_singleFuncs.put("NEXT_DAY", new FunctionDefinition("NEXT_DAY", 2, OracleFunctionsBundle.get("NEXT_DAY"), "DATE"));
        this.m_singleFuncs.put("SESSIONTIMEZONE", new FunctionDefinition("SESSIONTIMEZONE", 0, OracleFunctionsBundle.get("SESSIONTIMEZONE"), "DATE"));
        this.m_singleFuncs.put("SYS_EXTRACT_UTC", new FunctionDefinition("SYS_EXTRACT_UTC", 1, OracleFunctionsBundle.get("SYS_EXTRACT_UTC"), "DATE"));
        this.m_singleFuncs.put("SYSDATE", new FunctionDefinition("SYSDATE", 0, OracleFunctionsBundle.get("SYSDATE"), "DATE"));
        this.m_singleFuncs.put("SYSTIMESTAMP", new FunctionDefinition("SYSTIMESTAMP", 0, OracleFunctionsBundle.get("SYSTIMESTAMP"), "DATE"));
        this.m_singleFuncs.put("TZ_OFFSET", new FunctionDefinition("TZ_OFFSET", 1, OracleFunctionsBundle.get("TZ_OFFSET"), "DATE"));
        this.m_singleFuncs.put("ASCIISTR", new FunctionDefinition("ASCIISTR", 1, OracleFunctionsBundle.get("ASCIISTR"), "VARCHAR2"));
        this.m_singleFuncs.put("BIN_TO_NUM", new FunctionDefinition("BIN_TO_NUM", 1, OracleFunctionsBundle.get("BIN_TO_NUM"), "NUMBER"));
        this.m_singleFuncs.put("CAST", new FunctionDefinition("CAST", 1, OracleFunctionsBundle.get("CAST"), null));
        this.m_singleFuncs.put("CHARTOROWID", new FunctionDefinition("CHARTOROWID", 1, OracleFunctionsBundle.get("CHARTOROWID"), "VARCHAR2"));
        this.m_singleFuncs.put("COMPOSE", new FunctionDefinition("COMPOSE", 1, OracleFunctionsBundle.get("COMPOSE"), "VARCHAR2"));
        this.m_singleFuncs.put("CONVERT", new FunctionDefinition("CONVERT", 2, 3, OracleFunctionsBundle.get("CONVERT"), "VARCHAR2"));
        this.m_singleFuncs.put("DECOMPOSE", new FunctionDefinition("DECOMPOSE", 1, OracleFunctionsBundle.get("DECOMPOSE"), "VARCHAR2"));
        this.m_singleFuncs.put("HEXTORAW", new FunctionDefinition("HEXTORAW", 1, OracleFunctionsBundle.get("HEXTORAW"), "RAW"));
        this.m_singleFuncs.put("NUMTODSINTERVAL", new FunctionDefinition("NUMTODSINTERVAL", 2, OracleFunctionsBundle.get("NUMTODSINTERVAL"), "DATE"));
        this.m_singleFuncs.put("NUMTOYMINTERVAL", new FunctionDefinition("NUMTOYMINTERVAL", 2, OracleFunctionsBundle.get("NUMTOYMINTERVAL"), "DATE"));
        this.m_singleFuncs.put("RAWTOHEX", new FunctionDefinition("RAWTOHEX", 1, OracleFunctionsBundle.get("RAWTOHEX"), "VARCHAR2"));
        this.m_singleFuncs.put("RAWTONHEX", new FunctionDefinition("RAWTONHEX", 1, OracleFunctionsBundle.get("RAWTONHEX"), "VARCHAR2"));
        this.m_singleFuncs.put("ROWIDTOCHAR", new FunctionDefinition("ROWIDTOCHAR", 1, OracleFunctionsBundle.get("ROWIDTOCHAR"), "VARCHAR2"));
        this.m_singleFuncs.put("ROWIDTONCHAR", new FunctionDefinition("ROWIDTONCHAR", 1, OracleFunctionsBundle.get("ROWIDTONCHAR"), "VARCHAR2"));
        this.m_singleFuncs.put("SCN_TO_TIMESTAMP", new FunctionDefinition("SCN_TO_TIMESTAMP", 1, OracleFunctionsBundle.get("SCN_TO_TIMESTAMP"), "DATE"));
        this.m_singleFuncs.put("TIMESTAMP_TO_SCN", new FunctionDefinition("TIMESTAMP_TO_SCN", 1, OracleFunctionsBundle.get("TIMESTAMP_TO_SCN"), "NUMBER"));
        this.m_singleFuncs.put("TO_BINARY_DOUBLE", new FunctionDefinition("TO_BINARY_DOUBLE", 1, 3, OracleFunctionsBundle.get("TO_BINARY_DOUBLE"), "NUMBER"));
        this.m_singleFuncs.put("TO_BINARY_FLOAT", new FunctionDefinition("TO_BINARY_FLOAT", 1, 3, OracleFunctionsBundle.get("TO_BINARY_FLOAT"), "NUMBER"));
        this.m_singleFuncs.put("TO_CHAR", new FunctionDefinition("TO_CHAR", 1, 3, OracleFunctionsBundle.get("TO_CHAR"), "VARCHAR2"));
        this.m_singleFuncs.put("TO_CLOB", new FunctionDefinition("TO_CLOB", 1, OracleFunctionsBundle.get("TO_CLOB"), "CLOB"));
        this.m_singleFuncs.put("TO_DATE", new FunctionDefinition("TO_DATE", 1, 3, OracleFunctionsBundle.get("TO_DATE"), "DATE"));
        this.m_singleFuncs.put("TO_DSINTERVAL", new FunctionDefinition("TO_DSINTERVAL", 1, 2, OracleFunctionsBundle.get("TO_DSINTERVAL"), "DATE"));
        this.m_singleFuncs.put("TO_LOB", new FunctionDefinition("TO_LOB", 1, OracleFunctionsBundle.get("TO_LOB"), "CLOB"));
        this.m_singleFuncs.put("TO_MULTI_BYTE", new FunctionDefinition("TO_MULTI_BYTE", 1, OracleFunctionsBundle.get("TO_MULTI_BYTE"), "VARCHAR2"));
        this.m_singleFuncs.put("TO_NCHAR", new FunctionDefinition("TO_NCHAR", 1, 3, OracleFunctionsBundle.get("TO_NCHAR"), "DATE"));
        this.m_singleFuncs.put("TO_NCLOB", new FunctionDefinition("TO_NCLOB", 1, OracleFunctionsBundle.get("TO_NCLOB"), "CLOB"));
        this.m_singleFuncs.put("TO_NUMBER", new FunctionDefinition("TO_NUMBER", 1, 3, OracleFunctionsBundle.get("TO_NUMBER"), "NUMBER"));
        this.m_singleFuncs.put("TO_SINGLE_BYTE", new FunctionDefinition("TO_SINGLE_BYTE", 1, OracleFunctionsBundle.get("TO_SINGLE_BYTE"), "VARCHAR2"));
        this.m_singleFuncs.put("TO_TIMESTAMP", new FunctionDefinition("TO_TIMESTAMP", 1, 3, OracleFunctionsBundle.get("TO_TIMESTAMP"), "DATE"));
        this.m_singleFuncs.put("TO_TIMESTAMP_TZ", new FunctionDefinition("TO_TIMESTAMP_TZ", 1, 3, OracleFunctionsBundle.get("TO_TIMESTAMP_TZ"), "DATE"));
        this.m_singleFuncs.put("TO_YMINTERVAL", new FunctionDefinition("TO_YMINTERVAL", 1, OracleFunctionsBundle.get("TO_YMINTERVAL"), "DATE"));
        this.m_singleFuncs.put("UNISTR", new FunctionDefinition("UNISTR", 1, OracleFunctionsBundle.get("UNISTR"), "VARCHAR2"));
        this.m_singleFuncs.put("BFILENAME", new FunctionDefinition("BFILENAME", 2, OracleFunctionsBundle.get("BFILENAME"), "VARCHAR2"));
        this.m_singleFuncs.put("EMPTY_BLOB", new FunctionDefinition("EMPTY_BLOB", 1, OracleFunctionsBundle.get("EMPTY_BLOB"), "BLOB"));
        this.m_singleFuncs.put("EMPTY_CLOB", new FunctionDefinition("EMPTY_CLOB", 1, OracleFunctionsBundle.get("EMPTY_CLOB"), "CLOB"));
        this.m_singleFuncs.put("DEREF", new FunctionDefinition("DEREF", 1, OracleFunctionsBundle.get("DEREF"), "REF"));
        this.m_singleFuncs.put("MAKE_REF", new FunctionDefinition("MAKE_REF", 2, OracleFunctionsBundle.get("MAKE_REF"), "REF"));
        this.m_singleFuncs.put("REF", new FunctionDefinition("REF", 1, OracleFunctionsBundle.get("REF"), "REF"));
        this.m_singleFuncs.put("REFTOHEX", new FunctionDefinition("REFTOHEX", 1, OracleFunctionsBundle.get("REFTOHEX"), "VARCHAR2"));
        this.m_singleFuncs.put("VALUE", new FunctionDefinition("VALUE", 1, OracleFunctionsBundle.get("VALUE"), null));
        this.m_singleFuncs.put("CARDINALITY", new FunctionDefinition("CARDINALITY", 1, OracleFunctionsBundle.get("CARDINALITY")));
        this.m_singleFuncs.put("COLLECT", new FunctionDefinition("COLLECT", 1, OracleFunctionsBundle.get("COLLECT")));
        this.m_singleFuncs.put("POWERMULTISET", new FunctionDefinition("POWERMULTISET", 1, OracleFunctionsBundle.get("POWERMULTISET")));
        this.m_singleFuncs.put("POWERMULTISET_BY_CARDINALITY", new FunctionDefinition("POWERMULTISET_BY_CARDINALITY", 2, OracleFunctionsBundle.get("POWERMULTISET_BY_CARDINALITY")));
        this.m_singleFuncs.put("SET", new FunctionDefinition("SET", 1, OracleFunctionsBundle.get("SET")));
        this.m_singleFuncs.put("SYS_CONNECT_BY_PATH", new FunctionDefinition("SYS_CONNECT_BY_PATH", 2, OracleFunctionsBundle.get("SYS_CONNECT_BY_PATH"), "VARCHAR2"));
        this.m_singleFuncs.put("CLUSTER_ID", new FunctionDefinition("CLUSTER_ID", 1, OracleFunctionsBundle.get("CLUSTER_ID")));
        this.m_singleFuncs.put("CLUSTER_PROBABILITY", new FunctionDefinition("CLUSTER_PROBABILITY", 1, OracleFunctionsBundle.get("CLUSTER_PROBABILITY")));
        this.m_singleFuncs.put("CLUSTER_SET", new FunctionDefinition("CLUSTER_SET", 1, OracleFunctionsBundle.get("CLUSTER_SET")));
        this.m_singleFuncs.put("FEATURE_ID", new FunctionDefinition("FEATURE_ID", 1, OracleFunctionsBundle.get("FEATURE_ID")));
        this.m_singleFuncs.put("FEATURE_SET", new FunctionDefinition("FEATURE_SET", 1, OracleFunctionsBundle.get("FEATURE_SET")));
        this.m_singleFuncs.put("FEATURE_VALUE", new FunctionDefinition("FEATURE_VALUE", 1, OracleFunctionsBundle.get("FEATURE_VALUE")));
        this.m_singleFuncs.put("PREDICTION", new FunctionDefinition("PREDICTION", 1, OracleFunctionsBundle.get("PREDICTION")));
        this.m_singleFuncs.put("PREDICTION_COST", new FunctionDefinition("PREDICTION_COST", 1, OracleFunctionsBundle.get("PREDICTION_COST")));
        this.m_singleFuncs.put("PREDICTION_DETAILS", new FunctionDefinition("PREDICTION_DETAILS", 1, OracleFunctionsBundle.get("PREDICTION_DETAILS")));
        this.m_singleFuncs.put("PREDICTION_PROBABILITY", new FunctionDefinition("PREDICTION_PROBABILITY", 1, OracleFunctionsBundle.get("PREDICTION_PROBABILITY")));
        this.m_singleFuncs.put("PREDICTION_SET", new FunctionDefinition("PREDICTION_SET", 1, OracleFunctionsBundle.get("PREDICTION_SET")));
        this.m_singleFuncs.put("PREDICTION_BOUNDS", new FunctionDefinition("PREDICTION_BOUNDS", 1, OracleFunctionsBundle.get("PREDICTION_BOUNDS")));
        this.m_singleFuncs.put("APPENDCHILDXML", new FunctionDefinition("APPENDCHILDXML", 3, 4, OracleFunctionsBundle.get("APPENDCHILDXML")));
        this.m_singleFuncs.put("DELETEXML", new FunctionDefinition("DELETEXML", 2, 3, OracleFunctionsBundle.get("DELETEXML")));
        this.m_singleFuncs.put("DEPTH", new FunctionDefinition("DEPTH", 1, OracleFunctionsBundle.get("DEPTH")));
        this.m_singleFuncs.put("EXISTSNODE", new FunctionDefinition("EXISTSNODE", 2, 3, OracleFunctionsBundle.get("EXISTSNODE")));
        this.m_singleFuncs.put("EXTRACTVALUE", new FunctionDefinition("EXTRACTVALUE", 2, 3, OracleFunctionsBundle.get("EXTRACTVALUE")));
        this.m_singleFuncs.put("INSERTCHILDXML", new FunctionDefinition("INSERTCHILDXML", 4, 5, OracleFunctionsBundle.get("INSERTCHILDXML")));
        this.m_singleFuncs.put("INSERTXMLBEFORE", new FunctionDefinition("INSERTXMLBEFORE", 3, 4, OracleFunctionsBundle.get("INSERTXMLBEFORE")));
        this.m_singleFuncs.put("PATH", new FunctionDefinition("PATH", 1, OracleFunctionsBundle.get("PATH")));
        this.m_singleFuncs.put("SYS_DBURIGEN", new FunctionDefinition("SYS_DBURIGEN", 1, OracleFunctionsBundle.get("SYS_DBURIGEN")));
        this.m_singleFuncs.put("SYS_XMLAGG", new FunctionDefinition("SYS_XMLAGG", 1, 2, OracleFunctionsBundle.get("SYS_XMLAGG")));
        this.m_singleFuncs.put("SYS_XMLGEN", new FunctionDefinition("SYS_XMLGEN", 1, 2, OracleFunctionsBundle.get("SYS_XMLGEN")));
        this.m_singleFuncs.put("UPDATEXML", new FunctionDefinition("UPDATEXML", 3, OracleFunctionsBundle.get("UPDATEXML")));
        this.m_singleFuncs.put("XMLAGG", new FunctionDefinition("XMLAGG", 1, 2, OracleFunctionsBundle.get("XMLAGG")));
        this.m_singleFuncs.put("XMLCDATA", new FunctionDefinition("XMLCDATA", 1, OracleFunctionsBundle.get("XMLCDATA")));
        this.m_singleFuncs.put("XMLCOLATTVAL", new FunctionDefinition("XMLCOLATTVAL", 1, OracleFunctionsBundle.get("XMLCOLATTVAL")));
        this.m_singleFuncs.put("XMLCOMMENT", new FunctionDefinition("XMLCOMMENT", 1, OracleFunctionsBundle.get("XMLCOMMENT")));
        this.m_singleFuncs.put("XMLCONCAT", new FunctionDefinition("XMLCONCAT", 1, OracleFunctionsBundle.get("XMLCONCAT")));
        this.m_singleFuncs.put("XMLELEMENT", new FunctionDefinition("XMLELEMENT", 1, OracleFunctionsBundle.get("XMLELEMENT")));
        this.m_singleFuncs.put("XMLFOREST", new FunctionDefinition("XMLFOREST", 1, OracleFunctionsBundle.get("XMLFOREST")));
        this.m_singleFuncs.put("XMLPARSE", new FunctionDefinition("XMLPARSE", 1, OracleFunctionsBundle.get("XMLPARSE")));
        this.m_singleFuncs.put("XMLPI", new FunctionDefinition("XMLPI", 1, 2, OracleFunctionsBundle.get("XMLPI")));
        this.m_singleFuncs.put("XMLQUERY", new FunctionDefinition("XMLQUERY", 1, OracleFunctionsBundle.get("XMLQUERY")));
        this.m_singleFuncs.put("XMLROOT", new FunctionDefinition("XMLROOT", 2, 3, OracleFunctionsBundle.get("XMLROOT")));
        this.m_singleFuncs.put("XMLSEQUENCE", new FunctionDefinition("XMLSEQUENCE", 1, 2, OracleFunctionsBundle.get("XMLSEQUENCE")));
        this.m_singleFuncs.put("XMLSERIALIZE", new FunctionDefinition("XMLSERIALIZE", 1, OracleFunctionsBundle.get("XMLSERIALIZE")));
        this.m_singleFuncs.put("XMLTABLE", new FunctionDefinition("XMLTABLE", 1, 2, OracleFunctionsBundle.get("XMLTABLE")));
        this.m_singleFuncs.put("XMLTRANSFORM", new FunctionDefinition("XMLTRANSFORM", 2, OracleFunctionsBundle.get("XMLTRANSFORM")));
        this.m_singleFuncs.put("XMLCAST", new FunctionDefinition("XMLCAST", 1, OracleFunctionsBundle.get("XMLCAST")));
        this.m_singleFuncs.put("XMLDIFF", new FunctionDefinition("XMLDIFF", 2, 4, OracleFunctionsBundle.get("XMLDIFF")));
        this.m_singleFuncs.put("XMLEXISTS", new FunctionDefinition("XMLEXISTS", 1, 2, OracleFunctionsBundle.get("XMLEXISTS")));
        this.m_singleFuncs.put("XMLPATCH", new FunctionDefinition("XMLPATCH", 2, 2, OracleFunctionsBundle.get("XMLPATCH")));
        this.m_singleFuncs.put("DECODE", new FunctionDefinition("DECODE", 3, OracleFunctionsBundle.get("DECODE")));
        this.m_singleFuncs.put("DUMP", new FunctionDefinition("DUMP", 1, 4, OracleFunctionsBundle.get("DUMP")));
        this.m_singleFuncs.put("ORA_HASH", new FunctionDefinition("ORA_HASH", 1, 3, OracleFunctionsBundle.get("ORA_HASH")));
        this.m_singleFuncs.put("VSIZE", new FunctionDefinition("VSIZE", 1, OracleFunctionsBundle.get("VSIZE")));
        this.m_singleFuncs.put("COALESCE", new FunctionDefinition("COALESCE", 1, OracleFunctionsBundle.get("COALESCE")));
        this.m_singleFuncs.put("LNNVL", new FunctionDefinition("LNNVL", 1, OracleFunctionsBundle.get("LNNVL")));
        this.m_singleFuncs.put("NULLIF", new FunctionDefinition("NULLIF", 2, OracleFunctionsBundle.get("NULLIF")));
        this.m_singleFuncs.put("NVL", new FunctionDefinition("NVL", 2, OracleFunctionsBundle.get("NVL")));
        this.m_singleFuncs.put("NVL2", new FunctionDefinition("NVL2", 3, OracleFunctionsBundle.get("NVL2")));
        this.m_singleFuncs.put("SYS_CONTEXT", new FunctionDefinition("SYS_CONTEXT", 2, 3, OracleFunctionsBundle.get("SYS_CONTEXT"), "VARCHAR2"));
        this.m_singleFuncs.put("SYS_GUID", new FunctionDefinition("SYS_GUID", 1, OracleFunctionsBundle.get("SYS_GUID"), "VARCHAR2"));
        this.m_singleFuncs.put("SYS_TYPEID", new FunctionDefinition("SYS_TYPEID", 1, OracleFunctionsBundle.get("SYS_TYPEID"), "NUMBER"));
        this.m_singleFuncs.put("UID", new FunctionDefinition("UID", 0, OracleFunctionsBundle.get("UID"), "NUMBER"));
        this.m_singleFuncs.put("USER", new FunctionDefinition("USER", 0, OracleFunctionsBundle.get("USER"), "VARCHAR2"));
        this.m_singleFuncs.put("USERENV", new FunctionDefinition("USERENV", 1, OracleFunctionsBundle.get("USERENV"), "VARCHAR2"));
        this.m_singleFuncs.put("CV", new FunctionDefinition("CV", 0, 1, OracleFunctionsBundle.get("CV")));
        this.m_singleFuncs.put("ITERATION_NUMBER", new FunctionDefinition("ITERATION_NUMBER", 0, OracleFunctionsBundle.get("ITERATION_NUMBER")));
        this.m_singleFuncs.put("PRESENTNNV", new FunctionDefinition("PRESENTNNV", 3, OracleFunctionsBundle.get("PRESENTNNV")));
        this.m_singleFuncs.put("PRESENTV", new FunctionDefinition("PRESENTV", 3, OracleFunctionsBundle.get("PRESENTV")));
        this.m_singleFuncs.put("PREVIOUS", new FunctionDefinition("PREVIOUS", 1, OracleFunctionsBundle.get("PREVIOUS")));
        this.m_singleFuncs.put("GREATEST", new FunctionDefinition("GREATEST", 1, OracleFunctionsBundle.get("GREATEST")));
        this.m_singleFuncs.put("LEAST", new FunctionDefinition("LEAST", 1, OracleFunctionsBundle.get("LEAST")));
        this.m_singleFuncs.put("NLS_CHARSET_DECL_LEN", new FunctionDefinition("NLS_CHARSET_DECL_LEN", 2, OracleFunctionsBundle.get("NLS_CHARSET_DECL_LEN")));
        this.m_singleFuncs.put("NLS_CHARSET_ID", new FunctionDefinition("NLS_CHARSET_ID", 1, OracleFunctionsBundle.get("NLS_CHARSET_ID")));
        this.m_singleFuncs.put("NLS_CHARSET_NAME", new FunctionDefinition("NLS_CHARSET_NAME", 1, OracleFunctionsBundle.get("NLS_CHARSET_NAME")));
        this.m_singleFuncs.put("CUBE_TABLE", new FunctionDefinition("CUBE_TABLE", 1, OracleFunctionsBundle.get("CUBE_TABLE")));
        this.m_singleFuncs.put("EXTRACT", new FunctionDefinition("EXTRACT", 1, 3, OracleFunctionsBundle.get("EXTRACT")));
        this.m_singleFuncs.put("FIRST_VALUE", new FunctionDefinition("FIRST_VALUE", 1, OracleFunctionsBundle.get("FIRST_VALUE")));
        this.m_singleFuncs.put("LAG", new FunctionDefinition("LAG", 1, 3, OracleFunctionsBundle.get("LAG")));
        this.m_singleFuncs.put("LAST_VALUE", new FunctionDefinition("LAST_VALUE", 1, OracleFunctionsBundle.get("LAST_VALUE")));
        this.m_singleFuncs.put("LEAD", new FunctionDefinition("LEAD", 1, 3, OracleFunctionsBundle.get("LEAD")));
        this.m_singleFuncs.put("NTILE", new FunctionDefinition("NTILE", 1, OracleFunctionsBundle.get("NTILE")));
        this.m_singleFuncs.put("RATIO_TO_REPORT", new FunctionDefinition("RATIO_TO_REPORT", 1, OracleFunctionsBundle.get("RATIO_TO_REPORT")));
        this.m_singleFuncs.put("ROW_NUMBER", new FunctionDefinition("ROW_NUMBER", 1, OracleFunctionsBundle.get("ROW_NUMBER")));
    }

    private void loadGroupingFunctions() {
        this.m_groupFuncs.put("AVG", new FunctionDefinition("AVG", 1, OracleFunctionsBundle.get("AVG"), true));
        this.m_groupFuncs.put("CORR", new FunctionDefinition("CORR", 2, OracleFunctionsBundle.get("CORR"), true));
        this.m_groupFuncs.put("CORR_K", new FunctionDefinition("CORR_K", 2, 3, OracleFunctionsBundle.get("CORR_K"), true));
        this.m_groupFuncs.put("CORR_S", new FunctionDefinition("CORR_S", 2, 3, OracleFunctionsBundle.get("CORR_S"), true));
        this.m_groupFuncs.put("COUNT", new FunctionDefinition("COUNT", 1, OracleFunctionsBundle.get("COUNT"), true));
        this.m_groupFuncs.put("COVAR_POP", new FunctionDefinition("COVAR_POP", 2, OracleFunctionsBundle.get("COVAR_POP"), true));
        this.m_groupFuncs.put("COVAR_SAMP", new FunctionDefinition("COVAR_SAMP", 2, OracleFunctionsBundle.get("COVAR_SAMP"), true));
        this.m_groupFuncs.put("CUME_DIST", new FunctionDefinition("CUME_DIST", 1, OracleFunctionsBundle.get("CUME_DIST"), true));
        this.m_groupFuncs.put("DENSE_RANK", new FunctionDefinition("DENSE_RANK", 1, OracleFunctionsBundle.get("DENSE_RANK"), true));
        this.m_groupFuncs.put("GROUP_ID", new FunctionDefinition("GROUP_ID", 1, OracleFunctionsBundle.get("GROUP_ID"), true));
        this.m_groupFuncs.put("GROUPING", new FunctionDefinition("GROUPING", 1, OracleFunctionsBundle.get("GROUPING"), true));
        this.m_groupFuncs.put("GROUPING_ID", new FunctionDefinition("GROUPING_ID", 1, OracleFunctionsBundle.get("GROUPING_ID"), true));
        this.m_groupFuncs.put("MAX", new FunctionDefinition("MAX", 1, OracleFunctionsBundle.get("MAX"), true));
        this.m_groupFuncs.put("MEDIAN", new FunctionDefinition("MEDIAN", 1, OracleFunctionsBundle.get("MEDIAN"), true));
        this.m_groupFuncs.put("MIN", new FunctionDefinition("MIN", 1, OracleFunctionsBundle.get("MIN"), true));
        this.m_groupFuncs.put("PERCENTILE_CONT", new FunctionDefinition("PERCENTILE_CONT", 1, OracleFunctionsBundle.get("PERCENTILE_CONT"), true));
        this.m_groupFuncs.put("PERCENTILE_DISC", new FunctionDefinition("PERCENTILE_DISC", 1, OracleFunctionsBundle.get("PERCENTILE_DISC"), true));
        this.m_groupFuncs.put("PERCENT_RANK", new FunctionDefinition("PERCENT_RANK", 1, OracleFunctionsBundle.get("PERCENT_RANK"), true));
        this.m_groupFuncs.put("RANK", new FunctionDefinition("RANK", 1, OracleFunctionsBundle.get("RANK"), true));
        this.m_groupFuncs.put("REGR_SLOPE", new FunctionDefinition("REGR_SLOPE", 2, OracleFunctionsBundle.get("REGR_SLOPE"), true));
        this.m_groupFuncs.put("REGR_INTERCEPT", new FunctionDefinition("REGR_INTERCEPT", 2, OracleFunctionsBundle.get("REGR_INTERCEPT"), true));
        this.m_groupFuncs.put("REGR_COUNT", new FunctionDefinition("REGR_COUNT", 2, OracleFunctionsBundle.get("REGR_COUNT"), true));
        this.m_groupFuncs.put("REGR_R2", new FunctionDefinition("REGR_R2", 2, OracleFunctionsBundle.get("REGR_R2"), true));
        this.m_groupFuncs.put("REGR_AVGX", new FunctionDefinition("REGR_AVGX", 2, OracleFunctionsBundle.get("REGR_AVGX"), true));
        this.m_groupFuncs.put("REGR_AVGY", new FunctionDefinition("REGR_AVGY", 2, OracleFunctionsBundle.get("REGR_AVGY"), true));
        this.m_groupFuncs.put("REGR_SXX", new FunctionDefinition("REGR_SXX", 2, OracleFunctionsBundle.get("REGR_SXX"), true));
        this.m_groupFuncs.put("REGR_SYY", new FunctionDefinition("REGR_SYY", 2, OracleFunctionsBundle.get("REGR_SYY"), true));
        this.m_groupFuncs.put("REGR_SXY", new FunctionDefinition("REGR_SXY", 2, OracleFunctionsBundle.get("REGR_SXY"), true));
        this.m_groupFuncs.put("STATS_BINOMIAL_TEST", new FunctionDefinition("STATS_BINOMIAL_TEST", 3, 4, OracleFunctionsBundle.get("STATS_BINOMIAL_TEST"), true));
        this.m_groupFuncs.put("STATS_CROSSTAB", new FunctionDefinition("STATS_CROSSTAB", 2, 3, OracleFunctionsBundle.get("STATS_CROSSTAB"), true));
        this.m_groupFuncs.put("STATS_F_TEST", new FunctionDefinition("STATS_F_TEST", 2, 3, OracleFunctionsBundle.get("STATS_F_TEST"), true));
        this.m_groupFuncs.put("STATS_KS_TEST", new FunctionDefinition("STATS_KS_TEST", 2, 3, OracleFunctionsBundle.get("STATS_KS_TEST"), true));
        this.m_groupFuncs.put("STATS_MODE", new FunctionDefinition("STATS_MODE", 1, OracleFunctionsBundle.get("STATS_MODE"), true));
        this.m_groupFuncs.put("STATS_MW_TEST", new FunctionDefinition("STATS_MW_TEST", 2, 3, OracleFunctionsBundle.get("STATS_MW_TEST"), true));
        this.m_groupFuncs.put("STATS_ONE_WAY_ANOVA", new FunctionDefinition("STATS_ONE_WAY_ANOVA", 2, 3, OracleFunctionsBundle.get("STATS_ONE_WAY_ANOVA"), true));
        this.m_groupFuncs.put("STATS_T_TEST_ONE", new FunctionDefinition("STATS_T_TEST_ONE", 2, 3, OracleFunctionsBundle.get("STATS_T_TEST_ONE"), true));
        this.m_groupFuncs.put("STATS_T_TEST_PAIRED", new FunctionDefinition("STATS_T_TEST_PAIRED", 2, 3, OracleFunctionsBundle.get("STATS_T_TEST_PAIRED"), true));
        this.m_groupFuncs.put("STATS_T_TEST_INDEP", new FunctionDefinition("STATS_T_TEST_INDEP", 2, 3, OracleFunctionsBundle.get("STATS_T_TEST_INDEP"), true));
        this.m_groupFuncs.put("STATS_T_TEST_INDEPU", new FunctionDefinition("STATS_T_TEST_INDEPU", 2, 3, OracleFunctionsBundle.get("STATS_T_TEST_INDEPU"), true));
        this.m_groupFuncs.put("STATS_WSR_TEST", new FunctionDefinition("STATS_WSR_TEST", 2, 3, OracleFunctionsBundle.get("STATS_WSR_TEST"), true));
        this.m_groupFuncs.put("STDDEV", new FunctionDefinition("STDDEV", 1, OracleFunctionsBundle.get("STDDEV"), true));
        this.m_groupFuncs.put("STDDEV_POP", new FunctionDefinition("STDDEV_POP", 1, OracleFunctionsBundle.get("STDDEV_POP"), true));
        this.m_groupFuncs.put("STDDEV_SAMP", new FunctionDefinition("STDDEV_SAMP", 1, OracleFunctionsBundle.get("STDDEV_SAMP"), true));
        this.m_groupFuncs.put("SUM", new FunctionDefinition("SUM", 1, OracleFunctionsBundle.get("SUM"), true));
        this.m_groupFuncs.put("VAR_POP", new FunctionDefinition("VAR_POP", 1, OracleFunctionsBundle.get("VAR_POP"), true));
        this.m_groupFuncs.put("VAR_SAMP", new FunctionDefinition("VAR_SAMP", 1, OracleFunctionsBundle.get("VAR_SAMP"), true));
        this.m_groupFuncs.put("VARIANCE", new FunctionDefinition("VARIANCE", 1, OracleFunctionsBundle.get("VARIANCE"), true));
        this.m_groupFuncs.put("FIRST", new FunctionDefinition("FIRST", 0, OracleFunctionsBundle.get("FIRST"), true));
        this.m_groupFuncs.put("LAST", new FunctionDefinition("LAST", 0, OracleFunctionsBundle.get("LAST"), true));
    }

    public Collection getSingleFunctions() {
        return this.m_singleFuncs.values();
    }

    public Collection getGroupFunctions() {
        return this.m_groupFuncs.values();
    }

    public Collection getAllFunctions() {
        TreeSet retval = new TreeSet();
        retval.addAll(this.getSingleFunctions());
        retval.addAll(this.getGroupFunctions());
        return retval;
    }

    public FunctionDefinition getFunction(String key) {
        if (this.m_singleFuncs.containsKey(key)) {
            return (FunctionDefinition)this.m_singleFuncs.get(key);
        }
        if (this.m_groupFuncs.containsKey(key)) {
            return (FunctionDefinition)this.m_groupFuncs.get(key);
        }
        return null;
    }

    public boolean isGroupingFunction(String func) {
        return this.m_groupFuncs.containsKey(func);
    }

    public DataType getDataType(String func, DBObjectProvider pro) {
        FunctionDefinition fd = this.getFunction(func);
        if (fd != null && fd.getReturnType() != null && pro != null) {
            return pro.getOrCreateDataType(fd.getReturnType());
        }
        return null;
    }
}

