/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.UnsupportedEncodingException;
import java.lang.constant.Constable;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.i18n.util.OraSQLUtil;
import oracle.javatools.db.BaseDatabaseDescriptor;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.extension.DelegateDDLGenerator;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.javatools.db.ora.Oracle10gR2XE;
import oracle.javatools.db.ora.Oracle11g;
import oracle.javatools.db.ora.Oracle11gR2;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.ora.Oracle8i;
import oracle.javatools.db.ora.Oracle9i;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleLite10gR3;
import oracle.javatools.db.ora.OracleSQLQueryBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.ddl.OracleDDLGenerator;
import oracle.javatools.db.ora.validators.DatabaseLinkValidator;
import oracle.javatools.db.ora.validators.DirectoryValidator;
import oracle.javatools.db.ora.validators.ExternalTablePropsValidator;
import oracle.javatools.db.ora.validators.IOTPropertiesValidator;
import oracle.javatools.db.ora.validators.IndexPartitionValidator;
import oracle.javatools.db.ora.validators.IndexPartitionsValidator;
import oracle.javatools.db.ora.validators.LOBDescriptorValidator;
import oracle.javatools.db.ora.validators.MaterializedViewLogValidator;
import oracle.javatools.db.ora.validators.MaterializedViewValidator;
import oracle.javatools.db.ora.validators.OracleColumnValidator;
import oracle.javatools.db.ora.validators.OracleConstraintValidator;
import oracle.javatools.db.ora.validators.OracleIndexValidator;
import oracle.javatools.db.ora.validators.OracleTableValidator;
import oracle.javatools.db.ora.validators.OracleTablespacePropertiesValidator;
import oracle.javatools.db.ora.validators.StoragePropertiesValidator;
import oracle.javatools.db.ora.validators.TablePartitionValidator;
import oracle.javatools.db.ora.validators.TablePartitionsValidator;
import oracle.javatools.db.ora.validators.XMLTypeColumnPropertiesValidator;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInitializer;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.validators.FileSpecificationValidator;
import oracle.javatools.db.validators.ObjectTypeValidator;
import oracle.javatools.db.validators.PackageValidator;
import oracle.javatools.db.validators.PlSqlValidator;
import oracle.javatools.db.validators.SequenceValidator;
import oracle.javatools.db.validators.SynonymValidator;
import oracle.javatools.db.validators.TablespaceValidator;
import oracle.javatools.db.validators.TriggerValidator;
import oracle.javatools.db.validators.ViewValidator;
import oracle.javatools.db.validators.XMLSchemaValidator;
import oracle.javatools.util.ModelUtil;
import oracle.sql.CharacterSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabaseDescriptor<T extends OracleDatabase>
extends BaseDatabaseDescriptor<T> {
    public static final String FEATURE_ORACLE_EXTERNAL_TABLE_PROJECT_COLUMN = "ORACLE_EXTERNAL_TABLE_PROJECT_COLUMN";
    public static final char QUOTE_IDENTIFIER = '\"';
    private static final int MAX_NAME_LEN = 30;
    private static final int MAX_DATABASE_LINK_NAME_LEN = 128;
    private static final int MAX_JAVA_NAME_LEN = 4000;
    private static final char PERIOD = '.';
    private static final String ALLOWED_CHARS = "_$#";
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "DUAL", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MLSLABEL", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"));
    private static final Map<Class<? extends OracleDatabase>, Integer> s_versions = new TreeMap<Class<OracleDatabase>, Integer>(new Comparator<Class<? extends OracleDatabase>>(){

        @Override
        public int compare(Class<? extends OracleDatabase> c1, Class<? extends OracleDatabase> c2) {
            int retval = c1.equals(c2) ? 0 : (c1.isAssignableFrom(c2) ? -1 : (c2.isAssignableFrom(c1) ? 1 : c1.getSimpleName().compareTo(c2.getSimpleName())));
            return retval;
        }
    });
    private CharacterSet m_dbCharset;
    private String m_dbCharsetName;
    private Database m_database;

    public OracleDatabaseDescriptor(Class<? extends T> databaseClass) {
        super(databaseClass);
    }

    public OracleDatabaseDescriptor(T database, String charsetName, CharacterSet charset) {
        this(database.getClass());
        this.m_database = database;
        this.m_dbCharsetName = charsetName;
        this.m_dbCharset = charset;
    }

    private String getDatabaseCharsetName() {
        if (this.m_dbCharsetName == null && this.m_database instanceof OracleDatabase) {
            this.m_dbCharsetName = ((OracleDatabase)this.m_database).getSessionParameterValue("NLS_CHARACTERSET");
        }
        return this.m_dbCharsetName;
    }

    private CharacterSet getDatabaseCharset() {
        if (this.m_dbCharset == null && this.m_database instanceof OracleDatabase) {
            int charsetID = Integer.valueOf(((OracleDatabase)this.m_database).getSessionParameterValue("NLS_CHARSET_ID"));
            this.m_dbCharset = CharacterSet.make((int)charsetID);
        }
        return this.m_dbCharset;
    }

    public String getDatabaseType() {
        Class clz = this.getDatabaseClass();
        if (OracleLite.class.isAssignableFrom(clz)) {
            return "Oracle Lite";
        }
        return "Oracle Database";
    }

    public int getDatabaseVersion() {
        int retval = -1;
        Class clz = this.getDatabaseClass();
        retval = OracleDatabaseDescriptor.getDatabaseVersion(clz);
        return retval;
    }

    public int getCasePolicy() {
        return 2;
    }

    public boolean supportsFeature(String feature) {
        Class dbClz = this.getDatabaseClass();
        return "LOB PARAMETERS".equals(feature) || "STORAGE OPTIONS".equals(feature) || "COLUMN SEQUENCES".equals(feature) || "TABLE PARTITIONING".equals(feature) && Oracle8.class.isAssignableFrom(dbClz) && !Oracle10gR2XE.class.isAssignableFrom(dbClz) && this.isPartitioningEnabled() || "GLOBAL HASH INDEX PARTITIONING".equals(feature) && Oracle10g.class.isAssignableFrom(dbClz) && !Oracle10gR2XE.class.isAssignableFrom(dbClz) && this.isPartitioningEnabled() || "BITMAP INDEXING".equals(feature) && !Oracle10gR2XE.class.isAssignableFrom(dbClz) || FEATURE_ORACLE_EXTERNAL_TABLE_PROJECT_COLUMN.equals(feature) && Oracle10g.class.isAssignableFrom(dbClz) || "FREEPOOLS".equals(feature) && Oracle9i.class.isAssignableFrom(dbClz) || "RETENTION".equals(feature) && Oracle9i.class.isAssignableFrom(dbClz) || "MAXTRANS".equals(feature) && Oracle8.class.isAssignableFrom(dbClz) && !Oracle10g.class.isAssignableFrom(dbClz) || "XMLTYPE COLUMN STORAGE PROPERTIES".equals(feature) && Oracle11g.class.isAssignableFrom(dbClz);
    }

    public void validateEncoding(String string, Object property) throws ValidationException {
        if (this.getDatabaseCharset() != null) {
            try {
                this.getDatabaseCharset().convert(string);
            }
            catch (SQLException sqe) {
                throw new ValidationException(null, DBArb.format((int)79, (Object)string, (Object)this.getDatabaseCharsetName()));
            }
        }
    }

    public String getIdentifierQuoteString() {
        return "\"";
    }

    public int getMaxNameLength(String type) {
        return OracleDatabaseDescriptor.getMaxIndentifierLength(type);
    }

    public void validateName(String type, String externalName) throws InvalidNameException {
        OracleDatabaseDescriptor.validateIdentifier(type, externalName);
        if (ModelUtil.hasLength((String)this.getDatabaseCharsetName())) {
            try {
                if (!OraSQLUtil.isValidIdentifier((String)externalName, (String)this.getDatabaseCharsetName())) {
                    throw new InvalidNameException(null, DBArb.format((int)11, (Object)externalName, (Object)this.getDatabaseCharsetName()));
                }
            }
            catch (UnsupportedEncodingException e) {
                DBLog.getLogger().log(Level.WARNING, e.getMessage());
            }
            String internalName = this.getInternalName(externalName, type);
            if (this.getDatabaseCharset().encodedByteLength(internalName) > this.getMaxNameLength(type)) {
                throw new InvalidNameException(null, DBArb.format((int)6, (Object)externalName));
            }
        } else if (this.getIdeCharset() != null) {
            try {
                if (!this.canEncode(externalName)) {
                    throw new InvalidNameException(null, DBArb.format((int)11, (Object)externalName, (Object)this.getIdeCharset().name()));
                }
                String internalName = this.getInternalName(externalName, type);
                byte[] bytes = internalName.getBytes(this.getIdeCharset().name());
                if (bytes.length > this.getMaxNameLength(type)) {
                    throw new InvalidNameException(null, DBArb.format((int)6, (Object)externalName));
                }
            }
            catch (UnsupportedEncodingException e) {
                String m = e.getMessage();
            }
        }
    }

    public String getExternalName(String name, String objectType) {
        if (ModelUtil.hasLength((String)name) && "DATABASE LINK".equals(objectType)) {
            boolean isQuotedName;
            String externalName = "";
            int length = name.length();
            boolean bl = isQuotedName = name.charAt(0) == '\"' && name.indexOf(34, 1) == length - 1;
            if (isQuotedName) {
                return name;
            }
            int searchFor = name.charAt(0) == '\"' ? 34 : 46;
            int startIdx = 0;
            while (startIdx < length) {
                int srchIdx = startIdx + (searchFor == 34 ? 1 : 0);
                int endIdx = name.indexOf(searchFor, srchIdx);
                int n = endIdx > -1 ? endIdx + (searchFor == 34 ? 1 : 0) : (endIdx = length);
                if (startIdx == endIdx) {
                    return name;
                }
                String component = name.substring(startIdx, endIdx);
                externalName = externalName + (this.isValidName("DATABASE LINK", component) ? component : '\"' + component + '\"');
                startIdx = endIdx + 1;
                if (startIdx == length) {
                    return name;
                }
                if (startIdx >= length) continue;
                externalName = externalName + '.';
                searchFor = name.charAt(startIdx) == '\"' ? 34 : 46;
            }
            return this.isValidName("DATABASE LINK", externalName) ? externalName : name;
        }
        return super.getExternalName(name, objectType);
    }

    public String getInternalName(String name, String objectType) {
        if (ModelUtil.hasLength((String)name) && "DATABASE LINK".equals(objectType)) {
            return name.toUpperCase().replaceAll(String.valueOf('\"'), "");
        }
        if (ModelUtil.hasLength((String)name) && "XML SCHEMA".equals(objectType)) {
            return name;
        }
        return super.getInternalName(name, objectType);
    }

    private static void validateIdentifier(String type, String identifier) throws InvalidNameException {
        String string = identifier = identifier == null ? "" : identifier.trim();
        if ("DATABASE LINK".equals(type)) {
            OracleDatabaseDescriptor.validateDbLinkName(identifier);
        } else if (!"XML SCHEMA".equals(type)) {
            OracleDatabaseDescriptor.validateIdentifier((String)identifier, (char)'\"', (int)OracleDatabaseDescriptor.getMaxIndentifierLength(type), (String)("FILE_SPECIFICATION".equals(type) ? "._$#" : ALLOWED_CHARS), (String)String.valueOf('\"'), (boolean)true, (Set)RESERVED_WORDS, (int)2);
        }
    }

    public static boolean isValidOracleIdentifier(String name) {
        try {
            OracleDatabaseDescriptor.validateIdentifier(null, name);
        }
        catch (InvalidNameException ine) {
            return false;
        }
        return true;
    }

    public static int getMaxIndentifierLength(String type) {
        return "DATABASE LINK".equals(type) ? 128 : ("JAVA CLASS".equals(type) || "JAVA SOURCE".equals(type) || "JAVA RESOURCE".equals(type) || "XML SCHEMA".equals(type) ? 4000 : 30);
    }

    private static void validateDbLinkName(String identifier) throws InvalidNameException {
        boolean isQuotedName;
        String link = identifier.replaceAll("\"", "");
        if (link.length() < 1) {
            throw new InvalidNameException(null, DBArb.getString((int)5));
        }
        if (link.length() > 128) {
            throw new InvalidNameException(null, DBArb.format((int)6, (Object)identifier));
        }
        int length = identifier.length();
        boolean bl = isQuotedName = identifier.charAt(0) == '\"' && identifier.indexOf(34, 1) == length - 1;
        if (isQuotedName) {
            identifier = identifier.substring(1, length - 1);
            length = identifier.length();
        }
        int searchFor = identifier.charAt(0) == '\"' ? 34 : 46;
        int startIdx = 0;
        while (startIdx < length) {
            int srchIdx = startIdx + (searchFor == 34 ? 1 : 0);
            int endIdx = identifier.indexOf(searchFor, srchIdx);
            int n = endIdx > -1 ? endIdx + (searchFor == 34 ? 1 : 0) : (endIdx = length);
            if (startIdx == endIdx || endIdx < length && identifier.charAt(endIdx) != '.') {
                throw new InvalidNameException(null, DBArb.format((int)12, (Object)identifier));
            }
            String component = identifier.substring(startIdx, endIdx);
            OracleDatabaseDescriptor.validateDbLinkNameComponent(isQuotedName ? '\"' + component + '\"' : component);
            startIdx = endIdx + 1;
            if (startIdx == length) {
                throw new InvalidNameException(null, DBArb.format((int)12, (Object)identifier));
            }
            if (startIdx >= length) continue;
            searchFor = identifier.charAt(startIdx) == '\"' ? 34 : 46;
        }
    }

    private boolean canEncode(String name) {
        boolean canEncode = true;
        Charset cs = this.getIdeCharset();
        if (cs != null) {
            try {
                CharsetEncoder charsetEncoder = cs.newEncoder();
                if (charsetEncoder != null) {
                    canEncode = charsetEncoder.canEncode(name);
                }
            }
            catch (UnsupportedOperationException uoe) {
                DBLog.getLogger().log(DBLog.getTraceLogLevel(), "charset " + cs.displayName() + " doesn't support encoding.");
            }
            catch (IllegalStateException ise) {
                DBLog.getLogger().log(Level.WARNING, "can't use encoder to test name", ise);
            }
        }
        return canEncode;
    }

    private static void validateDbLinkNameComponent(String component) throws InvalidNameException {
        boolean isQuoted;
        boolean bl = isQuoted = component.charAt(0) == '\"' && component.indexOf(34, 1) == component.length() - 1;
        if (isQuoted) {
            component = component.substring(1, component.length() - 1);
        }
        for (int i = 0; i < component.length(); ++i) {
            char c = component.charAt(i);
            if (c != '\"' && (Character.isLetterOrDigit(c) || ALLOWED_CHARS.indexOf(c) >= 0 || isQuoted && c == '.')) continue;
            throw new InvalidNameException(null, DBArb.format((int)9, (Object)component));
        }
        if (!isQuoted) {
            if (!Character.isLetter(component.charAt(0))) {
                throw new InvalidNameException(null, DBArb.format((int)8, (Object)component));
            }
            if (RESERVED_WORDS.contains(component.toUpperCase())) {
                throw new InvalidNameException(null, DBArb.format((int)10, (Object)component.toUpperCase()));
            }
        }
    }

    private boolean isPartitioningEnabled() {
        if (this.m_database instanceof OracleDatabaseImpl) {
            return ((OracleDatabaseImpl)this.m_database).supportsPartitioning();
        }
        return true;
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider pro) {
        Map<String, DBObjectValidator> v = super.getValidators(pro);
        v.put("COLUMN", new OracleColumnValidator(pro));
        v.put("TABLE", new OracleTableValidator(pro));
        v.put("INDEX", new OracleIndexValidator(pro));
        v.put("CONSTRAINT", new OracleConstraintValidator(pro));
        v.put("SYNONYM", new SynonymValidator(pro));
        v.put("SEQUENCE", new SequenceValidator(pro));
        v.put("VIEW", new ViewValidator(pro));
        v.put("OracleStorageProperties", new StoragePropertiesValidator(pro));
        if (!OracleLite.class.isAssignableFrom(this.getDatabaseClass())) {
            v.put("MATERIALIZED VIEW", new MaterializedViewValidator(pro));
            v.put("MATERIALIZED VIEW LOG", new MaterializedViewLogValidator(pro));
            v.put("TRIGGER", new TriggerValidator(pro));
            v.put("XML SCHEMA", new XMLSchemaValidator(pro));
            v.put("PACKAGE", new PackageValidator(pro));
            v.put("PROCEDURE", new PlSqlValidator(pro));
            v.put("FUNCTION", new PlSqlValidator(pro));
            v.put("IOT PROPERTIES", new IOTPropertiesValidator(pro));
            v.put("EXTERNAL TABLE PROPERTIES", new ExternalTablePropsValidator(pro));
            v.put("PARTITION MODEL", new TablePartitionsValidator(pro));
            v.put("PARTITION", new TablePartitionValidator(pro));
            v.put("LOB DESCRIPTOR", new LOBDescriptorValidator(pro));
            v.put("INDEX PARTITION MODEL", new IndexPartitionsValidator(pro));
            v.put("INDEX PARTITION", new IndexPartitionValidator(pro));
            v.put("TYPE", new ObjectTypeValidator(pro));
            v.put("DIRECTORY", new DirectoryValidator(pro));
            v.put("DATABASE LINK", new DatabaseLinkValidator(pro));
            v.put("XMLTypeColumnProperties", new XMLTypeColumnPropertiesValidator(pro));
        }
        if (Oracle10g.class.isAssignableFrom(this.getDatabaseClass())) {
            v.put("TABLESPACE", new TablespaceValidator(pro));
            v.put("OracleTablespaceProperties", new OracleTablespacePropertiesValidator(pro));
            v.put("FILE_SPECIFICATION", new FileSpecificationValidator(pro));
        }
        return v;
    }

    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        OracleDDLGenerator ddlgen = new OracleDDLGenerator(this.getDatabaseClass(), pro);
        if (DBObjectRegistry.isActive()) {
            ddlgen = new DelegateDDLGenerator((DDLGenerator)ddlgen, (DatabaseDescriptor)this, pro);
        }
        return ddlgen;
    }

    public Collection<String> listPreferredDataTypeNames() {
        return Arrays.asList("VARCHAR2", "NUMBER", "DATE", "CLOB", "BLOB");
    }

    public SQLQueryBuilderFactory getSQLQueryBuilderFactory() {
        return new SQLQueryBuilderFactory(){

            protected SQLQueryBuilder createBuilderImpl(DBObjectProvider pro, Schema schema) {
                return new OracleSQLQueryBuilder(pro, schema);
            }
        };
    }

    @Override
    public boolean isCompatibleUpgrade(Class<? extends Database> dbClz, Class<? extends Database> testClz) {
        if (testClz == Oracle10gR2XE.class) {
            return false;
        }
        if (dbClz == Oracle10gR2XE.class) {
            dbClz = Oracle9iR2.class;
        }
        return super.isCompatibleUpgrade(dbClz, testClz);
    }

    protected boolean isValidFKDataTypeImpl(DataType fktype, DataType reftype) {
        boolean isValid = super.isValidFKDataTypeImpl(fktype, reftype);
        if (!isValid && fktype instanceof NumericDataType && reftype instanceof NumericDataType) {
            isValid = true;
        }
        return isValid;
    }

    public List<PropertyInitializer> getExternalPropertyDefaulters(DBObjectProvider pro) {
        ArrayList<PropertyInitializer> list = new ArrayList<PropertyInitializer>();
        list.add(new OracleDBDefaultsInitializer(pro));
        return list;
    }

    private static int getDatabaseVersion(Class<? extends OracleDatabase> clz) {
        Integer retval = s_versions.get(clz);
        return retval == null ? -1 : retval;
    }

    static {
        s_versions.put(Oracle11gR2.class, 112);
        s_versions.put(Oracle11g.class, 110);
        s_versions.put(Oracle10gR2XE.class, 101);
        s_versions.put(Oracle10gR2.class, 102);
        s_versions.put(Oracle10g.class, 100);
        s_versions.put(Oracle9iR2.class, 92);
        s_versions.put(Oracle9i.class, 91);
        s_versions.put(Oracle8i.class, 82);
        s_versions.put(Oracle8.class, 81);
        s_versions.put(OracleLite.class, 1);
        s_versions.put(OracleLite10gR3.class, 3);
        s_versions.put(BaseOracleDatabase.class, 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OracleDBDefaultsInitializer
    extends PropertyInitializer {
        private Map<String, Object> m_genericOracleDefaults = new HashMap<String, Object>();
        private Map<String, Map<String, Object>> m_typeSpecificOracleDefaults = new HashMap<String, Map<String, Object>>();
        private Map<String, Collection<String>> m_subtypes = new HashMap<String, Collection<String>>();

        private void init() {
            if (this.m_genericOracleDefaults.isEmpty()) {
                HashMap<String, Integer> indexDefaults = new HashMap<String, Integer>();
                indexDefaults.put("initrans", 2);
                this.m_typeSpecificOracleDefaults.put("INDEX", indexDefaults);
                HashMap<String, Comparable<BigInteger>> sequenceDefaults = new HashMap<String, Comparable<BigInteger>>();
                sequenceDefaults.put("minValue", new BigInteger("1"));
                sequenceDefaults.put("maxValue", new BigInteger("999999999999999999999999999"));
                sequenceDefaults.put("incrementBy", new BigInteger("1"));
                sequenceDefaults.put("cacheSize", new BigInteger("20"));
                sequenceDefaults.put("cacheFlag", Boolean.TRUE);
                this.m_typeSpecificOracleDefaults.put("SEQUENCE", sequenceDefaults);
                HashMap<String, Boolean> matViewLogDefaults = new HashMap<String, Boolean>();
                matViewLogDefaults.put("cache", Boolean.FALSE);
                matViewLogDefaults.put("objectIdLogged", Boolean.FALSE);
                matViewLogDefaults.put("sequenceLogged", Boolean.FALSE);
                matViewLogDefaults.put("primaryKeyLogged", Boolean.TRUE);
                matViewLogDefaults.put("newValues", Boolean.FALSE);
                matViewLogDefaults.put("rowidLogged", Boolean.FALSE);
                this.m_typeSpecificOracleDefaults.put("MATERIALIZED VIEW LOG", matViewLogDefaults);
                ArrayList<String> tableSubtypes = new ArrayList<String>();
                tableSubtypes.add(Table.TableType.INDEX_ORGANIZED.toString());
                HashMap<String, Comparable<Boolean>> iotDefaults = new HashMap<String, Comparable<Boolean>>();
                iotDefaults.put("overflowable", Boolean.FALSE);
                iotDefaults.put("initrans", Integer.valueOf(2));
                this.m_typeSpecificOracleDefaults.put("TABLE" + Table.TableType.INDEX_ORGANIZED, iotDefaults);
                tableSubtypes.add(Table.TableType.SESSION_TEMP.toString());
                tableSubtypes.add(Table.TableType.TRANSACTION_TEMP.toString());
                HashMap<String, Constable> temporaryTableDefaults = new HashMap<String, Constable>();
                temporaryTableDefaults.put("percentUsed", Integer.valueOf(40));
                temporaryTableDefaults.put("freelists", Integer.valueOf(1));
                temporaryTableDefaults.put("freelistGroups", Integer.valueOf(1));
                temporaryTableDefaults.put("logging", Boolean.FALSE);
                this.m_typeSpecificOracleDefaults.put("TABLE" + Table.TableType.TRANSACTION_TEMP, temporaryTableDefaults);
                this.m_typeSpecificOracleDefaults.put("TABLE" + Table.TableType.SESSION_TEMP, temporaryTableDefaults);
                this.m_subtypes.put("TABLE", tableSubtypes);
                this.m_genericOracleDefaults.put("tablespaceID", new NameBasedID("TABLESPACE", null, "USERS"));
                this.m_genericOracleDefaults.put("percentFree", 10);
                this.m_genericOracleDefaults.put("initrans", 1);
                this.m_genericOracleDefaults.put("initialExtent", 65536);
                this.m_genericOracleDefaults.put("minExtent", 1);
                this.m_genericOracleDefaults.put("maxExtent", 0x7FFFFFFD);
                this.m_genericOracleDefaults.put("nextExtent", 0x100000);
                this.m_genericOracleDefaults.put("bufferMode", OracleStorageProperties.BufferModes.DEFAULT);
                this.m_genericOracleDefaults.put("maxtrans", 255);
                this.m_genericOracleDefaults.put("logging", true);
            }
        }

        OracleDBDefaultsInitializer(DBObjectProvider pro) {
            super(pro);
        }

        public String[] getPropertyNames(Class<? extends DBObject> clz) {
            this.init();
            HashSet<String> retval = new HashSet<String>();
            retval.addAll(this.m_genericOracleDefaults.keySet());
            Collection<String> tableTypes = this.m_subtypes.get("TABLE");
            for (String tableType : tableTypes) {
                retval.addAll(this.m_typeSpecificOracleDefaults.get("TABLE" + tableType).keySet());
            }
            for (String type : Metadata.getInstance().getAllTypes(clz)) {
                Map<String, Object> typeSpecifics = this.m_typeSpecificOracleDefaults.get(type);
                if (typeSpecifics == null) continue;
                retval.addAll(typeSpecifics.keySet());
            }
            return retval.toArray(new String[retval.size()]);
        }

        public Object getPropertyInitialValue(DBObject obj, String propertyName) throws PropertyInitializer.InitializationVeto {
            SystemObject sysObj;
            Object retval = null;
            this.init();
            SystemObject systemObject = sysObj = obj instanceof SystemObject ? (SystemObject)obj : null;
            for (DBObject parent = obj.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof SystemObject)) continue;
                sysObj = (SystemObject)parent;
                break;
            }
            if (sysObj != null) {
                Map<String, Object> typeMap;
                String type = sysObj.getType();
                if ("TABLE".equals(type)) {
                    type = type + ((Table)sysObj).getProperty("TableType");
                }
                if ((typeMap = this.m_typeSpecificOracleDefaults.get(type)) != null) {
                    retval = typeMap.get(propertyName);
                }
            }
            if (retval == null) {
                retval = this.m_genericOracleDefaults.get(propertyName);
            }
            return retval;
        }
    }
}

