/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializedViewBuilder
extends OracleTableBuilder<MaterializedView> {
    private static String TENG_REPLACE_COL = "A.UNKNOWN_TRUSTED_FD";
    private static String NON_TENG_REPLACE_COL = "'NULL'";

    MaterializedViewBuilder(BaseOracleDatabase db) {
        super(db, "MATERIALIZED VIEW");
    }

    @Override
    public MaterializedView createObject(String name, Schema schema, DBObjectID id) {
        MaterializedView mview = new MaterializedView(name, schema);
        mview.setID(id);
        return mview;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"updatable", "rewrite", "rewriteType", "refreshMode", "refreshMethod", "fastRefresh", "lastRefreshType", "lastRefreshDate", "staleness", "buildType", "onPrebuilt", "useNoIndex", "usingConstraints", "keyType", "parallel", "cache", "PARTITIONED TABLE", "OracleTablePartitions", "compression", "nextRefreshDate", "interval", "masters", "OracleStorageProperties"})
    public void fillInBaseProperties(final MaterializedView mview) throws DBException {
        final QueryWrapper wrap = this.newQueryWrapper(this.getQuery(this.getDatabase().getDatabaseVersion()), mview.getSchema(), mview);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        int index = 1;
                        mview.setUpdatable(MaterializedViewBuilder.this.parseYNBoolean(rs.getString(index++)));
                        mview.setRewrite(MaterializedViewBuilder.this.parseYNBoolean(rs.getString(index++)));
                        mview.setRewriteType(MaterializedViewBuilder.this.parseRewriteCapability(rs.getString(index++)));
                        mview.setRefreshMode(MaterializedViewBuilder.this.parseRefreshMode(rs.getString(index++)));
                        mview.setRefreshMethod(MaterializedViewBuilder.this.parseRefreshMethod(rs.getString(index++)));
                        mview.setFastRefresh(MaterializedViewBuilder.this.parseFastRefreshable(rs.getString(index++)));
                        mview.setLastRefreshType(MaterializedViewBuilder.this.parseRefreshMethod(rs.getString(index++)));
                        Timestamp timestamp = rs.getTimestamp(index++);
                        Date date = timestamp == null ? null : new Date(timestamp.getTime());
                        mview.setLastRefreshDate(date);
                        mview.setStaleness(MaterializedViewBuilder.this.parseStaleness(rs.getString(index++)));
                        mview.setBuildType(MaterializedViewBuilder.this.parseBuildType(rs.getString(index++)));
                        mview.setOnPrebuilt(MaterializedViewBuilder.this.parsePrebuilt(rs.getString(index++)));
                        mview.setUseNoIndex(MaterializedViewBuilder.this.parseYNBoolean(rs.getString(index++)));
                        mview.setUsingConstraints(MaterializedViewBuilder.this.parseUsingConstraints(rs.getString(index++)));
                        mview.setKeyType(MaterializedViewBuilder.this.parseKeyType(rs.getString(index++)));
                        mview.setParallel(MaterializedViewBuilder.this.parseParallel(rs.getString(index++)));
                        mview.setCache(MaterializedViewBuilder.this.parseYNBoolean(rs.getString(index++)));
                        if ("YES".equals(rs.getString(index++))) {
                            mview.setProperty("PARTITIONED TABLE", (Object)Boolean.TRUE);
                            mview.setProperty("OracleTablePartitions", (Object)MaterializedViewBuilder.this.getOracleTablePartitions(mview));
                        }
                        mview.setCompression("ENABLED".equals(rs.getString(index++)));
                        timestamp = rs.getTimestamp(index++);
                        date = timestamp == null ? null : new Date(timestamp.getTime());
                        mview.setNextRefreshDate(date);
                        mview.setInterval(rs.getString(index++));
                        ArrayList<String> masters = new ArrayList<String>();
                        String master = MaterializedViewBuilder.this.parseMasterName(rs.getString(index), rs.getString(index + 1));
                        while (master != null) {
                            if (master.length() > 0) {
                                masters.add(master);
                            }
                            master = rs.next() ? MaterializedViewBuilder.this.parseMasterName(rs.getString(index), rs.getString(index + 1)) : null;
                        }
                        mview.setMasters(masters.toArray(new String[masters.size()]));
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)mview, ex);
                }
            }
        };
        wrap.executeQuery(r);
        final QueryWrapper wrap2 = this.newQueryWrapper(this.getTableQuery(), mview.getSchema(), mview);
        QueryWrapper.QueryRunnable r2 = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        OracleStorageProperties osp = OracleTableBuilder.getSegmentAttributeProperties(rs, MaterializedViewBuilder.this.getDatabase());
                        mview.setProperty("OracleStorageProperties", (Object)osp);
                    }
                }
                catch (SQLException ex) {
                    wrap2.throwDBException((DBObject)mview, ex);
                }
            }
        };
        wrap2.executeQuery(r2);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"SQLQuery"})
    public void fillInQuery(final MaterializedView mview) throws DBException {
        final QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_MVIEW_QUERY_QUERY*/\n       A.QUERY\nFROM SYS.ALL_MVIEWS A\nWHERE A.OWNER = ? AND A.MVIEW_NAME = ? \n", mview.getSchema(), mview);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        NonDeclarativeSQLQuery query = new NonDeclarativeSQLQuery(rs.getString(1));
                        mview.setSQLQuery((SQLQuery)query);
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException(ex);
                }
            }
        };
        wrap.executeQuery(r);
    }

    @Override
    @AbstractDBObjectBuilder.PropertyBuilder(value={"indexes", "MatViewIndexStorageProperties"}, depends={"columns"})
    public void fillInIndexes(final MaterializedView mview) throws DBException {
        final Holder usingIndexName = new Holder();
        final QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_MVIEW_INDEX_QUERY*/\n       I.INDEX_NAME \n,      I.TABLESPACE_NAME \n,      I.PCT_FREE \n,      NULL PCT_USED \n,      I.INI_TRANS \n,      I.MAX_TRANS \n,      I.INITIAL_EXTENT \n,      I.NEXT_EXTENT \n,      I.MIN_EXTENTS \n,      I.MAX_EXTENTS \n,      I.PCT_INCREASE \n,      I.FREELISTS \n,      I.FREELIST_GROUPS \n,      I.LOGGING \n,      I.BUFFER_POOL \nFROM   SYS.ALL_MVIEWS A \n,      SYS.ALL_INDEXES I \n,      SYS.ALL_CONSTRAINTS C \nWHERE  A.MVIEW_NAME = I.TABLE_NAME \nAND    C.OWNER = A.OWNER \nAND    C.TABLE_NAME = A.MVIEW_NAME \nAND    C.CONSTRAINT_TYPE = 'P' \nAND    C.INDEX_NAME = I.INDEX_NAME\nAND    A.OWNER = ? \nAND    A.MVIEW_NAME = ? \n", mview.getSchema(), mview);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        usingIndexName.set((Object)rs.getString(1));
                        OracleStorageProperties osp = OracleTableBuilder.getSegmentAttributeProperties(rs, MaterializedViewBuilder.this.getDatabase());
                        mview.setProperty("MatViewIndexStorageProperties", (Object)osp);
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)mview, ex);
                }
            }
        };
        wrap.executeQuery(r);
        OracleIndexBuilder ib = (OracleIndexBuilder)this.getDatabase().getBuilderForType("INDEX");
        ib.setMatViewUsingIndexIndexName((String)usingIndexName.get());
        ib.fillInIndexes((SchemaObject)mview);
    }

    private String getQuery(int databaseType) {
        String toFormat = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_PROPERTIES_QUERY*/\n       A.UPDATABLE, A.REWRITE_ENABLED, A.REWRITE_CAPABILITY, \nA.REFRESH_MODE, A.REFRESH_METHOD, A.FAST_REFRESHABLE, \nA.LAST_REFRESH_TYPE, A.LAST_REFRESH_DATE, A.STALENESS, A.BUILD_MODE, \nA.UNKNOWN_PREBUILT, A.USE_NO_INDEX, %1$S, E.REFRESH_METHOD KEY_TYPE, \nC.DEGREE, C.CACHE, C.PARTITIONED, %2$S, D.NEXT_DATE, D.INTERVAL, \nB.DETAILOBJ_OWNER, B.DETAILOBJ_NAME \nFROM SYS.ALL_MVIEWS A, SYS.ALL_MVIEW_DETAIL_RELATIONS B, \nSYS.ALL_TABLES C, SYS.ALL_REFRESH D, \nSYS.ALL_SNAPSHOTS E\nWHERE A.OWNER = B.OWNER(+) AND A.MVIEW_NAME = B.MVIEW_NAME(+) \nAND A.MVIEW_NAME = C.TABLE_NAME AND A.OWNER = C.OWNER \nAND A.OWNER = D.ROWNER(+) AND A.MVIEW_NAME = D.RNAME(+) \nAND A.OWNER = ? AND A.MVIEW_NAME = ? \nAND A.OWNER = E.OWNER AND A.MVIEW_NAME = E.NAME";
        String qry = databaseType >= 100 ? String.format("SELECT /*OracleDictionaryQueries.ALL_MVIEW_PROPERTIES_QUERY*/\n       A.UPDATABLE, A.REWRITE_ENABLED, A.REWRITE_CAPABILITY, \nA.REFRESH_MODE, A.REFRESH_METHOD, A.FAST_REFRESHABLE, \nA.LAST_REFRESH_TYPE, A.LAST_REFRESH_DATE, A.STALENESS, A.BUILD_MODE, \nA.UNKNOWN_PREBUILT, A.USE_NO_INDEX, %1$S, E.REFRESH_METHOD KEY_TYPE, \nC.DEGREE, C.CACHE, C.PARTITIONED, %2$S, D.NEXT_DATE, D.INTERVAL, \nB.DETAILOBJ_OWNER, B.DETAILOBJ_NAME \nFROM SYS.ALL_MVIEWS A, SYS.ALL_MVIEW_DETAIL_RELATIONS B, \nSYS.ALL_TABLES C, SYS.ALL_REFRESH D, \nSYS.ALL_SNAPSHOTS E\nWHERE A.OWNER = B.OWNER(+) AND A.MVIEW_NAME = B.MVIEW_NAME(+) \nAND A.MVIEW_NAME = C.TABLE_NAME AND A.OWNER = C.OWNER \nAND A.OWNER = D.ROWNER(+) AND A.MVIEW_NAME = D.RNAME(+) \nAND A.OWNER = ? AND A.MVIEW_NAME = ? \nAND A.OWNER = E.OWNER AND A.MVIEW_NAME = E.NAME", TENG_REPLACE_COL, "C.COMPRESSION") : String.format("SELECT /*OracleDictionaryQueries.ALL_MVIEW_PROPERTIES_QUERY*/\n       A.UPDATABLE, A.REWRITE_ENABLED, A.REWRITE_CAPABILITY, \nA.REFRESH_MODE, A.REFRESH_METHOD, A.FAST_REFRESHABLE, \nA.LAST_REFRESH_TYPE, A.LAST_REFRESH_DATE, A.STALENESS, A.BUILD_MODE, \nA.UNKNOWN_PREBUILT, A.USE_NO_INDEX, %1$S, E.REFRESH_METHOD KEY_TYPE, \nC.DEGREE, C.CACHE, C.PARTITIONED, %2$S, D.NEXT_DATE, D.INTERVAL, \nB.DETAILOBJ_OWNER, B.DETAILOBJ_NAME \nFROM SYS.ALL_MVIEWS A, SYS.ALL_MVIEW_DETAIL_RELATIONS B, \nSYS.ALL_TABLES C, SYS.ALL_REFRESH D, \nSYS.ALL_SNAPSHOTS E\nWHERE A.OWNER = B.OWNER(+) AND A.MVIEW_NAME = B.MVIEW_NAME(+) \nAND A.MVIEW_NAME = C.TABLE_NAME AND A.OWNER = C.OWNER \nAND A.OWNER = D.ROWNER(+) AND A.MVIEW_NAME = D.RNAME(+) \nAND A.OWNER = ? AND A.MVIEW_NAME = ? \nAND A.OWNER = E.OWNER AND A.MVIEW_NAME = E.NAME", NON_TENG_REPLACE_COL, "NULL COMPRESSION");
        return qry;
    }

    private boolean parseYNBoolean(String s) {
        return "Y".equals(s.trim());
    }

    private MaterializedView.UsingConstraints parseUsingConstraints(String s) {
        Boolean boo = this.parseYNNullBoolean(s);
        if (boo != null) {
            return boo != false ? MaterializedView.UsingConstraints.TRUSTED : MaterializedView.UsingConstraints.ENFORCED;
        }
        return null;
    }

    private MaterializedView.RefreshWith parseKeyType(String s) {
        MaterializedView.RefreshWith ret = null;
        if (s != null) {
            s = s.trim();
            s = s.replace(" ", "_");
            try {
                ret = MaterializedView.RefreshWith.valueOf((String)s);
            }
            catch (IllegalArgumentException e) {
                ret = MaterializedView.RefreshWith.UNSPECIFIED;
            }
        }
        return ret;
    }

    private Boolean parseYNNullBoolean(String s) {
        String trim = s.trim();
        if ("Y".equals(trim) || "YES".equals(trim)) {
            return Boolean.TRUE;
        }
        if ("N".equals(trim) || "NO".equals(trim)) {
            return Boolean.FALSE;
        }
        return null;
    }

    private int parseParallel(String s) {
        int ret = 1;
        try {
            Integer i = new Integer(s.trim());
            ret = i;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    private MaterializedView.RewriteCapability parseRewriteCapability(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.RewriteCapability.valueOf((String)s) : null;
    }

    private MaterializedView.RefreshMode parseRefreshMode(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.RefreshMode.valueOf((String)s) : null;
    }

    private MaterializedView.RefreshMethod parseRefreshMethod(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.RefreshMethod.valueOf((String)s) : null;
    }

    private MaterializedView.FastRefreshable parseFastRefreshable(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.FastRefreshable.valueOf((String)s) : null;
    }

    private MaterializedView.PrebuiltType parsePrebuilt(String s) {
        MaterializedView.PrebuiltType result = MaterializedView.PrebuiltType.NONE;
        if ("Y".equals(s)) {
            result = MaterializedView.PrebuiltType.UNSPECIFIED_PRECISION;
        }
        return result;
    }

    private MaterializedView.Staleness parseStaleness(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.Staleness.valueOf((String)s) : null;
    }

    private MaterializedView.BuildType parseBuildType(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.BuildType.valueOf((String)s) : null;
    }

    private String parseMasterName(String schema, String name) {
        StringBuffer buf = new StringBuffer(64);
        if (ModelUtil.hasLength((String)schema)) {
            buf.append(schema);
        }
        if (ModelUtil.hasLength((String)name)) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name);
        }
        return buf.toString();
    }
}

