/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.mysql.MySQL5;
import oracle.javatools.db.mysql.MySQLDatabase;
import oracle.javatools.db.mysql.MySQLDatabaseDescriptor;
import oracle.javatools.db.mysql.MySQLDatabaseImpl;

public class MySQLDatabaseFactory
extends BaseDatabaseCreator {
    public MySQLDatabaseFactory() {
        this.registerProviderClass(MySQLDatabaseImpl.class, 399, (DataTypeRegistry.Registerer)new MySQLDatabaseImpl.Registerer());
        this.registerProviderClass(MySQL5.class, 400, null);
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        int t = this.getType(conn);
        switch (t) {
            case 0: {
                return new MySQLDatabaseImpl(connStore, connName, conn);
            }
            case 1: {
                return new MySQL5(connStore, connName, conn);
            }
        }
        return null;
    }

    protected int getType(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String dbName = dmd.getDatabaseProductName();
                if (dbName.startsWith("MySQL")) {
                    int v = dmd.getDatabaseMajorVersion();
                    if (v >= 5) {
                        return 1;
                    }
                    return 0;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (MySQLDatabase.class.isAssignableFrom(providerClass)) {
            return new MySQLDatabaseDescriptor(providerClass);
        }
        return null;
    }
}

