/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBCore;
import oracle.javatools.db.marshal.DBObjectXMLHandler;
import oracle.javatools.util.ModelUtil;

public class DBObjectXMLSupport {
    private final Map<String, DBObjectXMLHandler> m_handlers = new HashMap<String, DBObjectXMLHandler>();

    private DBObjectXMLSupport() {
    }

    public void registerHandler(DBObjectXMLHandler handler) {
        String namespace = handler.getNamespace();
        if (ModelUtil.hasLength((String)namespace)) {
            if (this.m_handlers.containsKey(namespace)) {
                throw new IllegalStateException("DBObjectXMLHandler for \"" + namespace + "\" already registered.");
            }
        } else {
            throw new IllegalArgumentException("DBObjectXMLHandler has no namespace defined");
        }
        this.m_handlers.put(namespace, handler);
    }

    public DBObjectXMLHandler getHandler(String namespace) {
        return this.m_handlers.get(namespace);
    }

    public static DBObjectXMLSupport getInstance() {
        DBCore core = DBCore.getInstance();
        DBObjectXMLSupport retval = (DBObjectXMLSupport)core.get(DBObjectXMLSupport.class);
        if (retval == null) {
            retval = new DBObjectXMLSupport();
            core.put((Object)retval);
        }
        return retval;
    }
}

