/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.BaseDatabaseDescriptor;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcColumnValidator;
import oracle.javatools.db.jdbc.JdbcDDLGenerator;
import oracle.javatools.db.property.PropertyInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDatabaseDescriptor<T extends Database>
extends BaseDatabaseDescriptor<T> {
    private static final int MAX_NAME_LENGTH = 500;
    private static final char QUOTE_IDENTIFIER = '\"';
    private String m_quoteIdent;
    private int m_casePolicy = -1;
    private T m_db;

    public JdbcDatabaseDescriptor(Class<? extends T> clz) {
        super(clz);
    }

    public JdbcDatabaseDescriptor(T db) {
        this(db.getClass());
        this.m_db = db;
    }

    public int getCasePolicy() {
        Connection c;
        if (this.m_casePolicy < 0 && this.m_db != null && (c = this.m_db.getConnection()) != null) {
            try {
                DatabaseMetaData dm = c.getMetaData();
                boolean lower = dm.storesLowerCaseIdentifiers();
                boolean lowerQuoted = dm.storesLowerCaseQuotedIdentifiers();
                boolean mixed = dm.storesMixedCaseIdentifiers();
                boolean mixedQuoted = dm.storesMixedCaseQuotedIdentifiers();
                boolean upper = dm.storesUpperCaseIdentifiers();
                boolean upperQuoted = dm.storesUpperCaseQuotedIdentifiers();
                this.m_casePolicy = lower ? 1 : (upper ? 2 : 0);
            }
            catch (SQLException e) {
                DBLog.getLogger().log(Level.WARNING, "couldn't get case policy for " + this.m_db.getConnectionName(), e);
            }
        }
        return this.m_casePolicy < 0 ? 0 : this.m_casePolicy;
    }

    public String getIdentifierQuoteString() {
        Connection c;
        if (this.m_db != null && this.m_quoteIdent == null && (c = this.m_db.getConnection()) != null) {
            try {
                DatabaseMetaData dm = c.getMetaData();
                this.m_quoteIdent = dm.getIdentifierQuoteString();
            }
            catch (SQLException e) {
                DBLog.getLogger().log(Level.WARNING, "couldn't get quote string for " + this.m_db.getConnectionName(), e);
            }
        }
        return this.m_quoteIdent == null ? String.valueOf('\"') : this.m_quoteIdent;
    }

    public int getMaxNameLength(String type) {
        return 500;
    }

    public void validateName(String type, String name) throws InvalidNameException {
        JdbcDatabaseDescriptor.validateIdentifier((String)name, (char)'\"', (int)500, null, (boolean)true, null, (int)this.getCasePolicy());
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider pro) {
        Map<String, DBObjectValidator> v = super.getValidators(pro);
        v.put("COLUMN", new JdbcColumnValidator(pro));
        return v;
    }

    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new JdbcDDLGenerator(pro);
    }

    @Override
    public boolean isCompatibleUpgrade(Class<? extends Database> dbClz, Class<? extends Database> testClz) {
        if (DataTypeRegistry.isGenericJdbcClass(dbClz)) {
            return false;
        }
        return super.isCompatibleUpgrade(dbClz, testClz);
    }

    public Collection<DataType> listSupportedDataTypes() {
        if (DataTypeRegistry.isGenericJdbcClass((Class)this.getDatabaseClass())) {
            return Arrays.asList(DataTypeRegistry.getInstance().getAnsiTypes());
        }
        return super.listSupportedDataTypes();
    }

    public DataType getDataType(String typeName) {
        if (DataTypeRegistry.isGenericJdbcClass((Class)this.getDatabaseClass())) {
            return DataTypeRegistry.getInstance().findAnsiType(typeName);
        }
        return super.getDataType(typeName);
    }

    public List<PropertyInitializer> getExternalPropertyDefaulters(DBObjectProvider pro) {
        return null;
    }

    public String getDatabaseType() {
        return "Generic JDBC";
    }

    public int getDatabaseVersion() {
        return 0;
    }
}

