/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObjectExpander;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.jdbc.JdbcSynonymBuilder;
import oracle.javatools.db.jdbc.JdbcTableBuilder;
import oracle.javatools.db.jdbc.JdbcViewBuilder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDDLDatabase
extends DDLDatabase
implements JdbcDatabase {
    private static final String ODBC_NOT_IMPLEMENTED = "IM001";
    private static final String SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String DMD_SCHEMA_NAME = "DMD_SCHEMA_NAME";
    public static final String DMD_CATALOG_NAME = "DMD_CATALOG_NAME";
    protected static final String DMD_NULL_SCHEMA = "<null>";
    private Map<String, Schema> m_dmdSchemas;
    private boolean m_supportsSchemas;
    private String m_catalog;
    private String m_quoteString;
    private boolean m_useSystemTable;

    public JdbcDDLDatabase(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    protected String getCatalog() {
        block4: {
            if (this.m_catalog == null) {
                try {
                    Connection conn = this.getConnection();
                    this.m_catalog = conn.getCatalog();
                    if (this.m_catalog == null) {
                        this.m_catalog = "";
                    }
                }
                catch (SQLException ex) {
                    if (JdbcDDLDatabase.isUnsupportedOperation(ex)) break block4;
                    DBLog.getLogger().log(Level.WARNING, "Error accessing jdbc database metadata", ex);
                    this.m_catalog = null;
                }
            }
        }
        return this.m_catalog;
    }

    public Schema getSchema(String name) throws DBException {
        if (!ModelUtil.hasLength((String)name)) {
            name = this.getDefaultSchemaName();
        }
        return super.getSchema(name);
    }

    protected Schema findSchema(String name) throws DBException {
        if (!ModelUtil.hasLength((String)name)) {
            name = this.getDefaultSchemaName();
        }
        return super.findSchema(name);
    }

    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> criteria) throws DBException {
        if (criteria.getTypes().contains("SCHEMA")) {
            if (criteria.getTypes().size() > 1) {
                throw new IllegalStateException("Cannot list schemas and schema objects at the same time!");
            }
            ArrayList<Schema> retval = new ArrayList<Schema>();
            for (Schema schema : this.loadSchemasImpl().values()) {
                if (!criteria.accept((SystemObject)schema)) continue;
                retval.add(schema);
            }
            return retval;
        }
        Schema schema = this.findSchema(criteria.getSchemaName());
        ArrayList<SystemObject> list = new ArrayList<SystemObject>();
        String[] objectTypes = criteria.getTypeArray();
        String ref = criteria.getNameLike();
        boolean moreRows = false;
        ResultSet rs = null;
        DatabaseMetaData dmd = null;
        String schemaName = null;
        String catalogName = null;
        if (this.isUseSchema() && schema != null) {
            schemaName = (String)schema.getProperty(DMD_SCHEMA_NAME);
            if (DMD_NULL_SCHEMA.equals(schemaName)) {
                schemaName = null;
            }
            if ((catalogName = (String)schema.getProperty(DMD_CATALOG_NAME)) == null) {
                catalogName = this.getCatalog();
            }
        }
        String tableName = this.getNameForDriver(ref);
        try {
            String schemaNameForDriver;
            dmd = this.getConnection().getMetaData();
            String dbProductName = dmd.getDatabaseProductName();
            if ("EXCEL".equals(dbProductName)) {
                objectTypes = null;
                if ("%".equals(ref)) {
                    tableName = null;
                }
            }
            if (this.m_useSystemTable && objectTypes != null) {
                for (int i = 0; i < objectTypes.length; ++i) {
                    if (!objectTypes[i].equals("TABLE")) continue;
                    objectTypes[i] = SYSTEM_TABLE;
                }
            }
            boolean bl = moreRows = (rs = this.getTables(dmd, catalogName, schemaNameForDriver = this.getNameForDriver(schemaName), objectTypes, tableName)) != null;
            while (moreRows) {
                DBObjectBuilder builder;
                SystemObject object = null;
                String rsCat = rs.getString(1);
                String rsSchema = this.catalogIsSchema() ? rsCat : rs.getString(2);
                String rsName = rs.getString(3);
                String rsType = rs.getString(4);
                if (SYSTEM_TABLE.equals(rsType)) {
                    rsType = "TABLE";
                }
                if (this.catalogMatches(catalogName, rsCat) && this.schemaMatches(schemaName, rsSchema) && this.tableMatches(ref, rsName) && (builder = this.getBuilderForType(rsType)) != null) {
                    Schema objSchema = rsSchema == null ? schema : this.findSchema(rsSchema);
                    object = this.findOrCreateObject(rsType, objSchema, rsName, null);
                }
                if (object != null) {
                    String comment;
                    if (rs.getMetaData().getColumnCount() > 4 && ModelUtil.hasLength((String)(comment = rs.getString(5)))) {
                        object.setProperty("Comment", (Object)comment);
                    }
                    list.add(object);
                }
                moreRows = rs.next();
            }
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                this.close(rs);
                throw throwable;
            }
        }
        this.close(rs);
        return list;
    }

    private ResultSet getTables(DatabaseMetaData dmd, String catalogName, String schemaNameForDriver, String[] objectTypes, String nameRef) throws SQLException {
        ResultSet rs = this.getTablesImpl(dmd, catalogName, schemaNameForDriver, objectTypes, nameRef);
        if (rs != null && !rs.next()) {
            this.close(rs);
            rs = null;
        }
        if (rs == null && (rs = this.getTablesImpl(dmd, catalogName, null, objectTypes, nameRef)) != null && !rs.next()) {
            this.close(rs);
            rs = null;
        }
        return rs;
    }

    private ResultSet getTablesImpl(DatabaseMetaData dmd, String catalogName, String schemaNameForDriver, String[] objectTypes, String nameRef) throws SQLException {
        ResultSet rs = null;
        try {
            rs = dmd.getTables(catalogName, schemaNameForDriver, nameRef, objectTypes);
        }
        catch (SQLException ex) {
            if (JdbcDDLDatabase.isUnsupportedOperation(ex)) {
                throw ex;
            }
            this.close(rs);
            rs = null;
        }
        return rs;
    }

    protected void close(ResultSet ... rss) {
        if (rss != null) {
            for (ResultSet rs : rss) {
                if (rs == null) continue;
                try {
                    rs.close();
                }
                catch (SQLException sqe) {
                    // empty catch block
                }
            }
        }
    }

    public String getUserName() throws DBException {
        String name = null;
        try {
            DatabaseMetaData dmd = this.getConnection().getMetaData();
            name = dmd.getUserName();
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        return name;
    }

    public String getIdentifierQuoteString() {
        DatabaseDescriptor desc = this.getDescriptor();
        if (desc == null) {
            if (this.m_quoteString == null) {
                try {
                    DatabaseMetaData dmd = this.getConnection().getMetaData();
                    this.m_quoteString = dmd.getIdentifierQuoteString();
                }
                catch (SQLException ex) {
                    this.m_quoteString = "";
                }
            }
            return this.m_quoteString;
        }
        return super.getIdentifierQuoteString();
    }

    protected void registerExpanders() {
        this.registerSchemaObjectExpander((SchemaObjectExpander)new TemplateExpander((DBObjectProvider)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerBuilders() {
        ResultSet rs;
        HashSet<String> types;
        block9: {
            types = new HashSet<String>();
            rs = null;
            try {
                Boolean sysOnlyUsed = false;
                DatabaseMetaData dmd = this.getConnection().getMetaData();
                rs = dmd.getTableTypes();
                while (rs.next()) {
                    String type = rs.getString(1).trim();
                    if (type.equals(SYSTEM_TABLE)) {
                        if (sysOnlyUsed != null) {
                            sysOnlyUsed = true;
                        }
                        type = "TABLE";
                    } else if (type.equals("TABLE")) {
                        sysOnlyUsed = null;
                    }
                    types.add(type);
                }
                if (sysOnlyUsed == null || !sysOnlyUsed.booleanValue()) break block9;
                this.m_useSystemTable = true;
            }
            catch (SQLException ex) {
                try {
                    types.clear();
                    types.add("TABLE");
                }
                catch (Throwable throwable) {
                    this.close(rs);
                    throw throwable;
                }
                this.close(rs);
            }
        }
        this.close(rs);
        String catalog = this.getCatalog();
        this.registerBuilders(types, catalog);
    }

    protected void registerBuilders(Collection<String> types, String catalog) {
        if (types.contains("TABLE")) {
            this.registerBuilder("TABLE", (DBObjectBuilder)new JdbcTableBuilder(this, catalog));
        }
        if (types.contains("VIEW")) {
            this.registerBuilder("VIEW", (DBObjectBuilder)new JdbcViewBuilder(this, catalog));
        }
        if (types.contains("SYNONYM")) {
            this.registerBuilder("SYNONYM", (DBObjectBuilder)new JdbcSynonymBuilder(this, catalog));
        }
    }

    public String normaliseDefaultValue(DataType type, String value) {
        return value;
    }

    public String normaliseDataTypeName(String name) {
        String testName = name;
        while (ModelUtil.hasLength((String)testName) && Character.isDigit(testName.charAt(testName.length() - 1))) {
            testName = testName.substring(0, testName.length() - 1);
        }
        if (ModelUtil.hasLength((String)testName) && !testName.equals(name) && this.getOrCreateDataType(testName) != null) {
            return testName;
        }
        return name;
    }

    public boolean isUseSchema() {
        try {
            this.loadSchemasImpl();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return this.m_supportsSchemas;
    }

    protected boolean useCatalogFromSchema() {
        return true;
    }

    public String getNameForDriver(String name) {
        return name;
    }

    public boolean catalogIsSchema() {
        return true;
    }

    public final Schema[] listSchemas(boolean showAll) throws DBException {
        Collection<Schema> list = this.loadSchemasImpl().values();
        return list.toArray(new Schema[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Schema> loadSchemasImpl() throws DBException {
        block10: {
            ResultSet crs;
            block8: {
                if (this.m_dmdSchemas != null) break block10;
                this.m_supportsSchemas = true;
                this.m_dmdSchemas = new TreeMap<String, Schema>();
                crs = null;
                try {
                    this.populateSchemas();
                    if (!this.catalogIsSchema()) break block8;
                    DatabaseMetaData dmd = this.getConnection().getMetaData();
                    crs = dmd.getCatalogs();
                    while (crs.next()) {
                        String name = crs.getString(1);
                        if (!ModelUtil.hasLength((String)name)) continue;
                        this.createAndCacheSchema(name, name, DMD_NULL_SCHEMA);
                    }
                }
                catch (SQLException ex) {
                    block9: {
                        try {
                            if (JdbcDDLDatabase.isUnsupportedOperation(ex)) break block9;
                            throw new DBException((Throwable)ex);
                        }
                        catch (Throwable throwable) {
                            this.close(crs);
                            throw throwable;
                        }
                    }
                    this.close(crs);
                }
            }
            this.close(crs);
            if (this.m_dmdSchemas.size() == 0 || this.alwaysIncludeDefaultSchema()) {
                String cat;
                if (this.m_dmdSchemas.size() == 0) {
                    this.m_supportsSchemas = false;
                }
                if (!this.m_dmdSchemas.containsKey(cat = this.getDefaultSchemaName())) {
                    Schema defaultSchema = this.createSchema(cat);
                    defaultSchema.setProperty("isDefaultSchema", (Object)Boolean.TRUE);
                    defaultSchema.setProperty(DMD_SCHEMA_NAME, (Object)defaultSchema.getName());
                    this.m_dmdSchemas.put(cat, defaultSchema);
                }
            }
        }
        return this.m_dmdSchemas;
    }

    protected boolean alwaysIncludeDefaultSchema() {
        return false;
    }

    protected void populateSchemas() throws SQLException {
        ResultSet srs = null;
        try {
            DatabaseMetaData dmd = this.getConnection().getMetaData();
            srs = dmd.getSchemas();
            while (srs.next()) {
                String name = srs.getString(1);
                String schemaName = ModelUtil.hasLength((String)name) ? name : DMD_NULL_SCHEMA;
                String catalogName = null;
                if (this.useCatalogFromSchema()) {
                    if (srs.getMetaData().getColumnCount() > 1) {
                        catalogName = srs.getString(2);
                    }
                } else {
                    catalogName = this.getCatalog();
                }
                this.createAndCacheSchema(schemaName, catalogName, name);
            }
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                this.close(srs);
                throw throwable;
            }
        }
        this.close(srs);
    }

    protected void createAndCacheSchema(String name, String catalogName, String dmdSchemaName) {
        if (this.m_dmdSchemas == null) {
            this.m_dmdSchemas = new TreeMap<String, Schema>();
        }
        if (!this.m_dmdSchemas.containsKey(name)) {
            Schema s = this.createSchema(name);
            s.setProperty(DMD_SCHEMA_NAME, (Object)dmdSchemaName);
            s.setProperty(DMD_CATALOG_NAME, (Object)catalogName);
            this.m_dmdSchemas.put(name, s);
        }
    }

    protected String getDefaultSchemaName() {
        String name = this.getCatalog();
        if (!ModelUtil.hasLength((String)name)) {
            try {
                name = this.getConnection().getMetaData().getUserName();
            }
            catch (SQLException e) {
                DBLog.getLogger().log(Level.FINE, "Couldn't get user name: " + e.getMessage());
            }
        }
        return ModelUtil.hasLength((String)name) ? name : DMD_NULL_SCHEMA;
    }

    public Schema getDefaultSchema() throws DBException {
        Schema def = super.getDefaultSchema();
        if (def == null && this.m_dmdSchemas.size() == 1) {
            def = this.m_dmdSchemas.values().iterator().next();
        }
        if (def == null) {
            def = this.findSchema(this.getDefaultSchemaName());
        }
        return def;
    }

    private boolean catalogMatches(String requestedCatalog, String returnedCatalog) {
        return !ModelUtil.hasLength((String)requestedCatalog) || !ModelUtil.hasLength((String)returnedCatalog) || this.nameMatches(requestedCatalog, returnedCatalog);
    }

    private boolean schemaMatches(String requestedSchema, String returnedSchema) {
        try {
            this.loadSchemasImpl();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return !this.m_supportsSchemas || !ModelUtil.hasLength((String)requestedSchema) || !ModelUtil.hasLength((String)returnedSchema) || this.nameMatches(requestedSchema, returnedSchema);
    }

    private boolean nameMatches(String requestedName, String returnedName) {
        if (!ModelUtil.hasLength((String)returnedName) || !ModelUtil.hasLength((String)requestedName)) {
            return false;
        }
        return this.getCasePolicy() == 3 || this.getQuotedNameCasePolicy() == 3 ? ModelUtil.areEqual((Object)requestedName, (Object)returnedName) : ModelUtil.areEqual((Object)requestedName.toLowerCase(), (Object)returnedName.toLowerCase());
    }

    protected boolean tableMatches(String ref, String rsName) {
        String regEx = ref == null ? ".*" : ref.replaceAll("%", ".*");
        return this.nameMatches(ref, rsName) || rsName.matches(regEx);
    }

    static void checkUnsupportedOperation(SQLException ex) throws SQLException {
        if (!JdbcDDLDatabase.isUnsupportedOperation(ex)) {
            throw ex;
        }
    }

    public static boolean isUnsupportedOperation(SQLException ex) {
        if (ex instanceof SQLFeatureNotSupportedException) {
            return true;
        }
        String state = ex.getSQLState();
        if (ModelUtil.areEqual((Object)state, (Object)"S1C00") || ModelUtil.areEqual((Object)state, (Object)ODBC_NOT_IMPLEMENTED)) {
            return true;
        }
        return "org.sqlite.MetaData".equals(ex.getStackTrace()[0].getClassName()) && "not yet implemented".equals(ex.getMessage());
    }

    public void close() {
        super.close();
        this.m_dmdSchemas = null;
        this.m_catalog = null;
        this.m_quoteString = null;
    }

    static {
        DataTypeRegistry.registerGenericJdbcClass(JdbcDDLDatabase.class);
    }
}

