/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.informix.InformixDatabase;
import oracle.javatools.db.informix.InformixDatabaseImpl;
import oracle.javatools.db.informix.InformixDynamicServer11;
import oracle.javatools.db.informix.InformixDynamicServer11Descriptor;
import oracle.javatools.db.informix.InformixDynamicServer11Impl;
import oracle.javatools.db.informix.InformixDynamicServerDescriptor;
import oracle.javatools.db.informix.InformixDynamicServerImpl;

public class InformixDynamicServerFactory
extends BaseDatabaseCreator {
    private DatabaseDescriptor m_descriptor;

    public InformixDynamicServerFactory() {
        this.registerProviderClass(InformixDatabaseImpl.class, null, (DataTypeRegistry.Registerer)new InformixDatabaseImpl.Registerer());
        this.registerProviderClass(InformixDynamicServerImpl.class, 408, (DataTypeRegistry.Registerer)new InformixDynamicServerImpl.Registerer());
        this.registerProviderClass(InformixDynamicServer11Impl.class, DBArb.getString((int)429), (DataTypeRegistry.Registerer)new InformixDynamicServer11Impl.Registerer());
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        int t = this.getInformixConnectionType(conn);
        switch (t) {
            case 0: {
                return new InformixDynamicServerImpl(connStore, connName, conn);
            }
            case 1: {
                return new InformixDynamicServer11Impl(connStore, connName, conn);
            }
        }
        return null;
    }

    protected int getInformixConnectionType(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String driverName = dmd.getDriverName();
                if (driverName.indexOf("Informix") > -1 || driverName.indexOf("iclit09b") > -1) {
                    int v = dmd.getDatabaseMajorVersion();
                    if (v >= 9) {
                        return 1;
                    }
                    return 0;
                }
                if (driverName.indexOf("iclit09b") > -1) {
                    return 0;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (InformixDynamicServer11.class.isAssignableFrom(providerClass)) {
            if (this.m_descriptor == null) {
                this.m_descriptor = new InformixDynamicServer11Descriptor(providerClass);
            }
            return this.m_descriptor;
        }
        if (InformixDatabase.class.isAssignableFrom(providerClass)) {
            if (this.m_descriptor == null) {
                this.m_descriptor = new InformixDynamicServerDescriptor(providerClass);
            }
            return this.m_descriptor;
        }
        return null;
    }
}

