/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.NumericDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformixDecimalDatatype
extends NumericDataType {
    private static final NumericDataType.MinMaxValue MIN_MAX_FLOAT = new NumericDataType.MinMaxValue("1.0e-130", "1.0e+124", 2);
    static final Long LONG_0 = new Long(0L);
    static final Long LONG_16 = new Long(16L);
    static final Long LONG_255 = new Long(255L);

    public InformixDecimalDatatype() {
    }

    public InformixDecimalDatatype(int domain) {
        super(domain, "DECIMAL", "DECIMAL[(<precision>[, <scale>])]", 1L, 32L, LONG_16, false, 0L, null, LONG_0, false, null, MIN_MAX_FLOAT);
    }

    public DataTypeUsage createUsage(Map<String, Object> attributeValues) {
        assert (attributeValues != null);
        Long scale = (Long)attributeValues.get("scale");
        if (scale.equals(LONG_255)) {
            attributeValues.remove("scale");
        }
        return super.createUsage(attributeValues);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
        if (dataTypeUsage != null) {
            Long scaleVal = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale");
            if (scaleVal == null) {
                InformixDecimalDatatype tempDatatype = (InformixDecimalDatatype)((Object)this.copyTo(null));
                DataTypeAttribute scale = tempDatatype.getDataTypeAttribute("scale");
                tempDatatype.removeAttribute(scale);
                tempDatatype.validateUsageAsFloatingPoint(dataTypeUsage, dbObject);
            } else {
                super.validateUsage(dataTypeUsage, dbObject);
            }
        }
    }

    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
        if (dataTypeUsage != null && defaultValue != null) {
            Long scaleVal = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale");
            if (scaleVal == null) {
                InformixDecimalDatatype tempDatatype = (InformixDecimalDatatype)((Object)this.copyTo(null));
                DataTypeAttribute scale = tempDatatype.getDataTypeAttribute("scale");
                tempDatatype.removeAttribute(scale);
                tempDatatype.validateDefaultValueAsFloatingPoint(defaultValue, dataTypeUsage, dbObject);
            } else {
                super.validateDefaultValue(defaultValue, dataTypeUsage, dbObject);
            }
        }
    }

    private void validateUsageAsFloatingPoint(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
        super.validateUsage(dataTypeUsage, dbObject);
    }

    private void validateDefaultValueAsFloatingPoint(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
        super.validateDefaultValue(defaultValue, dataTypeUsage, dbObject);
    }
}

