/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.datatypes.PredefinedDataTypeUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformixCollectionDatatype
extends PredefinedDataType {
    private DataTypeAttribute DATATYPE = new DataTypeAttribute("datatype", 178, new String[]{"INT8", "INTEGER", "SMALLINT", "DECIMAL", "MONEY", "FLOAT", "DOUBLE PRECISION", "SMALLFLOAT", "DATE", "DATETIME", "INTERVAL", "CHAR", "NCHAR", "VARCHAR", "NVARCHAR", "LVARCHAR", "BOOLEAN", "BLOB", "CLOB"}, null, true, true);

    public InformixCollectionDatatype() {
    }

    public InformixCollectionDatatype(int domain, String name) {
        super(domain, name, name + "(<datatype> NOT NULL)", null);
        this.addAttribute(this.DATATYPE, 0);
    }

    public DataTypeUsage createUsage(Map<String, Object> attributeValues) {
        assert (attributeValues != null);
        return super.createUsage(attributeValues);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
        super.validateUsage(dataTypeUsage, dbObject);
        PredefinedDataTypeUsage usage = (PredefinedDataTypeUsage)dataTypeUsage;
        String datatype = ((String)usage.getAttributeValue("datatype")).toUpperCase();
        String[] tokenizedDatatype = InformixCollectionDatatype.tokenize((String)datatype, (String)"( )");
        if (this.isNestedCollection(tokenizedDatatype[0])) {
            this.validateNestedCollection(tokenizedDatatype, 0, dbObject);
        } else {
            this.validateDatatype(tokenizedDatatype[0], dbObject);
        }
    }

    private boolean isNestedCollection(String token) {
        return token.equals("SET") || token.equals("LIST") || token.equals("MULTISET");
    }

    private int validateNestedCollection(String[] datatype, int idx, DBObject dbObject) throws DataTypeValidationException {
        String collectionName = datatype[idx];
        int lastIdx = datatype.length - 1;
        if (idx == lastIdx || datatype[++idx].charAt(0) != '(') {
            throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format((int)203, (Object)collectionName, (Object)datatype[idx]));
        }
        if (idx < lastIdx) {
            if (this.isNestedCollection(datatype[++idx])) {
                idx = this.validateNestedCollection(datatype, idx, dbObject);
            } else {
                this.validateDatatype(datatype[idx], dbObject);
            }
        }
        while (++idx < datatype.length && !datatype[idx].equals("NOT")) {
        }
        if (idx > lastIdx || !datatype[idx].equals("NOT") || ++idx > lastIdx || !datatype[idx].equals("NULL") || ++idx > lastIdx || datatype[idx].charAt(0) != ')') {
            throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format((int)203, (Object)collectionName, (Object)datatype[idx > lastIdx ? lastIdx : idx]));
        }
        return idx;
    }

    private void validateDatatype(String datatype, DBObject dbObject) throws DataTypeValidationException {
        if (datatype.equals("TEXT") || datatype.equals("BYTE") || datatype.equals("SERIAL") || datatype.equals("SERIAL8")) {
            throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format((int)192, (Object)datatype, (Object)this.getDataTypeAttribute("datatype").getLabel().replaceAll("&", "")));
        }
    }
}

