/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import oracle.javatools.db.Properties;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.OldDBObjectDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.TablePartition;

public class TablePartitionReconcileDiffer
extends OldDBObjectDiffer {
    private Stack<TablePartition> _a = new Stack();
    private Stack<Properties> _aProperties = new Stack();
    private Stack<TablePartition> _b = new Stack();
    private Stack<Properties> _bProperties = new Stack();
    private static final String PROPERTY_OBJECT_TYPE = "objectType";
    private static final String PROPERTY_PARTITION_TYPE = "partitionType";
    private static final String PROPERTY_VALUES = "values";
    private static final String PROPERTY_LOB_DESCRIPTORS = "LOBDescriptors";
    private static final String PROPERTY_PARTITION_LEVEL_SUBPARTITIONS = "partitionLevelSubpartitions";
    private static final String PROPERTY_SEGMENT_ATTRIBUTES = "segmentAttributes";

    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        ResultSet valuesRS;
        this._a.push((TablePartition)a);
        this._aProperties.push(a != null ? new Properties(a) : null);
        this._b.push((TablePartition)b);
        this._bProperties.push(b != null ? new Properties(b) : null);
        boolean res = super.diff(a, b, rs, dc);
        Map props = rs.getAllObjectsMap();
        ResultSet typeRS = (ResultSet)props.get(PROPERTY_OBJECT_TYPE);
        if (typeRS != null) {
            DisplayProps.setDisplay(typeRS, false);
        }
        if ((typeRS = (ResultSet)props.get(PROPERTY_PARTITION_TYPE)) != null) {
            DisplayProps.setDisplay(typeRS, false);
        }
        if ((valuesRS = (ResultSet)props.get(PROPERTY_VALUES)) != null) {
            List values = valuesRS.getAllObjectsList();
            for (ResultSet valueRS : values) {
                String value = valueRS.b() != null ? valueRS.b().toString() : (valueRS.a() != null ? valueRS.a().toString() : valueRS.getName());
                valueRS.setName(value);
            }
        }
        this._a.pop();
        this._aProperties.pop();
        this._b.pop();
        this._bProperties.pop();
        return res;
    }

    protected boolean diffSubAttributes(String propertyName) {
        return PROPERTY_SEGMENT_ATTRIBUTES.equals(propertyName) || PROPERTY_PARTITION_LEVEL_SUBPARTITIONS.equals(propertyName);
    }

    protected boolean isIgnoredProperty(String propertyName) {
        return this._a.peek() == null && this._b.peek() == null || this._a.peek() == null && this.isIgnoredProperty(propertyName, this._bProperties.peek()) || this._b.peek() == null && this.isIgnoredProperty(propertyName, this._aProperties.peek()) || this._a.peek() != null && this._b.peek() != null && this.isIgnoredProperty(propertyName, this._bProperties.peek());
    }

    private boolean isIgnoredProperty(String propertyName, Properties p) {
        return p == null || p.get(propertyName) == null || PROPERTY_LOB_DESCRIPTORS.equals(propertyName) && ((Object[])p.get(propertyName)).length == 0 || PROPERTY_VALUES.equals(propertyName) && ((Object[])p.get(propertyName)).length == 0;
    }
}

