/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.BeanDiffer;
import oracle.javatools.db.diff.ColumnConstraintDiffer;
import oracle.javatools.db.diff.ColumnConstraintReconcileDiffer;
import oracle.javatools.db.diff.ColumnReconcileDiffer;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.javatools.db.diff.DBObjectIDComparator;
import oracle.javatools.db.diff.DBObjectIDDiffer;
import oracle.javatools.db.diff.DBObjectReconcileDiffer;
import oracle.javatools.db.diff.DataTypeUsageDiffer;
import oracle.javatools.db.diff.DataTypeUsageDifferIgnorSynonyms;
import oracle.javatools.db.diff.DeclarativeSQLQueryDiffer;
import oracle.javatools.db.diff.DefaultComparator;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.FKConstraintDiffer;
import oracle.javatools.db.diff.GenericSchemaDiffer;
import oracle.javatools.db.diff.IndexDiffer;
import oracle.javatools.db.diff.IndexObjectDiffer;
import oracle.javatools.db.diff.IndexPartitionReconcileDiffer;
import oracle.javatools.db.diff.IndexReconcileDiffer;
import oracle.javatools.db.diff.LOBDescriptorReconcileDiffer;
import oracle.javatools.db.diff.ListDiffer;
import oracle.javatools.db.diff.OldDBObjectDiffer;
import oracle.javatools.db.diff.OldSQLFragmentDiffer;
import oracle.javatools.db.diff.OracleColumnPropertiesReconcileDiffer;
import oracle.javatools.db.diff.OracleExternalTableReconcileDiffer;
import oracle.javatools.db.diff.OracleIOTPropertiesReconcileDiffer;
import oracle.javatools.db.diff.OracleIndexPartitionsReconcileDiffer;
import oracle.javatools.db.diff.OracleStoragePropertiesReconcileDiffer;
import oracle.javatools.db.diff.OracleTablePartitionsReconcileDiffer;
import oracle.javatools.db.diff.OrderedListDiffer;
import oracle.javatools.db.diff.SQLFragmentComparator;
import oracle.javatools.db.diff.SourceObjectDiffer;
import oracle.javatools.db.diff.SpecPlSqlDiffer;
import oracle.javatools.db.diff.SynonymDiffer;
import oracle.javatools.db.diff.TablePartitionReconcileDiffer;
import oracle.javatools.db.diff.TableReconcileDiffer;
import oracle.javatools.db.diff.TriggerDiffer;
import oracle.javatools.db.diff.ViewDiffer;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReconcileHelper {
    private static Collection<String> m_ignorInReconcile;

    private ReconcileHelper() {
    }

    public static void registerIgnorInReconcile(Collection<String> ignorNames) {
        if (null == m_ignorInReconcile) {
            m_ignorInReconcile = new HashSet<String>(ignorNames);
        } else {
            m_ignorInReconcile.addAll(ignorNames);
        }
    }

    public static boolean isIgnoredInReconcile(String name) {
        return null != m_ignorInReconcile && m_ignorInReconcile.contains(name);
    }

    public static DiffEngine getCoreDiffEngine() {
        DiffEngine de = new DiffEngine();
        de.registerDiffer((Differ)new BeanDiffer(), Object.class);
        de.registerDiffer((Differ)new IndexDiffer(), Index.class);
        de.registerDiffer((Differ)new IndexObjectDiffer(), IndexObject.class);
        de.registerDiffer((Differ)new OldDBObjectDiffer(), DBObject.class);
        de.registerDiffer((Differ)new DataTypeUsageDiffer(), DataTypeUsage.class);
        de.registerDiffer((Differ)new ColumnConstraintDiffer(), ColumnConstraint.class);
        de.registerDiffer((Differ)new FKConstraintDiffer(), FKConstraint.class);
        de.registerDiffer((Differ)new DeclarativeSQLQueryDiffer(), DeclarativeSQLQuery.class);
        de.registerDiffer((Differ)new OldSQLFragmentDiffer(), SQLFragment.class);
        de.registerDiffer((Differ)new SourceObjectDiffer(), SourceObject.class);
        de.registerDiffer((Differ)new SpecPlSqlDiffer(), SpecPlSql.class);
        de.registerDiffer((Differ)new TriggerDiffer(), Trigger.class);
        de.registerListDiffer((Differ)new OrderedListDiffer(), Object.class);
        de.registerListDiffer((Differ)new ListDiffer(), Constraint.class);
        de.registerListDiffer((Differ)new ListDiffer(), Index.class);
        de.registerComparator((Comparator)new SQLFragmentComparator(), SQLFragment.class);
        de.registerComparator((Comparator)new DBObjectComparator(), DBObject.class);
        de.registerComparator((Comparator)new DefaultComparator(), Object.class);
        return de;
    }

    public static DiffEngine getDiffEngine() {
        DiffEngine de = ReconcileHelper.getCoreDiffEngine();
        de.registerDiffer((Differ)new GenericSchemaDiffer(), Schema.class);
        de.registerDiffer((Differ)new DBObjectReconcileDiffer(), DBObject.class);
        de.registerDiffer((Differ)new ColumnConstraintReconcileDiffer(), ColumnConstraint.class);
        de.registerDiffer((Differ)new DBObjectIDDiffer(), DBObjectID.class);
        de.registerDiffer((Differ)new DataTypeUsageDifferIgnorSynonyms(), DataTypeUsage.class);
        de.registerDiffer((Differ)new ViewDiffer(), SQLQueryOwner.class);
        de.registerDiffer((Differ)new SynonymDiffer(), Synonym.class);
        de.registerDiffer((Differ)new TableReconcileDiffer(), Table.class);
        de.registerDiffer((Differ)new IndexReconcileDiffer(), Index.class);
        de.registerDiffer((Differ)new OracleStoragePropertiesReconcileDiffer(), OracleStorageProperties.class);
        de.registerDiffer((Differ)new ColumnReconcileDiffer(), Column.class);
        de.registerDiffer((Differ)new OracleColumnPropertiesReconcileDiffer(), OracleColumnProperties.class);
        de.registerDiffer((Differ)new OracleIOTPropertiesReconcileDiffer(), OracleIndexOrganizedTableProperties.class);
        de.registerDiffer((Differ)new OracleExternalTableReconcileDiffer(), OracleExternalTableProperties.class);
        de.registerDiffer((Differ)new OracleTablePartitionsReconcileDiffer(), OracleTablePartitions.class);
        de.registerDiffer((Differ)new TablePartitionReconcileDiffer(), TablePartition.class);
        de.registerDiffer((Differ)new LOBDescriptorReconcileDiffer(), LOBDescriptor.class);
        de.registerDiffer((Differ)new OracleIndexPartitionsReconcileDiffer(), OracleIndexPartitions.class);
        de.registerDiffer((Differ)new IndexPartitionReconcileDiffer(), IndexPartition.class);
        de.registerComparator((Comparator)new DBObjectIDComparator(), DBObjectID.class);
        ReconcileHelper.registerIgnorInReconcile(Arrays.asList("AUTO_GENERATED_SEQUENCE", "AUTO_GENERATED_SEQUENCE_TRIGGER"));
        return de;
    }
}

