/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import oracle.javatools.db.Properties;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.OldDBObjectDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.util.ModelUtil;

public class OracleIndexPartitionsReconcileDiffer
extends OldDBObjectDiffer {
    private Stack<OracleIndexPartitions> _b = new Stack();
    private Stack<Properties> _bProperties = new Stack();
    private Stack<OracleIndexPartitions> _a = new Stack();
    private Stack<Properties> _aProperties = new Stack();
    private static final String PROPERTY_PARTITION_TYPE_GLOBAL_HASH = "GLOBAL HASH";
    private static final String PROPERTY_PARTITION_TYPE_GLOBAL_RANGE = "GLOBAL RANGE";
    private static final String PROPERTY_PARTITION_TYPE_LOCAL = "LOCAL";
    private static final String PROPERTY_PARTITION_TYPE_SUBPARTITION = "SUBPARTITION";
    private static final String PROPERTY_HASH_QUANTITY_TABLESPACES = "tablespaces";
    private static final String PROPERTY_GLOBAL_PARTITION_COLUMNS = "globalPartitionColumns";

    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        ResultSet rsPartitions;
        ResultSet rsGlobalPartitionColumns;
        this._a.push((OracleIndexPartitions)a);
        this._aProperties.push(a != null ? new Properties(a) : null);
        this._b.push((OracleIndexPartitions)b);
        this._bProperties.push(b != null ? new Properties(b) : null);
        boolean res = super.diff(a, b, rs, dc);
        Map props = rs.getAllObjectsMap();
        ResultSet rsPartitionType = (ResultSet)props.get("partitionType");
        boolean isSubpartitioning = false;
        if (rsPartitionType != null) {
            DisplayProps.setAVal(rsPartitionType, this.getPartitionType(DisplayProps.getAVal(rsPartitionType)));
            DisplayProps.setBVal(rsPartitionType, this.getPartitionType(DisplayProps.getBVal(rsPartitionType)));
            if (PROPERTY_PARTITION_TYPE_SUBPARTITION.equals(DisplayProps.getAVal(rsPartitionType)) || PROPERTY_PARTITION_TYPE_SUBPARTITION.equals(DisplayProps.getBVal(rsPartitionType))) {
                isSubpartitioning = true;
                DisplayProps.setDisplay(rsPartitionType, false);
            }
        }
        if ((isSubpartitioning || PROPERTY_PARTITION_TYPE_LOCAL.equals(DisplayProps.getAVal(rsPartitionType)) && PROPERTY_PARTITION_TYPE_LOCAL.equals(DisplayProps.getBVal(rsPartitionType)) || PROPERTY_PARTITION_TYPE_LOCAL.equals(DisplayProps.getAVal(rsPartitionType)) && !ModelUtil.hasLength((String)DisplayProps.getBVal(rsPartitionType)) || PROPERTY_PARTITION_TYPE_LOCAL.equals(DisplayProps.getBVal(rsPartitionType)) && !ModelUtil.hasLength((String)DisplayProps.getAVal(rsPartitionType))) && (rsGlobalPartitionColumns = (ResultSet)props.get(PROPERTY_GLOBAL_PARTITION_COLUMNS)) != null) {
            DisplayProps.setDisplay(rsGlobalPartitionColumns, false);
        }
        if ((rsPartitions = (ResultSet)props.get("partitions")) != null) {
            List partitions = rsPartitions.getAllObjectsList();
            if (partitions == null || partitions.size() == 0) {
                DisplayProps.setDisplay(rsPartitions, false);
            } else if (isSubpartitioning) {
                rsPartitions.setName("subpartitions");
            }
        }
        if (!isSubpartitioning) {
            DisplayProps.setDisplayMapAsFolder(rs, true);
        }
        this._a.pop();
        this._aProperties.pop();
        this._b.pop();
        this._bProperties.pop();
        return res;
    }

    protected boolean isIgnoredProperty(String propertyName) {
        return "name".equals(propertyName) || this._a.peek() == null && this._b.peek() == null || this._a.peek() == null && this.isIgnoredProperty(propertyName, this._bProperties.peek()) || this._b.peek() == null && this.isIgnoredProperty(propertyName, this._aProperties.peek()) || this._a.peek() != null && this._b.peek() != null && this.isIgnoredProperty(propertyName, this._bProperties.peek());
    }

    private boolean isIgnoredProperty(String propertyName, Properties p) {
        return p == null || p.get(propertyName) == null || PROPERTY_HASH_QUANTITY_TABLESPACES.equals(propertyName) && ((Object[])p.get(propertyName)).length == 0;
    }

    private String getPartitionType(String partitionType) {
        return !ModelUtil.hasLength((String)partitionType) ? null : (OracleIndexPartitions.PartitionType.GLOBAL_HASH.name().equals(partitionType) ? PROPERTY_PARTITION_TYPE_GLOBAL_HASH : (OracleIndexPartitions.PartitionType.GLOBAL_RANGE.name().equals(partitionType) ? PROPERTY_PARTITION_TYPE_GLOBAL_RANGE : (OracleIndexPartitions.PartitionType.SUBPARTITION.name().equals(partitionType) ? PROPERTY_PARTITION_TYPE_SUBPARTITION : PROPERTY_PARTITION_TYPE_LOCAL)));
    }
}

