/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Comparator;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.BeanDiffer;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ListDiffer;
import oracle.javatools.db.diff.OrderedListDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.util.ModelUtil;

public class OldDBObjectDiffer
extends BeanDiffer {
    private final String PROPERTY_DATATYPE_USAGE = "dataTypeUsage";

    public boolean diff(Object a, Object b) {
        ResultSet rs = new ResultSet(null, a, b, null, "MAP");
        DiffEngine de = new DiffEngine();
        DiffContext dc = new DiffContext(de, rs);
        de.registerComparator((Comparator)new DBObjectComparator(), DBObject.class);
        de.registerDiffer((Differ)new OldDBObjectDiffer(), DBObject.class);
        de.registerListDiffer((Differ)new OrderedListDiffer(), DBObject.class);
        de.registerListDiffer((Differ)new ListDiffer(), Constraint.class);
        de.registerListDiffer((Differ)new ListDiffer(), Index.class);
        return this.diff(a, b, rs, dc);
    }

    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        String objectName;
        assert (null != a || null != b);
        assert (null == a || a instanceof DBObject);
        assert (null == b || b instanceof DBObject);
        assert ("MAP".equals(rs.getType()));
        String string = objectName = b == null ? ((DBObject)a).getName() : ((DBObject)b).getName();
        if (ModelUtil.hasLength((String)objectName)) {
            rs.setName(objectName);
        }
        if (dc.isTreeRequired() || a != null && b != null || a != null && !(a instanceof SchemaObject) || b != null && !(b instanceof SchemaObject)) {
            boolean attrsSame = this.diffAttributes(a, b, rs, dc);
            boolean listsSame = this.diffLists(a, b, rs, dc);
            rs.setSame(attrsSame && listsSame);
        }
        return true;
    }

    @Deprecated
    protected boolean diffName(Object a, Object b, ResultSet rs) {
        boolean nameSame = false;
        String name = null;
        String aname = null;
        String bname = null;
        if (null != b) {
            bname = ((DBObject)b).getName();
            if (null == bname) {
                bname = "";
            }
            name = bname;
            if (null != a) {
                aname = ((DBObject)a).getName();
                if (null == aname) {
                    aname = "";
                }
                nameSame = aname.equals(bname);
            }
        } else {
            nameSame = false;
            aname = ((DBObject)a).getName();
            if (null == aname) {
                aname = "";
            }
            name = aname;
        }
        ResultSet rName = new ResultSet(rs, nameSame, a, b, name);
        DisplayProps.setAVal(rName, aname);
        DisplayProps.setBVal(rName, bname);
        return nameSame;
    }

    protected boolean diffSubAttributes(String propertyName) {
        return "dataTypeUsage".equals(propertyName);
    }
}

