/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.Properties;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.OldDBObjectDiffer;
import oracle.javatools.db.diff.ResultSet;

public class LOBDescriptorReconcileDiffer
extends OldDBObjectDiffer {
    private Properties _aProperties;
    private Properties _bProperties;
    private static final String PROPERTY_PARTITION_COLUMNS = "columns";
    private static final String PROPERTY_STORAGE = "storage";

    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        this._aProperties = a != null ? new Properties(a) : null;
        this._bProperties = b != null ? new Properties(b) : null;
        boolean res = super.diff(a, b, rs, dc);
        Map props = rs.getAllObjectsMap();
        ResultSet columnsRS = (ResultSet)props.get(PROPERTY_PARTITION_COLUMNS);
        if (columnsRS != null) {
            List columns = columnsRS.getAllObjectsList();
            if (columns == null || columns.size() == 0) {
                DisplayProps.setDisplay(columnsRS, false);
            } else {
                for (ResultSet column : columns) {
                    Map columnProps = column.getAllObjectsMap();
                    Iterator key = columnProps.keySet().iterator();
                    while (key.hasNext()) {
                        ResultSet value = (ResultSet)columnProps.get(key.next());
                        DisplayProps.setDisplay(value, false);
                    }
                }
            }
        }
        return res;
    }

    protected boolean diffSubAttributes(String propertyName) {
        return PROPERTY_STORAGE.equals(propertyName);
    }

    protected boolean isIgnoredProperty(String propertyName) {
        return "name".equals(propertyName) || this._aProperties == null && this._bProperties == null || this._aProperties == null && this._bProperties.get(propertyName) == null || this._bProperties == null && this._aProperties.get(propertyName) == null || this._aProperties != null && this._bProperties != null && this._bProperties.get(propertyName) == null && !"LOBSegName".equals(propertyName);
    }
}

