/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import oracle.javatools.db.Properties;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.OldDBObjectDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;

public class IndexPartitionReconcileDiffer
extends OldDBObjectDiffer {
    private Stack<IndexPartition> _a = new Stack();
    private Stack<Properties> _aProperties = new Stack();
    private Stack<IndexPartition> _b = new Stack();
    private Stack<Properties> _bProperties = new Stack();
    private static final String PROPERTY_SEGMENT_ATTRIBUTES = "segmentAttributes";
    private static final String PROPERTY_SUBPARTITIONS = "subpartitions";
    private static final String PROPERTY_VALUES = "valuesLessThan";

    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        ResultSet rsSegmentAttrs;
        this._a.push((IndexPartition)a);
        this._aProperties.push(a != null ? new Properties(a) : null);
        this._b.push((IndexPartition)b);
        this._bProperties.push(b != null ? new Properties(b) : null);
        boolean res = super.diff(a, b, rs, dc);
        Map props = rs.getAllObjectsMap();
        ResultSet rsValuesLessThan = (ResultSet)props.get(PROPERTY_VALUES);
        if (rsValuesLessThan != null) {
            List values = rsValuesLessThan.getAllObjectsList();
            if (values.size() == 0) {
                DisplayProps.setDisplay(rsValuesLessThan, false);
            } else {
                for (ResultSet rsValue : values) {
                    String value = rsValue.b() != null ? rsValue.b().toString() : (rsValue.a() != null ? rsValue.a().toString() : rsValue.getName());
                    rsValue.setName(value);
                }
            }
        }
        if (this.isSubpartitionOrHashPartition(this._a.peek()) && this.isSubpartitionOrHashPartition(this._b.peek()) && (rsSegmentAttrs = (ResultSet)props.get(PROPERTY_SEGMENT_ATTRIBUTES)) != null) {
            Map saProps = rsSegmentAttrs.getAllObjectsMap();
            for (String propertyName : rsSegmentAttrs.getAllObjectsMap().keySet()) {
                ResultSet rsProperty;
                if ("tablespace".equals(propertyName) || (rsProperty = (ResultSet)saProps.get(propertyName)) == null) continue;
                DisplayProps.setDisplay(rsProperty, false);
            }
        }
        this._a.pop();
        this._aProperties.pop();
        this._b.pop();
        this._bProperties.pop();
        return res;
    }

    protected boolean diffSubAttributes(String propertyName) {
        return PROPERTY_SEGMENT_ATTRIBUTES.equals(propertyName) || PROPERTY_SUBPARTITIONS.equals(propertyName);
    }

    protected boolean isIgnoredProperty(String propertyName) {
        return "parent".equals(propertyName) || this._a.peek() == null && this._b.peek() == null || this._a.peek() == null && this.isIgnoredProperty(propertyName, this._bProperties.peek()) || this._b.peek() == null && this.isIgnoredProperty(propertyName, this._aProperties.peek()) || this._a.peek() != null && this._b.peek() != null && this.isIgnoredProperty(propertyName, this._aProperties.peek()) && this.isIgnoredProperty(propertyName, this._bProperties.peek());
    }

    private boolean isIgnoredProperty(String propertyName, Properties p) {
        return p == null || p.get(propertyName) == null;
    }

    private OracleIndexPartitions.PartitionType getPartitionType(IndexPartition ip) {
        return ip != null && ip.getParent() != null ? ((OracleIndexPartitions)ip.getParent()).getPartitionType() : null;
    }

    private boolean isSubpartitionOrHashPartition(IndexPartition ip) {
        OracleIndexPartitions.PartitionType partitionType = ip != null && ip.getParent() != null ? ((OracleIndexPartitions)ip.getParent()).getPartitionType() : null;
        return partitionType == null || partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH || partitionType == OracleIndexPartitions.PartitionType.LOCAL_HASH || partitionType == OracleIndexPartitions.PartitionType.SUBPARTITION;
    }
}

