/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.AbstractPropertyFilter;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.property.Property;
import oracle.javatools.util.ModelUtil;

public class DefaultPropertyValueFilter
extends AbstractPropertyFilter {
    private boolean m_ignoreMissingDTAs;

    public DefaultPropertyValueFilter(DBObjectProvider source, DBObjectProvider target, boolean ignoreMissingDatatypeAttributes) {
        super(source, target);
        this.m_ignoreMissingDTAs = ignoreMissingDatatypeAttributes;
    }

    protected boolean isFilteredProperty(Difference diff, DBObject original, DBObject updated, String prop) {
        boolean retval = false;
        Object origValue = diff.getOriginalObject();
        Object newValue = diff.getUpdatedObject();
        if (origValue == null && newValue != null) {
            retval = this.isDefaultValue(newValue, updated, prop, this.getSourceProvider());
        } else if (origValue != null && newValue == null) {
            String[] properties = Property.getProperties((String)prop);
            if (updated instanceof MaterializedView && properties.length == 2 && "Comment".equals(properties[1])) {
                if (!(this.getSourceProvider() instanceof Database) && this.getTargetProvider() instanceof Database) {
                    retval = true;
                }
            } else {
                retval = this.isDefaultValue(origValue, original, prop, this.getTargetProvider());
            }
        }
        return retval;
    }

    private boolean isDefaultValue(Object value, DBObject obj, String prop, DBObjectProvider pro) {
        String[] properties;
        boolean retval = false;
        Object defaultValue = pro.getObjectFactory().getExternalDefaultValue(obj, prop);
        if (defaultValue != null) {
            if (ModelUtil.areEqual((Object)defaultValue, (Object)value)) {
                retval = true;
            }
        } else if (obj instanceof DataTypeUsage && (properties = Property.getProperties((String)prop)).length == 2 && "attributeValues".equals(properties[0])) {
            String dtaName = properties[1];
            try {
                DataTypeAttribute dta;
                DataType dt = DataTypeHelper.getDataType((DataTypeUsage)((DataTypeUsage)obj));
                if (dt != null && (dta = dt.getDataTypeAttribute(dtaName)) != null) {
                    retval = !dta.isMandatory();
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger((Object)this).log(Level.WARNING, "Couldn't resolve datatype: " + dbe.getMessage());
            }
        }
        return retval;
    }

    protected boolean ignoreProperty(DBObject obj, String redactedProp) {
        return false;
    }
}

