/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.util.ModelUtil;

public class DataTypeUsageDiffer
implements Differ {
    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        assert (null != a || null != b);
        assert (null == a || a instanceof DataTypeUsage);
        assert (null == b || b instanceof DataTypeUsage);
        assert ("MAP".equals(rs.getType()));
        DataTypeUsage dtua = (DataTypeUsage)a;
        DataTypeUsage dtub = (DataTypeUsage)b;
        String ddla = null;
        String ddlb = null;
        if (null != dtua) {
            ddla = DataTypeHelper.getDDL((DataTypeUsage)dtua);
            DisplayProps.setAVal(rs, ddla);
        }
        if (null != dtub) {
            ddlb = DataTypeHelper.getDDL((DataTypeUsage)dtub);
            DisplayProps.setBVal(rs, ddlb);
        }
        Comparator dtuComparator = dc.getEngine().getComparator(DataTypeUsage.class);
        boolean same = true;
        same &= this.diffDatatypeName(dtua, dtub, rs);
        rs.setSame(same &= this.diffDatatypeAttr(dtua, dtub, rs, dc));
        if (!same) {
            for (ResultSet child : rs.getAllObjectsMap().values()) {
                child.setSame(false);
            }
        }
        return true;
    }

    protected boolean diffDatatypeName(DataTypeUsage a, DataTypeUsage b, ResultSet rs) {
        boolean nameSame = false;
        String name = null;
        String aname = this.getDataTypeName(a);
        String abasename = this.getDataTypeBaseName(a);
        String bname = this.getDataTypeName(b);
        String bbasename = this.getDataTypeBaseName(b);
        if (null != b) {
            name = bname;
            if (null != a) {
                nameSame = abasename.equals(bbasename);
            }
        } else {
            nameSame = false;
            name = aname;
        }
        ResultSet rDatatype = new ResultSet(rs, nameSame, (Object)a, (Object)b, "Datatype");
        DisplayProps.setAVal(rDatatype, aname);
        DisplayProps.setBVal(rDatatype, bname);
        return nameSame;
    }

    protected String getDataTypeName(DataTypeUsage dtu) {
        String name = null;
        try {
            if (null != dtu) {
                DBObject dbo = dtu.getDataTypeID().resolveID();
                name = dbo instanceof SchemaObject ? ((SchemaObject)dbo).getSchema().getName() + "." + dbo.getName() : dbo.getName();
            }
        }
        catch (DBException dbe) {
            DBLog.logStackTrace((Throwable)dbe);
        }
        return name;
    }

    private boolean diffDatatypeAttr(DataTypeUsage a, DataTypeUsage b, ResultSet r, DiffContext dc) {
        ResultSet rAttr;
        Object bVal;
        HashMap copyb;
        boolean result = true;
        DataType dta = null;
        DataType dtb = null;
        try {
            DBObject dbo;
            if (null != a) {
                dbo = a.getDataTypeID().resolveID();
                dta = (DataType)dbo;
            }
            if (null != b) {
                dbo = b.getDataTypeID().resolveID();
                dtb = (DataType)dbo;
            }
        }
        catch (DBException dbe) {
            // empty catch block
        }
        Map attra = null;
        Map attrb = null == b ? null : b.getAttributeValues();
        HashMap hashMap = copyb = null == attrb ? null : new HashMap(attrb);
        if (null != a && null != a.getAttributeValues()) {
            attra = a.getAttributeValues();
            for (String attrName : attra.keySet()) {
                Object aVal = this.getValueOrDefault(dta, a, attrName);
                bVal = null;
                String aValString = DataTypeHelper.getStringAttributeValue((DataTypeUsage)a, (String)attrName);
                if (null != dtb && (dtb.hasDataTypeAttribute(attrName) || null == aVal || attrb != null && attrb.get(attrName) != null)) {
                    bVal = this.getValueOrDefault(dtb, b, attrName);
                    String bValString = DataTypeHelper.getStringAttributeValue((DataTypeUsage)b, (String)attrName);
                    if (bVal != null || !dc.isSrcOffline() || dtb.getDataTypeAttribute(attrName) == null || dtb.getDataTypeAttribute(attrName).isMandatory()) {
                        if (ModelUtil.areEqual((Object)aValString, (Object)bValString) || null == bVal && this.isSynonym(b)) {
                            rAttr = new ResultSet(r, true, (Object)a, (Object)b, attrName);
                            DisplayProps.setAVal(rAttr, aValString);
                            DisplayProps.setBVal(rAttr, bValString);
                        } else {
                            rAttr = new ResultSet(r, false, (Object)a, (Object)b, attrName);
                            DisplayProps.setAVal(rAttr, aValString);
                            DisplayProps.setBVal(rAttr, bValString);
                            result = false;
                        }
                    }
                    copyb.remove(attrName);
                    continue;
                }
                boolean same = this.isSynonym(b);
                rAttr = new ResultSet(r, same, (Object)a, (Object)b, attrName);
                DisplayProps.setAVal(rAttr, aValString);
                result &= same;
            }
        }
        if (null != copyb) {
            for (String attrName : copyb.keySet()) {
                String bValString = DataTypeHelper.getStringAttributeValue((DataTypeUsage)b, (String)attrName);
                bVal = this.getValueOrDefault(dtb, b, attrName);
                Object aVal = null;
                if (null != dta && dta.hasDataTypeAttribute(attrName)) {
                    aVal = this.getValueOrDefault(dta, a, attrName);
                    String aValString = DataTypeHelper.getStringAttributeValue((DataTypeUsage)a, (String)attrName);
                    if (ModelUtil.areEqual((Object)aVal, (Object)bVal) || this.isSynonym(a)) {
                        rAttr = new ResultSet(r, true, (Object)a, (Object)b, attrName);
                        DisplayProps.setAVal(rAttr, aValString);
                        DisplayProps.setBVal(rAttr, bValString);
                        continue;
                    }
                    rAttr = new ResultSet(r, false, (Object)a, (Object)b, attrName);
                    DisplayProps.setAVal(rAttr, aValString);
                    DisplayProps.setBVal(rAttr, bValString);
                    result = false;
                    continue;
                }
                boolean same = this.isSynonym(a);
                rAttr = new ResultSet(r, same, (Object)a, (Object)b, attrName);
                DisplayProps.setBVal(rAttr, bValString);
                result &= same;
            }
        }
        return result;
    }

    protected String getDataTypeBaseName(DataTypeUsage dtu) {
        return this.getDataTypeName(dtu);
    }

    protected boolean isSynonym(DataTypeUsage dtu) {
        return false;
    }

    protected Object getValueOrDefault(DataType dt, DataTypeUsage dtu, String aname) {
        Object result = null;
        if (null != dtu && null == (result = dtu.getAttributeValue(aname)) && dt.hasDataTypeAttribute(aname)) {
            DataTypeAttribute dta = dt.getDataTypeAttribute(aname);
            result = dta.getDefaultValue();
        }
        return result;
    }
}

