/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.OldDBObjectDiffer;
import oracle.javatools.db.diff.ResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnConstraintDiffer
extends OldDBObjectDiffer {
    @Override
    public boolean diff(Object a, Object b) {
        ResultSet rs = new ResultSet(null, a, b, null, "MAP");
        DiffEngine de = new DiffEngine();
        DiffContext dc = new DiffContext(de, rs);
        return this.diff(a, b, rs, dc);
    }

    @Override
    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        assert (null != a || null != b);
        assert (null == a || a instanceof ColumnConstraint);
        assert (null == b || b instanceof ColumnConstraint);
        assert ("MAP".equals(rs.getType()));
        boolean attrsSame = this.diffAttributes((DBObject)a, (DBObject)b, rs, dc);
        Comparator cmp = dc.getEngine().getComparator(Column.class);
        boolean listSame = this.diffColList((ColumnConstraint)a, (ColumnConstraint)b, "columns", rs, dc, cmp);
        rs.setName(b == null ? ((DBObject)a).getName() : ((DBObject)b).getName());
        rs.setSame(attrsSame && listSame);
        return true;
    }

    protected boolean diffColList(ColumnConstraint a, ColumnConstraint b, String listName, ResultSet r, DiffContext dc, Comparator cmp) {
        return this.diffColListForceSame(a, b, listName, r, dc, cmp, false);
    }

    protected boolean diffColListForceSame(ColumnConstraint a, ColumnConstraint b, String listName, ResultSet r, DiffContext dc, Comparator cmp, boolean forceSame) {
        DBObjectID[] aColIDs = a == null ? new DBObjectID[]{} : a.getColumnIDs();
        DBObjectID[] bColIDs = b == null ? new DBObjectID[]{} : b.getColumnIDs();
        List<Column> aCols = ColumnConstraintDiffer.getColumns(a);
        List<Column> bCols = ColumnConstraintDiffer.getColumns(b);
        ResultSet rl = new ResultSet(r, (Object)a, (Object)b, listName, "LIST");
        ArrayList<Column> blist = new ArrayList<Column>();
        if (bCols != null) {
            blist.addAll(bCols);
        }
        ArrayList<Column> added = new ArrayList<Column>();
        ArrayList<Column> removed = new ArrayList<Column>();
        boolean same = true;
        if (aCols != null) {
            for (int i = 0; i < aColIDs.length; ++i) {
                Column ao = aCols.get(i);
                boolean found = false;
                ListIterator bi = blist.listIterator();
                int j = -1;
                while (bi.hasNext()) {
                    Column bo = (Column)bi.next();
                    if (cmp.compare(ao, bo) != 0 && !this.areEqual(aColIDs[i], bColIDs[++j])) continue;
                    bi.remove();
                    ResultSet rm = new ResultSet(rl, (Object)ao, (Object)bo, aCols.indexOf(ao), bCols.indexOf(bo), ao == null ? null : ao.getName(), "MAP");
                    rm.setSame(true);
                    found = true;
                    break;
                }
                if (found) continue;
                removed.add(ao);
                ResultSet rm = new ResultSet(rl, (Object)ao, null, aCols.indexOf(ao), -1, ao == null ? null : ao.getName(), "MAP");
                if (forceSame) {
                    rm.setSame(true);
                }
                same = false;
            }
        }
        for (Column bo : blist) {
            added.add(bo);
            ResultSet rm = new ResultSet(rl, null, (Object)bo, -1, bCols.indexOf(bo), bo == null ? null : bo.getName(), "MAP");
            if (forceSame) {
                rm.setSame(true);
            }
            same = false;
        }
        if (aCols != null && bCols != null) {
            int ai = 0;
            for (int bi = 0; ai < aCols.size() && bi < bCols.size(); ++ai, ++bi) {
                Column bo;
                Column ao = aCols.get(ai);
                if (cmp.compare(ao, bo = bCols.get(bi)) == 0) continue;
                if (removed.contains(bo)) {
                    while (null != bo && removed.contains(bo)) {
                        bo = ++bi < bCols.size() ? bCols.get(bi) : null;
                    }
                    --bi;
                    continue;
                }
                if (added.contains(ao)) {
                    while (null != ao && added.contains(ao)) {
                        ao = ++ai < aCols.size() ? ((List)a).get(ai) : null;
                    }
                    --ai;
                    continue;
                }
                if (this.areEqual(aColIDs[ai], bColIDs[bi])) continue;
                rl.setListReordered(true);
                same = false;
                break;
            }
        }
        rl.setSame(same || forceSame);
        return same;
    }

    static List<Column> getColumns(ColumnConstraint cc) {
        if (cc == null) {
            return null;
        }
        ArrayList<Column> cols = new ArrayList<Column>();
        Relation r = (Relation)cc.getParent();
        if (r != null) {
            for (DBObjectID id : cc.getColumnIDs()) {
                cols.add((Column)r.findOwnedObject(id));
            }
        }
        return cols;
    }

    private boolean areEqual(DBObjectID id1, DBObjectID id2) {
        if (id1 == id2) {
            return true;
        }
        if (id1 == null || id2 == null) {
            return false;
        }
        return id1.equals(id2, false);
    }
}

