/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Properties;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public class BeanDiffer
implements Differ {
    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        assert (null != a || null != b);
        assert ("MAP".equals(rs.getType()));
        boolean attrsSame = this.diffAttributes(a, b, rs, dc);
        boolean listsSame = this.diffLists(a, b, rs, dc);
        if (!ModelUtil.hasLength((String)rs.getName())) {
            String name;
            String string = name = b == null ? a.getClass().getName() : b.getClass().getName();
            if (ModelUtil.hasLength((String)name)) {
                int lastDot = name.lastIndexOf(".");
                int startOfClassName = lastDot < 0 ? 0 : lastDot + 1;
                name = name.substring(startOfClassName);
                rs.setName(name);
            }
        }
        rs.setSame(attrsSame && listsSame);
        return true;
    }

    protected boolean diffAttributes(Object a, Object b, ResultSet r, DiffContext dc) {
        Properties bProps;
        boolean result = true;
        Properties aProps = null;
        Properties properties = bProps = null == b ? null : new Properties(b);
        if (null != a) {
            aProps = new Properties(a);
            for (String propertyName : aProps.keySet()) {
                if (this.isIgnoredProperty(propertyName)) continue;
                Object aVal = aProps.get(propertyName);
                String aValString = aProps.getStringVal(propertyName);
                if (null != bProps && bProps.containsKey(propertyName)) {
                    Object bVal = bProps.get(propertyName);
                    String bValString = bProps.getStringVal(propertyName);
                    if ((aVal instanceof Copyable || bVal instanceof Copyable) && !(aVal instanceof DBObjectID) || aVal instanceof ReferenceID && bVal instanceof ReferenceID) {
                        ResultSet rdtu = new ResultSet(r, aVal, bVal, propertyName, "MAP");
                        dc.getEngine().diff(aVal, bVal, rdtu, dc);
                        result &= rdtu.isSame();
                    } else {
                        ResultSet prs;
                        Object o2;
                        Object o1 = aVal instanceof TemporaryObjectID ? aVal : bVal;
                        Object object = o2 = aVal instanceof TemporaryObjectID ? bVal : aVal;
                        if (ModelUtil.areEqual((Object)o1, (Object)o2)) {
                            prs = new ResultSet(r, true, a, b, propertyName);
                            DisplayProps.setAVal(prs, aValString);
                            DisplayProps.setBVal(prs, bValString);
                        } else {
                            prs = new ResultSet(r, false, a, b, propertyName);
                            DisplayProps.setAVal(prs, aValString);
                            DisplayProps.setBVal(prs, bValString);
                            result = false;
                        }
                    }
                    bProps.remove(propertyName);
                    continue;
                }
                if (aVal == null) continue;
                if (this.diffSubAttributes(propertyName)) {
                    ResultSet rdtu = new ResultSet(r, aVal, null, propertyName, "MAP");
                    dc.getEngine().diff(aVal, null, rdtu, dc);
                } else {
                    ResultSet prs = new ResultSet(r, false, a, b, propertyName);
                    DisplayProps.setAVal(prs, aValString);
                }
                result = false;
            }
        }
        if (null != bProps) {
            for (String propertyName : bProps.keySet()) {
                if (this.isIgnoredProperty(propertyName)) continue;
                if (this.diffSubAttributes(propertyName)) {
                    Object bVal = bProps.get(propertyName);
                    ResultSet rdtu = new ResultSet(r, null, bVal, propertyName, "MAP");
                    dc.getEngine().diff(null, bVal, rdtu, dc);
                } else {
                    String bValString = bProps.getStringVal(propertyName);
                    ResultSet rAttr = new ResultSet(r, false, a, b, propertyName);
                    DisplayProps.setBVal(rAttr, bValString);
                }
                result = false;
            }
        }
        return result;
    }

    protected boolean diffSubAttributes(String propertyName) {
        return false;
    }

    protected boolean isIgnoredProperty(String name) {
        return false;
    }

    protected boolean diffLists(Object a, Object b, ResultSet r, DiffContext dc) {
        Properties aprops = a != null ? new Properties(a) : null;
        Properties bprops = b != null ? new Properties(b) : null;
        return this.diffLists(a, aprops, b, bprops, r, dc);
    }

    protected boolean diffLists(Object a, Properties aprops, Object b, Properties bprops, ResultSet r, DiffContext dc) {
        Iterator i;
        boolean result = true;
        Iterator iterator = null != aprops ? aprops.childKeySet().iterator() : (i = null != bprops ? bprops.childKeySet().iterator() : null);
        if (i != null) {
            while (i.hasNext()) {
                Object[] barray;
                Object[] aarray;
                String listName = (String)i.next();
                if (this.isIgnoredProperty(listName)) continue;
                ResultSet rl = new ResultSet(r, a, b, listName, "LIST");
                List<Object> aList = null;
                List<Object> bList = null;
                if (null != a && null != (aarray = (Object[])aprops.get(listName))) {
                    aList = Arrays.asList(aarray);
                }
                if (null != b && null != (barray = (Object[])bprops.get(listName))) {
                    bList = Arrays.asList(barray);
                }
                dc.getEngine().diff(aList, bList, rl, dc);
                result = result && rl.isSame();
            }
        }
        return result;
    }
}

