/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.derby;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.derby.DerbyDatabase;
import oracle.javatools.db.derby.DerbyDatabaseDescriptor;
import oracle.javatools.db.derby.DerbyDatabaseImpl;

public class DerbyDatabaseFactory
extends BaseDatabaseCreator {
    public DerbyDatabaseFactory() {
        this.registerProviderClass(DerbyDatabaseImpl.class, DBArb.getString((int)427), (DataTypeRegistry.Registerer)new DerbyDatabaseImpl.Registerer());
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        int t = this.getType(conn);
        switch (t) {
            case 1: {
                return new DerbyDatabaseImpl(connStore, connName, conn);
            }
        }
        return null;
    }

    protected int getType(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String dbName = dmd.getDatabaseProductName();
                String apache = DBArb.getString((int)427).split(" ")[0];
                if (dbName.startsWith(apache)) {
                    int v = dmd.getDatabaseMajorVersion();
                    return 1;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (DerbyDatabase.class.isAssignableFrom(providerClass)) {
            return new DerbyDatabaseDescriptor(providerClass);
        }
        return null;
    }
}

