/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.derby;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.derby.DerbyDDLGenerator;
import oracle.javatools.db.derby.DerbyDatabase;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyDatabaseDescriptor<T extends DerbyDatabase>
extends JdbcDatabaseDescriptor<T> {
    public static final int MAX_NAME_LENGTH = 128;
    public static final char QUOTE_IDENTIFIER = '\"';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIGINT", "BIT", "BOOLEAN", "BOTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CHAR", "CHARACTER", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOUBLE", "DROP", "ELSE", "END", "END-EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "FUNCTION", "GET", "GETCURRENTCONNECTION", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LAST", "LEFT", "LIKE", "LOWER", "LTRIM", "MATCH", "MAX", "MIN", "MINUTE", "NATIONAL", "NATURAL", "NCHAR", "NVARCHAR", "NEXT", "NO", "NONE", "NOT", "NULL", "NULLIF", "NUMERIC", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVER", "OVERLAPS", "PAD", "PARTIAL", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "ROW_NUMBER", "RTRIM", "SCHEMA", "SCROLL", "SECOND", "SELECT", "SESSION_USER", "SET", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTR", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USER", "USING", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "XML", "XMLEXISTS", "XMLPARSE", "XMLQUERY", "XMLSERIALIZE", "YEAR"));

    public DerbyDatabaseDescriptor(Class<? extends T> clz) {
        super(clz);
    }

    @Override
    public int getCasePolicy() {
        return 2;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String type) {
        return 128;
    }

    @Override
    public void validateName(String type, String name) throws InvalidNameException {
        DerbyDatabaseDescriptor.validateIdentifier((String)name, (char)'\"', (int)128, (String)"_", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy());
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider pro) {
        Map<String, DBObjectValidator> v = super.getValidators(pro);
        return v;
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new DerbyDDLGenerator(pro);
    }

    @Override
    public String getDatabaseType() {
        return "Derby";
    }

    @Override
    public int getDatabaseVersion() {
        int retval = 1;
        return retval;
    }
}

