/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.jdbc.JdbcTableBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB2TableBuilder
extends JdbcTableBuilder<Table> {
    public DB2TableBuilder(JdbcDatabase jdbcDatabase, String string) {
        super(jdbcDatabase, string);
    }

    @Override
    public void fillInObject(Table rel) throws DBException {
        try {
            Connection conn = this.getConnection();
            DatabaseMetaData dmd = conn.getMetaData();
            this.fillInColumns((Relation)rel, dmd);
            this.fillInConstraints((Relation)rel, dmd, conn);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        this.buildIndexes(rel);
    }

    @Override
    protected boolean validPKTable(Connection conn, String pkTableName, String pkSchemaName) {
        try {
            Statement stmt = conn.createStatement();
            String queryString = "select table_name, table_schem from SYSIBM.SQLTABLES where table_type = 'TABLE' and table_name = '" + pkTableName + "' and table_schem = '" + pkSchemaName + "'";
            ResultSet rs = stmt.executeQuery(queryString);
            if (rs.next()) {
                rs.close();
                return true;
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected void findUniqueKeys(Connection conn, Relation rel, List list) {
        try {
            Statement stmt = conn.createStatement();
            String queryString = "select constname, tabname from SYSCAT.TABCONST where type = 'U' and tabname = '" + rel.getName() + "'";
            ResultSet rs = stmt.executeQuery(queryString);
            while (rs.next()) {
                String ukName = rs.getString(1);
                UniqueConstraint con = new UniqueConstraint(ukName, rel);
                con.setID((DBObjectID)new NameBasedID("CONSTRAINT", ukName, rel.getID()));
                String colQuery = "select colname from syscat.keycoluse where constname = '" + ukName + "'" + " and tabname = '" + rel.getName() + "'" + " and tabschema = '" + rel.getSchema().getName() + "'" + " order by colseq";
                Statement stmt2 = conn.createStatement();
                ResultSet rs2 = stmt2.executeQuery(colQuery);
                while (rs2.next()) {
                    String colName = rs2.getString(1);
                    Column column = rel.getColumn(colName);
                    if (column == null) continue;
                    con.addColumn(column);
                }
                if (con.getColumns().length > 0) {
                    rel.addConstraint((Constraint)con);
                    list.add(con);
                }
                rs2.close();
            }
            rs.close();
        }
        catch (SQLException ex) {
            // empty catch block
        }
    }
}

