/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.SQLServer.SQLServer2005;
import oracle.javatools.db.SQLServer.SQLServer2008;
import oracle.javatools.db.SQLServer.SQLServerDatabase;
import oracle.javatools.db.SQLServer.SQLServerDatabaseDescriptor;
import oracle.javatools.db.SQLServer.SQLServerDatabaseImpl;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.util.Version;

public class SQLServerDatabaseFactory
extends BaseDatabaseCreator {
    private Map<String, DatabaseDescriptor> m_descriptors = new HashMap<String, DatabaseDescriptor>();

    public SQLServerDatabaseFactory() {
        this.registerProviderClass(SQLServerDatabaseImpl.class, 401, (DataTypeRegistry.Registerer)new SQLServerDatabaseImpl.Registerer());
        this.registerProviderClass(SQLServer2005.class, 402, (DataTypeRegistry.Registerer)new SQLServer2005.Registerer());
        this.registerProviderClass(SQLServer2008.class, 403, (DataTypeRegistry.Registerer)new SQLServer2008.Registerer());
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        int t = this.getSQLServerConnectionVersion(conn);
        switch (t) {
            case 0: {
                return null;
            }
            case 10: {
                return new SQLServer2008(connStore, connName, conn);
            }
            case 9: {
                return new SQLServer2005(connStore, connName, conn);
            }
        }
        return new SQLServerDatabaseImpl(connStore, connName, conn);
    }

    protected int getSQLServerConnectionVersion(Connection conn) {
        int majorVer;
        block6: {
            majorVer = 0;
            if (conn != null) {
                try {
                    DatabaseMetaData dmd = conn.getMetaData();
                    String databaseName = dmd.getDatabaseProductName();
                    if (databaseName.indexOf("Microsoft SQL Server") <= -1) break block6;
                    try {
                        majorVer = dmd.getDatabaseMajorVersion();
                    }
                    catch (Throwable t) {
                        Statement stmt = conn.createStatement();
                        ResultSet r = stmt.executeQuery("select SERVERPROPERTY('ProductVersion')");
                        while (r.next()) {
                            Version productVer = new Version(r.getString(1));
                            int[] versionParts = productVer != null ? productVer.toIntArray() : null;
                            if (versionParts == null) continue;
                            majorVer = versionParts[0];
                        }
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return majorVer;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (SQLServerDatabase.class.isAssignableFrom(providerClass)) {
            SQLServerDatabaseDescriptor descriptor = this.m_descriptors.get(providerClass.getName());
            if (descriptor == null) {
                descriptor = new SQLServerDatabaseDescriptor(providerClass);
                this.m_descriptors.put(providerClass.getName(), descriptor);
            }
            return descriptor;
        }
        return null;
    }
}

