/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectExpander;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;
import oracle.javatools.db.jdbc.JdbcSynonymBuilder;
import oracle.javatools.db.jdbc.JdbcTableBuilder;
import oracle.javatools.db.jdbc.JdbcViewBuilder;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class JdbcDatabaseImpl
extends AbstractDatabase
implements JdbcDatabase {
    public static final String ODBC_NOT_IMPLEMENTED = "IM001";
    private String m_catalog;
    private Map<String, Schema> m_schemas;
    private String m_quoteString;
    private boolean m_supportsSchemas;
    private DDLGenerator m_defaultGen;
    private Map<String, String> m_metaDataDEBUG = new TreeMap<String, String>();
    private Set<String> m_catalogsDEBUG = new TreeSet<String>();
    private Set<String> m_schemasDEBUG = new TreeSet<String>();

    public JdbcDatabaseImpl(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    @Deprecated
    protected void setDDLGenerator(DDLGenerator gen) {
        this.m_defaultGen = gen;
    }

    @Deprecated
    public oracle.javatools.db.ddl.DDLGenerator getDDLGenerator() {
        if (this.m_defaultGen == null) {
            return super.getDDLGenerator();
        }
        return (oracle.javatools.db.ddl.DDLGenerator)this.m_defaultGen;
    }

    protected String getCatalog() {
        block4: {
            if (this.m_catalog == null) {
                try {
                    Connection conn = this.getConnection();
                    this.m_catalog = conn.getCatalog();
                    if (this.m_catalog == null) {
                        this.m_catalog = "";
                    }
                }
                catch (SQLException ex) {
                    if (JdbcDatabaseImpl.isUnsupportedOperation(ex)) break block4;
                    DBLog.getLogger().log(Level.WARNING, "Error accessing jdbc database metadata", ex);
                    this.m_catalog = null;
                }
            }
        }
        return this.m_catalog;
    }

    protected void registerBuilders() {
        HashSet<String> types = new HashSet<String>();
        try {
            DatabaseMetaData dmd = this.getConnection().getMetaData();
            ResultSet rs = dmd.getTableTypes();
            while (rs.next()) {
                types.add(rs.getString(1).trim());
            }
        }
        catch (SQLException ex) {
            types.clear();
            types.add("TABLE");
        }
        String catalog = this.getCatalog();
        this.registerBuilders(types, catalog);
    }

    protected void registerBuilders(Collection<String> types, String catalog) {
        if (types.contains("TABLE")) {
            this.registerBuilder("TABLE", (DBObjectBuilder)new JdbcTableBuilder(this, catalog));
        }
        if (types.contains("VIEW")) {
            this.registerBuilder("VIEW", (DBObjectBuilder)new JdbcViewBuilder(this, catalog));
        }
        if (types.contains("SYNONYM")) {
            this.registerBuilder("SYNONYM", (DBObjectBuilder)new JdbcSynonymBuilder(this, catalog));
        }
    }

    public PropertyManager getPropertyManager() {
        return null;
    }

    public String getUserName() throws DBException {
        String name = null;
        try {
            DatabaseMetaData dmd = this.getConnection().getMetaData();
            name = dmd.getUserName();
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        return name;
    }

    public boolean hasPriviledge(String type, Schema schema, String priv) {
        if ("CREATE".equals(priv) || "DELETE".equals(priv)) {
            return false;
        }
        return super.hasPriviledge(type, schema, priv);
    }

    public String getIdentifierQuoteString() {
        DatabaseDescriptor desc = this.getDescriptor();
        if (desc == null) {
            if (this.m_quoteString == null) {
                try {
                    DatabaseMetaData dmd = this.getConnection().getMetaData();
                    this.m_quoteString = dmd.getIdentifierQuoteString();
                }
                catch (SQLException ex) {
                    this.m_quoteString = "";
                }
            }
            return this.m_quoteString;
        }
        return super.getIdentifierQuoteString();
    }

    public boolean canCreate(SystemObject object, boolean replace) {
        return false;
    }

    public boolean canDelete(SystemObject object, boolean cascade) {
        return false;
    }

    public void createObjects(SystemObject[] objects, boolean replace) throws DBException {
        for (int i = 0; i < objects.length; ++i) {
            if (!(objects[i] instanceof SchemaObject)) continue;
            this.createObject((SchemaObject)objects[i], replace);
        }
    }

    public void createObject(SchemaObject object, boolean replace) throws DBException {
        throw new DBException((DBObject)object, (Throwable)new UnsupportedOperationException("Object Creation"));
    }

    public void deleteObjects(SystemObject[] objects, boolean cascade) throws DBException {
        for (int i = 0; i < objects.length; ++i) {
            if (!(objects[i] instanceof SchemaObject)) continue;
            this.deleteObject((SchemaObject)objects[i], cascade);
        }
    }

    public void deleteObject(SchemaObject object, boolean cascade) throws DBException {
        throw new DBException((DBObject)object, (Throwable)new UnsupportedOperationException("Object Deletion"));
    }

    public void undeleteObject(SchemaObject object) throws DBException {
        throw new DBException((DBObject)object, (Throwable)new UnsupportedOperationException("Object Undeletion"));
    }

    public void undeleteObjects(SchemaObject[] objects) throws DBException {
        throw new DBException((Throwable)new UnsupportedOperationException("Object Undletion"));
    }

    public void validateObject(DBObject object) throws ValidationException {
    }

    public void validateObject(DBObject original, DBObject update) throws ValidationException {
    }

    public void updateObjects(Difference rs, boolean replace, boolean cascade) throws DBException {
        for (Difference rs1 : rs.getChildren()) {
            DBObject orig = (DBObject)rs1.getOriginalObject();
            DBObject update = (DBObject)rs1.getUpdatedObject();
            if (!(orig instanceof SchemaObject) && !(update instanceof SchemaObject)) continue;
            this.updateObject((SchemaObject)orig, (SchemaObject)update);
        }
    }

    public void updateObject(SchemaObject oldObject, SchemaObject newObject) throws DBException {
        throw new DBException((DBObject)oldObject, (Throwable)new UnsupportedOperationException("Object Update"));
    }

    public Schema getSchema(String name) throws DBException {
        Schema schema;
        this.loadSchemasImpl();
        if (name == null) {
            name = "";
        }
        if ((schema = this.m_schemas.get(name)) == null && this.getCasePolicy() != 3 && this.getQuotedNameCasePolicy() != 3) {
            Iterator<String> k = this.m_schemas.keySet().iterator();
            while (k.hasNext()) {
                Schema s = this.m_schemas.get(k.next());
                if (!name.equalsIgnoreCase(s.getName())) continue;
                schema = s;
                break;
            }
        }
        return schema;
    }

    public boolean isUseSchema() {
        try {
            this.loadSchemasImpl();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return this.m_supportsSchemas;
    }

    public Schema[] listSchemas() throws DBException {
        return this.listSchemas(true);
    }

    public Schema[] listSchemas(boolean showAll) throws DBException {
        this.loadSchemasImpl();
        Collection<Schema> list = this.m_schemas.values();
        return list.toArray(new Schema[list.size()]);
    }

    public boolean canCreate(Schema schema, boolean replace) {
        return false;
    }

    public void createSchema(Schema schema, boolean replace) throws DBException {
        throw new DBException((DBObject)schema, (Throwable)new UnsupportedOperationException("Create Schema"));
    }

    public boolean canDelete(Schema schema, boolean cascade) {
        return false;
    }

    public void deleteSchema(Schema schema, boolean cascade) throws DBException {
        throw new DBException((DBObject)schema, (Throwable)new UnsupportedOperationException("Schema Deletion"));
    }

    public void updateSchema(Schema oldSchema, Schema newSchema) throws DBException {
        throw new DBException((DBObject)oldSchema, (Throwable)new UnsupportedOperationException("Schema Update"));
    }

    public boolean catalogIsSchema() {
        return false;
    }

    private void loadSchemasImpl() throws DBException {
        if (this.m_schemas == null) {
            this.m_supportsSchemas = true;
            this.m_schemas = this.getSchemasImpl();
            if (this.m_schemas.size() == 0) {
                this.m_supportsSchemas = false;
                Schema defaultSchema = this.createSchema("");
                defaultSchema.setProperty("isDefaultSchema", (Object)Boolean.TRUE);
                this.m_schemas.put("", defaultSchema);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Schema> getSchemasImpl() throws DBException {
        TreeMap<String, Schema> schemas = new TreeMap<String, Schema>();
        ResultSet rs = null;
        try {
            String name;
            DatabaseMetaData dmd = this.getConnection().getMetaData();
            rs = dmd.getSchemas();
            while (rs.next()) {
                name = rs.getString(1);
                schemas.put(name, this.createSchema(name));
            }
            if (schemas.size() == 0 && this.catalogIsSchema()) {
                rs = dmd.getCatalogs();
                while (rs.next()) {
                    name = rs.getString(1);
                    schemas.put(name, this.createSchema(name));
                }
            }
        }
        catch (SQLException ex) {
            if (!JdbcDatabaseImpl.isUnsupportedOperation(ex)) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        return schemas;
    }

    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> criteria) throws DBException {
        Schema schema = this.getSchema(criteria.getSchemaName());
        String[] objectTypes = criteria.getTypeArray();
        String ref = criteria.getNameLike();
        return this.listObjectsImpl(objectTypes, schema, ref);
    }

    protected Collection<SystemObject> listObjectsImpl(String[] objectTypes, Schema schema, String ref) throws DBException {
        ArrayList<SystemObject> l = new ArrayList<SystemObject>();
        boolean moreRows = false;
        ResultSet rs = null;
        DatabaseMetaData dmd = null;
        String schemaName = this.isUseSchema() && schema != null ? schema.getName() : null;
        String catalogName = this.catalogIsSchema() ? schemaName : this.m_catalog;
        String tableName = this.getNameForDriver(ref);
        try {
            dmd = this.getConnection().getMetaData();
            String dbProductName = dmd.getDatabaseProductName();
            if ("EXCEL".equals(dbProductName)) {
                objectTypes = null;
                if ("%".equals(ref)) {
                    tableName = null;
                }
            }
            try {
                rs = dmd.getTables(catalogName, this.getNameForDriver(schemaName), tableName, objectTypes);
                moreRows = rs.next();
                if (!moreRows) {
                    rs = dmd.getTables(catalogName, null, tableName, objectTypes);
                    moreRows = rs.next();
                }
            }
            catch (SQLException ex) {
                if (!JdbcDatabaseImpl.isUnsupportedOperation(ex)) {
                    rs = dmd.getTables(catalogName, null, null, objectTypes);
                    moreRows = rs.next();
                }
                throw ex;
            }
            while (moreRows) {
                DBObjectBuilder builder;
                AbstractBuildableObject object = null;
                String rsCat = rs.getString(1);
                String rsSchema = this.catalogIsSchema() ? rsCat : rs.getString(2);
                String rsName = rs.getString(3);
                String rsType = rs.getString(4);
                if ("EXCEL".equals(dbProductName) && "SYSTEM TABLE".equals(rsType)) {
                    rsType = "TABLE";
                }
                if (this.catalogMatches(catalogName, rsCat) && this.schemaMatches(schemaName, rsSchema) && this.tableMatches(ref, rsName) && (builder = this.getBuilderForType(rsType)) != null) {
                    Schema objSchema = this.getSchema(rsSchema);
                    NameBasedID id = new NameBasedID(rsType, JdbcDatabaseImpl.convertObject((DBObject)objSchema), rsName, (AbstractDBObjectProvider)this);
                    object = (AbstractBuildableObject)builder.createObject(rsName, objSchema, (DBObjectID)id);
                }
                if (object != null) {
                    this.markForLazyInit(object);
                    l.add((SystemObject)object);
                }
                moreRows = rs.next();
            }
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        return l;
    }

    protected void registerExpanders() {
        this.registerSchemaObjectExpander((SchemaObjectExpander)new TemplateExpander((DBObjectProvider)this));
    }

    public String normaliseDataTypeName(String dmdDataTypeName) {
        return dmdDataTypeName;
    }

    public String normaliseDefaultValue(DataType dataType, String defaultValue) {
        return defaultValue;
    }

    public String getNameForDriver(String name) {
        return name;
    }

    private boolean catalogMatches(String requestedCatalog, String returnedCatalog) {
        return !ModelUtil.hasLength((String)requestedCatalog) || !ModelUtil.hasLength((String)returnedCatalog) || this.nameMatches(requestedCatalog, returnedCatalog);
    }

    private boolean schemaMatches(String requestedSchema, String returnedSchema) {
        try {
            this.loadSchemasImpl();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return !this.m_supportsSchemas || !ModelUtil.hasLength((String)requestedSchema) || this.nameMatches(requestedSchema, returnedSchema);
    }

    private boolean nameMatches(String requestedName, String returnedName) {
        if (!ModelUtil.hasLength((String)returnedName) || !ModelUtil.hasLength((String)requestedName)) {
            return false;
        }
        return this.getCasePolicy() == 3 || this.getQuotedNameCasePolicy() == 3 ? ModelUtil.areEqual((Object)requestedName, (Object)returnedName) : ModelUtil.areEqual((Object)requestedName.toLowerCase(), (Object)returnedName.toLowerCase());
    }

    private boolean tableMatches(String ref, String rsName) {
        String regEx = ref == null ? ".*" : ref.replaceAll("%", ".*");
        return this.nameMatches(ref, rsName) || rsName.matches(regEx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDatabaseMetaData(DatabaseMetaData dmd) {
        ResultSet rs = null;
        try {
            this.m_metaDataDEBUG.clear();
            this.m_metaDataDEBUG.put("Database name", dmd.getDatabaseProductName());
            this.m_metaDataDEBUG.put("Database version", dmd.getDatabaseProductVersion());
            this.m_metaDataDEBUG.put("Driver name", dmd.getDriverName());
            this.m_metaDataDEBUG.put("Driver version", dmd.getDriverVersion());
            this.m_metaDataDEBUG.put("Catalog name", this.m_catalog);
            this.m_metaDataDEBUG.put("Identifier quote", dmd.getIdentifierQuoteString());
            this.m_metaDataDEBUG.put("Case sensitive identifiers", dmd.supportsMixedCaseIdentifiers() ? "YES" : "NO");
            this.m_metaDataDEBUG.put("Case sensitive quoted identifiers", dmd.supportsMixedCaseQuotedIdentifiers() ? "YES" : "NO");
            this.m_metaDataDEBUG.put("Store case insensitive identifiers in lower case", dmd.storesLowerCaseIdentifiers() ? "YES" : "NO");
            this.m_metaDataDEBUG.put("Store case insensitive quoted identifiers in lower case", dmd.storesLowerCaseQuotedIdentifiers() ? "YES" : "NO");
            this.m_metaDataDEBUG.put("Store case insensitive identifiers in upper case", dmd.storesUpperCaseIdentifiers() ? "YES" : "NO");
            this.m_metaDataDEBUG.put("Store case insensitive quoted identifiers in upper case", dmd.storesUpperCaseQuotedIdentifiers() ? "YES" : "NO");
            this.m_metaDataDEBUG.put("Store case insensitive identifiers in mixed case", dmd.storesMixedCaseIdentifiers() ? "YES" : "NO");
            this.m_metaDataDEBUG.put("Store case insensitive quoted identifiers in mixed case", dmd.storesMixedCaseQuotedIdentifiers() ? "YES" : "NO");
            this.m_catalogsDEBUG.clear();
            rs = dmd.getCatalogs();
            while (rs.next()) {
                this.m_catalogsDEBUG.add(rs.getString(1));
            }
            rs.close();
            this.m_schemasDEBUG.clear();
            rs = dmd.getSchemas();
            while (rs.next()) {
                this.m_schemasDEBUG.add(rs.getString(1));
            }
        }
        catch (SQLException x) {
            String msg = x.getMessage();
            boolean i = true;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    static void checkUnsupportedOperation(SQLException ex) throws SQLException {
        if (!JdbcDatabaseImpl.isUnsupportedOperation(ex)) {
            throw ex;
        }
    }

    static boolean isUnsupportedOperation(SQLException ex) {
        return JdbcDDLDatabase.isUnsupportedOperation(ex);
    }

    static {
        DataTypeRegistry.registerGenericJdbcClass(JdbcDatabaseImpl.class);
    }
}

