/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.diff.GenericIDComparator;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.diff.ResultSetApplier;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DummyDBObjectProvider
extends AbstractDBObjectProvider {
    private final String m_name;
    private final DatabaseDescriptor m_desc;
    private final String[] m_types;
    private String m_defSchema;
    private Map<String, DBObject> m_templates;
    private Collection<String> m_builtInSchemaNames;

    public DummyDBObjectProvider(String name, DatabaseDescriptor descriptor) {
        this.m_name = name;
        this.m_desc = descriptor;
        TreeSet<String> types = new TreeSet<String>();
        Map map = this.m_desc.getValidators((DBObjectProvider)this);
        for (Map.Entry entry : map.entrySet()) {
            String type = (String)entry.getKey();
            this.registerValidator(type, (DBObjectValidator)entry.getValue());
            if (!Metadata.getInstance().isSchemaObject(type)) continue;
            types.add(type);
        }
        this.m_types = types.toArray(new String[types.size()]);
        this.m_builtInSchemaNames = new ArrayList<String>();
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        for (String schemaName : dtr.listComplexTypeSchemas(this.m_desc.getDatabaseClass())) {
            Schema schema = new Schema(schemaName);
            try {
                this.createSchema(schema, false);
                this.createObjects((SystemObject[])dtr.listComplexTypes(schemaName, this.m_desc.getDatabaseClass()), false);
                this.m_builtInSchemaNames.add(schemaName);
            }
            catch (DBException e) {
                // empty catch block
            }
        }
    }

    protected String getName() {
        return this.m_name;
    }

    public DatabaseDescriptor getDescriptor() {
        return this.m_desc;
    }

    public DiffEngine getDiffEngine() {
        return GenericDiffEngine.getDiffEngine((boolean)true);
    }

    protected void registerExpanders() {
    }

    public String[] listObjectTypes() {
        return this.m_types;
    }

    public boolean canCreate(SystemObject object, boolean replace) {
        if (!replace) {
            try {
                return DBUtil.getProviderDefinition((DBObject)object, (DBObjectProvider)this) == null;
            }
            catch (DBException dbe) {
                this.getLogger().log(Level.WARNING, "Couldn't check create permissions:  " + dbe.getMessage());
            }
        }
        return true;
    }

    public void createObjects(SystemObject[] objects, boolean replace) throws DBException {
        HashMap<Schema, ArrayList<SystemObject>> objs = new HashMap<Schema, ArrayList<SystemObject>>();
        for (SystemObject so : objects) {
            Schema realSchema;
            if (!replace && DBUtil.getProviderDefinition((DBObject)so, (DBObjectProvider)this) != null) {
                throw new NameInUseException((DBObject)so);
            }
            Schema s = so instanceof Schema ? null : DBUtil.getSchema((DBObject)so);
            Schema schema = realSchema = s == null ? null : this.getSchema(s.getName());
            if (s == null && s instanceof SchemaObject) {
                throw new ValidationException((DBObject)so, "Object must have a Schema");
            }
            if (s != null && realSchema == null) {
                throw new ValidationException((DBObject)so, "Schema does not exist");
            }
            ArrayList<SystemObject> objList = (ArrayList<SystemObject>)objs.get(s);
            if (objList == null) {
                objList = new ArrayList<SystemObject>();
                objs.put(s, objList);
            }
            objList.add(so);
        }
        TreeMap<DBObjectID, DBObjectID> idMap = new TreeMap<DBObjectID, DBObjectID>((Comparator<DBObjectID>)new GenericIDComparator(false));
        for (SystemObject so : objects) {
            this.ensureID((DBObject)so, idMap);
        }
        for (SystemObject so : objects) {
            this.replaceReferenceIDs((DBObject)so, idMap);
            this.cacheObject(so, false);
        }
        for (Schema s : objs.keySet()) {
            if (s == null) continue;
            Collection objList = (Collection)objs.get(s);
            this.fireObjectsAdded(s, objList.toArray(new SchemaObject[objList.size()]));
        }
    }

    private void ensureID(DBObject obj, Map<DBObjectID, DBObjectID> idMap) {
        DBObjectID oldID = obj.getID();
        if (oldID instanceof BaseObjectID) {
            return;
        }
        IdentifierBasedID newID = new IdentifierBasedID(obj, (Object)UUID.randomUUID().toString(), (AbstractDBObjectProvider)this);
        if (oldID != null) {
            idMap.put(oldID, (DBObjectID)newID);
        }
        obj.setID((DBObjectID)newID);
        for (DBObject kid : obj.getOwnedObjects()) {
            this.ensureID(kid, idMap);
        }
    }

    private void replaceReferenceIDs(DBObject obj, Map<DBObjectID, DBObjectID> idMap) {
        obj.replaceReferenceIDs(idMap);
        for (DBObject kid : obj.getOwnedObjects()) {
            this.replaceReferenceIDs(kid, idMap);
        }
    }

    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> criteria) throws DBException {
        TreeSet<SystemObject> retval = new TreeSet<SystemObject>(DBUtil.getNameComparator());
        if (criteria.isUserOnly() && criteria.getTypes().contains("SCHEMA")) {
            for (SystemObject so : this.listObjectsFromCache(criteria)) {
                if (so instanceof Schema && this.m_builtInSchemaNames.contains(so.getName())) continue;
                retval.add(so);
            }
        } else {
            retval.addAll(this.listObjectsFromCache(criteria));
        }
        return retval;
    }

    public void deleteObjects(SystemObject[] objects, boolean cascade) throws DBException {
        SchemaObjectManager som = this.getCascadeManager();
        for (SystemObject so : objects) {
            Collection deps = som.listTopLevelReferers((SystemObject)((SchemaObject)so), false);
            if (deps.size() <= 0 || cascade) continue;
            throw new CascadeRequiredException((DBObject)so, deps);
        }
        for (SystemObject so : objects) {
            this.uncacheObject(so);
        }
    }

    public void undeleteObject(SchemaObject object) throws DBException {
        throw new UnsupportedOperationException("undelete not supported");
    }

    public void undeleteObjects(SchemaObject[] objects) throws DBException {
        throw new UnsupportedOperationException("undelete not supported");
    }

    public boolean canDelete(SystemObject object, boolean cascade) {
        return true;
    }

    public boolean canDelete(Schema schema, boolean cascade) {
        return true;
    }

    public void updateObjects(Difference rs, boolean replace, boolean cascade) throws DBException {
        if (!rs.isSame()) {
            ResultSetApplier rsa = new ResultSetApplier();
            rsa.apply(rs);
            for (DBObjectChange doc : rsa.fireEvents()) {
                this.fireSchemaObjectUpdated(doc);
            }
        }
    }

    public Schema getDefaultSchema() throws DBException {
        Schema[] schemas;
        Schema retval = null;
        if (ModelUtil.hasLength((String)this.m_defSchema)) {
            retval = this.getSchema(this.m_defSchema);
        }
        if (retval == null && (schemas = this.listSchemas(false)) != null && schemas.length > 0) {
            retval = schemas[0];
        }
        return retval;
    }

    public void setDefautSchema(String name) {
        this.m_defSchema = name;
    }

    public void createSchema(Schema schema, boolean replace) throws DBException {
        this.createObject((SystemObject)schema, replace);
        if (this.m_builtInSchemaNames.contains(schema.getName())) {
            this.m_builtInSchemaNames.remove(schema.getName());
        }
        this.fireSchemaAdded(schema);
    }

    public void updateSchema(Schema oldSchema, Schema newSchema) throws DBException {
        String name = newSchema.getName();
        Schema realOldSchema = this.getSchema(name);
        if (realOldSchema == null) {
            throw new DBException((DBObject)newSchema, "Schema " + name + " doesn't exist to update.");
        }
        ResultSet rs = this.getDiffEngine().diff((Object)realOldSchema, (Object)newSchema).getResult();
        if (!rs.isSame()) {
            ResultSetApplier rsa = new ResultSetApplier();
            rsa.apply((Difference)rs);
            DBObjectChange[] changes = rsa.fireEvents();
            if (changes.length > 0) {
                this.fireSchemaUpdated(changes[0]);
            }
        }
    }

    public void deleteSchema(Schema schema, boolean cascade) throws DBException {
        String name = schema.getName();
        if (this.getSchema(name) == null) {
            throw new DBException((DBObject)schema, "Schema " + name + " doesn't exist to delete.");
        }
        this.deleteObject((SystemObject)schema, cascade);
        this.fireSchemaRemoved(schema);
    }

    public void clear() {
        this.clearAllCaches();
    }

    protected DBObject findByID(DBObjectID id) throws DBException {
        DBObject retval = super.findByID(id);
        if (retval == null && id instanceof NameBasedID) {
            retval = this.getObject(((NameBasedID)id).getType(), new Schema(((NameBasedID)id).getSchemaName()), ((NameBasedID)id).getName());
        }
        return retval;
    }

    public void setDefaultTemplateForType(String type, DBObject template) {
        if (template == null) {
            if (this.m_templates != null) {
                this.m_templates.remove(type);
            }
        } else {
            Class clz = Metadata.getInstance().getObjectClass(type);
            if (clz == null || !clz.isAssignableFrom(template.getClass())) {
                throw new IllegalArgumentException("Invalid template for type " + type);
            }
            this.m_templates = new TreeMap<String, DBObject>();
            this.m_templates.put(type, template);
        }
    }

    public DBObject getDefaultTemplateForType(String type) {
        return this.m_templates == null ? null : this.m_templates.get(type);
    }
}

