/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectExpander;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnSequenceExpander
implements SchemaObjectExpander,
TemplateExpander.Initialiser {
    public static final String NEW_SEQUENCE_NAME = "ColumnSequenceExpander.NewSequenceName";
    public static final String NEW_TRIGGER_NAME = "ColumnSequenceExpander.NewTriggerName";
    public static final String REUSE_SEQUENCE = "ColumnSequenceExpander.ReuseSequence";
    public static final String TRIGGER_NULL_CHECK = "ColumnSequenceExpander.TriggerNullCheck";
    private static final String TEMPLATE_TABLE_SEQ_ID = "ColumnSequenceExpander.TemplateTableSeqID";
    private static final String TEMPLATE_TABLE_TRG_ID = "ColumnSequenceExpander.TemplateTableTrgID";
    private static final String DBL_LEFT_CHEV = "<<";
    private static final String DBL_RIGHT_CHEV = ">>";
    private static final String COLUMN_SEQUENCES = "COLUMN_SEQUENCES";
    private static final String NEWLINE = "\n";
    private static final String DOT = ".";
    private static final String SEMICOLON = ";";
    private static final String COLON = ":";
    private static final String SPACE = " ";
    private static final String SPACE2 = "  ";
    private static final String BEGIN = "BEGIN";
    private static final String SELECT = "SELECT";
    private static final String INTO = "INTO";
    private static final String NEXTVAL = "NEXTVAL";
    private static final String FROM = "FROM";
    private static final String DUAL = "DUAL";
    private static final String END = "END";
    private static final String IF = "IF";
    private static final String THEN = "THEN";
    private static final String IS = "IS";
    private static final String NULL = "NULL";
    private static final String NEW = "NEW";
    private DBObjectProvider m_pro;
    private Set<String> m_existingSequenceNames;

    private ColumnSequenceExpander() {
    }

    public ColumnSequenceExpander(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    public void expand(Difference rs) {
        Schema lastSchema = null;
        ArrayList<SchemaObject> oldSeqsAndTrigs = new ArrayList<SchemaObject>();
        ArrayList<SchemaObject> newSeqsAndTrigs = new ArrayList<SchemaObject>();
        for (Difference objectRS : rs.getChildren()) {
            Object newObj = objectRS.getUpdatedObject();
            if (!(newObj instanceof Table)) continue;
            Table table = (Table)newObj;
            Schema tabSchema = table.getSchema();
            if (!this.isSameSchema(tabSchema, lastSchema)) {
                lastSchema = tabSchema;
                this.populateProviderSequenceNames(tabSchema);
                this.populateRSSequenceNames(tabSchema, rs);
            }
            this.getSecondaryObjects(oldSeqsAndTrigs, newSeqsAndTrigs, objectRS);
        }
        int extraObjsSize = newSeqsAndTrigs.size();
        if (extraObjsSize > 0) {
            if (extraObjsSize != oldSeqsAndTrigs.size()) {
                DBLog.getLogger().severe("Column Sequence expander failed - new and old objects sizes don't match.");
                return;
            }
            SystemObject[] rsOld = null;
            if (rs.getOriginalObject() instanceof List) {
                List l = (List)rs.getOriginalObject();
                rsOld = (SystemObject[])l.toArray();
            } else {
                rsOld = (SystemObject[])rs.getOriginalObject();
            }
            SystemObject[] rsUpdated = null;
            if (rs.getUpdatedObject() instanceof List) {
                List l = (List)rs.getUpdatedObject();
                rsUpdated = (SystemObject[])l.toArray();
            } else {
                rsUpdated = (SystemObject[])rs.getUpdatedObject();
            }
            int newSize = rsOld.length + extraObjsSize;
            Object[] newOld = new SystemObject[newSize];
            Object[] newUpdated = new SystemObject[newSize];
            for (int i = 0; i < rsOld.length; ++i) {
                newOld[i] = rsOld[i];
                newUpdated[i] = rsUpdated[i];
            }
            for (int j = 0; j < extraObjsSize; ++j) {
                newOld[i + j] = (SystemObject)oldSeqsAndTrigs.get(j);
                newUpdated[i + j] = (SystemObject)newSeqsAndTrigs.get(j);
            }
            ResultSet rs2 = this.m_pro.getDiffEngine().diff(newOld, newUpdated).getResult();
            rs2.copyTo((Object)rs);
        }
        this.m_existingSequenceNames = null;
    }

    private void getSecondaryObjects(List<SchemaObject> oldObjs, List<SchemaObject> newObjs, Difference rs) {
        HashMap<String, Sequence> newSequences = new HashMap<String, Sequence>();
        HashMap<String, List<Column>> triggerColumnsMap = new HashMap<String, List<Column>>();
        Table table = (Table)rs.getUpdatedObject();
        for (Column column : table.getColumns()) {
            String trigName;
            String seqSchemaAndName = (String)column.getProperty(NEW_SEQUENCE_NAME);
            String schemaName = null;
            String seqName = null;
            if (NEW_SEQUENCE_NAME.equals(seqSchemaAndName)) {
                seqSchemaAndName = table.getSchema().getName() + NEWLINE + ColumnSequenceExpander.getUniqueName(this.m_pro, "SEQUENCE", table.getSchema(), table.getName());
            }
            if (seqSchemaAndName != null) {
                String[] bits = seqSchemaAndName.split(NEWLINE);
                schemaName = bits[0];
                seqName = bits[1];
                if (!this.isExistingSequence(seqSchemaAndName)) {
                    Sequence seq = (Sequence)newSequences.get(seqSchemaAndName);
                    if (seq == null) {
                        Sequence templateSeq = null;
                        DBObjectID templateSeqID = (DBObjectID)column.getProperty(TEMPLATE_TABLE_SEQ_ID);
                        if (templateSeqID != null) {
                            column.setProperty(TEMPLATE_TABLE_SEQ_ID, null);
                            try {
                                templateSeq = (Sequence)templateSeqID.resolveID();
                            }
                            catch (DBException e) {
                                // empty catch block
                            }
                        }
                        Schema schema = null;
                        try {
                            schema = this.m_pro.getSchema(schemaName);
                            if (schema == null) {
                                schema = new Schema(schemaName);
                                schema.setID(TemporaryObjectID.createID((DBObject)schema));
                            }
                        }
                        catch (DBException e) {
                            // empty catch block
                        }
                        seq = templateSeq != null ? (Sequence)this.m_pro.getObjectFactory().newObject((DBObject)templateSeq, (DBObject)schema) : (Sequence)this.m_pro.getObjectFactory().newObject(Sequence.class, (DBObject)schema);
                        seq.setName(seqName);
                        seq.setID(TemporaryObjectID.createID((DBObject)seq));
                        newSequences.put(seqSchemaAndName, seq);
                    }
                    column.getProperties().remove(NEW_SEQUENCE_NAME);
                    column.setProperty("AUTO_GENERATED_SEQUENCE", (Object)seq.getID());
                }
            }
            if ((trigName = (String)column.getProperty(NEW_TRIGGER_NAME)) == null && column.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER") == null && column.getProperty("AUTO_GENERATED_SEQUENCE") != null) {
                trigName = ColumnSequenceExpander.getUniqueName(this.m_pro, "TRIGGER", table.getSchema(), table.getName());
            }
            if (trigName == null) continue;
            ArrayList<Column> trgColumns = (ArrayList<Column>)triggerColumnsMap.get(trigName);
            if (trgColumns != null) {
                trgColumns.add(column);
                continue;
            }
            trgColumns = new ArrayList<Column>();
            trgColumns.add(column);
            triggerColumnsMap.put(trigName, trgColumns);
        }
        for (Sequence s : newSequences.values()) {
            oldObjs.add(null);
            newObjs.add((SchemaObject)s);
        }
        this.createTriggers(triggerColumnsMap, oldObjs, newObjs, rs);
    }

    private void createTriggers(Map<String, List<Column>> triggerColumnsMap, List<SchemaObject> oldObjs, List<SchemaObject> newObjs, Difference rs) {
        Table table = (Table)rs.getUpdatedObject();
        if (table.getID() == null) {
            table.setID(TemporaryObjectID.createID((DBObject)table));
        }
        for (String trgName : triggerColumnsMap.keySet()) {
            DDLGenerator g;
            Trigger trigger = null;
            Trigger templateTrigger = null;
            DBObjectID templateTrgID = null;
            for (Column column : triggerColumnsMap.get(trgName)) {
                if (templateTrgID == null) {
                    templateTrgID = (DBObjectID)column.getProperty(TEMPLATE_TABLE_TRG_ID);
                }
                column.setProperty(TEMPLATE_TABLE_TRG_ID, null);
            }
            if (templateTrgID != null) {
                try {
                    templateTrigger = (Trigger)templateTrgID.resolveID();
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
            if (templateTrigger == null) {
                templateTrigger = (Trigger)this.m_pro.getDefaultTemplateForType("TRIGGER");
                if (templateTrigger == null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(BEGIN).append(NEWLINE).append(SPACE2).append(DBL_LEFT_CHEV).append(COLUMN_SEQUENCES).append(DBL_RIGHT_CHEV).append(BEGIN).append(SPACE).append(NULL).append(SEMICOLON).append(END).append(SEMICOLON).append(NEWLINE).append(END).append(SEMICOLON);
                    templateTrigger = new Trigger();
                    templateTrigger.setCode(sb.toString());
                    sb.insert(0, "CREATE TRIGGER X BEFORE INSERT ON Y\n");
                    templateTrigger.setSource(sb.toString());
                }
                templateTrigger.setTiming(Trigger.Timing.BEFORE);
                templateTrigger.setEvents(new String[]{"INSERT"});
            }
            trigger = (Trigger)this.m_pro.getObjectFactory().newObject((DBObject)templateTrigger, (DBObject)table.getSchema());
            trigger.setName(trgName);
            trigger.setTableID(table.getID());
            trigger.setBaseType(Trigger.BaseType.TABLE);
            trigger.setStatementLevel(false);
            trigger.setSource(null);
            if (trigger.getID() == null) {
                trigger.setID(TemporaryObjectID.createID((DBObject)trigger));
            }
            if ((g = this.m_pro.getDescriptor().getDDLGenerator(this.m_pro)) == null) {
                DBLog.getLogger().warning("Column Sequence support needs support for DDL Generation.");
            } else {
                try {
                    DDL ddl = g.getCreateDDL(new DDLOptions(true, false), new DBObject[]{trigger});
                    String source = ddl.toString(false);
                    trigger.setSource(source);
                }
                catch (Exception e) {
                    DBLog.getLogger().warning("Column Sequence support needs support for Trigger DDL Generation.");
                }
            }
            TemplateExpander.applySourceFromTemplate((PlSql)templateTrigger, (PlSql)trigger);
            PlSqlInterrogator pi = trigger.getSourceInterrogator();
            PlSqlFragment codeFrag = pi.getRoot().findChild(PlSqlFragment.Type.PLSQL_BLOCK, true);
            PlSqlFragment labelFrag = null;
            PlSqlFragment colSeqFrag = null;
            PlSqlToken tk = pi.skipToCodeToken(codeFrag, codeFrag.getFirstToken(), new String[]{DBL_LEFT_CHEV});
            if (tk != null && tk.getNextCodeToken() != null && tk.getNextCodeToken(2) != null && tk.getNextCodeToken().matches(COLUMN_SEQUENCES) && tk.getNextCodeToken(2).matches(DBL_RIGHT_CHEV) && (labelFrag = pi.getFragmentAtOffset(tk.getEnd())).getFramentType().equals((Object)PlSqlFragment.Type.LABEL)) {
                boolean found = false;
                for (PlSqlFragment frag : labelFrag.getParent().getChildren()) {
                    if (found) {
                        colSeqFrag = frag;
                        break;
                    }
                    if (frag != labelFrag) continue;
                    found = true;
                }
            }
            int insertStart = 0;
            int insertEnd = 0;
            String indent = null;
            if (labelFrag == null || colSeqFrag == null) {
                PlSqlToken tk2 = pi.skipToCodeToken(codeFrag, codeFrag.getFirstToken(), new String[]{BEGIN});
                tk2 = tk2.getNextCodeToken();
                insertEnd = insertStart = trigger.getSource().substring(0, tk2.getStart()).lastIndexOf(NEWLINE) + 1;
                indent = trigger.getSource().substring(insertStart, tk2.getStart());
            } else {
                insertStart = trigger.getSource().substring(0, labelFrag.getFirstToken().getStart()).lastIndexOf(NEWLINE) + 1;
                insertEnd = colSeqFrag.getLastToken().getEnd() + 2;
                indent = trigger.getSource().substring(insertStart, labelFrag.getFirstToken().getStart());
            }
            StringBuffer sb = new StringBuffer();
            sb.append(trigger.getSource().substring(0, insertStart)).append(this.getColSeqBlock(trigger, triggerColumnsMap.get(trgName), indent)).append(trigger.getSource().substring(insertEnd));
            trigger.setSource(sb.toString());
            trigger.setCode(sb.toString().substring(codeFrag.getFirstToken().getStart()));
            oldObjs.add(null);
            newObjs.add((SchemaObject)trigger);
        }
    }

    private boolean isExistingSequence(String seqName) {
        return this.m_existingSequenceNames.contains(seqName);
    }

    private void populateProviderSequenceNames(Schema schema) {
        this.m_existingSequenceNames = new HashSet<String>();
        try {
            String[] names;
            for (String name : names = this.m_pro.listObjects("SEQUENCE", schema)) {
                this.m_existingSequenceNames.add(schema.getName() + DOT + name);
            }
        }
        catch (DBException e) {
            DBLog.getLogger().log(Level.WARNING, "Error listing existing sequences for Column Sequence support: " + e.getMessage());
        }
    }

    private void populateRSSequenceNames(Schema schema, Difference rs) {
        for (Difference rs3 : rs.getChildren()) {
            Sequence seq;
            Object obj = rs3.getUpdatedObject();
            if (!(obj instanceof Sequence) || !this.isSameSchema(schema, (seq = (Sequence)obj).getSchema())) continue;
            this.m_existingSequenceNames.add(schema.getName() + DOT + seq.getName());
        }
    }

    private boolean isSameSchema(Schema s1, Schema s2) {
        return DBUtil.getNameComparator().compare(s1, s2) == 0;
    }

    public void initialiseObject(DBObject template, DBObject object) {
        if ("TABLE".equals(template.getType())) {
            Table templateTable = (Table)template;
            Table newTable = (Table)object;
            for (Column c : templateTable.getColumns()) {
                DBObjectID seqID = (DBObjectID)c.getProperty("AUTO_GENERATED_SEQUENCE");
                if (seqID == null) continue;
                Boolean reuseSeq = (Boolean)c.getProperty(REUSE_SEQUENCE);
                Column c2 = newTable.getColumn(c.getName());
                Sequence seq = null;
                try {
                    seq = (Sequence)seqID.resolveID();
                }
                catch (DBException e) {
                    // empty catch block
                }
                if (reuseSeq == null) {
                    reuseSeq = seq == null || seq.getName().equals(templateTable.getName() + "_SEQ") && seq.getSchema().equals((Object)templateTable.getSchema()) ? Boolean.FALSE : Boolean.TRUE;
                }
                if (!reuseSeq.booleanValue()) {
                    c2.getProperties().remove("AUTO_GENERATED_SEQUENCE");
                    c2.setProperty(NEW_SEQUENCE_NAME, (Object)NEW_SEQUENCE_NAME);
                }
                c2.getProperties().remove("AUTO_GENERATED_SEQUENCE_TRIGGER");
                c2.setProperty(TEMPLATE_TABLE_SEQ_ID, (Object)seqID);
                c2.setProperty(TEMPLATE_TABLE_TRG_ID, c.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER"));
            }
        }
    }

    public static String getUniqueName(DBObjectProvider pro, String type, Schema schema, String tableName) {
        String baseName;
        int maxTableNameLength;
        String name = null;
        String suffix = "SEQUENCE".equals(type) ? "SEQ" : "TRG";
        int n = maxTableNameLength = tableName.length() > 25 ? 25 : tableName.length();
        while (ModelUtil.hasLength((String)(name = pro.getUniqueName(type, (DBObject)schema, baseName = tableName.substring(0, maxTableNameLength--) + '_' + suffix))) && name.length() > 30) {
        }
        name = name != null ? pro.getExternalName(name) : null;
        return name;
    }

    private String getColSeqBlock(Trigger trigger, List<Column> cols, String indent) {
        StringBuffer code = new StringBuffer();
        code.append(indent).append(DBL_LEFT_CHEV).append(COLUMN_SEQUENCES).append(DBL_RIGHT_CHEV).append(NEWLINE).append(indent).append(BEGIN).append(NEWLINE);
        String newTok = trigger.getReferencingNewAs();
        if (newTok == null || newTok.length() == 0) {
            newTok = NEW;
        }
        for (Column column : cols) {
            Relation table = (Relation)column.getParent();
            DBObjectID seqID = (DBObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE");
            if (seqID == null) continue;
            Sequence seq = null;
            try {
                seq = (Sequence)seqID.resolveID();
                String seqName = this.m_pro.getExternalName(seq.getName());
                column.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", (Object)trigger.getID());
                column.getProperties().remove(NEW_TRIGGER_NAME);
                Boolean tnc = (Boolean)column.getProperty(TRIGGER_NULL_CHECK);
                if (tnc == null) {
                    tnc = Boolean.FALSE;
                }
                if (tnc.booleanValue()) {
                    code.append(indent).append(SPACE2).append(IF).append(SPACE).append(COLON).append(newTok).append(DOT).append(this.m_pro.getExternalName(column.getName())).append(SPACE).append(IS).append(SPACE).append(NULL).append(SPACE).append(THEN).append(NEWLINE).append(SPACE2);
                }
                code.append(indent).append(SPACE2).append(SELECT).append(SPACE);
                if (!seq.getSchema().getName().equals(table.getSchema().getName())) {
                    code.append(this.m_pro.getExternalName(seq.getSchema().getName()));
                    code.append(DOT);
                }
                code.append(seqName).append(DOT).append(NEXTVAL).append(SPACE).append(INTO).append(SPACE).append(COLON).append(newTok).append(DOT).append(this.m_pro.getExternalName(column.getName())).append(SPACE).append(FROM).append(SPACE).append(DUAL).append(SEMICOLON).append(NEWLINE);
                if (!tnc.booleanValue()) continue;
                code.append(indent).append(SPACE2).append(END).append(SPACE).append(IF).append(SEMICOLON).append(NEWLINE);
            }
            catch (DBException e) {}
        }
        code.append(indent).append(END).append(SPACE).append(COLUMN_SEQUENCES).append(SEMICOLON).append(NEWLINE);
        return code.toString();
    }

    static {
        TemplateExpander.registerInitialiser((TemplateExpander.Initialiser)new ColumnSequenceExpander());
    }
}

