/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectExpander;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;

public class ColumnMoveExpander
implements SchemaObjectExpander {
    public static final String SOURCE_COLUMN_ID = "ColumnMoveExpander.SOURCE_COLUMN_ID";
    DBObjectProvider m_pro;

    public ColumnMoveExpander(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    public void expand(Difference rs) {
        ArrayList<Object> origObjs = new ArrayList<Object>();
        ArrayList<Object> updObjs = new ArrayList<Object>();
        boolean found = false;
        for (Difference newRS : rs.getChildren()) {
            origObjs.add((SchemaObject)newRS.getOriginalObject());
            updObjs.add((SchemaObject)newRS.getUpdatedObject());
        }
        for (Difference newRS : rs.getChildren()) {
            SchemaObject upd = (SchemaObject)newRS.getUpdatedObject();
            if (!(upd instanceof Table) || !"TABLE".equals(((Table)upd).getType())) continue;
            Table tab = (Table)upd;
            for (Column col : tab.getColumns()) {
                DBObjectID sourceID = (DBObjectID)col.getProperty(SOURCE_COLUMN_ID);
                if (sourceID == null) continue;
                found = true;
                col.setProperty(SOURCE_COLUMN_ID, null);
                try {
                    Column colToDelete;
                    Column colToDeleteInOrigTable = (Column)sourceID.resolveID();
                    if (colToDeleteInOrigTable == null) continue;
                    Table origTable = (Table)colToDeleteInOrigTable.getParent();
                    Table updTable = null;
                    if (origTable == null) continue;
                    for (int i = 0; i < origObjs.size(); ++i) {
                        if (origObjs.get(i) == null || !((SchemaObject)origObjs.get(i)).getID().equals(origTable.getID())) continue;
                        updTable = (Table)updObjs.get(i);
                        break;
                    }
                    if (updTable == null) {
                        origObjs.add(origTable);
                        updTable = (Table)origTable.copyTo(null, true);
                        updObjs.add(updTable);
                    }
                    if ((colToDelete = updTable.getColumn(colToDeleteInOrigTable.getName())) == null) continue;
                    updTable.removeColumn(colToDelete);
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
        }
        if (found) {
            Object[] oa = origObjs.toArray(new SchemaObject[origObjs.size()]);
            Object[] ua = updObjs.toArray(new SchemaObject[updObjs.size()]);
            ResultSet rs2 = this.m_pro.getDiffEngine().diff(oa, ua).getResult();
            rs2.copyTo((Object)rs);
        }
    }
}

