/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

public enum SecurityConstraint {
    NONE("none"),
    SECURE("secure"),
    AUTHENTICATED("authenticated"),
    SECURE_AND_AUTHENTICATED("secure-and-authenticated");

    private final String name;

    public String toString() {
        return this.name;
    }

    private SecurityConstraint(String name) {
        this.name = name;
    }

    public static final SecurityConstraint fromString(String text) {
        SecurityConstraint value = NONE;
        if (text != null) {
            for (SecurityConstraint constraint : SecurityConstraint.values()) {
                if (!text.equals(constraint.toString())) continue;
                value = constraint;
            }
            if ("YES".equalsIgnoreCase(text)) {
                value = SECURE;
            }
        }
        return value;
    }
}

