/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.Closeable;
import java.io.IOException;
import oracle.dbtools.common.config.Configuration;
import oracle.dbtools.common.config.ConfigurationEventListener;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.AuthenticationService;
import oracle.dbtools.rt.cors.CrossOriginResourceSharing;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.web.DispatchLog;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestPaths;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

@Service
public class RequestDispatchers {
    @Reference
    private AuthenticationService auth;
    @Reference
    private CrossOriginResourceSharing cors;
    private boolean enabled = true;
    private final ConfigurationEventListener onConfigChange = new ConfigurationEventListener(){

        public void configurationRemoved(String name) {
        }

        public void configurationChanged(String name, Configuration newConf) {
            RequestDispatchers.this.enable((Boolean)PrimitiveTypes.valueOf((String)newConf.get(RequestDispatchers.RESOURCE_TEMPLATES_ENABLED, "true"), Boolean.class));
        }
    };
    private static final String RESOURCE_TEMPLATES_ENABLED = "resourceTemplates.enabled";

    public RequestDispatcher.Score canDispatch(RequestEntity request) {
        return this.choose(request);
    }

    public HttpResource dispatch(RequestDispatcher.Score score, RequestEntity request) throws IOException {
        if (score == null) {
            score = this.choose(request);
        }
        if (!RequestDispatcher.Score.isMatch(score)) {
            if (DispatchLog.isEnabled()) {
                DispatchLog.log(request.path() + " not found");
            }
            throw WebException.notFound();
        }
        Pair target = (Pair)score.handle();
        score = (RequestDispatcher.Score)target.first();
        RequestDispatcher dispatcher = (RequestDispatcher)target.second();
        if (dispatcher == null) {
            if (DispatchLog.isEnabled()) {
                DispatchLog.log(request.path() + " not found");
            }
            throw WebException.notFound();
        }
        RequestEntity authenticatedRequest = this.authenticate(score, request);
        HttpResource resource = dispatcher.dispatch(score, authenticatedRequest);
        Entity response = resource.response();
        EntityHeader forwardTo = response.headers().header("X-APEX-FORWARD");
        EntityHeadersBuilder additionalHeaders = Entities.headers();
        EntityHeader statusCode = response.headers().header("X-APEX-STATUS-CODE");
        if (statusCode != null) {
            additionalHeaders.header((CharSequence)"X-APEX-STATUS-CODE", statusCode.value());
        }
        if (forwardTo == null) {
            Entity corsReponse = this.cors.process(authenticatedRequest, response, this.isPublicResource(score));
            return new NotForwarded(resource, corsReponse);
        }
        if (DispatchLog.isEnabled()) {
            DispatchLog.log(dispatcher.getClass().getName() + " forwarded request to: " + forwardTo);
        }
        HttpResource forwarded = this.dispatch(null, Requests.forward(authenticatedRequest, forwardTo.value(), true, null));
        return new Forwarded(forwardTo, authenticatedRequest, forwarded, additionalHeaders.build());
    }

    protected void activate(ServiceProperties properties) throws Exception {
        GlobalConfiguration.globalConfiguration().addListener(this.onConfigChange);
    }

    void enable(boolean enable) {
        this.enabled = enable;
    }

    private RequestEntity authenticate(RequestDispatcher.Score score, RequestEntity request) {
        if (this.isPublicResource(score)) {
            if (DispatchLog.isEnabled()) {
                DispatchLog.log(request.path() + " is a public resource");
            }
            return request;
        }
        try {
            CompoundPrincipal user = this.auth.verify(score.securityRealm(), request);
            if (user == null) {
                if (DispatchLog.isEnabled()) {
                    DispatchLog.log(request.path() + "Authenticator asserts " + request.path() + " is a public resource");
                }
                return request;
            }
            if (DispatchLog.isEnabled()) {
                DispatchLog.log(request.path() + " authorized as: " + user.getName());
            }
            return Requests.principal(request, user);
        }
        catch (WebException e) {
            if (DispatchLog.isEnabled()) {
                DispatchLog.log(request.path() + " failed authentication");
            }
            throw e;
        }
    }

    private RequestDispatcher.Score choose(RequestEntity request) {
        if (this.enabled) {
            Iterable dispatchers = ServiceLocator.acquireAll(RequestDispatcher.class, (String[])new String[0]);
            Object candidate = null;
            RequestDispatcher.Score score = RequestDispatcher.NO_MATCH;
            for (RequestDispatcher dispatcher : dispatchers) {
                RequestDispatcher.Score weighting = dispatcher.canDispatch(request);
                if (weighting.score() <= score.score()) continue;
                if (DispatchLog.isEnabled()) {
                    DispatchLog.log("Choosing: " + dispatcher.getClass().getName() + " as current candidate with score: " + weighting);
                }
                candidate = dispatcher;
                score = weighting;
            }
            if (RequestDispatcher.Score.isMatch(score)) {
                if (DispatchLog.isEnabled()) {
                    DispatchLog.log("Chose " + candidate.getClass().getName() + " as the final candidate with score: " + score + " for: " + request.method() + " " + request.path());
                }
                return this.score(score, (RequestDispatcher)candidate);
            }
        }
        if (DispatchLog.isEnabled()) {
            DispatchLog.log("No candidate found for: " + request.method() + " " + request.path());
        }
        return RequestDispatcher.NO_MATCH;
    }

    private boolean isPublicResource(RequestDispatcher.Score score) {
        AuthenticationRealm securityRealm = score.securityRealm();
        boolean isPublic = RequestDispatcher.NO_SECURITY_REALM.equals((Object)securityRealm);
        return isPublic;
    }

    private RequestDispatcher.Score score(RequestDispatcher.Score score, RequestDispatcher candidate) {
        return new RequestDispatcher.Score(score.score(), score.securityRealm(), Pair.pair((Object)score, (Object)candidate));
    }

    private final class NotForwarded
    implements HttpResource,
    Closeable {
        private final HttpResource resource;
        private final Entity response;

        private NotForwarded(HttpResource resource, Entity response) {
            this.resource = resource;
            this.response = response;
        }

        @Override
        public void close() throws IOException {
            Closeables.close((Object)this.response);
        }

        @Override
        public String version() {
            return this.resource.version();
        }

        @Override
        public Entity response() throws IOException {
            return this.response;
        }
    }

    private final class Forwarded
    implements HttpResource {
        private final EntityHeaders addtionalHeaders;
        private final HttpResource forwarded;
        private final EntityHeader forwardTo;
        private final RequestPaths request;

        private Forwarded(EntityHeader forwardTo, RequestPaths request, HttpResource forwarded, EntityHeaders additionalHeaders) {
            this.forwardTo = forwardTo;
            this.request = request;
            this.forwarded = forwarded;
            this.addtionalHeaders = additionalHeaders;
        }

        @Override
        public String version() {
            return this.forwarded.version();
        }

        @Override
        public Entity response() throws IOException {
            Entity f = this.forwarded.response();
            return Entities.entity(f.body(), Entities.merge(Entities.merge(f.headers(), this.addtionalHeaders), Entities.headers(HttpHeader.LOCATION, this.request.base() + this.forwardTo.value())));
        }
    }
}

