/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestEntity;

public interface RequestDispatcher {
    public static final AuthenticationRealm NO_SECURITY_REALM = AuthenticationRealm.NONE;
    public static final Score NO_MATCH = new Score(-1, NO_SECURITY_REALM, null);

    public Score canDispatch(RequestEntity var1);

    public HttpResource dispatch(Score var1, RequestEntity var2) throws IOException;

    public static class Score {
        private final Object handle;
        private final int score;
        private final AuthenticationRealm scope;

        public static boolean isMatch(Score score) {
            return score != null && score != NO_MATCH && score.score != -1;
        }

        public Score(int score, AuthenticationRealm scope, Object handle) {
            this.score = score;
            this.scope = scope;
            this.handle = handle;
        }

        public Object handle() {
            return this.handle;
        }

        public int score() {
            return this.score;
        }

        public AuthenticationRealm securityRealm() {
            return this.scope;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Score [handle=");
            builder.append(this.handle);
            builder.append(", score=");
            builder.append(this.score);
            builder.append(", securityRealm=");
            builder.append((Object)this.scope);
            builder.append("]");
            return builder.toString();
        }
    }
}

