/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestDispatchers;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

public abstract class ReTargetingDispatcher<T extends Target>
implements RequestDispatcher {
    @Reference
    private RequestDispatchers dispatchers;

    protected abstract T target(RequestEntity var1);

    protected Entity modifyResponse(T target, Entity response) throws IOException {
        return response;
    }

    protected RequestEntity modifyRequest(T target, RequestEntity request) throws IOException {
        return Requests.forward(request, ((Target)target).target(), false, this.forwardedHeaders(target, request));
    }

    @Override
    public RequestDispatcher.Score canDispatch(RequestEntity request) {
        RequestDispatcher.Score score;
        T target = this.target(request);
        if (target != null && RequestDispatcher.Score.isMatch(score = this.dispatchers.canDispatch(Requests.forward(request, ((Target)target).target(), true, this.forwardedHeaders(target, request))))) {
            return new RequestDispatcher.Score(score.score() + 1, score.securityRealm(), target);
        }
        return RequestDispatcher.NO_MATCH;
    }

    protected EntityHeaders forwardedHeaders(T target, RequestEntity request) {
        return null;
    }

    @Override
    public HttpResource dispatch(RequestDispatcher.Score score, RequestEntity request) throws IOException {
        if (score == null) {
            throw WebException.badRequest(Reason.reason("target", new TranslatableMessage(ResourceTemplateMessages.class, "ReTargetingDispatcher.0", "Could not determine the original target of this request", new Object[0])));
        }
        String originalPath = request.path();
        final Target target = (Target)score.handle();
        if (target == null) {
            throw WebException.badRequest(Reason.reason("target", new TranslatableMessage(ResourceTemplateMessages.class, "ReTargetingDispatcher.1", "Could not find a target service to consume this request", new Object[0])));
        }
        RequestEntity newRequest = this.modifyRequest(target, request);
        String actualPath = newRequest.path();
        if (actualPath.equals(originalPath)) {
            throw WebException.internalError(new IllegalStateException("The forwarded path is the same as the originally requested path"), new Reason[0]);
        }
        final HttpResource resource = this.dispatchers.dispatch(null, newRequest);
        return new HttpResource(){

            @Override
            public Entity response() throws IOException {
                Entity response = resource.response();
                return ReTargetingDispatcher.this.modifyResponse(target, response);
            }

            @Override
            public String version() {
                return resource.version();
            }
        };
    }

    public static class Target {
        private final String target;

        public Target(String target) {
            this.target = target;
        }

        public String target() {
            return this.target;
        }
    }
}

