/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.common.util.Base64;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Digests;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.WebException;

public abstract class ETags {
    private static final String QUOTE = "\"";

    private ETags() {
    }

    public static Entity handle(RequestEntity request, HttpResource resource) throws IOException {
        Entity response = resource.response();
        try {
            String current = resource.version();
            if (current != null && current.isEmpty()) {
                response = Entities.buffer(resource.response());
                current = ETags.hash(response);
            }
            if (ETags.isRead(request)) {
                EntityHeader condition = request.headers().header(HttpHeader.IF_NONE_MATCH);
                if (condition != null && !condition.value().equals("*") && ETags.etag(condition).equals(current)) {
                    throw WebException.notModified();
                }
            } else {
                EntityHeader condition = request.headers().header(HttpHeader.IF_MATCH);
                if (condition != null && !condition.value().equals("*") && !ETags.etag(condition).equals(current)) {
                    throw WebException.preconditionFailed();
                }
            }
            return ETags.addETag(response, current);
        }
        catch (RuntimeException e) {
            Closeables.close((Object)resource);
            throw e;
        }
    }

    private static Entity addETag(Entity response, String etag) throws IOException {
        if (etag != null) {
            if (etag.isEmpty()) {
                throw WebException.internalError(null, new Reason[0]);
            }
            response = Entities.entity(response.body(), Entities.merge(response.headers(), Entities.headers(HttpHeader.ETAG, QUOTE + etag + QUOTE)));
        }
        return response;
    }

    private static String etag(EntityHeader condition) {
        return condition.value().replaceAll("\"(.*)\"", "$1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String hash(Entity response) throws IOException {
        try {
            String string = Base64.byteArrayToBase64((byte[])Digests.digest((InputStream)response.body()));
            return string;
        }
        finally {
            Closeables.close((Object)response);
        }
    }

    private static boolean isRead(RequestEntity request) {
        return HttpMethod.GET.equals(request.method()) || HttpMethod.HEAD.equals(request.method());
    }
}

